/*
 * Copyright (c) 2014-2016 The Linux Foundation. All rights reserved.
 *
 * Previously licensed under the ISC license by Qualcomm Atheros, Inc.
 *
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * This file was originally distributed by Qualcomm Atheros, Inc.
 * under proprietary terms before Copyright ownership was assigned
 * to the Linux Foundation.
 */

#ifndef __WLAN_HDD_TRACE_H__
#define __WLAN_HDD_TRACE_H__

#include "macTrace.h"

#define NO_SESSION 0xFF
#define TRACE_CODE_HDD_RX_SME_MSG 0xFF

enum {
	TRACE_CODE_HDD_OPEN_REQUEST,
	TRACE_CODE_HDD_STOP_REQUEST,
	TRACE_CODE_HDD_TX_TIMEOUT,
	TRACE_CODE_HDD_P2P_DEV_ADDR_IOCTL,
	TRACE_CODE_HDD_SETSUSPENDMODE_IOCTL,
	TRACE_CODE_HDD_SETROAMTRIGGER_IOCTL,
	TRACE_CODE_HDD_GETROAMTRIGGER_IOCTL,
	TRACE_CODE_HDD_SETROAMSCANPERIOD_IOCTL,
	TRACE_CODE_HDD_GETROAMSCANPERIOD_IOCTL,
	TRACE_CODE_HDD_SETROAMDELTA_IOCTL,
	TRACE_CODE_HDD_GETROAMDELTA_IOCTL,
	TRACE_CODE_HDD_GETBAND_IOCTL,
	TRACE_CODE_HDD_GETCOUNTRYREV_IOCTL,
	TRACE_CODE_HDD_SETROAMSCANCHANNELS_IOCTL,
	TRACE_CODE_HDD_GETROAMSCANCHANNELS_IOCTL,
	TRACE_CODE_HDD_HOSTAPD_OPEN_REQUEST,
	TRACE_CODE_HDD_HOSTAPD_STOP_REQUEST,
	TRACE_CODE_HDD_HOSTAPD_UNINIT_REQUEST,
	TRACE_CODE_HDD_SOFTAP_TX_TIMEOUT,
	TRACE_CODE_HDD_HOSTAPD_SET_MAC_ADDR,
	TRACE_CODE_HDD_HOSTAPD_P2P_SET_NOA_IOCTL,
	TRACE_CODE_HDD_HOSTAPD_P2P_SET_PS_IOCTL,
	TRACE_CODE_HDD_HOSTAPD_SET_SAP_CHANNEL_LIST_IOCTL,
	TRACE_CODE_HDD_ADD_VIRTUAL_INTF,
	TRACE_CODE_HDD_DEL_VIRTUAL_INTF,
	TRACE_CODE_HDD_CHANGE_VIRTUAL_INTF,
	TRACE_CODE_HDD_CFG80211_START_AP,
	TRACE_CODE_HDD_CFG80211_CHANGE_BEACON,
	TRACE_CODE_HDD_CFG80211_STOP_AP,
	TRACE_CODE_HDD_CFG80211_CHANGE_BSS,
	TRACE_CODE_HDD_CFG80211_ADD_KEY,
	TRACE_CODE_HDD_CFG80211_GET_KEY,
	TRACE_CODE_HDD_CFG80211_SET_DEFAULT_KEY,
	TRACE_CODE_HDD_CFG80211_CONNECT,
	TRACE_CODE_HDD_CFG80211_DISCONNECT,
	TRACE_CODE_HDD_CFG80211_JOIN_IBSS,
	TRACE_CODE_HDD_CFG80211_LEAVE_IBSS,
	TRACE_CODE_HDD_CFG80211_SET_WIPHY_PARAMS,
	TRACE_CODE_HDD_CFG80211_SET_TXPOWER,
	TRACE_CODE_HDD_CFG80211_GET_TXPOWER,
	TRACE_CODE_HDD_CFG80211_SET_CHANNEL,
	TRACE_CODE_HDD_CFG80211_ADD_BEACON,
	TRACE_CODE_HDD_CFG80211_SET_BEACON,
	TRACE_CODE_HDD_CFG80211_CHANGE_IFACE,
	TRACE_CODE_HDD_CHANGE_STATION,
	TRACE_CODE_HDD_CFG80211_UPDATE_BSS,
	TRACE_CODE_HDD_CFG80211_SCAN,
	TRACE_CODE_HDD_REMAIN_ON_CHANNEL,
	TRACE_CODE_HDD_REMAINCHANREADYHANDLER,
	TRACE_CODE_HDD_CFG80211_CANCEL_REMAIN_ON_CHANNEL,
	TRACE_CODE_HDD_ACTION,
	TRACE_CODE_HDD_MGMT_TX_CANCEL_WAIT,
	TRACE_CODE_HDD_CFG80211_GET_STA,
	TRACE_CODE_HDD_CFG80211_SET_POWER_MGMT,
	TRACE_CODE_HDD_CFG80211_DEL_STA,
	TRACE_CODE_HDD_CFG80211_ADD_STA,
	TRACE_CODE_HDD_CFG80211_SET_PMKSA,
	TRACE_CODE_HDD_CFG80211_UPDATE_FT_IES,
	TRACE_CODE_HDD_CFG80211_TDLS_MGMT,
	TRACE_CODE_HDD_CFG80211_TDLS_OPER,
	TRACE_CODE_HDD_CFG80211_SET_REKEY_DATA,
	TRACE_CODE_HDD_UNSUPPORTED_IOCTL,
	TRACE_CODE_HDD_SETROAMSCANCHANNELMINTIME_IOCTL,
	TRACE_CODE_HDD_GETROAMSCANCHANNELMINTIME_IOCTL,
	TRACE_CODE_HDD_STORE_JOIN_REQ,
	TRACE_CODE_HDD_CLEAR_JOIN_REQ,
	TRACE_CODE_HDD_ISSUE_JOIN_REQ,
	TRACE_CODE_HDD_CFG80211_RESUME_WLAN,
	TRACE_CODE_HDD_CFG80211_SUSPEND_WLAN,
	TRACE_CODE_HDD_CFG80211_SET_MAC_ACL,
	TRACE_CODE_HDD_CFG80211_TESTMODE,
	TRACE_CODE_HDD_CFG80211_DUMP_SURVEY,
	TRACE_CODE_HDD_CFG80211_SCHED_SCAN_START,
	TRACE_CODE_HDD_CFG80211_SCHED_SCAN_STOP,
	TRACE_CODE_HDD_CFG80211_DEL_PMKSA,
};

extern void hddTraceDump(void *pMac, tpvosTraceRecord pRecord,
			 tANI_U16 recIndex);
extern void hddTraceInit(void);
#endif
