// Code generated by smithy-go-codegen DO NOT EDIT.

package honeycode

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/honeycode/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpBatchCreateTableRows struct {
}

func (*awsRestjson1_serializeOpBatchCreateTableRows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchCreateTableRows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchCreateTableRowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/tables/{tableId}/rows/batchcreate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchCreateTableRowsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchCreateTableRowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchCreateTableRowsInput(v *BatchCreateTableRowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TableId == nil || len(*v.TableId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member tableId must not be empty")}
	}
	if v.TableId != nil {
		if err := encoder.SetURI("tableId").String(*v.TableId); err != nil {
			return err
		}
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchCreateTableRowsInput(v *BatchCreateTableRowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.RowsToCreate != nil {
		ok := object.Key("rowsToCreate")
		if err := awsRestjson1_serializeDocumentCreateRowDataList(v.RowsToCreate, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchDeleteTableRows struct {
}

func (*awsRestjson1_serializeOpBatchDeleteTableRows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDeleteTableRows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteTableRowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/tables/{tableId}/rows/batchdelete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchDeleteTableRowsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDeleteTableRowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDeleteTableRowsInput(v *BatchDeleteTableRowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TableId == nil || len(*v.TableId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member tableId must not be empty")}
	}
	if v.TableId != nil {
		if err := encoder.SetURI("tableId").String(*v.TableId); err != nil {
			return err
		}
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDeleteTableRowsInput(v *BatchDeleteTableRowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.RowIds != nil {
		ok := object.Key("rowIds")
		if err := awsRestjson1_serializeDocumentRowIdList(v.RowIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchUpdateTableRows struct {
}

func (*awsRestjson1_serializeOpBatchUpdateTableRows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchUpdateTableRows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchUpdateTableRowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/tables/{tableId}/rows/batchupdate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchUpdateTableRowsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchUpdateTableRowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchUpdateTableRowsInput(v *BatchUpdateTableRowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TableId == nil || len(*v.TableId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member tableId must not be empty")}
	}
	if v.TableId != nil {
		if err := encoder.SetURI("tableId").String(*v.TableId); err != nil {
			return err
		}
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchUpdateTableRowsInput(v *BatchUpdateTableRowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.RowsToUpdate != nil {
		ok := object.Key("rowsToUpdate")
		if err := awsRestjson1_serializeDocumentUpdateRowDataList(v.RowsToUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchUpsertTableRows struct {
}

func (*awsRestjson1_serializeOpBatchUpsertTableRows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchUpsertTableRows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchUpsertTableRowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/tables/{tableId}/rows/batchupsert")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchUpsertTableRowsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchUpsertTableRowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchUpsertTableRowsInput(v *BatchUpsertTableRowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TableId == nil || len(*v.TableId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member tableId must not be empty")}
	}
	if v.TableId != nil {
		if err := encoder.SetURI("tableId").String(*v.TableId); err != nil {
			return err
		}
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchUpsertTableRowsInput(v *BatchUpsertTableRowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.RowsToUpsert != nil {
		ok := object.Key("rowsToUpsert")
		if err := awsRestjson1_serializeDocumentUpsertRowDataList(v.RowsToUpsert, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTableDataImportJob struct {
}

func (*awsRestjson1_serializeOpDescribeTableDataImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTableDataImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTableDataImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/tables/{tableId}/import/{jobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTableDataImportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTableDataImportJobInput(v *DescribeTableDataImportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member jobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("jobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if v.TableId == nil || len(*v.TableId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member tableId must not be empty")}
	}
	if v.TableId != nil {
		if err := encoder.SetURI("tableId").String(*v.TableId); err != nil {
			return err
		}
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetScreenData struct {
}

func (*awsRestjson1_serializeOpGetScreenData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetScreenData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetScreenDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/screendata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetScreenDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetScreenDataInput(v *GetScreenDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetScreenDataInput(v *GetScreenDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppId != nil {
		ok := object.Key("appId")
		ok.String(*v.AppId)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ScreenId != nil {
		ok := object.Key("screenId")
		ok.String(*v.ScreenId)
	}

	if v.Variables != nil {
		ok := object.Key("variables")
		if err := awsRestjson1_serializeDocumentVariableValueMap(v.Variables, ok); err != nil {
			return err
		}
	}

	if v.WorkbookId != nil {
		ok := object.Key("workbookId")
		ok.String(*v.WorkbookId)
	}

	return nil
}

type awsRestjson1_serializeOpInvokeScreenAutomation struct {
}

func (*awsRestjson1_serializeOpInvokeScreenAutomation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpInvokeScreenAutomation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InvokeScreenAutomationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/apps/{appId}/screens/{screenId}/automations/{screenAutomationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsInvokeScreenAutomationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentInvokeScreenAutomationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsInvokeScreenAutomationInput(v *InvokeScreenAutomationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ScreenAutomationId == nil || len(*v.ScreenAutomationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member screenAutomationId must not be empty")}
	}
	if v.ScreenAutomationId != nil {
		if err := encoder.SetURI("screenAutomationId").String(*v.ScreenAutomationId); err != nil {
			return err
		}
	}

	if v.ScreenId == nil || len(*v.ScreenId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member screenId must not be empty")}
	}
	if v.ScreenId != nil {
		if err := encoder.SetURI("screenId").String(*v.ScreenId); err != nil {
			return err
		}
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentInvokeScreenAutomationInput(v *InvokeScreenAutomationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.RowId != nil {
		ok := object.Key("rowId")
		ok.String(*v.RowId)
	}

	if v.Variables != nil {
		ok := object.Key("variables")
		if err := awsRestjson1_serializeDocumentVariableValueMap(v.Variables, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTableColumns struct {
}

func (*awsRestjson1_serializeOpListTableColumns) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTableColumns) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTableColumnsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/tables/{tableId}/columns")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTableColumnsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTableColumnsInput(v *ListTableColumnsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.TableId == nil || len(*v.TableId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member tableId must not be empty")}
	}
	if v.TableId != nil {
		if err := encoder.SetURI("tableId").String(*v.TableId); err != nil {
			return err
		}
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTableRows struct {
}

func (*awsRestjson1_serializeOpListTableRows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTableRows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTableRowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/tables/{tableId}/rows/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTableRowsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTableRowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTableRowsInput(v *ListTableRowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TableId == nil || len(*v.TableId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member tableId must not be empty")}
	}
	if v.TableId != nil {
		if err := encoder.SetURI("tableId").String(*v.TableId); err != nil {
			return err
		}
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTableRowsInput(v *ListTableRowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.RowIds != nil {
		ok := object.Key("rowIds")
		if err := awsRestjson1_serializeDocumentRowIdList(v.RowIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTables struct {
}

func (*awsRestjson1_serializeOpListTables) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTables) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTablesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/tables")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTablesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTablesInput(v *ListTablesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpQueryTableRows struct {
}

func (*awsRestjson1_serializeOpQueryTableRows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpQueryTableRows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*QueryTableRowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/tables/{tableId}/rows/query")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsQueryTableRowsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentQueryTableRowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsQueryTableRowsInput(v *QueryTableRowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TableId == nil || len(*v.TableId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member tableId must not be empty")}
	}
	if v.TableId != nil {
		if err := encoder.SetURI("tableId").String(*v.TableId); err != nil {
			return err
		}
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentQueryTableRowsInput(v *QueryTableRowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterFormula != nil {
		ok := object.Key("filterFormula")
		if err := awsRestjson1_serializeDocumentFilter(v.FilterFormula, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpStartTableDataImportJob struct {
}

func (*awsRestjson1_serializeOpStartTableDataImportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartTableDataImportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartTableDataImportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workbooks/{workbookId}/tables/{destinationTableId}/import")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartTableDataImportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartTableDataImportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartTableDataImportJobInput(v *StartTableDataImportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DestinationTableId == nil || len(*v.DestinationTableId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member destinationTableId must not be empty")}
	}
	if v.DestinationTableId != nil {
		if err := encoder.SetURI("destinationTableId").String(*v.DestinationTableId); err != nil {
			return err
		}
	}

	if v.WorkbookId == nil || len(*v.WorkbookId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workbookId must not be empty")}
	}
	if v.WorkbookId != nil {
		if err := encoder.SetURI("workbookId").String(*v.WorkbookId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartTableDataImportJobInput(v *StartTableDataImportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if len(v.DataFormat) > 0 {
		ok := object.Key("dataFormat")
		ok.String(string(v.DataFormat))
	}

	if v.DataSource != nil {
		ok := object.Key("dataSource")
		if err := awsRestjson1_serializeDocumentImportDataSource(v.DataSource, ok); err != nil {
			return err
		}
	}

	if v.ImportOptions != nil {
		ok := object.Key("importOptions")
		if err := awsRestjson1_serializeDocumentImportOptions(v.ImportOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCellInput(v *types.CellInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Fact != nil {
		ok := object.Key("fact")
		ok.String(*v.Fact)
	}

	if v.Facts != nil {
		ok := object.Key("facts")
		if err := awsRestjson1_serializeDocumentFactList(v.Facts, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateRowData(v *types.CreateRowData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchItemId != nil {
		ok := object.Key("batchItemId")
		ok.String(*v.BatchItemId)
	}

	if v.CellsToCreate != nil {
		ok := object.Key("cellsToCreate")
		if err := awsRestjson1_serializeDocumentRowDataInput(v.CellsToCreate, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateRowDataList(v []types.CreateRowData, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCreateRowData(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDelimitedTextImportOptions(v *types.DelimitedTextImportOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataCharacterEncoding) > 0 {
		ok := object.Key("dataCharacterEncoding")
		ok.String(string(v.DataCharacterEncoding))
	}

	if v.Delimiter != nil {
		ok := object.Key("delimiter")
		ok.String(*v.Delimiter)
	}

	if v.HasHeaderRow {
		ok := object.Key("hasHeaderRow")
		ok.Boolean(v.HasHeaderRow)
	}

	if v.IgnoreEmptyRows {
		ok := object.Key("ignoreEmptyRows")
		ok.Boolean(v.IgnoreEmptyRows)
	}

	return nil
}

func awsRestjson1_serializeDocumentDestinationOptions(v *types.DestinationOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnMap != nil {
		ok := object.Key("columnMap")
		if err := awsRestjson1_serializeDocumentImportColumnMap(v.ColumnMap, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFactList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFilter(v *types.Filter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContextRowId != nil {
		ok := object.Key("contextRowId")
		ok.String(*v.ContextRowId)
	}

	if v.Formula != nil {
		ok := object.Key("formula")
		ok.String(*v.Formula)
	}

	return nil
}

func awsRestjson1_serializeDocumentImportColumnMap(v map[string]types.SourceDataColumnProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentSourceDataColumnProperties(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentImportDataSource(v *types.ImportDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceConfig != nil {
		ok := object.Key("dataSourceConfig")
		if err := awsRestjson1_serializeDocumentImportDataSourceConfig(v.DataSourceConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentImportDataSourceConfig(v *types.ImportDataSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceUrl != nil {
		ok := object.Key("dataSourceUrl")
		ok.String(*v.DataSourceUrl)
	}

	return nil
}

func awsRestjson1_serializeDocumentImportOptions(v *types.ImportOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DelimitedTextOptions != nil {
		ok := object.Key("delimitedTextOptions")
		if err := awsRestjson1_serializeDocumentDelimitedTextImportOptions(v.DelimitedTextOptions, ok); err != nil {
			return err
		}
	}

	if v.DestinationOptions != nil {
		ok := object.Key("destinationOptions")
		if err := awsRestjson1_serializeDocumentDestinationOptions(v.DestinationOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRowDataInput(v map[string]types.CellInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentCellInput(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRowIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSourceDataColumnProperties(v *types.SourceDataColumnProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnIndex != 0 {
		ok := object.Key("columnIndex")
		ok.Integer(v.ColumnIndex)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentUpdateRowData(v *types.UpdateRowData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CellsToUpdate != nil {
		ok := object.Key("cellsToUpdate")
		if err := awsRestjson1_serializeDocumentRowDataInput(v.CellsToUpdate, ok); err != nil {
			return err
		}
	}

	if v.RowId != nil {
		ok := object.Key("rowId")
		ok.String(*v.RowId)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateRowDataList(v []types.UpdateRowData, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentUpdateRowData(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUpsertRowData(v *types.UpsertRowData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchItemId != nil {
		ok := object.Key("batchItemId")
		ok.String(*v.BatchItemId)
	}

	if v.CellsToUpdate != nil {
		ok := object.Key("cellsToUpdate")
		if err := awsRestjson1_serializeDocumentRowDataInput(v.CellsToUpdate, ok); err != nil {
			return err
		}
	}

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsRestjson1_serializeDocumentFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpsertRowDataList(v []types.UpsertRowData, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentUpsertRowData(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentVariableValue(v *types.VariableValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RawValue != nil {
		ok := object.Key("rawValue")
		ok.String(*v.RawValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentVariableValueMap(v map[string]types.VariableValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentVariableValue(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}
