// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains the tracker resource details.
type BatchDeleteDevicePositionHistoryError struct {

	// The ID of the device for this position.
	//
	// This member is required.
	DeviceId *string

	// Contains the batch request error details associated with the request.
	//
	// This member is required.
	Error *BatchItemError

	noSmithyDocumentSerde
}

// Contains error details for each geofence that failed to delete from the geofence
// collection.
type BatchDeleteGeofenceError struct {

	// Contains details associated to the batch error.
	//
	// This member is required.
	Error *BatchItemError

	// The geofence associated with the error message.
	//
	// This member is required.
	GeofenceId *string

	noSmithyDocumentSerde
}

// Contains error details for each device that failed to evaluate its position
// against the geofences in a given geofence collection.
type BatchEvaluateGeofencesError struct {

	// The device associated with the position evaluation error.
	//
	// This member is required.
	DeviceId *string

	// Contains details associated to the batch error.
	//
	// This member is required.
	Error *BatchItemError

	// Specifies a timestamp for when the error occurred in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	SampleTime *time.Time

	noSmithyDocumentSerde
}

// Contains error details for each device that didn't return a position.
type BatchGetDevicePositionError struct {

	// The ID of the device that didn't return a position.
	//
	// This member is required.
	DeviceId *string

	// Contains details related to the error code.
	//
	// This member is required.
	Error *BatchItemError

	noSmithyDocumentSerde
}

// Contains the batch request error details associated with the request.
type BatchItemError struct {

	// The error code associated with the batch request error.
	Code BatchItemErrorCode

	// A message with the reason for the batch request error.
	Message *string

	noSmithyDocumentSerde
}

// Contains error details for each geofence that failed to be stored in a given
// geofence collection.
type BatchPutGeofenceError struct {

	// Contains details associated to the batch error.
	//
	// This member is required.
	Error *BatchItemError

	// The geofence associated with the error message.
	//
	// This member is required.
	GeofenceId *string

	noSmithyDocumentSerde
}

// Contains geofence geometry details.
type BatchPutGeofenceRequestEntry struct {

	// The identifier for the geofence to be stored in a given geofence collection.
	//
	// This member is required.
	GeofenceId *string

	// Contains the details of the position of the geofence. Can be either a polygon or
	// a circle. Including both will return a validation error. Each  geofence polygon
	// (https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html)
	// can have a maximum of 1,000 vertices.
	//
	// This member is required.
	Geometry *GeofenceGeometry

	noSmithyDocumentSerde
}

// Contains a summary of each geofence that was successfully stored in a given
// geofence collection.
type BatchPutGeofenceSuccess struct {

	// The timestamp for when the geofence was stored in a geofence collection in ISO
	// 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	CreateTime *time.Time

	// The geofence successfully stored in a geofence collection.
	//
	// This member is required.
	GeofenceId *string

	// The timestamp for when the geofence was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Contains error details for each device that failed to update its position.
type BatchUpdateDevicePositionError struct {

	// The device associated with the failed location update.
	//
	// This member is required.
	DeviceId *string

	// Contains details related to the error code such as the error code and error
	// message.
	//
	// This member is required.
	Error *BatchItemError

	// The timestamp at which the device position was determined. Uses  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	SampleTime *time.Time

	noSmithyDocumentSerde
}

// Contains details about additional route preferences for requests that specify
// TravelMode as Car.
type CalculateRouteCarModeOptions struct {

	// Avoids ferries when calculating routes. Default Value: false Valid Values: false
	// | true
	AvoidFerries *bool

	// Avoids tolls when calculating routes. Default Value: false Valid Values: false |
	// true
	AvoidTolls *bool

	noSmithyDocumentSerde
}

// A summary of the calculated route matrix.
type CalculateRouteMatrixSummary struct {

	// The data provider of traffic and road network data used to calculate the routes.
	// Indicates one of the available providers:
	//
	// * Esri
	//
	// * Here
	//
	// For more information
	// about data providers, see Amazon Location Service data providers
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The unit of measurement for route distances.
	//
	// This member is required.
	DistanceUnit DistanceUnit

	// The count of error results in the route matrix. If this number is 0, all routes
	// were calculated successfully.
	//
	// This member is required.
	ErrorCount *int32

	// The count of cells in the route matrix. Equal to the number of
	// DeparturePositions multiplied by the number of DestinationPositions.
	//
	// This member is required.
	RouteCount *int32

	noSmithyDocumentSerde
}

// A summary of the calculated route.
type CalculateRouteSummary struct {

	// The data provider of traffic and road network data used to calculate the route.
	// Indicates one of the available providers:
	//
	// * Esri
	//
	// * Here
	//
	// For more information
	// about data providers, see Amazon Location Service data providers
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The total distance covered by the route. The sum of the distance travelled
	// between every stop on the route. If Esri is the data source for the route
	// calculator, the route distance can’t be greater than 400 km. If the route
	// exceeds 400 km, the response is a 400 RoutesValidationException error.
	//
	// This member is required.
	Distance *float64

	// The unit of measurement for route distances.
	//
	// This member is required.
	DistanceUnit DistanceUnit

	// The total travel time for the route measured in seconds. The sum of the travel
	// time between every stop on the route.
	//
	// This member is required.
	DurationSeconds *float64

	// Specifies a geographical box surrounding a route. Used to zoom into a route when
	// displaying it in a map. For example, [min x, min y, max x, max y]. The first 2
	// bbox parameters describe the lower southwest corner:
	//
	// * The first bbox position
	// is the X coordinate or longitude of the lower southwest corner.
	//
	// * The second
	// bbox position is the Y coordinate or latitude of the lower southwest
	// corner.
	//
	// The next 2 bbox parameters describe the upper northeast corner:
	//
	// * The
	// third bbox position is the X coordinate, or longitude of the upper northeast
	// corner.
	//
	// * The fourth bbox position is the Y coordinate, or latitude of the
	// upper northeast corner.
	//
	// This member is required.
	RouteBBox []float64

	noSmithyDocumentSerde
}

// Contains details about additional route preferences for requests that specify
// TravelMode as Truck.
type CalculateRouteTruckModeOptions struct {

	// Avoids ferries when calculating routes. Default Value: false Valid Values: false
	// | true
	AvoidFerries *bool

	// Avoids tolls when calculating routes. Default Value: false Valid Values: false |
	// true
	AvoidTolls *bool

	// Specifies the truck's dimension specifications including length, height, width,
	// and unit of measurement. Used to avoid roads that can't support the truck's
	// dimensions.
	Dimensions *TruckDimensions

	// Specifies the truck's weight specifications including total weight and unit of
	// measurement. Used to avoid roads that can't support the truck's weight.
	Weight *TruckWeight

	noSmithyDocumentSerde
}

// A circle on the earth, as defined by a center point and a radius.
type Circle struct {

	// A single point geometry, specifying the center of the circle, using WGS 84
	// (https://gisgeography.com/wgs84-world-geodetic-system/) coordinates, in the form
	// [longitude, latitude].
	//
	// This member is required.
	Center []float64

	// The radius of the circle in meters. Must be greater than zero and no larger than
	// 100,000 (100 kilometers).
	//
	// This member is required.
	Radius *float64

	noSmithyDocumentSerde
}

// Specifies the data storage option chosen for requesting Places. When using
// Amazon Location Places:
//
// * If using HERE Technologies as a data provider, you
// can't store results for locations in Japan by setting IntendedUse to Storage.
// parameter.
//
// * Under the MobileAssetTracking or MobilAssetManagement pricing
// plan, you can't store results from your place index resources by setting
// IntendedUse to Storage. This returns a validation exception error.
//
// For more
// information, see the AWS Service Terms (https://aws.amazon.com/service-terms/)
// for Amazon Location Service.
type DataSourceConfiguration struct {

	// Specifies how the results of an operation will be stored by the caller. Valid
	// values include:
	//
	// * SingleUse specifies that the results won't be stored.
	//
	// *
	// Storage specifies that the result can be cached or stored in a
	// database.
	//
	// Default value: SingleUse
	IntendedUse IntendedUse

	noSmithyDocumentSerde
}

// Contains the device position details.
type DevicePosition struct {

	// The last known device position.
	//
	// This member is required.
	Position []float64

	// The timestamp for when the tracker resource received the device position in  ISO
	// 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	ReceivedTime *time.Time

	// The timestamp at which the device's position was determined. Uses  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	SampleTime *time.Time

	// The accuracy of the device position.
	Accuracy *PositionalAccuracy

	// The device whose position you retrieved.
	DeviceId *string

	// The properties associated with the position.
	PositionProperties map[string]string

	noSmithyDocumentSerde
}

// Contains the position update details for a device.
type DevicePositionUpdate struct {

	// The device associated to the position update.
	//
	// This member is required.
	DeviceId *string

	// The latest device position defined in WGS 84
	// (https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format: [X or
	// longitude, Y or latitude].
	//
	// This member is required.
	Position []float64

	// The timestamp at which the device's position was determined. Uses ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	SampleTime *time.Time

	// The accuracy of the device position.
	Accuracy *PositionalAccuracy

	// Associates one of more properties with the position update. A property is a
	// key-value pair stored with the position update and added to any geofence event
	// the update may trigger. Format: "key" : "value"
	PositionProperties map[string]string

	noSmithyDocumentSerde
}

// Contains the geofence geometry details. A geofence geometry is made up of either
// a polygon or a circle. Can be either a polygon or a circle. Including both will
// return a validation error. Amazon Location doesn't currently support polygons
// with holes, multipolygons, polygons that are wound clockwise, or that cross the
// antimeridian.
type GeofenceGeometry struct {

	// A circle on the earth, as defined by a center point and a radius.
	Circle *Circle

	// An array of 1 or more linear rings. A linear ring is an array of 4 or more
	// vertices, where the first and last vertex are the same to form a closed
	// boundary. Each vertex is a 2-dimensional point of the form: [longitude,
	// latitude]. The first linear ring is an outer ring, describing the polygon's
	// boundary. Subsequent linear rings may be inner or outer rings to describe holes
	// and islands. Outer rings must list their vertices in counter-clockwise order
	// around the ring's center, where the left side is the polygon's exterior. Inner
	// rings must list their vertices in clockwise order, where the left side is the
	// polygon's interior. A geofence polygon can consist of between 4 and 1,000
	// vertices.
	Polygon [][][]float64

	noSmithyDocumentSerde
}

// Contains the calculated route's details for each path between a pair of
// positions. The number of legs returned corresponds to one fewer than the total
// number of positions in the request. For example, a route with a departure
// position and destination position returns one leg with the positions snapped to
// a nearby road
// (https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html):
//
// *
// The StartPosition is the departure position.
//
// * The EndPosition is the
// destination position.
//
// A route with a waypoint between the departure and
// destination position returns two legs with the positions snapped to a nearby
// road:
//
// * Leg 1: The StartPosition is the departure position . The EndPosition is
// the waypoint positon.
//
// * Leg 2: The StartPosition is the waypoint position. The
// EndPosition is the destination position.
type Leg struct {

	// The distance between the leg's StartPosition and EndPosition along a calculated
	// route.
	//
	// * The default measurement is Kilometers unless the request specifies a
	// DistanceUnit of Miles.
	//
	// This member is required.
	Distance *float64

	// The estimated travel time between the leg's StartPosition and EndPosition. The
	// travel mode and departure time that you specify in the request determines the
	// calculated time.
	//
	// This member is required.
	DurationSeconds *float64

	// The terminating position of the leg. Follows the format [longitude,latitude]. If
	// the EndPosition isn't located on a road, it's snapped to a nearby road
	// (https://docs.aws.amazon.com/location/latest/developerguide/nap-to-nearby-road.html).
	//
	// This member is required.
	EndPosition []float64

	// The starting position of the leg. Follows the format [longitude,latitude]. If
	// the StartPosition isn't located on a road, it's snapped to a nearby road
	// (https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html).
	//
	// This member is required.
	StartPosition []float64

	// Contains a list of steps, which represent subsections of a leg. Each step
	// provides instructions for how to move to the next step in the leg such as the
	// step's start position, end position, travel distance, travel duration, and
	// geometry offset.
	//
	// This member is required.
	Steps []Step

	// Contains the calculated route's path as a linestring geometry.
	Geometry *LegGeometry

	noSmithyDocumentSerde
}

// Contains the geometry details for each path between a pair of positions. Used in
// plotting a route leg on a map.
type LegGeometry struct {

	// An ordered list of positions used to plot a route on a map. The first position
	// is closest to the start position for the leg, and the last position is the
	// closest to the end position for the leg.
	//
	// * For example, [[-123.117,
	// 49.284],[-123.115, 49.285],[-123.115, 49.285]]
	LineString [][]float64

	noSmithyDocumentSerde
}

// Contains the tracker resource details.
type ListDevicePositionsResponseEntry struct {

	// The ID of the device for this position.
	//
	// This member is required.
	DeviceId *string

	// The last known device position. Empty if no positions currently stored.
	//
	// This member is required.
	Position []float64

	// The timestamp at which the device position was determined. Uses  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	SampleTime *time.Time

	// The accuracy of the device position.
	Accuracy *PositionalAccuracy

	// The properties associated with the position.
	PositionProperties map[string]string

	noSmithyDocumentSerde
}

// Contains the geofence collection details.
type ListGeofenceCollectionsResponseEntry struct {

	// The name of the geofence collection.
	//
	// This member is required.
	CollectionName *string

	// The timestamp for when the geofence collection was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	CreateTime *time.Time

	// The description for the geofence collection
	//
	// This member is required.
	Description *string

	// Specifies a timestamp for when the resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	UpdateTime *time.Time

	// No longer used. Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan PricingPlan

	// No longer used. Always returns an empty string.
	//
	// Deprecated: Deprecated. Unused.
	PricingPlanDataSource *string

	noSmithyDocumentSerde
}

// Contains a list of geofences stored in a given geofence collection.
type ListGeofenceResponseEntry struct {

	// The timestamp for when the geofence was stored in a geofence collection in ISO
	// 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	CreateTime *time.Time

	// The geofence identifier.
	//
	// This member is required.
	GeofenceId *string

	// Contains the geofence geometry details describing a polygon or a circle.
	//
	// This member is required.
	Geometry *GeofenceGeometry

	// Identifies the state of the geofence. A geofence will hold one of the following
	// states:
	//
	// * ACTIVE — The geofence has been indexed by the system.
	//
	// * PENDING —
	// The geofence is being processed by the system.
	//
	// * FAILED — The geofence failed
	// to be indexed by the system.
	//
	// * DELETED — The geofence has been deleted from the
	// system index.
	//
	// * DELETING — The geofence is being deleted from the system index.
	//
	// This member is required.
	Status *string

	// The timestamp for when the geofence was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Contains details of an existing map resource in your AWS account.
type ListMapsResponseEntry struct {

	// The timestamp for when the map resource was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	CreateTime *time.Time

	// Specifies the data provider for the associated map tiles.
	//
	// This member is required.
	DataSource *string

	// The description for the map resource.
	//
	// This member is required.
	Description *string

	// The name of the associated map resource.
	//
	// This member is required.
	MapName *string

	// The timestamp for when the map resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	UpdateTime *time.Time

	// No longer used. Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan PricingPlan

	noSmithyDocumentSerde
}

// A place index resource listed in your AWS account.
type ListPlaceIndexesResponseEntry struct {

	// The timestamp for when the place index resource was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	CreateTime *time.Time

	// The data provider of geospatial data. Values can be one of the following:
	//
	// *
	// Esri
	//
	// * Here
	//
	// For more information about data providers, see Amazon Location
	// Service data providers
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The optional description for the place index resource.
	//
	// This member is required.
	Description *string

	// The name of the place index resource.
	//
	// This member is required.
	IndexName *string

	// The timestamp for when the place index resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	UpdateTime *time.Time

	// No longer used. Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan PricingPlan

	noSmithyDocumentSerde
}

// A route calculator resource listed in your AWS account.
type ListRouteCalculatorsResponseEntry struct {

	// The name of the route calculator resource.
	//
	// This member is required.
	CalculatorName *string

	// The timestamp when the route calculator resource was created in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// * For example, 2020–07-2T12:15:20.000Z+01:00
	//
	// This member is required.
	CreateTime *time.Time

	// The data provider of traffic and road network data. Indicates one of the
	// available providers:
	//
	// * Esri
	//
	// * Here
	//
	// For more information about data providers,
	// see Amazon Location Service data providers
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The optional description of the route calculator resource.
	//
	// This member is required.
	Description *string

	// The timestamp when the route calculator resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// * For example, 2020–07-2T12:15:20.000Z+01:00
	//
	// This member is required.
	UpdateTime *time.Time

	// Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan PricingPlan

	noSmithyDocumentSerde
}

// Contains the tracker resource details.
type ListTrackersResponseEntry struct {

	// The timestamp for when the tracker resource was created in  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	CreateTime *time.Time

	// The description for the tracker resource.
	//
	// This member is required.
	Description *string

	// The name of the tracker resource.
	//
	// This member is required.
	TrackerName *string

	// The timestamp at which the device's position was determined. Uses  ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// This member is required.
	UpdateTime *time.Time

	// Always returns RequestBasedUsage.
	//
	// Deprecated: Deprecated. Always returns RequestBasedUsage.
	PricingPlan PricingPlan

	// No longer used. Always returns an empty string.
	//
	// Deprecated: Deprecated. Unused.
	PricingPlanDataSource *string

	noSmithyDocumentSerde
}

// Specifies the map tile style selected from an available provider.
type MapConfiguration struct {

	// Specifies the map style selected from an available data provider. Valid Esri map
	// styles
	// (https://docs.aws.amazon.com/location/latest/developerguide/esri.html):
	//
	// *
	// VectorEsriDarkGrayCanvas – The Esri Dark Gray Canvas map style. A vector basemap
	// with a dark gray, neutral background with minimal colors, labels, and features
	// that's designed to draw attention to your thematic content.
	//
	// * RasterEsriImagery
	// – The Esri Imagery map style. A raster basemap that provides one meter or better
	// satellite and aerial imagery in many parts of the world and lower resolution
	// satellite imagery worldwide.
	//
	// * VectorEsriLightGrayCanvas – The Esri Light Gray
	// Canvas map style, which provides a detailed vector basemap with a light gray,
	// neutral background style with minimal colors, labels, and features that's
	// designed to draw attention to your thematic content.
	//
	// * VectorEsriTopographic –
	// The Esri Light map style, which provides a detailed vector basemap with a
	// classic Esri map style.
	//
	// * VectorEsriStreets – The Esri World Streets map style,
	// which provides a detailed vector basemap for the world symbolized with a classic
	// Esri street map style. The vector tile layer is similar in content and style to
	// the World Street Map raster map.
	//
	// * VectorEsriNavigation – The Esri World
	// Navigation map style, which provides a detailed basemap for the world symbolized
	// with a custom navigation map style that's designed for use during the day in
	// mobile devices.
	//
	// Valid HERE Technologies map styles
	// (https://docs.aws.amazon.com/location/latest/developerguide/HERE.html):
	//
	// *
	// VectorHereContrast – The HERE Contrast (Berlin) map style is a high contrast
	// detailed base map of the world that blends 3D and 2D rendering.
	//
	// *
	// VectorHereExplore – A default HERE map style containing a neutral, global map
	// and its features including roads, buildings, landmarks, and water features. It
	// also now includes a fully designed map of Japan.
	//
	// * VectorHereExploreTruck – A
	// global map containing truck restrictions and attributes (e.g. width / height /
	// HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to
	// support use cases within transport and logistics.
	//
	// The VectorHereContrast style
	// has been renamed from VectorHereBerlin. VectorHereBerlin has been deprecated,
	// but will continue to work in applications that use it.
	//
	// This member is required.
	Style *string

	noSmithyDocumentSerde
}

// Contains details about addresses or points of interest that match the search
// criteria. Not all details are included with all responses. Some details may only
// be returned by specific data partners.
type Place struct {

	// Places uses a point geometry to specify a location or a Place.
	//
	// This member is required.
	Geometry *PlaceGeometry

	// The numerical portion of an address, such as a building number.
	AddressNumber *string

	// A country/region specified using ISO 3166
	// (https://www.iso.org/iso-3166-country-codes.html) 3-digit country/region code.
	// For example, CAN.
	Country *string

	// True if the result is interpolated from other known places. False if the Place
	// is a known place. Not returned when the partner does not provide the
	// information. For example, returns False for an address location that is found in
	// the partner data, but returns True if an address does not exist in the partner
	// data and its location is calculated by interpolating between other known
	// addresses.
	Interpolated *bool

	// The full name and address of the point of interest such as a city, region, or
	// country. For example, 123 Any Street, Any Town, USA.
	Label *string

	// A name for a local area, such as a city or town name. For example, Toronto.
	Municipality *string

	// The name of a community district. For example, Downtown.
	Neighborhood *string

	// A group of numbers and letters in a country-specific format, which accompanies
	// the address for the purpose of identifying a location.
	PostalCode *string

	// A name for an area or geographical division, such as a province or state name.
	// For example, British Columbia.
	Region *string

	// The name for a street or a road to identify a location. For example, Main
	// Street.
	Street *string

	// A country, or an area that's part of a larger region. For example, Metro
	// Vancouver.
	SubRegion *string

	// The time zone in which the Place is located. Returned only when using Here as
	// the selected partner.
	TimeZone *TimeZone

	// For addresses with multiple units, the unit identifier. Can include numbers and
	// letters, for example 3B or Unit 123. Returned only for a place index that uses
	// Esri as a data provider. Is not returned for SearchPlaceIndexForPosition.
	UnitNumber *string

	// For addresses with a UnitNumber, the type of unit. For example, Apartment.
	UnitType *string

	noSmithyDocumentSerde
}

// Places uses a point geometry to specify a location or a Place.
type PlaceGeometry struct {

	// A single point geometry specifies a location for a Place using WGS 84
	// (https://gisgeography.com/wgs84-world-geodetic-system/) coordinates:
	//
	// * x —
	// Specifies the x coordinate or longitude.
	//
	// * y — Specifies the y coordinate or
	// latitude.
	Point []float64

	noSmithyDocumentSerde
}

// Defines the level of certainty of the position.
type PositionalAccuracy struct {

	// Estimated maximum distance, in meters, between the measured position and the
	// true position of a device, along the Earth's surface.
	//
	// This member is required.
	Horizontal *float64

	noSmithyDocumentSerde
}

// The result for the calculated route of one DeparturePositionDestinationPosition
// pair.
type RouteMatrixEntry struct {

	// The total distance of travel for the route.
	Distance *float64

	// The expected duration of travel for the route.
	DurationSeconds *float64

	// An error corresponding to the calculation of a route between the
	// DeparturePosition and DestinationPosition.
	Error *RouteMatrixEntryError

	noSmithyDocumentSerde
}

// An error corresponding to the calculation of a route between the
// DeparturePosition and DestinationPosition. The error code can be one of the
// following:
//
// * RouteNotFound - Unable to find a valid route with the given
// parameters.
//
// * RouteTooLong - Route calculation went beyond the maximum size of
// a route and was terminated before completion.
//
// * PositionsNotFound - One or more
// of the input positions were not found on the route network.
//
// *
// DestinationPositionNotFound - The destination position was not found on the
// route network.
//
// * DeparturePositionNotFound - The departure position was not
// found on the route network.
//
// * OtherValidationError - The given inputs were not
// valid or a route was not found. More information is given in the error Message
type RouteMatrixEntryError struct {

	// The type of error which occurred for the route calculation.
	//
	// This member is required.
	Code RouteMatrixErrorCode

	// A message about the error that occurred for the route calculation.
	Message *string

	noSmithyDocumentSerde
}

// Contains a search result from a position search query that is run on a place
// index resource.
type SearchForPositionResult struct {

	// The distance in meters of a great-circle arc between the query position and the
	// result. A great-circle arc is the shortest path on a sphere, in this case the
	// Earth. This returns the shortest distance between two locations.
	//
	// This member is required.
	Distance *float64

	// Details about the search result, such as its address and position.
	//
	// This member is required.
	Place *Place

	// The unique identifier of the place. You can use this with the GetPlace operation
	// to find the place again later. For SearchPlaceIndexForPosition operations, the
	// PlaceId is returned only by place indexes that use HERE as a data provider.
	PlaceId *string

	noSmithyDocumentSerde
}

// Contains a place suggestion resulting from a place suggestion query that is run
// on a place index resource.
type SearchForSuggestionsResult struct {

	// The text of the place suggestion, typically formatted as an address string.
	//
	// This member is required.
	Text *string

	// The unique identifier of the place. You can use this with the GetPlace operation
	// to find the place again later. For SearchPlaceIndexForSuggestions operations,
	// the PlaceId is returned by place indexes that use HERE or Esri as data
	// providers.
	PlaceId *string

	noSmithyDocumentSerde
}

// Contains a search result from a text search query that is run on a place index
// resource.
type SearchForTextResult struct {

	// Details about the search result, such as its address and position.
	//
	// This member is required.
	Place *Place

	// The distance in meters of a great-circle arc between the bias position specified
	// and the result. Distance will be returned only if a bias position was specified
	// in the query. A great-circle arc is the shortest path on a sphere, in this case
	// the Earth. This returns the shortest distance between two locations.
	Distance *float64

	// The unique identifier of the place. You can use this with the GetPlace operation
	// to find the place again later. For SearchPlaceIndexForText operations, the
	// PlaceId is returned only by place indexes that use HERE as a data provider.
	PlaceId *string

	// The relative confidence in the match for a result among the results returned.
	// For example, if more fields for an address match (including house number,
	// street, city, country/region, and postal code), the relevance score is closer to
	// 1. Returned only when the partner selected is Esri.
	Relevance *float64

	noSmithyDocumentSerde
}

// A summary of the request sent by using SearchPlaceIndexForPosition.
type SearchPlaceIndexForPositionSummary struct {

	// The geospatial data provider attached to the place index resource specified in
	// the request. Values can be one of the following:
	//
	// * Esri
	//
	// * Here
	//
	// For more
	// information about data providers, see Amazon Location Service data providers
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The position specified in the request.
	//
	// This member is required.
	Position []float64

	// The preferred language used to return results. Matches the language in the
	// request. The value is a valid BCP 47 (https://tools.ietf.org/search/bcp47)
	// language tag, for example, en for English.
	Language *string

	// Contains the optional result count limit that is specified in the request.
	// Default value: 50
	MaxResults int32

	noSmithyDocumentSerde
}

// A summary of the request sent by using SearchPlaceIndexForSuggestions.
type SearchPlaceIndexForSuggestionsSummary struct {

	// The geospatial data provider attached to the place index resource specified in
	// the request. Values can be one of the following:
	//
	// * Esri
	//
	// * Here
	//
	// For more
	// information about data providers, see Amazon Location Service data providers
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The free-form partial text input specified in the request.
	//
	// This member is required.
	Text *string

	// Contains the coordinates for the optional bias position specified in the
	// request. This parameter contains a pair of numbers. The first number represents
	// the X coordinate, or longitude; the second number represents the Y coordinate,
	// or latitude. For example, [-123.1174, 49.2847] represents the position with
	// longitude -123.1174 and latitude 49.2847.
	BiasPosition []float64

	// Contains the coordinates for the optional bounding box specified in the request.
	FilterBBox []float64

	// Contains the optional country filter specified in the request.
	FilterCountries []string

	// The preferred language used to return results. Matches the language in the
	// request. The value is a valid BCP 47 (https://tools.ietf.org/search/bcp47)
	// language tag, for example, en for English.
	Language *string

	// Contains the optional result count limit specified in the request.
	MaxResults *int32

	noSmithyDocumentSerde
}

// A summary of the request sent by using SearchPlaceIndexForText.
type SearchPlaceIndexForTextSummary struct {

	// The geospatial data provider attached to the place index resource specified in
	// the request. Values can be one of the following:
	//
	// * Esri
	//
	// * Here
	//
	// For more
	// information about data providers, see Amazon Location Service data providers
	// (https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
	//
	// This member is required.
	DataSource *string

	// The search text specified in the request.
	//
	// This member is required.
	Text *string

	// Contains the coordinates for the optional bias position specified in the
	// request. This parameter contains a pair of numbers. The first number represents
	// the X coordinate, or longitude; the second number represents the Y coordinate,
	// or latitude. For example, [-123.1174, 49.2847] represents the position with
	// longitude -123.1174 and latitude 49.2847.
	BiasPosition []float64

	// Contains the coordinates for the optional bounding box specified in the request.
	FilterBBox []float64

	// Contains the optional country filter specified in the request.
	FilterCountries []string

	// The preferred language used to return results. Matches the language in the
	// request. The value is a valid BCP 47 (https://tools.ietf.org/search/bcp47)
	// language tag, for example, en for English.
	Language *string

	// Contains the optional result count limit specified in the request.
	MaxResults int32

	// The bounding box that fully contains all search results. If you specified the
	// optional FilterBBox parameter in the request, ResultBBox is contained within
	// FilterBBox.
	ResultBBox []float64

	noSmithyDocumentSerde
}

// Represents an element of a leg within a route. A step contains instructions for
// how to move to the next step in the leg.
type Step struct {

	// The travel distance between the step's StartPosition and EndPosition.
	//
	// This member is required.
	Distance *float64

	// The estimated travel time, in seconds, from the step's StartPosition to the
	// EndPosition. . The travel mode and departure time that you specify in the
	// request determines the calculated time.
	//
	// This member is required.
	DurationSeconds *float64

	// The end position of a step. If the position the last step in the leg, this
	// position is the same as the end position of the leg.
	//
	// This member is required.
	EndPosition []float64

	// The starting position of a step. If the position is the first step in the leg,
	// this position is the same as the start position of the leg.
	//
	// This member is required.
	StartPosition []float64

	// Represents the start position, or index, in a sequence of steps within the leg's
	// line string geometry. For example, the index of the first step in a leg geometry
	// is 0. Included in the response for queries that set IncludeLegGeometry to True.
	GeometryOffset *int32

	noSmithyDocumentSerde
}

// Information about a time zone. Includes the name of the time zone and the offset
// from UTC in seconds.
type TimeZone struct {

	// The name of the time zone, following the  IANA time zone standard
	// (https://www.iana.org/time-zones). For example, America/Los_Angeles.
	//
	// This member is required.
	Name *string

	// The time zone's offset, in seconds, from UTC.
	Offset *int32

	noSmithyDocumentSerde
}

// Contains details about the truck dimensions in the unit of measurement that you
// specify. Used to filter out roads that can't support or allow the specified
// dimensions for requests that specify TravelMode as Truck.
type TruckDimensions struct {

	// The height of the truck.
	//
	// * For example, 4.5.
	//
	// For routes calculated with a HERE
	// resource, this value must be between 0 and 50 meters.
	Height *float64

	// The length of the truck.
	//
	// * For example, 15.5.
	//
	// For routes calculated with a
	// HERE resource, this value must be between 0 and 300 meters.
	Length *float64

	// Specifies the unit of measurement for the truck dimensions. Default Value:
	// Meters
	Unit DimensionUnit

	// The width of the truck.
	//
	// * For example, 4.5.
	//
	// For routes calculated with a HERE
	// resource, this value must be between 0 and 50 meters.
	Width *float64

	noSmithyDocumentSerde
}

// Contains details about the truck's weight specifications. Used to avoid roads
// that can't support or allow the total weight for requests that specify
// TravelMode as Truck.
type TruckWeight struct {

	// The total weight of the truck.
	//
	// * For example, 3500.
	Total *float64

	// The unit of measurement to use for the truck weight. Default Value: Kilograms
	Unit VehicleWeightUnit

	noSmithyDocumentSerde
}

// The input failed to meet the constraints specified by the AWS service in a
// specified field.
type ValidationExceptionField struct {

	// A message with the reason for the validation exception error.
	//
	// This member is required.
	Message *string

	// The field name where the invalid entry was detected.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
