// Code generated by smithy-go-codegen DO NOT EDIT.

package types

type AcceleratorType string

// Enum values for AcceleratorType
const (
	// GPU accelerator type.
	AcceleratorTypeGpu AcceleratorType = "gpu"
)

// Values returns all known values for AcceleratorType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AcceleratorType) Values() []AcceleratorType {
	return []AcceleratorType{
		"gpu",
	}
}

type AutoScalingMode string

// Enum values for AutoScalingMode
const (
	AutoScalingModeNoScaling             AutoScalingMode = "NO_SCALING"
	AutoScalingModeEventBasedAutoScaling AutoScalingMode = "EVENT_BASED_AUTO_SCALING"
)

// Values returns all known values for AutoScalingMode. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AutoScalingMode) Values() []AutoScalingMode {
	return []AutoScalingMode{
		"NO_SCALING",
		"EVENT_BASED_AUTO_SCALING",
	}
}

type AutoScalingStatus string

// Enum values for AutoScalingStatus
const (
	AutoScalingStatusGrowing   AutoScalingStatus = "GROWING"
	AutoScalingStatusSteady    AutoScalingStatus = "STEADY"
	AutoScalingStatusShrinking AutoScalingStatus = "SHRINKING"
)

// Values returns all known values for AutoScalingStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AutoScalingStatus) Values() []AutoScalingStatus {
	return []AutoScalingStatus{
		"GROWING",
		"STEADY",
		"SHRINKING",
	}
}

type BudgetActionType string

// Enum values for BudgetActionType
const (
	BudgetActionTypeStopSchedulingAndCompleteTasks BudgetActionType = "STOP_SCHEDULING_AND_COMPLETE_TASKS"
	BudgetActionTypeStopSchedulingAndCancelTasks   BudgetActionType = "STOP_SCHEDULING_AND_CANCEL_TASKS"
)

// Values returns all known values for BudgetActionType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (BudgetActionType) Values() []BudgetActionType {
	return []BudgetActionType{
		"STOP_SCHEDULING_AND_COMPLETE_TASKS",
		"STOP_SCHEDULING_AND_CANCEL_TASKS",
	}
}

type BudgetStatus string

// Enum values for BudgetStatus
const (
	BudgetStatusActive   BudgetStatus = "ACTIVE"
	BudgetStatusInactive BudgetStatus = "INACTIVE"
)

// Values returns all known values for BudgetStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (BudgetStatus) Values() []BudgetStatus {
	return []BudgetStatus{
		"ACTIVE",
		"INACTIVE",
	}
}

type ComparisonOperator string

// Enum values for ComparisonOperator
const (
	ComparisonOperatorEqual              ComparisonOperator = "EQUAL"
	ComparisonOperatorNotEqual           ComparisonOperator = "NOT_EQUAL"
	ComparisonOperatorGreaterThanEqualTo ComparisonOperator = "GREATER_THAN_EQUAL_TO"
	ComparisonOperatorGreaterThan        ComparisonOperator = "GREATER_THAN"
	ComparisonOperatorLessThanEqualTo    ComparisonOperator = "LESS_THAN_EQUAL_TO"
	ComparisonOperatorLessThan           ComparisonOperator = "LESS_THAN"
)

// Values returns all known values for ComparisonOperator. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ComparisonOperator) Values() []ComparisonOperator {
	return []ComparisonOperator{
		"EQUAL",
		"NOT_EQUAL",
		"GREATER_THAN_EQUAL_TO",
		"GREATER_THAN",
		"LESS_THAN_EQUAL_TO",
		"LESS_THAN",
	}
}

type CompletedStatus string

// Enum values for CompletedStatus
const (
	CompletedStatusSucceeded      CompletedStatus = "SUCCEEDED"
	CompletedStatusFailed         CompletedStatus = "FAILED"
	CompletedStatusInterrupted    CompletedStatus = "INTERRUPTED"
	CompletedStatusCanceled       CompletedStatus = "CANCELED"
	CompletedStatusNeverAttempted CompletedStatus = "NEVER_ATTEMPTED"
)

// Values returns all known values for CompletedStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (CompletedStatus) Values() []CompletedStatus {
	return []CompletedStatus{
		"SUCCEEDED",
		"FAILED",
		"INTERRUPTED",
		"CANCELED",
		"NEVER_ATTEMPTED",
	}
}

type ConflictExceptionReason string

// Enum values for ConflictExceptionReason
const (
	ConflictExceptionReasonConflictException      ConflictExceptionReason = "CONFLICT_EXCEPTION"
	ConflictExceptionReasonConcurrentModification ConflictExceptionReason = "CONCURRENT_MODIFICATION"
	ConflictExceptionReasonResourceAlreadyExists  ConflictExceptionReason = "RESOURCE_ALREADY_EXISTS"
	ConflictExceptionReasonResourceInUse          ConflictExceptionReason = "RESOURCE_IN_USE"
	ConflictExceptionReasonStatusConflict         ConflictExceptionReason = "STATUS_CONFLICT"
)

// Values returns all known values for ConflictExceptionReason. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ConflictExceptionReason) Values() []ConflictExceptionReason {
	return []ConflictExceptionReason{
		"CONFLICT_EXCEPTION",
		"CONCURRENT_MODIFICATION",
		"RESOURCE_ALREADY_EXISTS",
		"RESOURCE_IN_USE",
		"STATUS_CONFLICT",
	}
}

type CpuArchitectureType string

// Enum values for CpuArchitectureType
const (
	CpuArchitectureTypeX8664 CpuArchitectureType = "x86_64"
	CpuArchitectureTypeArm64 CpuArchitectureType = "arm64"
)

// Values returns all known values for CpuArchitectureType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (CpuArchitectureType) Values() []CpuArchitectureType {
	return []CpuArchitectureType{
		"x86_64",
		"arm64",
	}
}

type CreateJobTargetTaskRunStatus string

// Enum values for CreateJobTargetTaskRunStatus
const (
	CreateJobTargetTaskRunStatusReady     CreateJobTargetTaskRunStatus = "READY"
	CreateJobTargetTaskRunStatusSuspended CreateJobTargetTaskRunStatus = "SUSPENDED"
)

// Values returns all known values for CreateJobTargetTaskRunStatus. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (CreateJobTargetTaskRunStatus) Values() []CreateJobTargetTaskRunStatus {
	return []CreateJobTargetTaskRunStatus{
		"READY",
		"SUSPENDED",
	}
}

type CustomerManagedFleetOperatingSystemFamily string

// Enum values for CustomerManagedFleetOperatingSystemFamily
const (
	CustomerManagedFleetOperatingSystemFamilyWindows CustomerManagedFleetOperatingSystemFamily = "WINDOWS"
	CustomerManagedFleetOperatingSystemFamilyLinux   CustomerManagedFleetOperatingSystemFamily = "LINUX"
	CustomerManagedFleetOperatingSystemFamilyMacos   CustomerManagedFleetOperatingSystemFamily = "MACOS"
)

// Values returns all known values for CustomerManagedFleetOperatingSystemFamily.
// Note that this can be expanded in the future, and so it is only as up to date as
// the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (CustomerManagedFleetOperatingSystemFamily) Values() []CustomerManagedFleetOperatingSystemFamily {
	return []CustomerManagedFleetOperatingSystemFamily{
		"WINDOWS",
		"LINUX",
		"MACOS",
	}
}

type DeadlinePrincipalType string

// Enum values for DeadlinePrincipalType
const (
	DeadlinePrincipalTypeUser  DeadlinePrincipalType = "USER"
	DeadlinePrincipalTypeGroup DeadlinePrincipalType = "GROUP"
)

// Values returns all known values for DeadlinePrincipalType. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DeadlinePrincipalType) Values() []DeadlinePrincipalType {
	return []DeadlinePrincipalType{
		"USER",
		"GROUP",
	}
}

type DefaultQueueBudgetAction string

// Enum values for DefaultQueueBudgetAction
const (
	DefaultQueueBudgetActionNone                           DefaultQueueBudgetAction = "NONE"
	DefaultQueueBudgetActionStopSchedulingAndCompleteTasks DefaultQueueBudgetAction = "STOP_SCHEDULING_AND_COMPLETE_TASKS"
	DefaultQueueBudgetActionStopSchedulingAndCancelTasks   DefaultQueueBudgetAction = "STOP_SCHEDULING_AND_CANCEL_TASKS"
)

// Values returns all known values for DefaultQueueBudgetAction. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DefaultQueueBudgetAction) Values() []DefaultQueueBudgetAction {
	return []DefaultQueueBudgetAction{
		"NONE",
		"STOP_SCHEDULING_AND_COMPLETE_TASKS",
		"STOP_SCHEDULING_AND_CANCEL_TASKS",
	}
}

type DependencyConsumerResolutionStatus string

// Enum values for DependencyConsumerResolutionStatus
const (
	DependencyConsumerResolutionStatusResolved   DependencyConsumerResolutionStatus = "RESOLVED"
	DependencyConsumerResolutionStatusUnresolved DependencyConsumerResolutionStatus = "UNRESOLVED"
)

// Values returns all known values for DependencyConsumerResolutionStatus. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DependencyConsumerResolutionStatus) Values() []DependencyConsumerResolutionStatus {
	return []DependencyConsumerResolutionStatus{
		"RESOLVED",
		"UNRESOLVED",
	}
}

type DesiredWorkerStatus string

// Enum values for DesiredWorkerStatus
const (
	DesiredWorkerStatusStopped DesiredWorkerStatus = "STOPPED"
)

// Values returns all known values for DesiredWorkerStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DesiredWorkerStatus) Values() []DesiredWorkerStatus {
	return []DesiredWorkerStatus{
		"STOPPED",
	}
}

type Ec2MarketType string

// Enum values for Ec2MarketType
const (
	Ec2MarketTypeOnDemand Ec2MarketType = "on-demand"
	Ec2MarketTypeSpot     Ec2MarketType = "spot"
)

// Values returns all known values for Ec2MarketType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (Ec2MarketType) Values() []Ec2MarketType {
	return []Ec2MarketType{
		"on-demand",
		"spot",
	}
}

type EnvironmentTemplateType string

// Enum values for EnvironmentTemplateType
const (
	EnvironmentTemplateTypeJson EnvironmentTemplateType = "JSON"
	EnvironmentTemplateTypeYaml EnvironmentTemplateType = "YAML"
)

// Values returns all known values for EnvironmentTemplateType. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (EnvironmentTemplateType) Values() []EnvironmentTemplateType {
	return []EnvironmentTemplateType{
		"JSON",
		"YAML",
	}
}

type FileSystemLocationType string

// Enum values for FileSystemLocationType
const (
	FileSystemLocationTypeShared FileSystemLocationType = "SHARED"
	FileSystemLocationTypeLocal  FileSystemLocationType = "LOCAL"
)

// Values returns all known values for FileSystemLocationType. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (FileSystemLocationType) Values() []FileSystemLocationType {
	return []FileSystemLocationType{
		"SHARED",
		"LOCAL",
	}
}

type FleetStatus string

// Enum values for FleetStatus
const (
	FleetStatusActive           FleetStatus = "ACTIVE"
	FleetStatusCreateInProgress FleetStatus = "CREATE_IN_PROGRESS"
	FleetStatusUpdateInProgress FleetStatus = "UPDATE_IN_PROGRESS"
	FleetStatusCreateFailed     FleetStatus = "CREATE_FAILED"
	FleetStatusUpdateFailed     FleetStatus = "UPDATE_FAILED"
)

// Values returns all known values for FleetStatus. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (FleetStatus) Values() []FleetStatus {
	return []FleetStatus{
		"ACTIVE",
		"CREATE_IN_PROGRESS",
		"UPDATE_IN_PROGRESS",
		"CREATE_FAILED",
		"UPDATE_FAILED",
	}
}

type JobAttachmentsFileSystem string

// Enum values for JobAttachmentsFileSystem
const (
	JobAttachmentsFileSystemCopied  JobAttachmentsFileSystem = "COPIED"
	JobAttachmentsFileSystemVirtual JobAttachmentsFileSystem = "VIRTUAL"
)

// Values returns all known values for JobAttachmentsFileSystem. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (JobAttachmentsFileSystem) Values() []JobAttachmentsFileSystem {
	return []JobAttachmentsFileSystem{
		"COPIED",
		"VIRTUAL",
	}
}

type JobEntityErrorCode string

// Enum values for JobEntityErrorCode
const (
	JobEntityErrorCodeAccessDeniedException     JobEntityErrorCode = "AccessDeniedException"
	JobEntityErrorCodeInternalServerException   JobEntityErrorCode = "InternalServerException"
	JobEntityErrorCodeValidationException       JobEntityErrorCode = "ValidationException"
	JobEntityErrorCodeResourceNotFoundException JobEntityErrorCode = "ResourceNotFoundException"
	JobEntityErrorCodeMaxPayloadSizeExceeded    JobEntityErrorCode = "MaxPayloadSizeExceeded"
	JobEntityErrorCodeConflictException         JobEntityErrorCode = "ConflictException"
)

// Values returns all known values for JobEntityErrorCode. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (JobEntityErrorCode) Values() []JobEntityErrorCode {
	return []JobEntityErrorCode{
		"AccessDeniedException",
		"InternalServerException",
		"ValidationException",
		"ResourceNotFoundException",
		"MaxPayloadSizeExceeded",
		"ConflictException",
	}
}

type JobLifecycleStatus string

// Enum values for JobLifecycleStatus
const (
	JobLifecycleStatusCreateInProgress JobLifecycleStatus = "CREATE_IN_PROGRESS"
	JobLifecycleStatusCreateFailed     JobLifecycleStatus = "CREATE_FAILED"
	JobLifecycleStatusCreateComplete   JobLifecycleStatus = "CREATE_COMPLETE"
	JobLifecycleStatusUploadInProgress JobLifecycleStatus = "UPLOAD_IN_PROGRESS"
	JobLifecycleStatusUploadFailed     JobLifecycleStatus = "UPLOAD_FAILED"
	JobLifecycleStatusUpdateInProgress JobLifecycleStatus = "UPDATE_IN_PROGRESS"
	JobLifecycleStatusUpdateFailed     JobLifecycleStatus = "UPDATE_FAILED"
	JobLifecycleStatusUpdateSucceeded  JobLifecycleStatus = "UPDATE_SUCCEEDED"
	JobLifecycleStatusArchived         JobLifecycleStatus = "ARCHIVED"
)

// Values returns all known values for JobLifecycleStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (JobLifecycleStatus) Values() []JobLifecycleStatus {
	return []JobLifecycleStatus{
		"CREATE_IN_PROGRESS",
		"CREATE_FAILED",
		"CREATE_COMPLETE",
		"UPLOAD_IN_PROGRESS",
		"UPLOAD_FAILED",
		"UPDATE_IN_PROGRESS",
		"UPDATE_FAILED",
		"UPDATE_SUCCEEDED",
		"ARCHIVED",
	}
}

type JobTargetTaskRunStatus string

// Enum values for JobTargetTaskRunStatus
const (
	JobTargetTaskRunStatusReady     JobTargetTaskRunStatus = "READY"
	JobTargetTaskRunStatusFailed    JobTargetTaskRunStatus = "FAILED"
	JobTargetTaskRunStatusSucceeded JobTargetTaskRunStatus = "SUCCEEDED"
	JobTargetTaskRunStatusCanceled  JobTargetTaskRunStatus = "CANCELED"
	JobTargetTaskRunStatusSuspended JobTargetTaskRunStatus = "SUSPENDED"
	JobTargetTaskRunStatusPending   JobTargetTaskRunStatus = "PENDING"
)

// Values returns all known values for JobTargetTaskRunStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (JobTargetTaskRunStatus) Values() []JobTargetTaskRunStatus {
	return []JobTargetTaskRunStatus{
		"READY",
		"FAILED",
		"SUCCEEDED",
		"CANCELED",
		"SUSPENDED",
		"PENDING",
	}
}

type JobTemplateType string

// Enum values for JobTemplateType
const (
	JobTemplateTypeJson JobTemplateType = "JSON"
	JobTemplateTypeYaml JobTemplateType = "YAML"
)

// Values returns all known values for JobTemplateType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (JobTemplateType) Values() []JobTemplateType {
	return []JobTemplateType{
		"JSON",
		"YAML",
	}
}

type LicenseEndpointStatus string

// Enum values for LicenseEndpointStatus
const (
	LicenseEndpointStatusCreateInProgress LicenseEndpointStatus = "CREATE_IN_PROGRESS"
	LicenseEndpointStatusDeleteInProgress LicenseEndpointStatus = "DELETE_IN_PROGRESS"
	LicenseEndpointStatusReady            LicenseEndpointStatus = "READY"
	LicenseEndpointStatusNotReady         LicenseEndpointStatus = "NOT_READY"
)

// Values returns all known values for LicenseEndpointStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (LicenseEndpointStatus) Values() []LicenseEndpointStatus {
	return []LicenseEndpointStatus{
		"CREATE_IN_PROGRESS",
		"DELETE_IN_PROGRESS",
		"READY",
		"NOT_READY",
	}
}

type LogicalOperator string

// Enum values for LogicalOperator
const (
	LogicalOperatorAnd LogicalOperator = "AND"
	LogicalOperatorOr  LogicalOperator = "OR"
)

// Values returns all known values for LogicalOperator. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (LogicalOperator) Values() []LogicalOperator {
	return []LogicalOperator{
		"AND",
		"OR",
	}
}

type MembershipLevel string

// Enum values for MembershipLevel
const (
	MembershipLevelViewer      MembershipLevel = "VIEWER"
	MembershipLevelContributor MembershipLevel = "CONTRIBUTOR"
	MembershipLevelOwner       MembershipLevel = "OWNER"
	MembershipLevelManager     MembershipLevel = "MANAGER"
)

// Values returns all known values for MembershipLevel. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (MembershipLevel) Values() []MembershipLevel {
	return []MembershipLevel{
		"VIEWER",
		"CONTRIBUTOR",
		"OWNER",
		"MANAGER",
	}
}

type PathFormat string

// Enum values for PathFormat
const (
	PathFormatWindows PathFormat = "windows"
	PathFormatPosix   PathFormat = "posix"
)

// Values returns all known values for PathFormat. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (PathFormat) Values() []PathFormat {
	return []PathFormat{
		"windows",
		"posix",
	}
}

type Period string

// Enum values for Period
const (
	PeriodHourly  Period = "HOURLY"
	PeriodDaily   Period = "DAILY"
	PeriodWeekly  Period = "WEEKLY"
	PeriodMonthly Period = "MONTHLY"
)

// Values returns all known values for Period. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (Period) Values() []Period {
	return []Period{
		"HOURLY",
		"DAILY",
		"WEEKLY",
		"MONTHLY",
	}
}

type QueueBlockedReason string

// Enum values for QueueBlockedReason
const (
	QueueBlockedReasonNoBudgetConfigured     QueueBlockedReason = "NO_BUDGET_CONFIGURED"
	QueueBlockedReasonBudgetThresholdReached QueueBlockedReason = "BUDGET_THRESHOLD_REACHED"
)

// Values returns all known values for QueueBlockedReason. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (QueueBlockedReason) Values() []QueueBlockedReason {
	return []QueueBlockedReason{
		"NO_BUDGET_CONFIGURED",
		"BUDGET_THRESHOLD_REACHED",
	}
}

type QueueFleetAssociationStatus string

// Enum values for QueueFleetAssociationStatus
const (
	QueueFleetAssociationStatusActive                         QueueFleetAssociationStatus = "ACTIVE"
	QueueFleetAssociationStatusStopSchedulingAndCompleteTasks QueueFleetAssociationStatus = "STOP_SCHEDULING_AND_COMPLETE_TASKS"
	QueueFleetAssociationStatusStopSchedulingAndCancelTasks   QueueFleetAssociationStatus = "STOP_SCHEDULING_AND_CANCEL_TASKS"
	QueueFleetAssociationStatusStopped                        QueueFleetAssociationStatus = "STOPPED"
)

// Values returns all known values for QueueFleetAssociationStatus. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (QueueFleetAssociationStatus) Values() []QueueFleetAssociationStatus {
	return []QueueFleetAssociationStatus{
		"ACTIVE",
		"STOP_SCHEDULING_AND_COMPLETE_TASKS",
		"STOP_SCHEDULING_AND_CANCEL_TASKS",
		"STOPPED",
	}
}

type QueueStatus string

// Enum values for QueueStatus
const (
	QueueStatusIdle              QueueStatus = "IDLE"
	QueueStatusScheduling        QueueStatus = "SCHEDULING"
	QueueStatusSchedulingBlocked QueueStatus = "SCHEDULING_BLOCKED"
)

// Values returns all known values for QueueStatus. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (QueueStatus) Values() []QueueStatus {
	return []QueueStatus{
		"IDLE",
		"SCHEDULING",
		"SCHEDULING_BLOCKED",
	}
}

type RunAs string

// Enum values for RunAs
const (
	RunAsQueueConfiguredUser RunAs = "QUEUE_CONFIGURED_USER"
	RunAsWorkerAgentUser     RunAs = "WORKER_AGENT_USER"
)

// Values returns all known values for RunAs. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (RunAs) Values() []RunAs {
	return []RunAs{
		"QUEUE_CONFIGURED_USER",
		"WORKER_AGENT_USER",
	}
}

type ServiceManagedFleetOperatingSystemFamily string

// Enum values for ServiceManagedFleetOperatingSystemFamily
const (
	ServiceManagedFleetOperatingSystemFamilyWindows ServiceManagedFleetOperatingSystemFamily = "WINDOWS"
	ServiceManagedFleetOperatingSystemFamilyLinux   ServiceManagedFleetOperatingSystemFamily = "LINUX"
)

// Values returns all known values for ServiceManagedFleetOperatingSystemFamily.
// Note that this can be expanded in the future, and so it is only as up to date as
// the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ServiceManagedFleetOperatingSystemFamily) Values() []ServiceManagedFleetOperatingSystemFamily {
	return []ServiceManagedFleetOperatingSystemFamily{
		"WINDOWS",
		"LINUX",
	}
}

type ServiceQuotaExceededExceptionReason string

// Enum values for ServiceQuotaExceededExceptionReason
const (
	ServiceQuotaExceededExceptionReasonServiceQuotaExceededException ServiceQuotaExceededExceptionReason = "SERVICE_QUOTA_EXCEEDED_EXCEPTION"
	ServiceQuotaExceededExceptionReasonKmsKeyLimitExceeded           ServiceQuotaExceededExceptionReason = "KMS_KEY_LIMIT_EXCEEDED"
)

// Values returns all known values for ServiceQuotaExceededExceptionReason. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ServiceQuotaExceededExceptionReason) Values() []ServiceQuotaExceededExceptionReason {
	return []ServiceQuotaExceededExceptionReason{
		"SERVICE_QUOTA_EXCEEDED_EXCEPTION",
		"KMS_KEY_LIMIT_EXCEEDED",
	}
}

type SessionActionStatus string

// Enum values for SessionActionStatus
const (
	SessionActionStatusAssigned       SessionActionStatus = "ASSIGNED"
	SessionActionStatusRunning        SessionActionStatus = "RUNNING"
	SessionActionStatusCanceling      SessionActionStatus = "CANCELING"
	SessionActionStatusSucceeded      SessionActionStatus = "SUCCEEDED"
	SessionActionStatusFailed         SessionActionStatus = "FAILED"
	SessionActionStatusInterrupted    SessionActionStatus = "INTERRUPTED"
	SessionActionStatusCanceled       SessionActionStatus = "CANCELED"
	SessionActionStatusNeverAttempted SessionActionStatus = "NEVER_ATTEMPTED"
	SessionActionStatusScheduled      SessionActionStatus = "SCHEDULED"
	SessionActionStatusReclaiming     SessionActionStatus = "RECLAIMING"
	SessionActionStatusReclaimed      SessionActionStatus = "RECLAIMED"
)

// Values returns all known values for SessionActionStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SessionActionStatus) Values() []SessionActionStatus {
	return []SessionActionStatus{
		"ASSIGNED",
		"RUNNING",
		"CANCELING",
		"SUCCEEDED",
		"FAILED",
		"INTERRUPTED",
		"CANCELED",
		"NEVER_ATTEMPTED",
		"SCHEDULED",
		"RECLAIMING",
		"RECLAIMED",
	}
}

type SessionLifecycleStatus string

// Enum values for SessionLifecycleStatus
const (
	SessionLifecycleStatusStarted          SessionLifecycleStatus = "STARTED"
	SessionLifecycleStatusUpdateInProgress SessionLifecycleStatus = "UPDATE_IN_PROGRESS"
	SessionLifecycleStatusUpdateSucceeded  SessionLifecycleStatus = "UPDATE_SUCCEEDED"
	SessionLifecycleStatusUpdateFailed     SessionLifecycleStatus = "UPDATE_FAILED"
	SessionLifecycleStatusEnded            SessionLifecycleStatus = "ENDED"
)

// Values returns all known values for SessionLifecycleStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SessionLifecycleStatus) Values() []SessionLifecycleStatus {
	return []SessionLifecycleStatus{
		"STARTED",
		"UPDATE_IN_PROGRESS",
		"UPDATE_SUCCEEDED",
		"UPDATE_FAILED",
		"ENDED",
	}
}

type SessionLifecycleTargetStatus string

// Enum values for SessionLifecycleTargetStatus
const (
	SessionLifecycleTargetStatusEnded SessionLifecycleTargetStatus = "ENDED"
)

// Values returns all known values for SessionLifecycleTargetStatus. Note that
// this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SessionLifecycleTargetStatus) Values() []SessionLifecycleTargetStatus {
	return []SessionLifecycleTargetStatus{
		"ENDED",
	}
}

type SessionsStatisticsAggregationStatus string

// Enum values for SessionsStatisticsAggregationStatus
const (
	SessionsStatisticsAggregationStatusInProgress SessionsStatisticsAggregationStatus = "IN_PROGRESS"
	SessionsStatisticsAggregationStatusTimeout    SessionsStatisticsAggregationStatus = "TIMEOUT"
	SessionsStatisticsAggregationStatusFailed     SessionsStatisticsAggregationStatus = "FAILED"
	SessionsStatisticsAggregationStatusCompleted  SessionsStatisticsAggregationStatus = "COMPLETED"
)

// Values returns all known values for SessionsStatisticsAggregationStatus. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SessionsStatisticsAggregationStatus) Values() []SessionsStatisticsAggregationStatus {
	return []SessionsStatisticsAggregationStatus{
		"IN_PROGRESS",
		"TIMEOUT",
		"FAILED",
		"COMPLETED",
	}
}

type SortOrder string

// Enum values for SortOrder
const (
	SortOrderAscending  SortOrder = "ASCENDING"
	SortOrderDescending SortOrder = "DESCENDING"
)

// Values returns all known values for SortOrder. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SortOrder) Values() []SortOrder {
	return []SortOrder{
		"ASCENDING",
		"DESCENDING",
	}
}

type StepLifecycleStatus string

// Enum values for StepLifecycleStatus
const (
	StepLifecycleStatusCreateComplete   StepLifecycleStatus = "CREATE_COMPLETE"
	StepLifecycleStatusUpdateInProgress StepLifecycleStatus = "UPDATE_IN_PROGRESS"
	StepLifecycleStatusUpdateFailed     StepLifecycleStatus = "UPDATE_FAILED"
	StepLifecycleStatusUpdateSucceeded  StepLifecycleStatus = "UPDATE_SUCCEEDED"
)

// Values returns all known values for StepLifecycleStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (StepLifecycleStatus) Values() []StepLifecycleStatus {
	return []StepLifecycleStatus{
		"CREATE_COMPLETE",
		"UPDATE_IN_PROGRESS",
		"UPDATE_FAILED",
		"UPDATE_SUCCEEDED",
	}
}

type StepParameterType string

// Enum values for StepParameterType
const (
	StepParameterTypeInt    StepParameterType = "INT"
	StepParameterTypeFloat  StepParameterType = "FLOAT"
	StepParameterTypeString StepParameterType = "STRING"
	StepParameterTypePath   StepParameterType = "PATH"
)

// Values returns all known values for StepParameterType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (StepParameterType) Values() []StepParameterType {
	return []StepParameterType{
		"INT",
		"FLOAT",
		"STRING",
		"PATH",
	}
}

type StepTargetTaskRunStatus string

// Enum values for StepTargetTaskRunStatus
const (
	StepTargetTaskRunStatusReady     StepTargetTaskRunStatus = "READY"
	StepTargetTaskRunStatusFailed    StepTargetTaskRunStatus = "FAILED"
	StepTargetTaskRunStatusSucceeded StepTargetTaskRunStatus = "SUCCEEDED"
	StepTargetTaskRunStatusCanceled  StepTargetTaskRunStatus = "CANCELED"
	StepTargetTaskRunStatusSuspended StepTargetTaskRunStatus = "SUSPENDED"
	StepTargetTaskRunStatusPending   StepTargetTaskRunStatus = "PENDING"
)

// Values returns all known values for StepTargetTaskRunStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (StepTargetTaskRunStatus) Values() []StepTargetTaskRunStatus {
	return []StepTargetTaskRunStatus{
		"READY",
		"FAILED",
		"SUCCEEDED",
		"CANCELED",
		"SUSPENDED",
		"PENDING",
	}
}

type StorageProfileOperatingSystemFamily string

// Enum values for StorageProfileOperatingSystemFamily
const (
	StorageProfileOperatingSystemFamilyWindows StorageProfileOperatingSystemFamily = "WINDOWS"
	StorageProfileOperatingSystemFamilyLinux   StorageProfileOperatingSystemFamily = "LINUX"
	StorageProfileOperatingSystemFamilyMacos   StorageProfileOperatingSystemFamily = "MACOS"
)

// Values returns all known values for StorageProfileOperatingSystemFamily. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (StorageProfileOperatingSystemFamily) Values() []StorageProfileOperatingSystemFamily {
	return []StorageProfileOperatingSystemFamily{
		"WINDOWS",
		"LINUX",
		"MACOS",
	}
}

type TaskRunStatus string

// Enum values for TaskRunStatus
const (
	TaskRunStatusPending       TaskRunStatus = "PENDING"
	TaskRunStatusReady         TaskRunStatus = "READY"
	TaskRunStatusAssigned      TaskRunStatus = "ASSIGNED"
	TaskRunStatusStarting      TaskRunStatus = "STARTING"
	TaskRunStatusScheduled     TaskRunStatus = "SCHEDULED"
	TaskRunStatusInterrupting  TaskRunStatus = "INTERRUPTING"
	TaskRunStatusRunning       TaskRunStatus = "RUNNING"
	TaskRunStatusSuspended     TaskRunStatus = "SUSPENDED"
	TaskRunStatusCanceled      TaskRunStatus = "CANCELED"
	TaskRunStatusFailed        TaskRunStatus = "FAILED"
	TaskRunStatusSucceeded     TaskRunStatus = "SUCCEEDED"
	TaskRunStatusNotCompatible TaskRunStatus = "NOT_COMPATIBLE"
)

// Values returns all known values for TaskRunStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (TaskRunStatus) Values() []TaskRunStatus {
	return []TaskRunStatus{
		"PENDING",
		"READY",
		"ASSIGNED",
		"STARTING",
		"SCHEDULED",
		"INTERRUPTING",
		"RUNNING",
		"SUSPENDED",
		"CANCELED",
		"FAILED",
		"SUCCEEDED",
		"NOT_COMPATIBLE",
	}
}

type TaskTargetRunStatus string

// Enum values for TaskTargetRunStatus
const (
	TaskTargetRunStatusReady     TaskTargetRunStatus = "READY"
	TaskTargetRunStatusFailed    TaskTargetRunStatus = "FAILED"
	TaskTargetRunStatusSucceeded TaskTargetRunStatus = "SUCCEEDED"
	TaskTargetRunStatusCanceled  TaskTargetRunStatus = "CANCELED"
	TaskTargetRunStatusSuspended TaskTargetRunStatus = "SUSPENDED"
	TaskTargetRunStatusPending   TaskTargetRunStatus = "PENDING"
)

// Values returns all known values for TaskTargetRunStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (TaskTargetRunStatus) Values() []TaskTargetRunStatus {
	return []TaskTargetRunStatus{
		"READY",
		"FAILED",
		"SUCCEEDED",
		"CANCELED",
		"SUSPENDED",
		"PENDING",
	}
}

type UpdatedWorkerStatus string

// Enum values for UpdatedWorkerStatus
const (
	UpdatedWorkerStatusStarted  UpdatedWorkerStatus = "STARTED"
	UpdatedWorkerStatusStopping UpdatedWorkerStatus = "STOPPING"
	UpdatedWorkerStatusStopped  UpdatedWorkerStatus = "STOPPED"
)

// Values returns all known values for UpdatedWorkerStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UpdatedWorkerStatus) Values() []UpdatedWorkerStatus {
	return []UpdatedWorkerStatus{
		"STARTED",
		"STOPPING",
		"STOPPED",
	}
}

type UpdateJobLifecycleStatus string

// Enum values for UpdateJobLifecycleStatus
const (
	UpdateJobLifecycleStatusArchived UpdateJobLifecycleStatus = "ARCHIVED"
)

// Values returns all known values for UpdateJobLifecycleStatus. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UpdateJobLifecycleStatus) Values() []UpdateJobLifecycleStatus {
	return []UpdateJobLifecycleStatus{
		"ARCHIVED",
	}
}

type UpdateQueueFleetAssociationStatus string

// Enum values for UpdateQueueFleetAssociationStatus
const (
	UpdateQueueFleetAssociationStatusActive                         UpdateQueueFleetAssociationStatus = "ACTIVE"
	UpdateQueueFleetAssociationStatusStopSchedulingAndCompleteTasks UpdateQueueFleetAssociationStatus = "STOP_SCHEDULING_AND_COMPLETE_TASKS"
	UpdateQueueFleetAssociationStatusStopSchedulingAndCancelTasks   UpdateQueueFleetAssociationStatus = "STOP_SCHEDULING_AND_CANCEL_TASKS"
)

// Values returns all known values for UpdateQueueFleetAssociationStatus. Note
// that this can be expanded in the future, and so it is only as up to date as the
// client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UpdateQueueFleetAssociationStatus) Values() []UpdateQueueFleetAssociationStatus {
	return []UpdateQueueFleetAssociationStatus{
		"ACTIVE",
		"STOP_SCHEDULING_AND_COMPLETE_TASKS",
		"STOP_SCHEDULING_AND_CANCEL_TASKS",
	}
}

type UsageGroupByField string

// Enum values for UsageGroupByField
const (
	UsageGroupByFieldQueueId        UsageGroupByField = "QUEUE_ID"
	UsageGroupByFieldFleetId        UsageGroupByField = "FLEET_ID"
	UsageGroupByFieldJobId          UsageGroupByField = "JOB_ID"
	UsageGroupByFieldUserId         UsageGroupByField = "USER_ID"
	UsageGroupByFieldUsageType      UsageGroupByField = "USAGE_TYPE"
	UsageGroupByFieldInstanceType   UsageGroupByField = "INSTANCE_TYPE"
	UsageGroupByFieldLicenseProduct UsageGroupByField = "LICENSE_PRODUCT"
)

// Values returns all known values for UsageGroupByField. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UsageGroupByField) Values() []UsageGroupByField {
	return []UsageGroupByField{
		"QUEUE_ID",
		"FLEET_ID",
		"JOB_ID",
		"USER_ID",
		"USAGE_TYPE",
		"INSTANCE_TYPE",
		"LICENSE_PRODUCT",
	}
}

type UsageStatistic string

// Enum values for UsageStatistic
const (
	UsageStatisticSum UsageStatistic = "SUM"
	UsageStatisticMin UsageStatistic = "MIN"
	UsageStatisticMax UsageStatistic = "MAX"
	UsageStatisticAvg UsageStatistic = "AVG"
)

// Values returns all known values for UsageStatistic. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UsageStatistic) Values() []UsageStatistic {
	return []UsageStatistic{
		"SUM",
		"MIN",
		"MAX",
		"AVG",
	}
}

type UsageType string

// Enum values for UsageType
const (
	UsageTypeCompute UsageType = "COMPUTE"
	UsageTypeLicense UsageType = "LICENSE"
)

// Values returns all known values for UsageType. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UsageType) Values() []UsageType {
	return []UsageType{
		"COMPUTE",
		"LICENSE",
	}
}

type ValidationExceptionReason string

// Enum values for ValidationExceptionReason
const (
	ValidationExceptionReasonUnknownOperation      ValidationExceptionReason = "UNKNOWN_OPERATION"
	ValidationExceptionReasonCannotParse           ValidationExceptionReason = "CANNOT_PARSE"
	ValidationExceptionReasonFieldValidationFailed ValidationExceptionReason = "FIELD_VALIDATION_FAILED"
	ValidationExceptionReasonOther                 ValidationExceptionReason = "OTHER"
)

// Values returns all known values for ValidationExceptionReason. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ValidationExceptionReason) Values() []ValidationExceptionReason {
	return []ValidationExceptionReason{
		"UNKNOWN_OPERATION",
		"CANNOT_PARSE",
		"FIELD_VALIDATION_FAILED",
		"OTHER",
	}
}

type WorkerStatus string

// Enum values for WorkerStatus
const (
	WorkerStatusCreated       WorkerStatus = "CREATED"
	WorkerStatusStarted       WorkerStatus = "STARTED"
	WorkerStatusStopping      WorkerStatus = "STOPPING"
	WorkerStatusStopped       WorkerStatus = "STOPPED"
	WorkerStatusNotResponding WorkerStatus = "NOT_RESPONDING"
	WorkerStatusNotCompatible WorkerStatus = "NOT_COMPATIBLE"
	WorkerStatusRunning       WorkerStatus = "RUNNING"
	WorkerStatusIdle          WorkerStatus = "IDLE"
)

// Values returns all known values for WorkerStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (WorkerStatus) Values() []WorkerStatus {
	return []WorkerStatus{
		"CREATED",
		"STARTED",
		"STOPPING",
		"STOPPED",
		"NOT_RESPONDING",
		"NOT_COMPATIBLE",
		"RUNNING",
		"IDLE",
	}
}
