// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/common/ad_type_infos.proto

package common

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A text ad.
type TextAdInfo struct {
	// The headline of the ad.
	Headline *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline,proto3" json:"headline,omitempty"`
	// The first line of the ad's description.
	Description1 *wrappers.StringValue `protobuf:"bytes,2,opt,name=description1,proto3" json:"description1,omitempty"`
	// The second line of the ad's description.
	Description2         *wrappers.StringValue `protobuf:"bytes,3,opt,name=description2,proto3" json:"description2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TextAdInfo) Reset()         { *m = TextAdInfo{} }
func (m *TextAdInfo) String() string { return proto.CompactTextString(m) }
func (*TextAdInfo) ProtoMessage()    {}
func (*TextAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{0}
}

func (m *TextAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextAdInfo.Unmarshal(m, b)
}
func (m *TextAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextAdInfo.Marshal(b, m, deterministic)
}
func (m *TextAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextAdInfo.Merge(m, src)
}
func (m *TextAdInfo) XXX_Size() int {
	return xxx_messageInfo_TextAdInfo.Size(m)
}
func (m *TextAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TextAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TextAdInfo proto.InternalMessageInfo

func (m *TextAdInfo) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

func (m *TextAdInfo) GetDescription1() *wrappers.StringValue {
	if m != nil {
		return m.Description1
	}
	return nil
}

func (m *TextAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

// An expanded text ad.
type ExpandedTextAdInfo struct {
	// The first part of the ad's headline.
	HeadlinePart1 *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline_part1,json=headlinePart1,proto3" json:"headline_part1,omitempty"`
	// The second part of the ad's headline.
	HeadlinePart2 *wrappers.StringValue `protobuf:"bytes,2,opt,name=headline_part2,json=headlinePart2,proto3" json:"headline_part2,omitempty"`
	// The third part of the ad's headline.
	HeadlinePart3 *wrappers.StringValue `protobuf:"bytes,6,opt,name=headline_part3,json=headlinePart3,proto3" json:"headline_part3,omitempty"`
	// The description of the ad.
	Description *wrappers.StringValue `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The second description of the ad.
	Description2 *wrappers.StringValue `protobuf:"bytes,7,opt,name=description2,proto3" json:"description2,omitempty"`
	// The text that can appear alongside the ad's displayed URL.
	Path1 *wrappers.StringValue `protobuf:"bytes,4,opt,name=path1,proto3" json:"path1,omitempty"`
	// Additional text that can appear alongside the ad's displayed URL.
	Path2                *wrappers.StringValue `protobuf:"bytes,5,opt,name=path2,proto3" json:"path2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExpandedTextAdInfo) Reset()         { *m = ExpandedTextAdInfo{} }
func (m *ExpandedTextAdInfo) String() string { return proto.CompactTextString(m) }
func (*ExpandedTextAdInfo) ProtoMessage()    {}
func (*ExpandedTextAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{1}
}

func (m *ExpandedTextAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExpandedTextAdInfo.Unmarshal(m, b)
}
func (m *ExpandedTextAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExpandedTextAdInfo.Marshal(b, m, deterministic)
}
func (m *ExpandedTextAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExpandedTextAdInfo.Merge(m, src)
}
func (m *ExpandedTextAdInfo) XXX_Size() int {
	return xxx_messageInfo_ExpandedTextAdInfo.Size(m)
}
func (m *ExpandedTextAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExpandedTextAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExpandedTextAdInfo proto.InternalMessageInfo

func (m *ExpandedTextAdInfo) GetHeadlinePart1() *wrappers.StringValue {
	if m != nil {
		return m.HeadlinePart1
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetHeadlinePart2() *wrappers.StringValue {
	if m != nil {
		return m.HeadlinePart2
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetHeadlinePart3() *wrappers.StringValue {
	if m != nil {
		return m.HeadlinePart3
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetPath1() *wrappers.StringValue {
	if m != nil {
		return m.Path1
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetPath2() *wrappers.StringValue {
	if m != nil {
		return m.Path2
	}
	return nil
}

// A call-only ad.
type CallOnlyAdInfo struct {
	// The country code in the ad.
	CountryCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// The phone number in the ad.
	PhoneNumber *wrappers.StringValue `protobuf:"bytes,2,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	// The business name in the ad.
	BusinessName *wrappers.StringValue `protobuf:"bytes,3,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// First headline in the ad.
	Headline1 *wrappers.StringValue `protobuf:"bytes,11,opt,name=headline1,proto3" json:"headline1,omitempty"`
	// Second headline in the ad.
	Headline2 *wrappers.StringValue `protobuf:"bytes,12,opt,name=headline2,proto3" json:"headline2,omitempty"`
	// The first line of the ad's description.
	Description1 *wrappers.StringValue `protobuf:"bytes,4,opt,name=description1,proto3" json:"description1,omitempty"`
	// The second line of the ad's description.
	Description2 *wrappers.StringValue `protobuf:"bytes,5,opt,name=description2,proto3" json:"description2,omitempty"`
	// Whether to enable call tracking for the creative. Enabling call
	// tracking also enables call conversions.
	CallTracked *wrappers.BoolValue `protobuf:"bytes,6,opt,name=call_tracked,json=callTracked,proto3" json:"call_tracked,omitempty"`
	// Whether to disable call conversion for the creative.
	// If set to `true`, disables call conversions even when `call_tracked` is
	// `true`.
	// If `call_tracked` is `false`, this field is ignored.
	DisableCallConversion *wrappers.BoolValue `protobuf:"bytes,7,opt,name=disable_call_conversion,json=disableCallConversion,proto3" json:"disable_call_conversion,omitempty"`
	// The URL to be used for phone number verification.
	PhoneNumberVerificationUrl *wrappers.StringValue `protobuf:"bytes,8,opt,name=phone_number_verification_url,json=phoneNumberVerificationUrl,proto3" json:"phone_number_verification_url,omitempty"`
	// The conversion action to attribute a call conversion to. If not set a
	// default conversion action is used. This field only has effect if
	// call_tracked is set to true. Otherwise this field is ignored.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,9,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// The call conversion behavior of this call only ad. It can use its own call
	// conversion setting, inherit the account level setting, or be disabled.
	ConversionReportingState enums.CallConversionReportingStateEnum_CallConversionReportingState `protobuf:"varint,10,opt,name=conversion_reporting_state,json=conversionReportingState,proto3,enum=google.ads.googleads.v3.enums.CallConversionReportingStateEnum_CallConversionReportingState" json:"conversion_reporting_state,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}                                                            `json:"-"`
	XXX_unrecognized         []byte                                                              `json:"-"`
	XXX_sizecache            int32                                                               `json:"-"`
}

func (m *CallOnlyAdInfo) Reset()         { *m = CallOnlyAdInfo{} }
func (m *CallOnlyAdInfo) String() string { return proto.CompactTextString(m) }
func (*CallOnlyAdInfo) ProtoMessage()    {}
func (*CallOnlyAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{2}
}

func (m *CallOnlyAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CallOnlyAdInfo.Unmarshal(m, b)
}
func (m *CallOnlyAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CallOnlyAdInfo.Marshal(b, m, deterministic)
}
func (m *CallOnlyAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CallOnlyAdInfo.Merge(m, src)
}
func (m *CallOnlyAdInfo) XXX_Size() int {
	return xxx_messageInfo_CallOnlyAdInfo.Size(m)
}
func (m *CallOnlyAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CallOnlyAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CallOnlyAdInfo proto.InternalMessageInfo

func (m *CallOnlyAdInfo) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *CallOnlyAdInfo) GetPhoneNumber() *wrappers.StringValue {
	if m != nil {
		return m.PhoneNumber
	}
	return nil
}

func (m *CallOnlyAdInfo) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *CallOnlyAdInfo) GetHeadline1() *wrappers.StringValue {
	if m != nil {
		return m.Headline1
	}
	return nil
}

func (m *CallOnlyAdInfo) GetHeadline2() *wrappers.StringValue {
	if m != nil {
		return m.Headline2
	}
	return nil
}

func (m *CallOnlyAdInfo) GetDescription1() *wrappers.StringValue {
	if m != nil {
		return m.Description1
	}
	return nil
}

func (m *CallOnlyAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

func (m *CallOnlyAdInfo) GetCallTracked() *wrappers.BoolValue {
	if m != nil {
		return m.CallTracked
	}
	return nil
}

func (m *CallOnlyAdInfo) GetDisableCallConversion() *wrappers.BoolValue {
	if m != nil {
		return m.DisableCallConversion
	}
	return nil
}

func (m *CallOnlyAdInfo) GetPhoneNumberVerificationUrl() *wrappers.StringValue {
	if m != nil {
		return m.PhoneNumberVerificationUrl
	}
	return nil
}

func (m *CallOnlyAdInfo) GetConversionAction() *wrappers.StringValue {
	if m != nil {
		return m.ConversionAction
	}
	return nil
}

func (m *CallOnlyAdInfo) GetConversionReportingState() enums.CallConversionReportingStateEnum_CallConversionReportingState {
	if m != nil {
		return m.ConversionReportingState
	}
	return enums.CallConversionReportingStateEnum_UNSPECIFIED
}

// An expanded dynamic search ad.
type ExpandedDynamicSearchAdInfo struct {
	// The description of the ad.
	Description *wrappers.StringValue `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// The second description of the ad.
	Description2         *wrappers.StringValue `protobuf:"bytes,2,opt,name=description2,proto3" json:"description2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExpandedDynamicSearchAdInfo) Reset()         { *m = ExpandedDynamicSearchAdInfo{} }
func (m *ExpandedDynamicSearchAdInfo) String() string { return proto.CompactTextString(m) }
func (*ExpandedDynamicSearchAdInfo) ProtoMessage()    {}
func (*ExpandedDynamicSearchAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{3}
}

func (m *ExpandedDynamicSearchAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExpandedDynamicSearchAdInfo.Unmarshal(m, b)
}
func (m *ExpandedDynamicSearchAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExpandedDynamicSearchAdInfo.Marshal(b, m, deterministic)
}
func (m *ExpandedDynamicSearchAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExpandedDynamicSearchAdInfo.Merge(m, src)
}
func (m *ExpandedDynamicSearchAdInfo) XXX_Size() int {
	return xxx_messageInfo_ExpandedDynamicSearchAdInfo.Size(m)
}
func (m *ExpandedDynamicSearchAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExpandedDynamicSearchAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExpandedDynamicSearchAdInfo proto.InternalMessageInfo

func (m *ExpandedDynamicSearchAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *ExpandedDynamicSearchAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

// A hotel ad.
type HotelAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HotelAdInfo) Reset()         { *m = HotelAdInfo{} }
func (m *HotelAdInfo) String() string { return proto.CompactTextString(m) }
func (*HotelAdInfo) ProtoMessage()    {}
func (*HotelAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{4}
}

func (m *HotelAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelAdInfo.Unmarshal(m, b)
}
func (m *HotelAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelAdInfo.Marshal(b, m, deterministic)
}
func (m *HotelAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelAdInfo.Merge(m, src)
}
func (m *HotelAdInfo) XXX_Size() int {
	return xxx_messageInfo_HotelAdInfo.Size(m)
}
func (m *HotelAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelAdInfo proto.InternalMessageInfo

// A Smart Shopping ad.
type ShoppingSmartAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShoppingSmartAdInfo) Reset()         { *m = ShoppingSmartAdInfo{} }
func (m *ShoppingSmartAdInfo) String() string { return proto.CompactTextString(m) }
func (*ShoppingSmartAdInfo) ProtoMessage()    {}
func (*ShoppingSmartAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{5}
}

func (m *ShoppingSmartAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShoppingSmartAdInfo.Unmarshal(m, b)
}
func (m *ShoppingSmartAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShoppingSmartAdInfo.Marshal(b, m, deterministic)
}
func (m *ShoppingSmartAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShoppingSmartAdInfo.Merge(m, src)
}
func (m *ShoppingSmartAdInfo) XXX_Size() int {
	return xxx_messageInfo_ShoppingSmartAdInfo.Size(m)
}
func (m *ShoppingSmartAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ShoppingSmartAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ShoppingSmartAdInfo proto.InternalMessageInfo

// A standard Shopping ad.
type ShoppingProductAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShoppingProductAdInfo) Reset()         { *m = ShoppingProductAdInfo{} }
func (m *ShoppingProductAdInfo) String() string { return proto.CompactTextString(m) }
func (*ShoppingProductAdInfo) ProtoMessage()    {}
func (*ShoppingProductAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{6}
}

func (m *ShoppingProductAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShoppingProductAdInfo.Unmarshal(m, b)
}
func (m *ShoppingProductAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShoppingProductAdInfo.Marshal(b, m, deterministic)
}
func (m *ShoppingProductAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShoppingProductAdInfo.Merge(m, src)
}
func (m *ShoppingProductAdInfo) XXX_Size() int {
	return xxx_messageInfo_ShoppingProductAdInfo.Size(m)
}
func (m *ShoppingProductAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ShoppingProductAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ShoppingProductAdInfo proto.InternalMessageInfo

// A Shopping Comparison Listing ad.
type ShoppingComparisonListingAdInfo struct {
	// Headline of the ad. This field is required. Allowed length is between 25
	// and 45 characters.
	Headline             *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline,proto3" json:"headline,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ShoppingComparisonListingAdInfo) Reset()         { *m = ShoppingComparisonListingAdInfo{} }
func (m *ShoppingComparisonListingAdInfo) String() string { return proto.CompactTextString(m) }
func (*ShoppingComparisonListingAdInfo) ProtoMessage()    {}
func (*ShoppingComparisonListingAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{7}
}

func (m *ShoppingComparisonListingAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShoppingComparisonListingAdInfo.Unmarshal(m, b)
}
func (m *ShoppingComparisonListingAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShoppingComparisonListingAdInfo.Marshal(b, m, deterministic)
}
func (m *ShoppingComparisonListingAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShoppingComparisonListingAdInfo.Merge(m, src)
}
func (m *ShoppingComparisonListingAdInfo) XXX_Size() int {
	return xxx_messageInfo_ShoppingComparisonListingAdInfo.Size(m)
}
func (m *ShoppingComparisonListingAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ShoppingComparisonListingAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ShoppingComparisonListingAdInfo proto.InternalMessageInfo

func (m *ShoppingComparisonListingAdInfo) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

// A Gmail ad.
type GmailAdInfo struct {
	// The Gmail teaser.
	Teaser *GmailTeaser `protobuf:"bytes,1,opt,name=teaser,proto3" json:"teaser,omitempty"`
	// The MediaFile resource name of the header image. Valid image types are GIF,
	// JPEG and PNG. The minimum size is 300x100 pixels and the aspect ratio must
	// be between 3:1 and 5:1 (+-1%).
	HeaderImage *wrappers.StringValue `protobuf:"bytes,2,opt,name=header_image,json=headerImage,proto3" json:"header_image,omitempty"`
	// The MediaFile resource name of the marketing image. Valid image types are
	// GIF, JPEG and PNG. The image must either be landscape with a minimum size
	// of 600x314 pixels and aspect ratio of 600:314 (+-1%) or square with a
	// minimum size of 300x300 pixels and aspect ratio of 1:1 (+-1%)
	MarketingImage *wrappers.StringValue `protobuf:"bytes,3,opt,name=marketing_image,json=marketingImage,proto3" json:"marketing_image,omitempty"`
	// Headline of the marketing image.
	MarketingImageHeadline *wrappers.StringValue `protobuf:"bytes,4,opt,name=marketing_image_headline,json=marketingImageHeadline,proto3" json:"marketing_image_headline,omitempty"`
	// Description of the marketing image.
	MarketingImageDescription *wrappers.StringValue `protobuf:"bytes,5,opt,name=marketing_image_description,json=marketingImageDescription,proto3" json:"marketing_image_description,omitempty"`
	// Display-call-to-action of the marketing image.
	MarketingImageDisplayCallToAction *DisplayCallToAction `protobuf:"bytes,6,opt,name=marketing_image_display_call_to_action,json=marketingImageDisplayCallToAction,proto3" json:"marketing_image_display_call_to_action,omitempty"`
	// Product images. Up to 15 images are supported.
	ProductImages []*ProductImage `protobuf:"bytes,7,rep,name=product_images,json=productImages,proto3" json:"product_images,omitempty"`
	// Product videos. Up to 7 videos are supported. At least one product video
	// or a marketing image must be specified.
	ProductVideos        []*ProductVideo `protobuf:"bytes,8,rep,name=product_videos,json=productVideos,proto3" json:"product_videos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *GmailAdInfo) Reset()         { *m = GmailAdInfo{} }
func (m *GmailAdInfo) String() string { return proto.CompactTextString(m) }
func (*GmailAdInfo) ProtoMessage()    {}
func (*GmailAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{8}
}

func (m *GmailAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GmailAdInfo.Unmarshal(m, b)
}
func (m *GmailAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GmailAdInfo.Marshal(b, m, deterministic)
}
func (m *GmailAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GmailAdInfo.Merge(m, src)
}
func (m *GmailAdInfo) XXX_Size() int {
	return xxx_messageInfo_GmailAdInfo.Size(m)
}
func (m *GmailAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GmailAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GmailAdInfo proto.InternalMessageInfo

func (m *GmailAdInfo) GetTeaser() *GmailTeaser {
	if m != nil {
		return m.Teaser
	}
	return nil
}

func (m *GmailAdInfo) GetHeaderImage() *wrappers.StringValue {
	if m != nil {
		return m.HeaderImage
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImage() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImage
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImageHeadline() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImageHeadline
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImageDescription() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImageDescription
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImageDisplayCallToAction() *DisplayCallToAction {
	if m != nil {
		return m.MarketingImageDisplayCallToAction
	}
	return nil
}

func (m *GmailAdInfo) GetProductImages() []*ProductImage {
	if m != nil {
		return m.ProductImages
	}
	return nil
}

func (m *GmailAdInfo) GetProductVideos() []*ProductVideo {
	if m != nil {
		return m.ProductVideos
	}
	return nil
}

// Gmail teaser data. The teaser is a small header that acts as an invitation
// to view the rest of the ad (the body).
type GmailTeaser struct {
	// Headline of the teaser.
	Headline *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline,proto3" json:"headline,omitempty"`
	// Description of the teaser.
	Description *wrappers.StringValue `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Business name of the advertiser.
	BusinessName *wrappers.StringValue `protobuf:"bytes,3,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// The MediaFile resource name of the logo image. Valid image types are GIF,
	// JPEG and PNG. The minimum size is 144x144 pixels and the aspect ratio must
	// be 1:1 (+-1%).
	LogoImage            *wrappers.StringValue `protobuf:"bytes,4,opt,name=logo_image,json=logoImage,proto3" json:"logo_image,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GmailTeaser) Reset()         { *m = GmailTeaser{} }
func (m *GmailTeaser) String() string { return proto.CompactTextString(m) }
func (*GmailTeaser) ProtoMessage()    {}
func (*GmailTeaser) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{9}
}

func (m *GmailTeaser) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GmailTeaser.Unmarshal(m, b)
}
func (m *GmailTeaser) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GmailTeaser.Marshal(b, m, deterministic)
}
func (m *GmailTeaser) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GmailTeaser.Merge(m, src)
}
func (m *GmailTeaser) XXX_Size() int {
	return xxx_messageInfo_GmailTeaser.Size(m)
}
func (m *GmailTeaser) XXX_DiscardUnknown() {
	xxx_messageInfo_GmailTeaser.DiscardUnknown(m)
}

var xxx_messageInfo_GmailTeaser proto.InternalMessageInfo

func (m *GmailTeaser) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

func (m *GmailTeaser) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *GmailTeaser) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *GmailTeaser) GetLogoImage() *wrappers.StringValue {
	if m != nil {
		return m.LogoImage
	}
	return nil
}

// Data for display call to action. The call to action is a piece of the ad
// that prompts the user to do something. Like clicking a link or making a phone
// call.
type DisplayCallToAction struct {
	// Text for the display-call-to-action.
	Text *wrappers.StringValue `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Text color for the display-call-to-action in hexadecimal, e.g. #ffffff for
	// white.
	TextColor *wrappers.StringValue `protobuf:"bytes,2,opt,name=text_color,json=textColor,proto3" json:"text_color,omitempty"`
	// Identifies the url collection in the ad.url_collections field. If not set
	// the url defaults to final_url.
	UrlCollectionId      *wrappers.StringValue `protobuf:"bytes,3,opt,name=url_collection_id,json=urlCollectionId,proto3" json:"url_collection_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DisplayCallToAction) Reset()         { *m = DisplayCallToAction{} }
func (m *DisplayCallToAction) String() string { return proto.CompactTextString(m) }
func (*DisplayCallToAction) ProtoMessage()    {}
func (*DisplayCallToAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{10}
}

func (m *DisplayCallToAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisplayCallToAction.Unmarshal(m, b)
}
func (m *DisplayCallToAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisplayCallToAction.Marshal(b, m, deterministic)
}
func (m *DisplayCallToAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisplayCallToAction.Merge(m, src)
}
func (m *DisplayCallToAction) XXX_Size() int {
	return xxx_messageInfo_DisplayCallToAction.Size(m)
}
func (m *DisplayCallToAction) XXX_DiscardUnknown() {
	xxx_messageInfo_DisplayCallToAction.DiscardUnknown(m)
}

var xxx_messageInfo_DisplayCallToAction proto.InternalMessageInfo

func (m *DisplayCallToAction) GetText() *wrappers.StringValue {
	if m != nil {
		return m.Text
	}
	return nil
}

func (m *DisplayCallToAction) GetTextColor() *wrappers.StringValue {
	if m != nil {
		return m.TextColor
	}
	return nil
}

func (m *DisplayCallToAction) GetUrlCollectionId() *wrappers.StringValue {
	if m != nil {
		return m.UrlCollectionId
	}
	return nil
}

// Product image specific data.
type ProductImage struct {
	// The MediaFile resource name of the product image. Valid image types are
	// GIF, JPEG and PNG. The minimum size is 300x300 pixels and the aspect ratio
	// must be 1:1 (+-1%).
	ProductImage *wrappers.StringValue `protobuf:"bytes,1,opt,name=product_image,json=productImage,proto3" json:"product_image,omitempty"`
	// Description of the product.
	Description *wrappers.StringValue `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Display-call-to-action of the product image.
	DisplayCallToAction  *DisplayCallToAction `protobuf:"bytes,3,opt,name=display_call_to_action,json=displayCallToAction,proto3" json:"display_call_to_action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ProductImage) Reset()         { *m = ProductImage{} }
func (m *ProductImage) String() string { return proto.CompactTextString(m) }
func (*ProductImage) ProtoMessage()    {}
func (*ProductImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{11}
}

func (m *ProductImage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductImage.Unmarshal(m, b)
}
func (m *ProductImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductImage.Marshal(b, m, deterministic)
}
func (m *ProductImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductImage.Merge(m, src)
}
func (m *ProductImage) XXX_Size() int {
	return xxx_messageInfo_ProductImage.Size(m)
}
func (m *ProductImage) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductImage.DiscardUnknown(m)
}

var xxx_messageInfo_ProductImage proto.InternalMessageInfo

func (m *ProductImage) GetProductImage() *wrappers.StringValue {
	if m != nil {
		return m.ProductImage
	}
	return nil
}

func (m *ProductImage) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *ProductImage) GetDisplayCallToAction() *DisplayCallToAction {
	if m != nil {
		return m.DisplayCallToAction
	}
	return nil
}

// Product video specific data.
type ProductVideo struct {
	// The MediaFile resource name of a video which must be hosted on YouTube.
	ProductVideo         *wrappers.StringValue `protobuf:"bytes,1,opt,name=product_video,json=productVideo,proto3" json:"product_video,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ProductVideo) Reset()         { *m = ProductVideo{} }
func (m *ProductVideo) String() string { return proto.CompactTextString(m) }
func (*ProductVideo) ProtoMessage()    {}
func (*ProductVideo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{12}
}

func (m *ProductVideo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductVideo.Unmarshal(m, b)
}
func (m *ProductVideo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductVideo.Marshal(b, m, deterministic)
}
func (m *ProductVideo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductVideo.Merge(m, src)
}
func (m *ProductVideo) XXX_Size() int {
	return xxx_messageInfo_ProductVideo.Size(m)
}
func (m *ProductVideo) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductVideo.DiscardUnknown(m)
}

var xxx_messageInfo_ProductVideo proto.InternalMessageInfo

func (m *ProductVideo) GetProductVideo() *wrappers.StringValue {
	if m != nil {
		return m.ProductVideo
	}
	return nil
}

// An image ad.
type ImageAdInfo struct {
	// Width in pixels of the full size image.
	PixelWidth *wrappers.Int64Value `protobuf:"bytes,4,opt,name=pixel_width,json=pixelWidth,proto3" json:"pixel_width,omitempty"`
	// Height in pixels of the full size image.
	PixelHeight *wrappers.Int64Value `protobuf:"bytes,5,opt,name=pixel_height,json=pixelHeight,proto3" json:"pixel_height,omitempty"`
	// URL of the full size image.
	ImageUrl *wrappers.StringValue `protobuf:"bytes,6,opt,name=image_url,json=imageUrl,proto3" json:"image_url,omitempty"`
	// Width in pixels of the preview size image.
	PreviewPixelWidth *wrappers.Int64Value `protobuf:"bytes,7,opt,name=preview_pixel_width,json=previewPixelWidth,proto3" json:"preview_pixel_width,omitempty"`
	// Height in pixels of the preview size image.
	PreviewPixelHeight *wrappers.Int64Value `protobuf:"bytes,8,opt,name=preview_pixel_height,json=previewPixelHeight,proto3" json:"preview_pixel_height,omitempty"`
	// URL of the preview size image.
	PreviewImageUrl *wrappers.StringValue `protobuf:"bytes,9,opt,name=preview_image_url,json=previewImageUrl,proto3" json:"preview_image_url,omitempty"`
	// The mime type of the image.
	MimeType enums.MimeTypeEnum_MimeType `protobuf:"varint,10,opt,name=mime_type,json=mimeType,proto3,enum=google.ads.googleads.v3.enums.MimeTypeEnum_MimeType" json:"mime_type,omitempty"`
	// The name of the image. If the image was created from a MediaFile, this is
	// the MediaFile's name. If the image was created from bytes, this is empty.
	Name *wrappers.StringValue `protobuf:"bytes,11,opt,name=name,proto3" json:"name,omitempty"`
	// The image to create the ImageAd from. This can be specified in one of
	// two ways.
	// 1. An existing MediaFile resource.
	// 2. The raw image data as bytes.
	//
	// Types that are valid to be assigned to Image:
	//	*ImageAdInfo_MediaFile
	//	*ImageAdInfo_Data
	//	*ImageAdInfo_AdIdToCopyImageFrom
	Image                isImageAdInfo_Image `protobuf_oneof:"image"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ImageAdInfo) Reset()         { *m = ImageAdInfo{} }
func (m *ImageAdInfo) String() string { return proto.CompactTextString(m) }
func (*ImageAdInfo) ProtoMessage()    {}
func (*ImageAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{13}
}

func (m *ImageAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageAdInfo.Unmarshal(m, b)
}
func (m *ImageAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageAdInfo.Marshal(b, m, deterministic)
}
func (m *ImageAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageAdInfo.Merge(m, src)
}
func (m *ImageAdInfo) XXX_Size() int {
	return xxx_messageInfo_ImageAdInfo.Size(m)
}
func (m *ImageAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ImageAdInfo proto.InternalMessageInfo

func (m *ImageAdInfo) GetPixelWidth() *wrappers.Int64Value {
	if m != nil {
		return m.PixelWidth
	}
	return nil
}

func (m *ImageAdInfo) GetPixelHeight() *wrappers.Int64Value {
	if m != nil {
		return m.PixelHeight
	}
	return nil
}

func (m *ImageAdInfo) GetImageUrl() *wrappers.StringValue {
	if m != nil {
		return m.ImageUrl
	}
	return nil
}

func (m *ImageAdInfo) GetPreviewPixelWidth() *wrappers.Int64Value {
	if m != nil {
		return m.PreviewPixelWidth
	}
	return nil
}

func (m *ImageAdInfo) GetPreviewPixelHeight() *wrappers.Int64Value {
	if m != nil {
		return m.PreviewPixelHeight
	}
	return nil
}

func (m *ImageAdInfo) GetPreviewImageUrl() *wrappers.StringValue {
	if m != nil {
		return m.PreviewImageUrl
	}
	return nil
}

func (m *ImageAdInfo) GetMimeType() enums.MimeTypeEnum_MimeType {
	if m != nil {
		return m.MimeType
	}
	return enums.MimeTypeEnum_UNSPECIFIED
}

func (m *ImageAdInfo) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

type isImageAdInfo_Image interface {
	isImageAdInfo_Image()
}

type ImageAdInfo_MediaFile struct {
	MediaFile *wrappers.StringValue `protobuf:"bytes,1,opt,name=media_file,json=mediaFile,proto3,oneof"`
}

type ImageAdInfo_Data struct {
	Data *wrappers.BytesValue `protobuf:"bytes,2,opt,name=data,proto3,oneof"`
}

type ImageAdInfo_AdIdToCopyImageFrom struct {
	AdIdToCopyImageFrom *wrappers.Int64Value `protobuf:"bytes,3,opt,name=ad_id_to_copy_image_from,json=adIdToCopyImageFrom,proto3,oneof"`
}

func (*ImageAdInfo_MediaFile) isImageAdInfo_Image() {}

func (*ImageAdInfo_Data) isImageAdInfo_Image() {}

func (*ImageAdInfo_AdIdToCopyImageFrom) isImageAdInfo_Image() {}

func (m *ImageAdInfo) GetImage() isImageAdInfo_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ImageAdInfo) GetMediaFile() *wrappers.StringValue {
	if x, ok := m.GetImage().(*ImageAdInfo_MediaFile); ok {
		return x.MediaFile
	}
	return nil
}

func (m *ImageAdInfo) GetData() *wrappers.BytesValue {
	if x, ok := m.GetImage().(*ImageAdInfo_Data); ok {
		return x.Data
	}
	return nil
}

func (m *ImageAdInfo) GetAdIdToCopyImageFrom() *wrappers.Int64Value {
	if x, ok := m.GetImage().(*ImageAdInfo_AdIdToCopyImageFrom); ok {
		return x.AdIdToCopyImageFrom
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImageAdInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImageAdInfo_MediaFile)(nil),
		(*ImageAdInfo_Data)(nil),
		(*ImageAdInfo_AdIdToCopyImageFrom)(nil),
	}
}

// Representation of video bumper in-stream ad format (very short in-stream
// non-skippable video ad).
type VideoBumperInStreamAdInfo struct {
	// The MediaFile resource name of the companion banner used with the ad.
	CompanionBanner      *wrappers.StringValue `protobuf:"bytes,1,opt,name=companion_banner,json=companionBanner,proto3" json:"companion_banner,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoBumperInStreamAdInfo) Reset()         { *m = VideoBumperInStreamAdInfo{} }
func (m *VideoBumperInStreamAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoBumperInStreamAdInfo) ProtoMessage()    {}
func (*VideoBumperInStreamAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{14}
}

func (m *VideoBumperInStreamAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoBumperInStreamAdInfo.Unmarshal(m, b)
}
func (m *VideoBumperInStreamAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoBumperInStreamAdInfo.Marshal(b, m, deterministic)
}
func (m *VideoBumperInStreamAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoBumperInStreamAdInfo.Merge(m, src)
}
func (m *VideoBumperInStreamAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoBumperInStreamAdInfo.Size(m)
}
func (m *VideoBumperInStreamAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoBumperInStreamAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoBumperInStreamAdInfo proto.InternalMessageInfo

func (m *VideoBumperInStreamAdInfo) GetCompanionBanner() *wrappers.StringValue {
	if m != nil {
		return m.CompanionBanner
	}
	return nil
}

// Representation of video non-skippable in-stream ad format (15 second
// in-stream non-skippable video ad).
type VideoNonSkippableInStreamAdInfo struct {
	// The MediaFile resource name of the companion banner used with the ad.
	CompanionBanner      *wrappers.StringValue `protobuf:"bytes,1,opt,name=companion_banner,json=companionBanner,proto3" json:"companion_banner,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoNonSkippableInStreamAdInfo) Reset()         { *m = VideoNonSkippableInStreamAdInfo{} }
func (m *VideoNonSkippableInStreamAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoNonSkippableInStreamAdInfo) ProtoMessage()    {}
func (*VideoNonSkippableInStreamAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{15}
}

func (m *VideoNonSkippableInStreamAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoNonSkippableInStreamAdInfo.Unmarshal(m, b)
}
func (m *VideoNonSkippableInStreamAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoNonSkippableInStreamAdInfo.Marshal(b, m, deterministic)
}
func (m *VideoNonSkippableInStreamAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoNonSkippableInStreamAdInfo.Merge(m, src)
}
func (m *VideoNonSkippableInStreamAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoNonSkippableInStreamAdInfo.Size(m)
}
func (m *VideoNonSkippableInStreamAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoNonSkippableInStreamAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoNonSkippableInStreamAdInfo proto.InternalMessageInfo

func (m *VideoNonSkippableInStreamAdInfo) GetCompanionBanner() *wrappers.StringValue {
	if m != nil {
		return m.CompanionBanner
	}
	return nil
}

// Representation of video TrueView in-stream ad format (ad shown during video
// playback, often at beginning, which displays a skip button a few seconds into
// the video).
type VideoTrueViewInStreamAdInfo struct {
	// Label on the CTA (call-to-action) button taking the user to the video ad's
	// final URL.
	// Required for TrueView for action campaigns, optional otherwise.
	ActionButtonLabel *wrappers.StringValue `protobuf:"bytes,1,opt,name=action_button_label,json=actionButtonLabel,proto3" json:"action_button_label,omitempty"`
	// Additional text displayed with the CTA (call-to-action) button to give
	// context and encourage clicking on the button.
	ActionHeadline *wrappers.StringValue `protobuf:"bytes,2,opt,name=action_headline,json=actionHeadline,proto3" json:"action_headline,omitempty"`
	// The MediaFile resource name of the companion banner used with the ad.
	CompanionBanner      *wrappers.StringValue `protobuf:"bytes,3,opt,name=companion_banner,json=companionBanner,proto3" json:"companion_banner,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoTrueViewInStreamAdInfo) Reset()         { *m = VideoTrueViewInStreamAdInfo{} }
func (m *VideoTrueViewInStreamAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoTrueViewInStreamAdInfo) ProtoMessage()    {}
func (*VideoTrueViewInStreamAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{16}
}

func (m *VideoTrueViewInStreamAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoTrueViewInStreamAdInfo.Unmarshal(m, b)
}
func (m *VideoTrueViewInStreamAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoTrueViewInStreamAdInfo.Marshal(b, m, deterministic)
}
func (m *VideoTrueViewInStreamAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoTrueViewInStreamAdInfo.Merge(m, src)
}
func (m *VideoTrueViewInStreamAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoTrueViewInStreamAdInfo.Size(m)
}
func (m *VideoTrueViewInStreamAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoTrueViewInStreamAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoTrueViewInStreamAdInfo proto.InternalMessageInfo

func (m *VideoTrueViewInStreamAdInfo) GetActionButtonLabel() *wrappers.StringValue {
	if m != nil {
		return m.ActionButtonLabel
	}
	return nil
}

func (m *VideoTrueViewInStreamAdInfo) GetActionHeadline() *wrappers.StringValue {
	if m != nil {
		return m.ActionHeadline
	}
	return nil
}

func (m *VideoTrueViewInStreamAdInfo) GetCompanionBanner() *wrappers.StringValue {
	if m != nil {
		return m.CompanionBanner
	}
	return nil
}

// Representation of video out-stream ad format (ad shown alongside a feed
// with automatic playback, without sound).
type VideoOutstreamAdInfo struct {
	// The headline of the ad.
	Headline *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline,proto3" json:"headline,omitempty"`
	// The description line.
	Description          *wrappers.StringValue `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoOutstreamAdInfo) Reset()         { *m = VideoOutstreamAdInfo{} }
func (m *VideoOutstreamAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoOutstreamAdInfo) ProtoMessage()    {}
func (*VideoOutstreamAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{17}
}

func (m *VideoOutstreamAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoOutstreamAdInfo.Unmarshal(m, b)
}
func (m *VideoOutstreamAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoOutstreamAdInfo.Marshal(b, m, deterministic)
}
func (m *VideoOutstreamAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoOutstreamAdInfo.Merge(m, src)
}
func (m *VideoOutstreamAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoOutstreamAdInfo.Size(m)
}
func (m *VideoOutstreamAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoOutstreamAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoOutstreamAdInfo proto.InternalMessageInfo

func (m *VideoOutstreamAdInfo) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

func (m *VideoOutstreamAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

// Representation of video TrueView discovery ad format.
type VideoTrueViewDiscoveryAdInfo struct {
	// The headline of the ad.
	Headline *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline,proto3" json:"headline,omitempty"`
	// First text line for a TrueView video discovery ad.
	Description1 *wrappers.StringValue `protobuf:"bytes,2,opt,name=description1,proto3" json:"description1,omitempty"`
	// Second text line for a TrueView video discovery ad.
	Description2         *wrappers.StringValue `protobuf:"bytes,3,opt,name=description2,proto3" json:"description2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoTrueViewDiscoveryAdInfo) Reset()         { *m = VideoTrueViewDiscoveryAdInfo{} }
func (m *VideoTrueViewDiscoveryAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoTrueViewDiscoveryAdInfo) ProtoMessage()    {}
func (*VideoTrueViewDiscoveryAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{18}
}

func (m *VideoTrueViewDiscoveryAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoTrueViewDiscoveryAdInfo.Unmarshal(m, b)
}
func (m *VideoTrueViewDiscoveryAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoTrueViewDiscoveryAdInfo.Marshal(b, m, deterministic)
}
func (m *VideoTrueViewDiscoveryAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoTrueViewDiscoveryAdInfo.Merge(m, src)
}
func (m *VideoTrueViewDiscoveryAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoTrueViewDiscoveryAdInfo.Size(m)
}
func (m *VideoTrueViewDiscoveryAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoTrueViewDiscoveryAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoTrueViewDiscoveryAdInfo proto.InternalMessageInfo

func (m *VideoTrueViewDiscoveryAdInfo) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

func (m *VideoTrueViewDiscoveryAdInfo) GetDescription1() *wrappers.StringValue {
	if m != nil {
		return m.Description1
	}
	return nil
}

func (m *VideoTrueViewDiscoveryAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

// A video ad.
type VideoAdInfo struct {
	// The MediaFile resource to use for the video.
	MediaFile *wrappers.StringValue `protobuf:"bytes,1,opt,name=media_file,json=mediaFile,proto3" json:"media_file,omitempty"`
	// Format-specific schema for the different video formats.
	//
	// Types that are valid to be assigned to Format:
	//	*VideoAdInfo_InStream
	//	*VideoAdInfo_Bumper
	//	*VideoAdInfo_OutStream
	//	*VideoAdInfo_NonSkippable
	//	*VideoAdInfo_Discovery
	Format               isVideoAdInfo_Format `protobuf_oneof:"format"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAdInfo) Reset()         { *m = VideoAdInfo{} }
func (m *VideoAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoAdInfo) ProtoMessage()    {}
func (*VideoAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{19}
}

func (m *VideoAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAdInfo.Unmarshal(m, b)
}
func (m *VideoAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAdInfo.Marshal(b, m, deterministic)
}
func (m *VideoAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAdInfo.Merge(m, src)
}
func (m *VideoAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoAdInfo.Size(m)
}
func (m *VideoAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAdInfo proto.InternalMessageInfo

func (m *VideoAdInfo) GetMediaFile() *wrappers.StringValue {
	if m != nil {
		return m.MediaFile
	}
	return nil
}

type isVideoAdInfo_Format interface {
	isVideoAdInfo_Format()
}

type VideoAdInfo_InStream struct {
	InStream *VideoTrueViewInStreamAdInfo `protobuf:"bytes,2,opt,name=in_stream,json=inStream,proto3,oneof"`
}

type VideoAdInfo_Bumper struct {
	Bumper *VideoBumperInStreamAdInfo `protobuf:"bytes,3,opt,name=bumper,proto3,oneof"`
}

type VideoAdInfo_OutStream struct {
	OutStream *VideoOutstreamAdInfo `protobuf:"bytes,4,opt,name=out_stream,json=outStream,proto3,oneof"`
}

type VideoAdInfo_NonSkippable struct {
	NonSkippable *VideoNonSkippableInStreamAdInfo `protobuf:"bytes,5,opt,name=non_skippable,json=nonSkippable,proto3,oneof"`
}

type VideoAdInfo_Discovery struct {
	Discovery *VideoTrueViewDiscoveryAdInfo `protobuf:"bytes,6,opt,name=discovery,proto3,oneof"`
}

func (*VideoAdInfo_InStream) isVideoAdInfo_Format() {}

func (*VideoAdInfo_Bumper) isVideoAdInfo_Format() {}

func (*VideoAdInfo_OutStream) isVideoAdInfo_Format() {}

func (*VideoAdInfo_NonSkippable) isVideoAdInfo_Format() {}

func (*VideoAdInfo_Discovery) isVideoAdInfo_Format() {}

func (m *VideoAdInfo) GetFormat() isVideoAdInfo_Format {
	if m != nil {
		return m.Format
	}
	return nil
}

func (m *VideoAdInfo) GetInStream() *VideoTrueViewInStreamAdInfo {
	if x, ok := m.GetFormat().(*VideoAdInfo_InStream); ok {
		return x.InStream
	}
	return nil
}

func (m *VideoAdInfo) GetBumper() *VideoBumperInStreamAdInfo {
	if x, ok := m.GetFormat().(*VideoAdInfo_Bumper); ok {
		return x.Bumper
	}
	return nil
}

func (m *VideoAdInfo) GetOutStream() *VideoOutstreamAdInfo {
	if x, ok := m.GetFormat().(*VideoAdInfo_OutStream); ok {
		return x.OutStream
	}
	return nil
}

func (m *VideoAdInfo) GetNonSkippable() *VideoNonSkippableInStreamAdInfo {
	if x, ok := m.GetFormat().(*VideoAdInfo_NonSkippable); ok {
		return x.NonSkippable
	}
	return nil
}

func (m *VideoAdInfo) GetDiscovery() *VideoTrueViewDiscoveryAdInfo {
	if x, ok := m.GetFormat().(*VideoAdInfo_Discovery); ok {
		return x.Discovery
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*VideoAdInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*VideoAdInfo_InStream)(nil),
		(*VideoAdInfo_Bumper)(nil),
		(*VideoAdInfo_OutStream)(nil),
		(*VideoAdInfo_NonSkippable)(nil),
		(*VideoAdInfo_Discovery)(nil),
	}
}

// A responsive search ad.
//
// Responsive search ads let you create an ad that adapts to show more text, and
// more relevant messages, to your customers. Enter multiple headlines and
// descriptions when creating a responsive search ad, and over time, Google Ads
// will automatically test different combinations and learn which combinations
// perform best. By adapting your ad's content to more closely match potential
// customers' search terms, responsive search ads may improve your campaign's
// performance.
//
// More information at https://support.google.com/google-ads/answer/7684791
type ResponsiveSearchAdInfo struct {
	// List of text assets for headlines. When the ad serves the headlines will
	// be selected from this list.
	Headlines []*AdTextAsset `protobuf:"bytes,1,rep,name=headlines,proto3" json:"headlines,omitempty"`
	// List of text assets for descriptions. When the ad serves the descriptions
	// will be selected from this list.
	Descriptions []*AdTextAsset `protobuf:"bytes,2,rep,name=descriptions,proto3" json:"descriptions,omitempty"`
	// First part of text that may appear appended to the url displayed in the ad.
	Path1 *wrappers.StringValue `protobuf:"bytes,3,opt,name=path1,proto3" json:"path1,omitempty"`
	// Second part of text that may appear appended to the url displayed in the
	// ad. This field can only be set when path1 is also set.
	Path2                *wrappers.StringValue `protobuf:"bytes,4,opt,name=path2,proto3" json:"path2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ResponsiveSearchAdInfo) Reset()         { *m = ResponsiveSearchAdInfo{} }
func (m *ResponsiveSearchAdInfo) String() string { return proto.CompactTextString(m) }
func (*ResponsiveSearchAdInfo) ProtoMessage()    {}
func (*ResponsiveSearchAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{20}
}

func (m *ResponsiveSearchAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResponsiveSearchAdInfo.Unmarshal(m, b)
}
func (m *ResponsiveSearchAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResponsiveSearchAdInfo.Marshal(b, m, deterministic)
}
func (m *ResponsiveSearchAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponsiveSearchAdInfo.Merge(m, src)
}
func (m *ResponsiveSearchAdInfo) XXX_Size() int {
	return xxx_messageInfo_ResponsiveSearchAdInfo.Size(m)
}
func (m *ResponsiveSearchAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponsiveSearchAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ResponsiveSearchAdInfo proto.InternalMessageInfo

func (m *ResponsiveSearchAdInfo) GetHeadlines() []*AdTextAsset {
	if m != nil {
		return m.Headlines
	}
	return nil
}

func (m *ResponsiveSearchAdInfo) GetDescriptions() []*AdTextAsset {
	if m != nil {
		return m.Descriptions
	}
	return nil
}

func (m *ResponsiveSearchAdInfo) GetPath1() *wrappers.StringValue {
	if m != nil {
		return m.Path1
	}
	return nil
}

func (m *ResponsiveSearchAdInfo) GetPath2() *wrappers.StringValue {
	if m != nil {
		return m.Path2
	}
	return nil
}

// A legacy responsive display ad. Ads of this type are labeled 'Responsive ads'
// in the Google Ads UI.
type LegacyResponsiveDisplayAdInfo struct {
	// The short version of the ad's headline.
	ShortHeadline *wrappers.StringValue `protobuf:"bytes,1,opt,name=short_headline,json=shortHeadline,proto3" json:"short_headline,omitempty"`
	// The long version of the ad's headline.
	LongHeadline *wrappers.StringValue `protobuf:"bytes,2,opt,name=long_headline,json=longHeadline,proto3" json:"long_headline,omitempty"`
	// The description of the ad.
	Description *wrappers.StringValue `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The business name in the ad.
	BusinessName *wrappers.StringValue `protobuf:"bytes,4,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// Advertiser's consent to allow flexible color. When true, the ad may be
	// served with different color if necessary. When false, the ad will be served
	// with the specified colors or a neutral color.
	// The default value is true.
	// Must be true if main_color and accent_color are not set.
	AllowFlexibleColor *wrappers.BoolValue `protobuf:"bytes,5,opt,name=allow_flexible_color,json=allowFlexibleColor,proto3" json:"allow_flexible_color,omitempty"`
	// The accent color of the ad in hexadecimal, e.g. #ffffff for white.
	// If one of main_color and accent_color is set, the other is required as
	// well.
	AccentColor *wrappers.StringValue `protobuf:"bytes,6,opt,name=accent_color,json=accentColor,proto3" json:"accent_color,omitempty"`
	// The main color of the ad in hexadecimal, e.g. #ffffff for white.
	// If one of main_color and accent_color is set, the other is required as
	// well.
	MainColor *wrappers.StringValue `protobuf:"bytes,7,opt,name=main_color,json=mainColor,proto3" json:"main_color,omitempty"`
	// The call-to-action text for the ad.
	CallToActionText *wrappers.StringValue `protobuf:"bytes,8,opt,name=call_to_action_text,json=callToActionText,proto3" json:"call_to_action_text,omitempty"`
	// The MediaFile resource name of the logo image used in the ad.
	LogoImage *wrappers.StringValue `protobuf:"bytes,9,opt,name=logo_image,json=logoImage,proto3" json:"logo_image,omitempty"`
	// The MediaFile resource name of the square logo image used in the ad.
	SquareLogoImage *wrappers.StringValue `protobuf:"bytes,10,opt,name=square_logo_image,json=squareLogoImage,proto3" json:"square_logo_image,omitempty"`
	// The MediaFile resource name of the marketing image used in the ad.
	MarketingImage *wrappers.StringValue `protobuf:"bytes,11,opt,name=marketing_image,json=marketingImage,proto3" json:"marketing_image,omitempty"`
	// The MediaFile resource name of the square marketing image used in the ad.
	SquareMarketingImage *wrappers.StringValue `protobuf:"bytes,12,opt,name=square_marketing_image,json=squareMarketingImage,proto3" json:"square_marketing_image,omitempty"`
	// Specifies which format the ad will be served in. Default is ALL_FORMATS.
	FormatSetting enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting `protobuf:"varint,13,opt,name=format_setting,json=formatSetting,proto3,enum=google.ads.googleads.v3.enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting" json:"format_setting,omitempty"`
	// Prefix before price. E.g. 'as low as'.
	PricePrefix *wrappers.StringValue `protobuf:"bytes,14,opt,name=price_prefix,json=pricePrefix,proto3" json:"price_prefix,omitempty"`
	// Promotion text used for dyanmic formats of responsive ads. For example
	// 'Free two-day shipping'.
	PromoText            *wrappers.StringValue `protobuf:"bytes,15,opt,name=promo_text,json=promoText,proto3" json:"promo_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *LegacyResponsiveDisplayAdInfo) Reset()         { *m = LegacyResponsiveDisplayAdInfo{} }
func (m *LegacyResponsiveDisplayAdInfo) String() string { return proto.CompactTextString(m) }
func (*LegacyResponsiveDisplayAdInfo) ProtoMessage()    {}
func (*LegacyResponsiveDisplayAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{21}
}

func (m *LegacyResponsiveDisplayAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LegacyResponsiveDisplayAdInfo.Unmarshal(m, b)
}
func (m *LegacyResponsiveDisplayAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LegacyResponsiveDisplayAdInfo.Marshal(b, m, deterministic)
}
func (m *LegacyResponsiveDisplayAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LegacyResponsiveDisplayAdInfo.Merge(m, src)
}
func (m *LegacyResponsiveDisplayAdInfo) XXX_Size() int {
	return xxx_messageInfo_LegacyResponsiveDisplayAdInfo.Size(m)
}
func (m *LegacyResponsiveDisplayAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LegacyResponsiveDisplayAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LegacyResponsiveDisplayAdInfo proto.InternalMessageInfo

func (m *LegacyResponsiveDisplayAdInfo) GetShortHeadline() *wrappers.StringValue {
	if m != nil {
		return m.ShortHeadline
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetLongHeadline() *wrappers.StringValue {
	if m != nil {
		return m.LongHeadline
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetAllowFlexibleColor() *wrappers.BoolValue {
	if m != nil {
		return m.AllowFlexibleColor
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetAccentColor() *wrappers.StringValue {
	if m != nil {
		return m.AccentColor
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetMainColor() *wrappers.StringValue {
	if m != nil {
		return m.MainColor
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetCallToActionText() *wrappers.StringValue {
	if m != nil {
		return m.CallToActionText
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetLogoImage() *wrappers.StringValue {
	if m != nil {
		return m.LogoImage
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetSquareLogoImage() *wrappers.StringValue {
	if m != nil {
		return m.SquareLogoImage
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetMarketingImage() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImage
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetSquareMarketingImage() *wrappers.StringValue {
	if m != nil {
		return m.SquareMarketingImage
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetFormatSetting() enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting {
	if m != nil {
		return m.FormatSetting
	}
	return enums.DisplayAdFormatSettingEnum_UNSPECIFIED
}

func (m *LegacyResponsiveDisplayAdInfo) GetPricePrefix() *wrappers.StringValue {
	if m != nil {
		return m.PricePrefix
	}
	return nil
}

func (m *LegacyResponsiveDisplayAdInfo) GetPromoText() *wrappers.StringValue {
	if m != nil {
		return m.PromoText
	}
	return nil
}

// An app ad.
type AppAdInfo struct {
	// An optional text asset that, if specified, must always be displayed when
	// the ad is served.
	MandatoryAdText *AdTextAsset `protobuf:"bytes,1,opt,name=mandatory_ad_text,json=mandatoryAdText,proto3" json:"mandatory_ad_text,omitempty"`
	// List of text assets for headlines. When the ad serves the headlines will
	// be selected from this list.
	Headlines []*AdTextAsset `protobuf:"bytes,2,rep,name=headlines,proto3" json:"headlines,omitempty"`
	// List of text assets for descriptions. When the ad serves the descriptions
	// will be selected from this list.
	Descriptions []*AdTextAsset `protobuf:"bytes,3,rep,name=descriptions,proto3" json:"descriptions,omitempty"`
	// List of image assets that may be displayed with the ad.
	Images []*AdImageAsset `protobuf:"bytes,4,rep,name=images,proto3" json:"images,omitempty"`
	// List of YouTube video assets that may be displayed with the ad.
	YoutubeVideos []*AdVideoAsset `protobuf:"bytes,5,rep,name=youtube_videos,json=youtubeVideos,proto3" json:"youtube_videos,omitempty"`
	// List of media bundle assets that may be used with the ad.
	Html5MediaBundles    []*AdMediaBundleAsset `protobuf:"bytes,6,rep,name=html5_media_bundles,json=html5MediaBundles,proto3" json:"html5_media_bundles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *AppAdInfo) Reset()         { *m = AppAdInfo{} }
func (m *AppAdInfo) String() string { return proto.CompactTextString(m) }
func (*AppAdInfo) ProtoMessage()    {}
func (*AppAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{22}
}

func (m *AppAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppAdInfo.Unmarshal(m, b)
}
func (m *AppAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppAdInfo.Marshal(b, m, deterministic)
}
func (m *AppAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppAdInfo.Merge(m, src)
}
func (m *AppAdInfo) XXX_Size() int {
	return xxx_messageInfo_AppAdInfo.Size(m)
}
func (m *AppAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AppAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AppAdInfo proto.InternalMessageInfo

func (m *AppAdInfo) GetMandatoryAdText() *AdTextAsset {
	if m != nil {
		return m.MandatoryAdText
	}
	return nil
}

func (m *AppAdInfo) GetHeadlines() []*AdTextAsset {
	if m != nil {
		return m.Headlines
	}
	return nil
}

func (m *AppAdInfo) GetDescriptions() []*AdTextAsset {
	if m != nil {
		return m.Descriptions
	}
	return nil
}

func (m *AppAdInfo) GetImages() []*AdImageAsset {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *AppAdInfo) GetYoutubeVideos() []*AdVideoAsset {
	if m != nil {
		return m.YoutubeVideos
	}
	return nil
}

func (m *AppAdInfo) GetHtml5MediaBundles() []*AdMediaBundleAsset {
	if m != nil {
		return m.Html5MediaBundles
	}
	return nil
}

// App engagement ads allow you to write text encouraging a specific action in
// the app, like checking in, making a purchase, or booking a flight.
// They allow you to send users to a specific part of your app where they can
// find what they're looking for easier and faster.
type AppEngagementAdInfo struct {
	// List of text assets for headlines. When the ad serves the headlines will
	// be selected from this list.
	Headlines []*AdTextAsset `protobuf:"bytes,1,rep,name=headlines,proto3" json:"headlines,omitempty"`
	// List of text assets for descriptions. When the ad serves the descriptions
	// will be selected from this list.
	Descriptions []*AdTextAsset `protobuf:"bytes,2,rep,name=descriptions,proto3" json:"descriptions,omitempty"`
	// List of image assets that may be displayed with the ad.
	Images []*AdImageAsset `protobuf:"bytes,3,rep,name=images,proto3" json:"images,omitempty"`
	// List of video assets that may be displayed with the ad.
	Videos               []*AdVideoAsset `protobuf:"bytes,4,rep,name=videos,proto3" json:"videos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *AppEngagementAdInfo) Reset()         { *m = AppEngagementAdInfo{} }
func (m *AppEngagementAdInfo) String() string { return proto.CompactTextString(m) }
func (*AppEngagementAdInfo) ProtoMessage()    {}
func (*AppEngagementAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{23}
}

func (m *AppEngagementAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppEngagementAdInfo.Unmarshal(m, b)
}
func (m *AppEngagementAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppEngagementAdInfo.Marshal(b, m, deterministic)
}
func (m *AppEngagementAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppEngagementAdInfo.Merge(m, src)
}
func (m *AppEngagementAdInfo) XXX_Size() int {
	return xxx_messageInfo_AppEngagementAdInfo.Size(m)
}
func (m *AppEngagementAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AppEngagementAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AppEngagementAdInfo proto.InternalMessageInfo

func (m *AppEngagementAdInfo) GetHeadlines() []*AdTextAsset {
	if m != nil {
		return m.Headlines
	}
	return nil
}

func (m *AppEngagementAdInfo) GetDescriptions() []*AdTextAsset {
	if m != nil {
		return m.Descriptions
	}
	return nil
}

func (m *AppEngagementAdInfo) GetImages() []*AdImageAsset {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *AppEngagementAdInfo) GetVideos() []*AdVideoAsset {
	if m != nil {
		return m.Videos
	}
	return nil
}

// A legacy app install ad that only can be used by a few select customers.
type LegacyAppInstallAdInfo struct {
	// The id of the mobile app.
	AppId *wrappers.StringValue `protobuf:"bytes,1,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	// The app store the mobile app is available in.
	AppStore enums.LegacyAppInstallAdAppStoreEnum_LegacyAppInstallAdAppStore `protobuf:"varint,2,opt,name=app_store,json=appStore,proto3,enum=google.ads.googleads.v3.enums.LegacyAppInstallAdAppStoreEnum_LegacyAppInstallAdAppStore" json:"app_store,omitempty"`
	// The headline of the ad.
	Headline *wrappers.StringValue `protobuf:"bytes,3,opt,name=headline,proto3" json:"headline,omitempty"`
	// The first description line of the ad.
	Description1 *wrappers.StringValue `protobuf:"bytes,4,opt,name=description1,proto3" json:"description1,omitempty"`
	// The second description line of the ad.
	Description2         *wrappers.StringValue `protobuf:"bytes,5,opt,name=description2,proto3" json:"description2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *LegacyAppInstallAdInfo) Reset()         { *m = LegacyAppInstallAdInfo{} }
func (m *LegacyAppInstallAdInfo) String() string { return proto.CompactTextString(m) }
func (*LegacyAppInstallAdInfo) ProtoMessage()    {}
func (*LegacyAppInstallAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{24}
}

func (m *LegacyAppInstallAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LegacyAppInstallAdInfo.Unmarshal(m, b)
}
func (m *LegacyAppInstallAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LegacyAppInstallAdInfo.Marshal(b, m, deterministic)
}
func (m *LegacyAppInstallAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LegacyAppInstallAdInfo.Merge(m, src)
}
func (m *LegacyAppInstallAdInfo) XXX_Size() int {
	return xxx_messageInfo_LegacyAppInstallAdInfo.Size(m)
}
func (m *LegacyAppInstallAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LegacyAppInstallAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LegacyAppInstallAdInfo proto.InternalMessageInfo

func (m *LegacyAppInstallAdInfo) GetAppId() *wrappers.StringValue {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *LegacyAppInstallAdInfo) GetAppStore() enums.LegacyAppInstallAdAppStoreEnum_LegacyAppInstallAdAppStore {
	if m != nil {
		return m.AppStore
	}
	return enums.LegacyAppInstallAdAppStoreEnum_UNSPECIFIED
}

func (m *LegacyAppInstallAdInfo) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

func (m *LegacyAppInstallAdInfo) GetDescription1() *wrappers.StringValue {
	if m != nil {
		return m.Description1
	}
	return nil
}

func (m *LegacyAppInstallAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

// A responsive display ad.
type ResponsiveDisplayAdInfo struct {
	// Marketing images to be used in the ad. Valid image types are GIF,
	// JPEG, and PNG. The minimum size is 600x314 and the aspect ratio must
	// be 1.91:1 (+-1%). At least one marketing_image is required. Combined with
	// square_marketing_images the maximum is 15.
	MarketingImages []*AdImageAsset `protobuf:"bytes,1,rep,name=marketing_images,json=marketingImages,proto3" json:"marketing_images,omitempty"`
	// Square marketing images to be used in the ad. Valid image types are GIF,
	// JPEG, and PNG. The minimum size is 300x300 and the aspect ratio must
	// be 1:1 (+-1%). At least one square marketing_image is required. Combined
	// with marketing_images the maximum is 15.
	SquareMarketingImages []*AdImageAsset `protobuf:"bytes,2,rep,name=square_marketing_images,json=squareMarketingImages,proto3" json:"square_marketing_images,omitempty"`
	// Logo images to be used in the ad. Valid image types are GIF,
	// JPEG, and PNG. The minimum size is 512x128 and the aspect ratio must
	// be 4:1 (+-1%). Combined with square_logo_images the maximum is 5.
	LogoImages []*AdImageAsset `protobuf:"bytes,3,rep,name=logo_images,json=logoImages,proto3" json:"logo_images,omitempty"`
	// Square logo images to be used in the ad. Valid image types are GIF,
	// JPEG, and PNG. The minimum size is 128x128 and the aspect ratio must
	// be 1:1 (+-1%). Combined with square_logo_images the maximum is 5.
	SquareLogoImages []*AdImageAsset `protobuf:"bytes,4,rep,name=square_logo_images,json=squareLogoImages,proto3" json:"square_logo_images,omitempty"`
	// Short format headlines for the ad. The maximum length is 30 characters.
	// At least 1 and max 5 headlines can be specified.
	Headlines []*AdTextAsset `protobuf:"bytes,5,rep,name=headlines,proto3" json:"headlines,omitempty"`
	// A required long format headline. The maximum length is 90 characters.
	LongHeadline *AdTextAsset `protobuf:"bytes,6,opt,name=long_headline,json=longHeadline,proto3" json:"long_headline,omitempty"`
	// Descriptive texts for the ad. The maximum length is 90 characters. At
	// least 1 and max 5 headlines can be specified.
	Descriptions []*AdTextAsset `protobuf:"bytes,7,rep,name=descriptions,proto3" json:"descriptions,omitempty"`
	// Optional YouTube videos for the ad. A maximum of 5 videos can be specified.
	YoutubeVideos []*AdVideoAsset `protobuf:"bytes,8,rep,name=youtube_videos,json=youtubeVideos,proto3" json:"youtube_videos,omitempty"`
	// The advertiser/brand name. Maximum display width is 25.
	BusinessName *wrappers.StringValue `protobuf:"bytes,9,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// The main color of the ad in hexadecimal, e.g. #ffffff for white.
	// If one of main_color and accent_color is set, the other is required as
	// well.
	MainColor *wrappers.StringValue `protobuf:"bytes,10,opt,name=main_color,json=mainColor,proto3" json:"main_color,omitempty"`
	// The accent color of the ad in hexadecimal, e.g. #ffffff for white.
	// If one of main_color and accent_color is set, the other is required as
	// well.
	AccentColor *wrappers.StringValue `protobuf:"bytes,11,opt,name=accent_color,json=accentColor,proto3" json:"accent_color,omitempty"`
	// Advertiser's consent to allow flexible color. When true, the ad may be
	// served with different color if necessary. When false, the ad will be served
	// with the specified colors or a neutral color.
	// The default value is true.
	// Must be true if main_color and accent_color are not set.
	AllowFlexibleColor *wrappers.BoolValue `protobuf:"bytes,12,opt,name=allow_flexible_color,json=allowFlexibleColor,proto3" json:"allow_flexible_color,omitempty"`
	// The call-to-action text for the ad. Maximum display width is 30.
	CallToActionText *wrappers.StringValue `protobuf:"bytes,13,opt,name=call_to_action_text,json=callToActionText,proto3" json:"call_to_action_text,omitempty"`
	// Prefix before price. E.g. 'as low as'.
	PricePrefix *wrappers.StringValue `protobuf:"bytes,14,opt,name=price_prefix,json=pricePrefix,proto3" json:"price_prefix,omitempty"`
	// Promotion text used for dyanmic formats of responsive ads. For example
	// 'Free two-day shipping'.
	PromoText *wrappers.StringValue `protobuf:"bytes,15,opt,name=promo_text,json=promoText,proto3" json:"promo_text,omitempty"`
	// Specifies which format the ad will be served in. Default is ALL_FORMATS.
	FormatSetting        enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting `protobuf:"varint,16,opt,name=format_setting,json=formatSetting,proto3,enum=google.ads.googleads.v3.enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting" json:"format_setting,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                `json:"-"`
	XXX_unrecognized     []byte                                                  `json:"-"`
	XXX_sizecache        int32                                                   `json:"-"`
}

func (m *ResponsiveDisplayAdInfo) Reset()         { *m = ResponsiveDisplayAdInfo{} }
func (m *ResponsiveDisplayAdInfo) String() string { return proto.CompactTextString(m) }
func (*ResponsiveDisplayAdInfo) ProtoMessage()    {}
func (*ResponsiveDisplayAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{25}
}

func (m *ResponsiveDisplayAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResponsiveDisplayAdInfo.Unmarshal(m, b)
}
func (m *ResponsiveDisplayAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResponsiveDisplayAdInfo.Marshal(b, m, deterministic)
}
func (m *ResponsiveDisplayAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponsiveDisplayAdInfo.Merge(m, src)
}
func (m *ResponsiveDisplayAdInfo) XXX_Size() int {
	return xxx_messageInfo_ResponsiveDisplayAdInfo.Size(m)
}
func (m *ResponsiveDisplayAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponsiveDisplayAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ResponsiveDisplayAdInfo proto.InternalMessageInfo

func (m *ResponsiveDisplayAdInfo) GetMarketingImages() []*AdImageAsset {
	if m != nil {
		return m.MarketingImages
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetSquareMarketingImages() []*AdImageAsset {
	if m != nil {
		return m.SquareMarketingImages
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetLogoImages() []*AdImageAsset {
	if m != nil {
		return m.LogoImages
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetSquareLogoImages() []*AdImageAsset {
	if m != nil {
		return m.SquareLogoImages
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetHeadlines() []*AdTextAsset {
	if m != nil {
		return m.Headlines
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetLongHeadline() *AdTextAsset {
	if m != nil {
		return m.LongHeadline
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetDescriptions() []*AdTextAsset {
	if m != nil {
		return m.Descriptions
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetYoutubeVideos() []*AdVideoAsset {
	if m != nil {
		return m.YoutubeVideos
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetMainColor() *wrappers.StringValue {
	if m != nil {
		return m.MainColor
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetAccentColor() *wrappers.StringValue {
	if m != nil {
		return m.AccentColor
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetAllowFlexibleColor() *wrappers.BoolValue {
	if m != nil {
		return m.AllowFlexibleColor
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetCallToActionText() *wrappers.StringValue {
	if m != nil {
		return m.CallToActionText
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetPricePrefix() *wrappers.StringValue {
	if m != nil {
		return m.PricePrefix
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetPromoText() *wrappers.StringValue {
	if m != nil {
		return m.PromoText
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetFormatSetting() enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting {
	if m != nil {
		return m.FormatSetting
	}
	return enums.DisplayAdFormatSettingEnum_UNSPECIFIED
}

// A generic type of display ad. The exact ad format is controlled by the
// display_upload_product_type field, which determines what kinds of data
// need to be included with the ad.
type DisplayUploadAdInfo struct {
	// The product type of this ad. See comments on the enum for details.
	DisplayUploadProductType enums.DisplayUploadProductTypeEnum_DisplayUploadProductType `protobuf:"varint,1,opt,name=display_upload_product_type,json=displayUploadProductType,proto3,enum=google.ads.googleads.v3.enums.DisplayUploadProductTypeEnum_DisplayUploadProductType" json:"display_upload_product_type,omitempty"`
	// The asset data that makes up the ad.
	//
	// Types that are valid to be assigned to MediaAsset:
	//	*DisplayUploadAdInfo_MediaBundle
	MediaAsset           isDisplayUploadAdInfo_MediaAsset `protobuf_oneof:"media_asset"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *DisplayUploadAdInfo) Reset()         { *m = DisplayUploadAdInfo{} }
func (m *DisplayUploadAdInfo) String() string { return proto.CompactTextString(m) }
func (*DisplayUploadAdInfo) ProtoMessage()    {}
func (*DisplayUploadAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b3dd1fef8feae128, []int{26}
}

func (m *DisplayUploadAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisplayUploadAdInfo.Unmarshal(m, b)
}
func (m *DisplayUploadAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisplayUploadAdInfo.Marshal(b, m, deterministic)
}
func (m *DisplayUploadAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisplayUploadAdInfo.Merge(m, src)
}
func (m *DisplayUploadAdInfo) XXX_Size() int {
	return xxx_messageInfo_DisplayUploadAdInfo.Size(m)
}
func (m *DisplayUploadAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DisplayUploadAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DisplayUploadAdInfo proto.InternalMessageInfo

func (m *DisplayUploadAdInfo) GetDisplayUploadProductType() enums.DisplayUploadProductTypeEnum_DisplayUploadProductType {
	if m != nil {
		return m.DisplayUploadProductType
	}
	return enums.DisplayUploadProductTypeEnum_UNSPECIFIED
}

type isDisplayUploadAdInfo_MediaAsset interface {
	isDisplayUploadAdInfo_MediaAsset()
}

type DisplayUploadAdInfo_MediaBundle struct {
	MediaBundle *AdMediaBundleAsset `protobuf:"bytes,2,opt,name=media_bundle,json=mediaBundle,proto3,oneof"`
}

func (*DisplayUploadAdInfo_MediaBundle) isDisplayUploadAdInfo_MediaAsset() {}

func (m *DisplayUploadAdInfo) GetMediaAsset() isDisplayUploadAdInfo_MediaAsset {
	if m != nil {
		return m.MediaAsset
	}
	return nil
}

func (m *DisplayUploadAdInfo) GetMediaBundle() *AdMediaBundleAsset {
	if x, ok := m.GetMediaAsset().(*DisplayUploadAdInfo_MediaBundle); ok {
		return x.MediaBundle
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DisplayUploadAdInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DisplayUploadAdInfo_MediaBundle)(nil),
	}
}

func init() {
	proto.RegisterType((*TextAdInfo)(nil), "google.ads.googleads.v3.common.TextAdInfo")
	proto.RegisterType((*ExpandedTextAdInfo)(nil), "google.ads.googleads.v3.common.ExpandedTextAdInfo")
	proto.RegisterType((*CallOnlyAdInfo)(nil), "google.ads.googleads.v3.common.CallOnlyAdInfo")
	proto.RegisterType((*ExpandedDynamicSearchAdInfo)(nil), "google.ads.googleads.v3.common.ExpandedDynamicSearchAdInfo")
	proto.RegisterType((*HotelAdInfo)(nil), "google.ads.googleads.v3.common.HotelAdInfo")
	proto.RegisterType((*ShoppingSmartAdInfo)(nil), "google.ads.googleads.v3.common.ShoppingSmartAdInfo")
	proto.RegisterType((*ShoppingProductAdInfo)(nil), "google.ads.googleads.v3.common.ShoppingProductAdInfo")
	proto.RegisterType((*ShoppingComparisonListingAdInfo)(nil), "google.ads.googleads.v3.common.ShoppingComparisonListingAdInfo")
	proto.RegisterType((*GmailAdInfo)(nil), "google.ads.googleads.v3.common.GmailAdInfo")
	proto.RegisterType((*GmailTeaser)(nil), "google.ads.googleads.v3.common.GmailTeaser")
	proto.RegisterType((*DisplayCallToAction)(nil), "google.ads.googleads.v3.common.DisplayCallToAction")
	proto.RegisterType((*ProductImage)(nil), "google.ads.googleads.v3.common.ProductImage")
	proto.RegisterType((*ProductVideo)(nil), "google.ads.googleads.v3.common.ProductVideo")
	proto.RegisterType((*ImageAdInfo)(nil), "google.ads.googleads.v3.common.ImageAdInfo")
	proto.RegisterType((*VideoBumperInStreamAdInfo)(nil), "google.ads.googleads.v3.common.VideoBumperInStreamAdInfo")
	proto.RegisterType((*VideoNonSkippableInStreamAdInfo)(nil), "google.ads.googleads.v3.common.VideoNonSkippableInStreamAdInfo")
	proto.RegisterType((*VideoTrueViewInStreamAdInfo)(nil), "google.ads.googleads.v3.common.VideoTrueViewInStreamAdInfo")
	proto.RegisterType((*VideoOutstreamAdInfo)(nil), "google.ads.googleads.v3.common.VideoOutstreamAdInfo")
	proto.RegisterType((*VideoTrueViewDiscoveryAdInfo)(nil), "google.ads.googleads.v3.common.VideoTrueViewDiscoveryAdInfo")
	proto.RegisterType((*VideoAdInfo)(nil), "google.ads.googleads.v3.common.VideoAdInfo")
	proto.RegisterType((*ResponsiveSearchAdInfo)(nil), "google.ads.googleads.v3.common.ResponsiveSearchAdInfo")
	proto.RegisterType((*LegacyResponsiveDisplayAdInfo)(nil), "google.ads.googleads.v3.common.LegacyResponsiveDisplayAdInfo")
	proto.RegisterType((*AppAdInfo)(nil), "google.ads.googleads.v3.common.AppAdInfo")
	proto.RegisterType((*AppEngagementAdInfo)(nil), "google.ads.googleads.v3.common.AppEngagementAdInfo")
	proto.RegisterType((*LegacyAppInstallAdInfo)(nil), "google.ads.googleads.v3.common.LegacyAppInstallAdInfo")
	proto.RegisterType((*ResponsiveDisplayAdInfo)(nil), "google.ads.googleads.v3.common.ResponsiveDisplayAdInfo")
	proto.RegisterType((*DisplayUploadAdInfo)(nil), "google.ads.googleads.v3.common.DisplayUploadAdInfo")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/common/ad_type_infos.proto", fileDescriptor_b3dd1fef8feae128)
}

var fileDescriptor_b3dd1fef8feae128 = []byte{
	// 2433 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x5a, 0xdd, 0x6e, 0xdb, 0xc8,
	0x15, 0xb6, 0x24, 0xff, 0x48, 0x47, 0x92, 0x7f, 0xe8, 0xfc, 0x68, 0x9d, 0xec, 0x6e, 0xca, 0x8b,
	0x22, 0x40, 0xbb, 0x72, 0x23, 0xa7, 0x45, 0xd7, 0xd9, 0x6c, 0x2a, 0xdb, 0x49, 0x64, 0xac, 0x93,
	0x78, 0x65, 0xc7, 0x29, 0x52, 0x03, 0xc4, 0x48, 0x1c, 0xcb, 0x6c, 0xc8, 0x19, 0x96, 0x43, 0x3a,
	0xd6, 0xed, 0x5e, 0xb4, 0xb7, 0x05, 0xf6, 0xaa, 0x45, 0x81, 0x02, 0x7b, 0x59, 0xa0, 0x8f, 0xd0,
	0xab, 0xde, 0x2d, 0xd0, 0x3e, 0xc1, 0x3e, 0x41, 0xfb, 0x08, 0x7b, 0xd1, 0x62, 0x7e, 0x48, 0x51,
	0x92, 0x65, 0x8d, 0xac, 0x6d, 0x83, 0xf6, 0x4a, 0x12, 0x79, 0xbe, 0x8f, 0x73, 0x66, 0xce, 0x7c,
	0xe7, 0xcc, 0xa1, 0xa0, 0xd6, 0xa1, 0xb4, 0xe3, 0xe2, 0x75, 0x64, 0xb3, 0x75, 0xf9, 0x95, 0x7f,
	0x3b, 0xdb, 0x58, 0x6f, 0x53, 0xcf, 0xa3, 0x64, 0x1d, 0xd9, 0x56, 0xd8, 0xf5, 0xb1, 0xe5, 0x90,
	0x13, 0xca, 0xaa, 0x7e, 0x40, 0x43, 0x6a, 0x7c, 0x20, 0x0d, 0xab, 0xc8, 0x66, 0xd5, 0x04, 0x53,
	0x3d, 0xdb, 0xa8, 0x4a, 0xcc, 0xda, 0x47, 0xe3, 0x39, 0x11, 0x63, 0x38, 0x94, 0x74, 0x6b, 0xdb,
	0xa3, 0xcc, 0x31, 0x89, 0x3c, 0xb6, 0xde, 0x46, 0xae, 0x6b, 0xb5, 0x29, 0x39, 0xc3, 0x01, 0x73,
	0x28, 0xb1, 0x02, 0xec, 0xd3, 0x20, 0x74, 0x48, 0xc7, 0x62, 0x21, 0x0a, 0xb1, 0x22, 0x79, 0x78,
	0x39, 0x89, 0xed, 0x30, 0xdf, 0x45, 0x5d, 0x0b, 0xd9, 0xd6, 0x09, 0x0d, 0x3c, 0x14, 0x5a, 0x0c,
	0x87, 0x9c, 0x44, 0xc1, 0x1f, 0xe9, 0xc1, 0x23, 0xdf, 0xa5, 0xc8, 0xb6, 0xfc, 0x80, 0xda, 0x51,
	0x3b, 0x14, 0x33, 0xa3, 0xe7, 0x84, 0x8b, 0x3b, 0xa8, 0xdd, 0xb5, 0x90, 0xef, 0x5b, 0x0e, 0x61,
	0x21, 0x77, 0x89, 0xcf, 0x82, 0xef, 0x5b, 0x2c, 0xa4, 0x41, 0x4c, 0xf2, 0xd1, 0xe5, 0x24, 0x9e,
	0xe3, 0xe1, 0xf4, 0x33, 0xd5, 0x3a, 0xac, 0x8b, 0x5f, 0xad, 0xe8, 0x64, 0xfd, 0x6d, 0x80, 0x7c,
	0x1f, 0x07, 0x6a, 0x9d, 0xd6, 0x6e, 0xc7, 0x74, 0xbe, 0xb3, 0x8e, 0x08, 0xa1, 0x21, 0x0a, 0x1d,
	0x4a, 0xd4, 0x5d, 0xf3, 0xeb, 0x0c, 0xc0, 0x21, 0x3e, 0x0f, 0xeb, 0xf6, 0x2e, 0x39, 0xa1, 0xc6,
	0x4f, 0x21, 0x7f, 0x8a, 0x91, 0xed, 0x3a, 0x04, 0x57, 0x32, 0x77, 0x32, 0x77, 0x8b, 0xb5, 0xdb,
	0x6a, 0x71, 0xab, 0x31, 0x7f, 0xf5, 0x20, 0x0c, 0x1c, 0xd2, 0x39, 0x42, 0x6e, 0x84, 0x9b, 0x89,
	0xb5, 0xf1, 0x33, 0x28, 0xd9, 0x98, 0xb5, 0x03, 0xc7, 0xe7, 0xf4, 0xf7, 0x2a, 0x59, 0x0d, 0x74,
	0x1f, 0x62, 0x80, 0xa1, 0x56, 0xc9, 0x4d, 0xc8, 0x50, 0x33, 0xff, 0x96, 0x03, 0xe3, 0xf1, 0xb9,
	0x8f, 0x88, 0x8d, 0xed, 0x94, 0x53, 0xdb, 0xb0, 0x18, 0x0f, 0xd3, 0xf2, 0x51, 0x10, 0xde, 0xd3,
	0x72, 0xad, 0x1c, 0x63, 0xf6, 0x39, 0x64, 0x88, 0xa4, 0xa6, 0xe5, 0x61, 0x1f, 0x49, 0x6d, 0x88,
	0x64, 0xa3, 0x32, 0x3f, 0x29, 0xc9, 0x86, 0xf1, 0x29, 0x14, 0x53, 0x5e, 0x6b, 0x4d, 0x53, 0x1a,
	0x30, 0x34, 0xcf, 0x0b, 0x93, 0xce, 0xb3, 0x51, 0x83, 0x39, 0x1f, 0x85, 0xa7, 0xf7, 0x2a, 0xb3,
	0x1a, 0x50, 0x69, 0x1a, 0x63, 0x6a, 0x95, 0x39, 0x5d, 0x4c, 0xcd, 0xfc, 0xf3, 0x02, 0x2c, 0x6e,
	0x23, 0xd7, 0x7d, 0x41, 0xdc, 0xae, 0x5a, 0xcb, 0x47, 0x50, 0x6a, 0xd3, 0x88, 0x84, 0x41, 0xd7,
	0x6a, 0x53, 0x5b, 0x2f, 0x48, 0x8b, 0x0a, 0xb1, 0x4d, 0x6d, 0xcc, 0x09, 0xfc, 0x53, 0x4a, 0xb0,
	0x45, 0x22, 0xaf, 0x85, 0x03, 0xad, 0x55, 0x2c, 0x0a, 0xc4, 0x73, 0x01, 0x30, 0xea, 0x50, 0x6e,
	0x45, 0xcc, 0x21, 0x98, 0x31, 0x8b, 0x20, 0x0f, 0xeb, 0xc5, 0x69, 0x0c, 0x79, 0x8e, 0x3c, 0x6c,
	0x6c, 0x42, 0x21, 0x5e, 0xd2, 0x7b, 0x95, 0xa2, 0x06, 0xbc, 0x67, 0x9e, 0xc6, 0xd6, 0x2a, 0xa5,
	0x49, 0xb0, 0xb5, 0xa1, 0x3d, 0x3a, 0x3b, 0xf5, 0x1e, 0x9d, 0x9b, 0x38, 0x76, 0x1e, 0x42, 0x49,
	0x68, 0x79, 0x18, 0xa0, 0xf6, 0x1b, 0x6c, 0xab, 0x0d, 0xb0, 0x36, 0xc4, 0xb0, 0x45, 0xa9, 0x1b,
	0x2f, 0x1f, 0x72, 0xdd, 0x43, 0x69, 0x6e, 0x34, 0xe1, 0xa6, 0xed, 0x30, 0xd4, 0x72, 0xb1, 0x35,
	0x90, 0x12, 0x54, 0x1c, 0x5f, 0xc6, 0x74, 0x5d, 0x41, 0x79, 0x4c, 0x6d, 0x27, 0x40, 0xc3, 0x82,
	0xf7, 0xd3, 0x21, 0x61, 0x9d, 0xe1, 0xc0, 0x39, 0x71, 0xda, 0x42, 0x27, 0xad, 0x28, 0x70, 0x2b,
	0x79, 0x0d, 0x2f, 0xd7, 0x52, 0x31, 0x72, 0x94, 0x22, 0x78, 0x19, 0xb8, 0xc6, 0x2e, 0xac, 0xa4,
	0x52, 0x17, 0x6a, 0x8b, 0x7d, 0x5b, 0xd0, 0x20, 0x5d, 0xee, 0xc1, 0xea, 0x02, 0x65, 0xfc, 0x3e,
	0x03, 0x6b, 0xa3, 0xd3, 0x60, 0x05, 0xee, 0x64, 0xee, 0x2e, 0xd6, 0x8e, 0xab, 0xa3, 0x72, 0xb3,
	0x48, 0x21, 0xd5, 0x7e, 0xff, 0x9b, 0x31, 0xc7, 0x01, 0xa7, 0x78, 0x4c, 0x22, 0xef, 0x52, 0x83,
	0x66, 0xa5, 0x3d, 0xe2, 0x8e, 0xf9, 0xc7, 0x0c, 0xdc, 0x8a, 0xf5, 0x77, 0xa7, 0x4b, 0x90, 0xe7,
	0xb4, 0x0f, 0x30, 0x0a, 0xda, 0xa7, 0x6a, 0xf3, 0x0e, 0x28, 0x57, 0x66, 0x5a, 0xe5, 0xca, 0x4e,
	0x9c, 0x21, 0xca, 0x50, 0x6c, 0xd0, 0x10, 0xbb, 0x72, 0x40, 0xe6, 0x75, 0x58, 0x3d, 0x38, 0xa5,
	0xbe, 0xcf, 0x3d, 0xf0, 0x50, 0xa0, 0x12, 0x86, 0x79, 0x13, 0xae, 0xc7, 0x97, 0xf7, 0x65, 0x92,
	0x57, 0x37, 0x7e, 0x01, 0x1f, 0xc6, 0x37, 0xb6, 0xa9, 0xe7, 0xa3, 0xc0, 0x61, 0x94, 0xec, 0x39,
	0x8c, 0x4f, 0xc1, 0xb4, 0x19, 0xd4, 0xfc, 0xeb, 0x1c, 0x14, 0x9f, 0x7a, 0xc8, 0x71, 0x93, 0xb4,
	0x35, 0x1f, 0x62, 0xc4, 0x70, 0xa0, 0x78, 0x7e, 0x50, 0xbd, 0xbc, 0xe2, 0xaa, 0x0a, 0xf0, 0xa1,
	0x80, 0x34, 0x15, 0x94, 0xcb, 0x1d, 0x7f, 0x00, 0x0e, 0x2c, 0xc7, 0x43, 0x1d, 0xac, 0x27, 0x77,
	0x12, 0xb1, 0xcb, 0x01, 0xc6, 0x63, 0x58, 0xf2, 0x50, 0xf0, 0x06, 0x8b, 0x20, 0x93, 0x1c, 0x3a,
	0x82, 0xb7, 0x98, 0x80, 0x24, 0xcd, 0x11, 0x54, 0x06, 0x68, 0xac, 0x64, 0x9a, 0x74, 0x64, 0xe8,
	0x46, 0x3f, 0x5f, 0x23, 0x2e, 0x3b, 0x8e, 0xe1, 0xd6, 0x20, 0x6f, 0x3a, 0xc4, 0x74, 0xf4, 0xe9,
	0xbd, 0x7e, 0xea, 0x9d, 0x54, 0xc0, 0xfd, 0x3a, 0x03, 0xdf, 0x1f, 0xa2, 0x57, 0x55, 0xa0, 0x54,
	0x31, 0x1a, 0x6f, 0x67, 0xa9, 0x63, 0x1b, 0xe3, 0xd6, 0x68, 0x47, 0xa2, 0xf9, 0x06, 0x3b, 0xa4,
	0x72, 0x4f, 0x37, 0xbf, 0x37, 0x30, 0x80, 0x61, 0x13, 0xe3, 0x00, 0x16, 0xe3, 0x72, 0x53, 0x8c,
	0x82, 0x55, 0x16, 0xee, 0xe4, 0xee, 0x16, 0x6b, 0x3f, 0x1c, 0xf7, 0x3c, 0x15, 0xbf, 0x82, 0xb8,
	0x59, 0xf6, 0x53, 0xbf, 0x58, 0x9a, 0xf4, 0xcc, 0xb1, 0x31, 0x65, 0x95, 0xfc, 0x44, 0xa4, 0x47,
	0x1c, 0x94, 0x90, 0x8a, 0x5f, 0xcc, 0xfc, 0x4d, 0x56, 0x45, 0xb1, 0x0c, 0xc4, 0x29, 0x2a, 0xca,
	0x01, 0xb5, 0xc8, 0x4e, 0xaa, 0x16, 0xdf, 0x41, 0xa2, 0x7e, 0x00, 0xe0, 0xd2, 0x0e, 0x55, 0x71,
	0xaf, 0x13, 0xa7, 0x05, 0x6e, 0x2f, 0xe6, 0xd7, 0xfc, 0x7b, 0x06, 0x56, 0x2f, 0x5a, 0xcb, 0x1f,
	0xc1, 0x6c, 0x88, 0xcf, 0x43, 0xad, 0xd9, 0x10, 0x96, 0x7c, 0x18, 0xfc, 0xd3, 0x6a, 0x53, 0x97,
	0xea, 0x55, 0x2c, 0x05, 0x6e, 0xbf, 0xcd, 0xcd, 0x8d, 0x06, 0xac, 0x44, 0x01, 0x4f, 0x94, 0xae,
	0x8b, 0xc5, 0x00, 0x2c, 0xc7, 0xd6, 0x9a, 0x8a, 0xa5, 0x28, 0x70, 0xb7, 0x13, 0xd4, 0xae, 0x6d,
	0x7e, 0x9b, 0x81, 0x52, 0x3a, 0x9e, 0xf8, 0x0c, 0xf7, 0x45, 0xa5, 0x96, 0x4b, 0xa5, 0x74, 0x10,
	0x4e, 0xbd, 0xc8, 0xa7, 0x70, 0x63, 0xc4, 0x86, 0xcc, 0x5d, 0x7d, 0x43, 0xae, 0xda, 0xc3, 0x17,
	0xcd, 0xcf, 0x13, 0xe7, 0x45, 0xa4, 0xa7, 0x9d, 0x17, 0xbb, 0x67, 0x22, 0xe7, 0x05, 0x85, 0xf9,
	0xc5, 0x3c, 0x14, 0xc5, 0x34, 0x28, 0xc5, 0xff, 0x04, 0x8a, 0xbe, 0x73, 0x8e, 0x5d, 0xeb, 0xad,
	0x63, 0x87, 0xa7, 0x2a, 0xde, 0x6e, 0x0d, 0x11, 0xee, 0x92, 0xf0, 0x27, 0xf7, 0x25, 0x1f, 0x08,
	0xfb, 0x57, 0xdc, 0xdc, 0xf8, 0x14, 0x4a, 0x12, 0x7d, 0x8a, 0x9d, 0xce, 0x69, 0xa8, 0xb4, 0xef,
	0x52, 0xb8, 0x7c, 0x5c, 0x43, 0xd8, 0x1b, 0x1f, 0x43, 0x41, 0x2a, 0x1c, 0x2f, 0x79, 0x74, 0xce,
	0x25, 0x79, 0x61, 0xce, 0x0b, 0x9c, 0xcf, 0x60, 0xd5, 0x0f, 0xf0, 0x99, 0x83, 0xdf, 0x5a, 0x69,
	0x07, 0x16, 0xc6, 0x8f, 0x60, 0x45, 0xe1, 0xf6, 0x7b, 0x7e, 0x3c, 0x83, 0x6b, 0xfd, 0x64, 0xca,
	0x9f, 0xfc, 0x78, 0x36, 0x23, 0xcd, 0xa6, 0xdc, 0x6a, 0x40, 0xfc, 0x0c, 0xab, 0xe7, 0x9e, 0x4e,
	0xf1, 0xb5, 0xa4, 0x60, 0xbb, 0xb1, 0x97, 0x9f, 0x43, 0x21, 0x39, 0x7c, 0xab, 0x4a, 0xeb, 0xfe,
	0x98, 0x4a, 0xeb, 0x99, 0xe3, 0xe1, 0xc3, 0xae, 0x2f, 0xab, 0xaa, 0xf8, 0x47, 0x33, 0xef, 0xa9,
	0x6f, 0x5c, 0x0b, 0x84, 0x34, 0xe9, 0x1c, 0x02, 0x84, 0xa5, 0xf1, 0x10, 0xc0, 0xc3, 0xb6, 0x83,
	0xac, 0x13, 0xc7, 0xd5, 0xda, 0x70, 0x8d, 0x99, 0x66, 0x41, 0x20, 0x9e, 0x38, 0x2e, 0x36, 0xee,
	0xc1, 0xac, 0x8d, 0x42, 0xa4, 0x36, 0xda, 0xf0, 0x64, 0x6e, 0x75, 0x43, 0xcc, 0x62, 0x9c, 0x30,
	0x35, 0x0e, 0xa1, 0x82, 0x6c, 0xcb, 0xb1, 0xf9, 0xde, 0x6a, 0x53, 0xbf, 0xab, 0xa6, 0xf1, 0x24,
	0xa0, 0x9e, 0xda, 0x64, 0x97, 0xad, 0x49, 0x63, 0xa6, 0xb9, 0x8a, 0xec, 0x5d, 0xfb, 0x90, 0x6e,
	0x53, 0xbf, 0x2b, 0xe6, 0xf2, 0x49, 0x40, 0xbd, 0xad, 0x05, 0x98, 0x13, 0x3c, 0xa6, 0x0d, 0xef,
	0x89, 0xdd, 0xb0, 0x15, 0x79, 0x3e, 0x0e, 0x76, 0xc9, 0x41, 0x18, 0x60, 0xe4, 0xa9, 0x1d, 0xf1,
	0x14, 0x96, 0xdb, 0xbc, 0xd0, 0x22, 0x5c, 0xb7, 0x5a, 0x88, 0x90, 0xa4, 0x1a, 0x1a, 0xb3, 0x76,
	0x09, 0x6a, 0x4b, 0x80, 0xcc, 0x5f, 0xc2, 0x87, 0xe2, 0x29, 0xcf, 0x29, 0x39, 0x78, 0xe3, 0xf8,
	0x3e, 0x3f, 0x06, 0xfc, 0xa7, 0x9e, 0xf5, 0x6d, 0x06, 0x6e, 0x89, 0x87, 0x1d, 0x06, 0x11, 0x3e,
	0xe2, 0x11, 0xd4, 0xff, 0xa0, 0x3d, 0x58, 0x95, 0x1a, 0x65, 0xb5, 0xa2, 0x30, 0xa4, 0xc4, 0x72,
	0x51, 0x0b, 0xbb, 0x5a, 0xcf, 0x5a, 0x91, 0xc0, 0x2d, 0x81, 0xdb, 0xe3, 0x30, 0x5e, 0xa0, 0x29,
	0xb6, 0x24, 0xcf, 0xea, 0xa8, 0xe8, 0xa2, 0x04, 0x25, 0x85, 0xd4, 0x45, 0xde, 0xe7, 0xae, 0xe2,
	0xfd, 0x6f, 0x33, 0x70, 0x4d, 0x78, 0xff, 0x22, 0x0a, 0x59, 0xda, 0xed, 0x77, 0x56, 0x09, 0x98,
	0xdf, 0x64, 0xe0, 0x76, 0xdf, 0x82, 0xec, 0x38, 0xac, 0x4d, 0xcf, 0x70, 0xd0, 0xfd, 0xbf, 0x68,
	0x7b, 0x7d, 0x35, 0x0b, 0x45, 0xe1, 0x9e, 0xf2, 0xe6, 0xc1, 0xa4, 0x12, 0x91, 0x16, 0x88, 0xd7,
	0x50, 0x70, 0x88, 0x25, 0x17, 0x4e, 0x79, 0xf3, 0x60, 0x5c, 0x0e, 0xbd, 0x24, 0xd8, 0x1b, 0x33,
	0xcd, 0xbc, 0xa3, 0xae, 0x18, 0x07, 0x30, 0xdf, 0x12, 0xbb, 0x5c, 0x39, 0xf9, 0xb1, 0x16, 0xf1,
	0x45, 0xc2, 0xd0, 0x98, 0x69, 0x2a, 0x2a, 0xe3, 0x25, 0x00, 0x8d, 0xc2, 0x78, 0xc4, 0x32, 0x67,
	0xde, 0xd7, 0x22, 0x1e, 0x08, 0x50, 0x2e, 0x94, 0x34, 0x0a, 0xd5, 0x58, 0x4f, 0xa0, 0x4c, 0x28,
	0xb1, 0x58, 0x2c, 0x16, 0x2a, 0x9d, 0x3e, 0xd2, 0x62, 0x1e, 0xad, 0x32, 0x8d, 0x99, 0x66, 0x89,
	0xa4, 0xee, 0x1a, 0xc7, 0x50, 0xb0, 0xe3, 0x68, 0x54, 0x59, 0xf7, 0x93, 0x89, 0xe6, 0x7b, 0x20,
	0x96, 0xb9, 0x17, 0x09, 0xe1, 0x56, 0x1e, 0xe6, 0x65, 0xa7, 0xdb, 0xfc, 0x43, 0x16, 0x6e, 0x34,
	0x31, 0xf3, 0x29, 0x61, 0xce, 0x19, 0xee, 0x3b, 0x96, 0xef, 0xf6, 0x5a, 0x4a, 0xac, 0x92, 0x11,
	0x47, 0x80, 0xb1, 0x67, 0xcd, 0xba, 0x6c, 0xb0, 0x32, 0x86, 0xc3, 0x5e, 0x87, 0x89, 0x19, 0x2f,
	0xfa, 0x82, 0x99, 0x55, 0xb2, 0x93, 0xb3, 0xf5, 0x11, 0xf4, 0x5a, 0x8d, 0xb9, 0x2b, 0xb4, 0x1a,
	0x67, 0xf5, 0x5b, 0x8d, 0xdf, 0xe4, 0xe1, 0xfd, 0x3d, 0xd1, 0x9e, 0xef, 0x4d, 0x92, 0x2a, 0x0d,
	0x7b, 0x5d, 0x64, 0x76, 0x4a, 0x83, 0xd0, 0x9a, 0x48, 0x29, 0xca, 0x02, 0x93, 0xa8, 0x6c, 0x1d,
	0xca, 0x2e, 0x25, 0x9d, 0xc9, 0xa4, 0xba, 0xc4, 0x21, 0x8d, 0x11, 0x62, 0x98, 0x9b, 0xfa, 0x58,
	0x34, 0x3b, 0xf1, 0xb1, 0x68, 0x0f, 0xae, 0x21, 0xd7, 0xa5, 0x6f, 0xad, 0x13, 0x17, 0x9f, 0x3b,
	0xa2, 0x17, 0x27, 0x4e, 0x26, 0x73, 0x63, 0x3b, 0x70, 0x86, 0xc0, 0x3d, 0x51, 0x30, 0x79, 0x40,
	0x79, 0x04, 0x25, 0xd4, 0x6e, 0x63, 0x12, 0x9f, 0x6f, 0x74, 0x4a, 0xcf, 0xa2, 0x44, 0x48, 0x02,
	0xae, 0x77, 0xc8, 0x21, 0x0a, 0xbe, 0xa0, 0xa5, 0x77, 0xc8, 0x21, 0x12, 0xfc, 0x19, 0xac, 0xf6,
	0x1f, 0x1c, 0x2c, 0x71, 0x38, 0xcb, 0x6b, 0x75, 0xe7, 0x52, 0xe7, 0x83, 0x43, 0x75, 0x50, 0x4b,
	0x9d, 0x17, 0x0b, 0x13, 0x9d, 0x17, 0x79, 0xa1, 0xca, 0x7e, 0x15, 0xa1, 0x00, 0x5b, 0x29, 0x0e,
	0xd0, 0x49, 0xc1, 0x12, 0xb6, 0x97, 0x30, 0x5d, 0xd0, 0xb3, 0x29, 0x5e, 0xa1, 0x67, 0xd3, 0x84,
	0x1b, 0x6a, 0x40, 0x83, 0x6c, 0x3a, 0x7d, 0xe7, 0x6b, 0x12, 0xfb, 0xac, 0x9f, 0xf3, 0x2d, 0x2c,
	0xf6, 0xbf, 0x7a, 0xab, 0x94, 0x45, 0x21, 0xbd, 0x3f, 0xa6, 0x90, 0x4e, 0xf6, 0xe2, 0x13, 0x81,
	0x3e, 0x90, 0x60, 0x51, 0x56, 0x5f, 0x7c, 0xab, 0x59, 0x3e, 0x49, 0xff, 0x14, 0x7d, 0xff, 0xc0,
	0x69, 0x63, 0xcb, 0x0f, 0xf0, 0x89, 0x73, 0x5e, 0x59, 0xd4, 0xea, 0xfb, 0x73, 0xc4, 0xbe, 0x00,
	0xf0, 0xb5, 0xf5, 0x03, 0xea, 0x51, 0x19, 0x1f, 0x4b, 0x3a, 0x6b, 0x2b, 0xec, 0x79, 0x60, 0x98,
	0xff, 0xca, 0x41, 0xa1, 0xee, 0xfb, 0x4a, 0x4a, 0x5e, 0xc1, 0x8a, 0x87, 0x88, 0x8d, 0x42, 0x1a,
	0x88, 0x97, 0x91, 0xa9, 0x76, 0xc0, 0x44, 0x52, 0xb9, 0x94, 0xb0, 0xc8, 0xab, 0xfd, 0x4a, 0x9e,
	0xfd, 0x4e, 0x95, 0x3c, 0x37, 0xad, 0x92, 0xef, 0xc0, 0xbc, 0x6a, 0x5d, 0xcd, 0xea, 0x75, 0x99,
	0xea, 0xb6, 0x3c, 0x1b, 0x0b, 0x2e, 0x85, 0x35, 0x0e, 0x60, 0xb1, 0x4b, 0xa3, 0x30, 0x6a, 0xe1,
	0xb8, 0x67, 0x35, 0xa7, 0xcb, 0x26, 0x4b, 0x24, 0xc1, 0x56, 0x56, 0x1c, 0xb2, 0x67, 0x65, 0xb4,
	0x60, 0xf5, 0x34, 0xf4, 0xdc, 0x1f, 0x5b, 0xb2, 0x6c, 0x6a, 0x45, 0xc4, 0x76, 0x31, 0xab, 0xcc,
	0x0b, 0xe6, 0xda, 0x78, 0xe6, 0x67, 0x1c, 0xb6, 0x25, 0x50, 0x92, 0x7f, 0x45, 0xd0, 0xa5, 0x2e,
	0x33, 0xf3, 0x2f, 0x59, 0x58, 0xad, 0xfb, 0xfe, 0x63, 0xd2, 0x41, 0x1d, 0xec, 0x61, 0x12, 0xfe,
	0x0f, 0x24, 0xdf, 0xde, 0x92, 0xe5, 0xa6, 0x58, 0xb2, 0x1d, 0x98, 0x57, 0x4b, 0x35, 0x7b, 0x85,
	0xa5, 0x52, 0x58, 0xf3, 0x8b, 0x1c, 0xdc, 0x90, 0x09, 0xba, 0xee, 0xfb, 0xbb, 0xf2, 0xed, 0xb9,
	0x9a, 0xc2, 0x0d, 0x98, 0x17, 0xaf, 0xd4, 0x6d, 0xad, 0x8c, 0x3c, 0x87, 0x7c, 0x7f, 0xd7, 0x36,
	0x22, 0x28, 0x24, 0x2f, 0xde, 0x45, 0x16, 0x5e, 0xac, 0xfd, 0x7c, 0x8c, 0x06, 0x0d, 0x3f, 0xbe,
	0xee, 0xfb, 0x07, 0x9c, 0x40, 0xe8, 0xd0, 0xe8, 0xdb, 0xcd, 0x3c, 0x52, 0xdf, 0xfa, 0x4e, 0x1a,
	0xb9, 0xa9, 0x4e, 0x1a, 0xef, 0xe0, 0xe5, 0x9d, 0xf9, 0x3b, 0x80, 0x9b, 0xa3, 0xea, 0xa3, 0x57,
	0xb0, 0x3c, 0x90, 0x26, 0xe2, 0x78, 0x9e, 0x2c, 0x6c, 0x96, 0xfa, 0xb3, 0x10, 0x33, 0x6c, 0xb8,
	0x79, 0x71, 0x1a, 0x8a, 0x23, 0x7c, 0x32, 0xfe, 0xeb, 0x17, 0xe5, 0x25, 0x66, 0x3c, 0x83, 0x62,
	0x2f, 0xed, 0x5e, 0x2d, 0xe0, 0x21, 0xc9, 0xe5, 0xcc, 0x78, 0x0d, 0xc6, 0x50, 0x32, 0xbf, 0x9a,
	0xf2, 0x2d, 0x0f, 0x64, 0x77, 0xd6, 0x2f, 0x19, 0x73, 0x53, 0x49, 0xc6, 0xfe, 0x60, 0x3d, 0x3a,
	0x3f, 0x79, 0x16, 0xea, 0x2f, 0x4f, 0x07, 0x45, 0x68, 0x61, 0x5a, 0x11, 0x1a, 0x56, 0xfc, 0xfc,
	0xf4, 0x8a, 0x3f, 0x54, 0x04, 0x17, 0xae, 0xf2, 0x6e, 0x20, 0x55, 0x75, 0xc2, 0x64, 0x55, 0xe7,
	0x60, 0xcd, 0x5b, 0x9c, 0xb4, 0xe6, 0x1d, 0x55, 0x82, 0x97, 0xae, 0x54, 0x82, 0x8f, 0x28, 0x82,
	0xcb, 0x57, 0x2a, 0x82, 0xdf, 0x69, 0xa5, 0x75, 0x41, 0x81, 0xb9, 0xfc, 0x5f, 0x29, 0x30, 0xcd,
	0x2f, 0xb3, 0xc9, 0xeb, 0x9e, 0x97, 0xe2, 0x0f, 0x62, 0x4a, 0x17, 0xbf, 0xcc, 0xc0, 0xad, 0x4b,
	0xfe, 0x39, 0x26, 0x72, 0xd6, 0x62, 0xed, 0x50, 0x6f, 0x78, 0x92, 0x59, 0xbd, 0x87, 0x48, 0x1a,
	0xcb, 0xa3, 0x6e, 0x36, 0x2b, 0xf6, 0x88, 0x3b, 0xc6, 0x2b, 0x28, 0xa5, 0x8b, 0x1d, 0x75, 0x0e,
	0xbd, 0x42, 0xad, 0xd3, 0x98, 0x69, 0x16, 0xbd, 0xde, 0xb5, 0xad, 0x32, 0xc8, 0x9f, 0xf2, 0xcf,
	0x7d, 0x5b, 0xff, 0xcc, 0x80, 0xd9, 0xa6, 0xde, 0x18, 0xde, 0xad, 0xe5, 0xba, 0xcd, 0x87, 0xc5,
	0x27, 0x8c, 0xed, 0xf3, 0x15, 0xde, 0xcf, 0xbc, 0xde, 0x51, 0x98, 0x0e, 0x75, 0x11, 0xe9, 0x54,
	0x69, 0xd0, 0x59, 0xef, 0x60, 0x22, 0xd6, 0x3f, 0xfe, 0x5f, 0x9c, 0xef, 0xb0, 0x51, 0xff, 0x2f,
	0x7c, 0x20, 0x3f, 0xbe, 0xca, 0xe6, 0x9e, 0xd6, 0xeb, 0x7f, 0xca, 0x7e, 0xf0, 0x54, 0x92, 0xd5,
	0x6d, 0x56, 0x95, 0x5f, 0xf9, 0xb7, 0xa3, 0x8d, 0xea, 0xb6, 0x30, 0xfb, 0x3a, 0x36, 0x38, 0xae,
	0xdb, 0xec, 0x38, 0x31, 0x38, 0x3e, 0xda, 0x38, 0x96, 0x06, 0xff, 0xc8, 0x9a, 0xf2, 0xea, 0xe6,
	0x66, 0xdd, 0x66, 0x9b, 0x9b, 0x89, 0xc9, 0xe6, 0xe6, 0xd1, 0xc6, 0xe6, 0xa6, 0x34, 0x6a, 0xcd,
	0x8b, 0xd1, 0x6d, 0xfc, 0x3b, 0x00, 0x00, 0xff, 0xff, 0xe2, 0x9b, 0x33, 0x5b, 0x50, 0x29, 0x00,
	0x00,
}
