// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/customer_feed_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [CustomerFeedService.GetCustomerFeed][google.ads.googleads.v3.services.CustomerFeedService.GetCustomerFeed].
type GetCustomerFeedRequest struct {
	// Required. The resource name of the customer feed to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCustomerFeedRequest) Reset()         { *m = GetCustomerFeedRequest{} }
func (m *GetCustomerFeedRequest) String() string { return proto.CompactTextString(m) }
func (*GetCustomerFeedRequest) ProtoMessage()    {}
func (*GetCustomerFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_900ccf1cb9cd0de8, []int{0}
}

func (m *GetCustomerFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCustomerFeedRequest.Unmarshal(m, b)
}
func (m *GetCustomerFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCustomerFeedRequest.Marshal(b, m, deterministic)
}
func (m *GetCustomerFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCustomerFeedRequest.Merge(m, src)
}
func (m *GetCustomerFeedRequest) XXX_Size() int {
	return xxx_messageInfo_GetCustomerFeedRequest.Size(m)
}
func (m *GetCustomerFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCustomerFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCustomerFeedRequest proto.InternalMessageInfo

func (m *GetCustomerFeedRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [CustomerFeedService.MutateCustomerFeeds][google.ads.googleads.v3.services.CustomerFeedService.MutateCustomerFeeds].
type MutateCustomerFeedsRequest struct {
	// Required. The ID of the customer whose customer feeds are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual customer feeds.
	Operations []*CustomerFeedOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerFeedsRequest) Reset()         { *m = MutateCustomerFeedsRequest{} }
func (m *MutateCustomerFeedsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerFeedsRequest) ProtoMessage()    {}
func (*MutateCustomerFeedsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_900ccf1cb9cd0de8, []int{1}
}

func (m *MutateCustomerFeedsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerFeedsRequest.Unmarshal(m, b)
}
func (m *MutateCustomerFeedsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerFeedsRequest.Marshal(b, m, deterministic)
}
func (m *MutateCustomerFeedsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerFeedsRequest.Merge(m, src)
}
func (m *MutateCustomerFeedsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerFeedsRequest.Size(m)
}
func (m *MutateCustomerFeedsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerFeedsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerFeedsRequest proto.InternalMessageInfo

func (m *MutateCustomerFeedsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCustomerFeedsRequest) GetOperations() []*CustomerFeedOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateCustomerFeedsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateCustomerFeedsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on a customer feed.
type CustomerFeedOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CustomerFeedOperation_Create
	//	*CustomerFeedOperation_Update
	//	*CustomerFeedOperation_Remove
	Operation            isCustomerFeedOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *CustomerFeedOperation) Reset()         { *m = CustomerFeedOperation{} }
func (m *CustomerFeedOperation) String() string { return proto.CompactTextString(m) }
func (*CustomerFeedOperation) ProtoMessage()    {}
func (*CustomerFeedOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_900ccf1cb9cd0de8, []int{2}
}

func (m *CustomerFeedOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomerFeedOperation.Unmarshal(m, b)
}
func (m *CustomerFeedOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomerFeedOperation.Marshal(b, m, deterministic)
}
func (m *CustomerFeedOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomerFeedOperation.Merge(m, src)
}
func (m *CustomerFeedOperation) XXX_Size() int {
	return xxx_messageInfo_CustomerFeedOperation.Size(m)
}
func (m *CustomerFeedOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomerFeedOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CustomerFeedOperation proto.InternalMessageInfo

func (m *CustomerFeedOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCustomerFeedOperation_Operation interface {
	isCustomerFeedOperation_Operation()
}

type CustomerFeedOperation_Create struct {
	Create *resources.CustomerFeed `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type CustomerFeedOperation_Update struct {
	Update *resources.CustomerFeed `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type CustomerFeedOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*CustomerFeedOperation_Create) isCustomerFeedOperation_Operation() {}

func (*CustomerFeedOperation_Update) isCustomerFeedOperation_Operation() {}

func (*CustomerFeedOperation_Remove) isCustomerFeedOperation_Operation() {}

func (m *CustomerFeedOperation) GetOperation() isCustomerFeedOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CustomerFeedOperation) GetCreate() *resources.CustomerFeed {
	if x, ok := m.GetOperation().(*CustomerFeedOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *CustomerFeedOperation) GetUpdate() *resources.CustomerFeed {
	if x, ok := m.GetOperation().(*CustomerFeedOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *CustomerFeedOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*CustomerFeedOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CustomerFeedOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CustomerFeedOperation_Create)(nil),
		(*CustomerFeedOperation_Update)(nil),
		(*CustomerFeedOperation_Remove)(nil),
	}
}

// Response message for a customer feed mutate.
type MutateCustomerFeedsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateCustomerFeedResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *MutateCustomerFeedsResponse) Reset()         { *m = MutateCustomerFeedsResponse{} }
func (m *MutateCustomerFeedsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerFeedsResponse) ProtoMessage()    {}
func (*MutateCustomerFeedsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_900ccf1cb9cd0de8, []int{3}
}

func (m *MutateCustomerFeedsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerFeedsResponse.Unmarshal(m, b)
}
func (m *MutateCustomerFeedsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerFeedsResponse.Marshal(b, m, deterministic)
}
func (m *MutateCustomerFeedsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerFeedsResponse.Merge(m, src)
}
func (m *MutateCustomerFeedsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerFeedsResponse.Size(m)
}
func (m *MutateCustomerFeedsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerFeedsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerFeedsResponse proto.InternalMessageInfo

func (m *MutateCustomerFeedsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateCustomerFeedsResponse) GetResults() []*MutateCustomerFeedResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the customer feed mutate.
type MutateCustomerFeedResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerFeedResult) Reset()         { *m = MutateCustomerFeedResult{} }
func (m *MutateCustomerFeedResult) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerFeedResult) ProtoMessage()    {}
func (*MutateCustomerFeedResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_900ccf1cb9cd0de8, []int{4}
}

func (m *MutateCustomerFeedResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerFeedResult.Unmarshal(m, b)
}
func (m *MutateCustomerFeedResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerFeedResult.Marshal(b, m, deterministic)
}
func (m *MutateCustomerFeedResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerFeedResult.Merge(m, src)
}
func (m *MutateCustomerFeedResult) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerFeedResult.Size(m)
}
func (m *MutateCustomerFeedResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerFeedResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerFeedResult proto.InternalMessageInfo

func (m *MutateCustomerFeedResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCustomerFeedRequest)(nil), "google.ads.googleads.v3.services.GetCustomerFeedRequest")
	proto.RegisterType((*MutateCustomerFeedsRequest)(nil), "google.ads.googleads.v3.services.MutateCustomerFeedsRequest")
	proto.RegisterType((*CustomerFeedOperation)(nil), "google.ads.googleads.v3.services.CustomerFeedOperation")
	proto.RegisterType((*MutateCustomerFeedsResponse)(nil), "google.ads.googleads.v3.services.MutateCustomerFeedsResponse")
	proto.RegisterType((*MutateCustomerFeedResult)(nil), "google.ads.googleads.v3.services.MutateCustomerFeedResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/customer_feed_service.proto", fileDescriptor_900ccf1cb9cd0de8)
}

var fileDescriptor_900ccf1cb9cd0de8 = []byte{
	// 782 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x4f, 0x6b, 0xe3, 0x46,
	0x14, 0xaf, 0xe4, 0x92, 0x36, 0xe3, 0xa4, 0x81, 0x09, 0x49, 0x55, 0xa7, 0x50, 0xa3, 0xa6, 0x24,
	0x98, 0x56, 0xa2, 0x36, 0x25, 0x45, 0x49, 0x28, 0x72, 0xa9, 0x9d, 0x1c, 0xd2, 0x04, 0xa5, 0xf8,
	0x50, 0x0c, 0x66, 0x22, 0x8d, 0xbd, 0x22, 0x92, 0x46, 0x3b, 0x23, 0x19, 0x42, 0xc8, 0x65, 0xbf,
	0xc1, 0xb2, 0xdf, 0x60, 0x8f, 0xfb, 0x15, 0xf6, 0xbc, 0x97, 0x5c, 0xf7, 0x96, 0x53, 0x0e, 0x0b,
	0x0b, 0x39, 0xec, 0x07, 0xd8, 0xcb, 0x2e, 0xd2, 0xcc, 0xd8, 0x72, 0x62, 0x63, 0x36, 0xb7, 0xa7,
	0x79, 0xbf, 0xf7, 0x7b, 0xff, 0x9f, 0xc0, 0xde, 0x80, 0x90, 0x41, 0x80, 0x4d, 0xe4, 0x31, 0x93,
	0x8b, 0x99, 0x34, 0x6c, 0x98, 0x0c, 0xd3, 0xa1, 0xef, 0x62, 0x66, 0xba, 0x29, 0x4b, 0x48, 0x88,
	0x69, 0xaf, 0x8f, 0xb1, 0xd7, 0x13, 0xcf, 0x46, 0x4c, 0x49, 0x42, 0x60, 0x95, 0x9b, 0x18, 0xc8,
	0x63, 0xc6, 0xc8, 0xda, 0x18, 0x36, 0x0c, 0x69, 0x5d, 0xf9, 0x63, 0x16, 0x3f, 0xc5, 0x8c, 0xa4,
	0xf4, 0x81, 0x03, 0x4e, 0x5c, 0xf9, 0x51, 0x9a, 0xc5, 0xbe, 0x89, 0xa2, 0x88, 0x24, 0x28, 0xf1,
	0x49, 0xc4, 0x84, 0xf6, 0xfb, 0x82, 0xd6, 0x0d, 0x7c, 0x1c, 0x25, 0x42, 0xf1, 0x53, 0x41, 0xd1,
	0xf7, 0x71, 0xe0, 0xf5, 0xce, 0xf0, 0x13, 0x34, 0xf4, 0x09, 0x15, 0x80, 0x1f, 0x0a, 0x00, 0x19,
	0x81, 0x50, 0x89, 0x5c, 0xcc, 0xfc, 0xeb, 0x2c, 0xed, 0x0b, 0x82, 0x10, 0xb1, 0xf3, 0x7b, 0x6e,
	0x69, 0xec, 0x9a, 0x2c, 0x41, 0x49, 0x2a, 0xe2, 0xd1, 0x03, 0xb0, 0xde, 0xc6, 0xc9, 0xdf, 0x22,
	0x8f, 0x16, 0xc6, 0x9e, 0x83, 0x9f, 0xa6, 0x98, 0x25, 0xd0, 0x01, 0xcb, 0xd2, 0x4d, 0x2f, 0x42,
	0x21, 0xd6, 0x94, 0xaa, 0xb2, 0xbd, 0xd8, 0xfc, 0xed, 0xd6, 0x56, 0x3f, 0xda, 0x5b, 0xe0, 0x97,
	0x71, 0xd1, 0x84, 0x14, 0xfb, 0xcc, 0x70, 0x49, 0x68, 0x4e, 0x90, 0x2d, 0x49, 0x8e, 0x7f, 0x51,
	0x88, 0xf5, 0x0f, 0x0a, 0xa8, 0x1c, 0xa5, 0x09, 0x4a, 0x70, 0x11, 0xc4, 0xa4, 0xcb, 0x4d, 0x50,
	0x1e, 0x55, 0xd4, 0xf7, 0x84, 0xc3, 0xd2, 0xad, 0xad, 0x3a, 0x40, 0xbe, 0x1f, 0x7a, 0xb0, 0x0b,
	0x00, 0x89, 0x31, 0xe5, 0x65, 0xd5, 0xd4, 0x6a, 0x69, 0xbb, 0x5c, 0xdf, 0x31, 0xe6, 0xb5, 0xd3,
	0x28, 0x7a, 0x3c, 0x96, 0xf6, 0x82, 0x7d, 0xcc, 0x07, 0xb7, 0xc0, 0x4a, 0x8c, 0x68, 0xe2, 0xa3,
	0xa0, 0xd7, 0x47, 0x7e, 0x90, 0x52, 0xac, 0x95, 0xaa, 0xca, 0xf6, 0xb7, 0xce, 0x77, 0xe2, 0xb9,
	0xc5, 0x5f, 0xe1, 0xcf, 0x60, 0x79, 0x88, 0x02, 0xdf, 0x43, 0x09, 0xee, 0x91, 0x28, 0xb8, 0xd0,
	0xbe, 0xce, 0x61, 0x4b, 0xf2, 0xf1, 0x38, 0x0a, 0x2e, 0xf4, 0xe7, 0x2a, 0x58, 0x9b, 0xea, 0x18,
	0xee, 0x82, 0x72, 0x1a, 0xe7, 0xc6, 0x59, 0x9b, 0x72, 0xe3, 0x72, 0xbd, 0x22, 0xd3, 0x90, 0x9d,
	0x34, 0x5a, 0x59, 0x27, 0x8f, 0x10, 0x3b, 0x77, 0x00, 0x87, 0x67, 0x32, 0x3c, 0x04, 0x0b, 0x2e,
	0xc5, 0x28, 0xe1, 0x4d, 0x29, 0xd7, 0xcd, 0x99, 0xe9, 0x8f, 0x66, 0x75, 0x22, 0xff, 0x83, 0xaf,
	0x1c, 0x41, 0x90, 0x51, 0x71, 0x62, 0x4d, 0x7d, 0x34, 0x15, 0x27, 0x80, 0x1a, 0x58, 0xa0, 0x38,
	0x24, 0x43, 0x5e, 0xb1, 0xc5, 0x4c, 0xc3, 0xbf, 0x9b, 0x65, 0xb0, 0x38, 0x2a, 0xb1, 0xfe, 0x5a,
	0x01, 0x1b, 0x53, 0x87, 0x80, 0xc5, 0x24, 0x62, 0x18, 0xb6, 0xc0, 0xda, 0xbd, 0x0e, 0xf4, 0x30,
	0xa5, 0x84, 0xe6, 0xac, 0xe5, 0x3a, 0x94, 0x01, 0xd2, 0xd8, 0x35, 0x4e, 0xf3, 0x59, 0x76, 0x56,
	0x27, 0x7b, 0xf3, 0x4f, 0x06, 0x87, 0xff, 0x81, 0x6f, 0x28, 0x66, 0x69, 0x90, 0xc8, 0x21, 0xb1,
	0xe6, 0x0f, 0xc9, 0xc3, 0xb8, 0x9c, 0x9c, 0xc2, 0x91, 0x54, 0xfa, 0x5f, 0x40, 0x9b, 0x05, 0xca,
	0x46, 0x62, 0xca, 0xca, 0x4c, 0xee, 0x40, 0xfd, 0x7d, 0x09, 0xac, 0x16, 0x6d, 0x4f, 0xb9, 0x6f,
	0xf8, 0x46, 0x01, 0x2b, 0xf7, 0x56, 0x11, 0xfe, 0x39, 0x3f, 0xe2, 0xe9, 0xdb, 0x5b, 0xf9, 0xd2,
	0x36, 0xea, 0xed, 0x1b, 0x7b, 0x32, 0xf8, 0x67, 0x6f, 0xdf, 0xbd, 0x50, 0x7f, 0x87, 0x66, 0x76,
	0xf1, 0x2e, 0x27, 0x34, 0xfb, 0x72, 0x19, 0x99, 0x59, 0x1b, 0x9d, 0xc0, 0xbc, 0x87, 0x66, 0xed,
	0x0a, 0xde, 0x29, 0x60, 0x75, 0x4a, 0x7b, 0xe1, 0xde, 0x63, 0xaa, 0x2f, 0x4f, 0x43, 0x65, 0xff,
	0x91, 0xd6, 0x7c, 0xa6, 0xf4, 0xce, 0x8d, 0xbd, 0x5e, 0x38, 0x2d, 0xbf, 0x8e, 0x17, 0x3e, 0x4f,
	0x73, 0x47, 0xaf, 0x67, 0x69, 0x8e, 0xf3, 0xba, 0x2c, 0x80, 0xf7, 0x6b, 0x57, 0x93, 0x59, 0x5a,
	0x61, 0xee, 0xc9, 0x52, 0x6a, 0x95, 0x8d, 0x6b, 0x5b, 0x9b, 0x75, 0x08, 0x9b, 0x9f, 0x14, 0xb0,
	0xe9, 0x92, 0x70, 0x6e, 0xe4, 0x4d, 0x6d, 0xca, 0x3c, 0x9c, 0x64, 0x17, 0xe0, 0x44, 0xf9, 0xff,
	0x40, 0x58, 0x0f, 0x48, 0x80, 0xa2, 0x81, 0x41, 0xe8, 0xc0, 0x1c, 0xe0, 0x28, 0xbf, 0x0f, 0xe6,
	0xd8, 0xdf, 0xec, 0x9f, 0xe0, 0xae, 0x14, 0x5e, 0xaa, 0xa5, 0xb6, 0x6d, 0xbf, 0x52, 0xab, 0x6d,
	0x4e, 0x68, 0x7b, 0xcc, 0xe0, 0x62, 0x26, 0x75, 0x1a, 0x86, 0x70, 0xcc, 0xae, 0x25, 0xa4, 0x6b,
	0x7b, 0xac, 0x3b, 0x82, 0x74, 0x3b, 0x8d, 0xae, 0x84, 0xdc, 0xa9, 0x9b, 0xfc, 0xdd, 0xb2, 0x6c,
	0x8f, 0x59, 0xd6, 0x08, 0x64, 0x59, 0x9d, 0x86, 0x65, 0x49, 0xd8, 0xd9, 0x42, 0x1e, 0x67, 0xe3,
	0x73, 0x00, 0x00, 0x00, 0xff, 0xff, 0x95, 0xd6, 0x41, 0xdf, 0xab, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CustomerFeedServiceClient is the client API for CustomerFeedService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CustomerFeedServiceClient interface {
	// Returns the requested customer feed in full detail.
	GetCustomerFeed(ctx context.Context, in *GetCustomerFeedRequest, opts ...grpc.CallOption) (*resources.CustomerFeed, error)
	// Creates, updates, or removes customer feeds. Operation statuses are
	// returned.
	MutateCustomerFeeds(ctx context.Context, in *MutateCustomerFeedsRequest, opts ...grpc.CallOption) (*MutateCustomerFeedsResponse, error)
}

type customerFeedServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCustomerFeedServiceClient(cc grpc.ClientConnInterface) CustomerFeedServiceClient {
	return &customerFeedServiceClient{cc}
}

func (c *customerFeedServiceClient) GetCustomerFeed(ctx context.Context, in *GetCustomerFeedRequest, opts ...grpc.CallOption) (*resources.CustomerFeed, error) {
	out := new(resources.CustomerFeed)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomerFeedService/GetCustomerFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerFeedServiceClient) MutateCustomerFeeds(ctx context.Context, in *MutateCustomerFeedsRequest, opts ...grpc.CallOption) (*MutateCustomerFeedsResponse, error) {
	out := new(MutateCustomerFeedsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomerFeedService/MutateCustomerFeeds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomerFeedServiceServer is the server API for CustomerFeedService service.
type CustomerFeedServiceServer interface {
	// Returns the requested customer feed in full detail.
	GetCustomerFeed(context.Context, *GetCustomerFeedRequest) (*resources.CustomerFeed, error)
	// Creates, updates, or removes customer feeds. Operation statuses are
	// returned.
	MutateCustomerFeeds(context.Context, *MutateCustomerFeedsRequest) (*MutateCustomerFeedsResponse, error)
}

// UnimplementedCustomerFeedServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCustomerFeedServiceServer struct {
}

func (*UnimplementedCustomerFeedServiceServer) GetCustomerFeed(ctx context.Context, req *GetCustomerFeedRequest) (*resources.CustomerFeed, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCustomerFeed not implemented")
}
func (*UnimplementedCustomerFeedServiceServer) MutateCustomerFeeds(ctx context.Context, req *MutateCustomerFeedsRequest) (*MutateCustomerFeedsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateCustomerFeeds not implemented")
}

func RegisterCustomerFeedServiceServer(s *grpc.Server, srv CustomerFeedServiceServer) {
	s.RegisterService(&_CustomerFeedService_serviceDesc, srv)
}

func _CustomerFeedService_GetCustomerFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerFeedServiceServer).GetCustomerFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomerFeedService/GetCustomerFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerFeedServiceServer).GetCustomerFeed(ctx, req.(*GetCustomerFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerFeedService_MutateCustomerFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCustomerFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerFeedServiceServer).MutateCustomerFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomerFeedService/MutateCustomerFeeds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerFeedServiceServer).MutateCustomerFeeds(ctx, req.(*MutateCustomerFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CustomerFeedService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.CustomerFeedService",
	HandlerType: (*CustomerFeedServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCustomerFeed",
			Handler:    _CustomerFeedService_GetCustomerFeed_Handler,
		},
		{
			MethodName: "MutateCustomerFeeds",
			Handler:    _CustomerFeedService_MutateCustomerFeeds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/customer_feed_service.proto",
}
