// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/asset/v1p4beta1/asset_service.proto

package asset

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// IAM policy analysis query message.
type IamPolicyAnalysisQuery struct {
	// Required. The relative name of the root asset. Only resources and IAM policies within
	// the parent will be analyzed. This can only be an organization number (such
	// as "organizations/123") or a folder number (such as "folders/123").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Specifies a resource for analysis. Leaving it empty means ANY.
	ResourceSelector *IamPolicyAnalysisQuery_ResourceSelector `protobuf:"bytes,2,opt,name=resource_selector,json=resourceSelector,proto3" json:"resource_selector,omitempty"`
	// Optional. Specifies an identity for analysis. Leaving it empty means ANY.
	IdentitySelector *IamPolicyAnalysisQuery_IdentitySelector `protobuf:"bytes,3,opt,name=identity_selector,json=identitySelector,proto3" json:"identity_selector,omitempty"`
	// Optional. Specifies roles or permissions for analysis. Leaving it empty
	// means ANY.
	AccessSelector       *IamPolicyAnalysisQuery_AccessSelector `protobuf:"bytes,4,opt,name=access_selector,json=accessSelector,proto3" json:"access_selector,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *IamPolicyAnalysisQuery) Reset()         { *m = IamPolicyAnalysisQuery{} }
func (m *IamPolicyAnalysisQuery) String() string { return proto.CompactTextString(m) }
func (*IamPolicyAnalysisQuery) ProtoMessage()    {}
func (*IamPolicyAnalysisQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{0}
}

func (m *IamPolicyAnalysisQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisQuery.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisQuery.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisQuery.Merge(m, src)
}
func (m *IamPolicyAnalysisQuery) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisQuery.Size(m)
}
func (m *IamPolicyAnalysisQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisQuery.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisQuery proto.InternalMessageInfo

func (m *IamPolicyAnalysisQuery) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *IamPolicyAnalysisQuery) GetResourceSelector() *IamPolicyAnalysisQuery_ResourceSelector {
	if m != nil {
		return m.ResourceSelector
	}
	return nil
}

func (m *IamPolicyAnalysisQuery) GetIdentitySelector() *IamPolicyAnalysisQuery_IdentitySelector {
	if m != nil {
		return m.IdentitySelector
	}
	return nil
}

func (m *IamPolicyAnalysisQuery) GetAccessSelector() *IamPolicyAnalysisQuery_AccessSelector {
	if m != nil {
		return m.AccessSelector
	}
	return nil
}

// Specifies the resource to analyze for access policies, which may be set
// directly on the resource, or on ancestors such as organizations, folders or
// projects. At least one of [ResourceSelector][google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.ResourceSelector], [IdentitySelector][google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.IdentitySelector] or
// [AccessSelector][google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.AccessSelector] must be specified in a request.
type IamPolicyAnalysisQuery_ResourceSelector struct {
	// Required. The [full resource
	// name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// .
	FullResourceName     string   `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IamPolicyAnalysisQuery_ResourceSelector) Reset() {
	*m = IamPolicyAnalysisQuery_ResourceSelector{}
}
func (m *IamPolicyAnalysisQuery_ResourceSelector) String() string { return proto.CompactTextString(m) }
func (*IamPolicyAnalysisQuery_ResourceSelector) ProtoMessage()    {}
func (*IamPolicyAnalysisQuery_ResourceSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{0, 0}
}

func (m *IamPolicyAnalysisQuery_ResourceSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisQuery_ResourceSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisQuery_ResourceSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector.Merge(m, src)
}
func (m *IamPolicyAnalysisQuery_ResourceSelector) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector.Size(m)
}
func (m *IamPolicyAnalysisQuery_ResourceSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisQuery_ResourceSelector proto.InternalMessageInfo

func (m *IamPolicyAnalysisQuery_ResourceSelector) GetFullResourceName() string {
	if m != nil {
		return m.FullResourceName
	}
	return ""
}

// Specifies an identity for which to determine resource access, based on
// roles assigned either directly to them or to the groups they belong to,
// directly or indirectly.
type IamPolicyAnalysisQuery_IdentitySelector struct {
	// Required. The identity appear in the form of members in
	// [IAM policy
	// binding](https://cloud.google.com/iam/reference/rest/v1/Binding).
	Identity             string   `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IamPolicyAnalysisQuery_IdentitySelector) Reset() {
	*m = IamPolicyAnalysisQuery_IdentitySelector{}
}
func (m *IamPolicyAnalysisQuery_IdentitySelector) String() string { return proto.CompactTextString(m) }
func (*IamPolicyAnalysisQuery_IdentitySelector) ProtoMessage()    {}
func (*IamPolicyAnalysisQuery_IdentitySelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{0, 1}
}

func (m *IamPolicyAnalysisQuery_IdentitySelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisQuery_IdentitySelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisQuery_IdentitySelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector.Merge(m, src)
}
func (m *IamPolicyAnalysisQuery_IdentitySelector) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector.Size(m)
}
func (m *IamPolicyAnalysisQuery_IdentitySelector) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisQuery_IdentitySelector proto.InternalMessageInfo

func (m *IamPolicyAnalysisQuery_IdentitySelector) GetIdentity() string {
	if m != nil {
		return m.Identity
	}
	return ""
}

// Specifies roles and/or permissions to analyze, to determine both the
// identities possessing them and the resources they control. If multiple
// values are specified, results will include identities and resources
// matching any of them.
type IamPolicyAnalysisQuery_AccessSelector struct {
	// Optional. The roles to appear in result.
	Roles []string `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	// Optional. The permissions to appear in result.
	Permissions          []string `protobuf:"bytes,2,rep,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IamPolicyAnalysisQuery_AccessSelector) Reset()         { *m = IamPolicyAnalysisQuery_AccessSelector{} }
func (m *IamPolicyAnalysisQuery_AccessSelector) String() string { return proto.CompactTextString(m) }
func (*IamPolicyAnalysisQuery_AccessSelector) ProtoMessage()    {}
func (*IamPolicyAnalysisQuery_AccessSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{0, 2}
}

func (m *IamPolicyAnalysisQuery_AccessSelector) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisQuery_AccessSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisQuery_AccessSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector.Merge(m, src)
}
func (m *IamPolicyAnalysisQuery_AccessSelector) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector.Size(m)
}
func (m *IamPolicyAnalysisQuery_AccessSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisQuery_AccessSelector proto.InternalMessageInfo

func (m *IamPolicyAnalysisQuery_AccessSelector) GetRoles() []string {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *IamPolicyAnalysisQuery_AccessSelector) GetPermissions() []string {
	if m != nil {
		return m.Permissions
	}
	return nil
}

// A request message for [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1p4beta1.AssetService.AnalyzeIamPolicy].
type AnalyzeIamPolicyRequest struct {
	// Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// Optional. The request options.
	Options              *AnalyzeIamPolicyRequest_Options `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *AnalyzeIamPolicyRequest) Reset()         { *m = AnalyzeIamPolicyRequest{} }
func (m *AnalyzeIamPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*AnalyzeIamPolicyRequest) ProtoMessage()    {}
func (*AnalyzeIamPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{1}
}

func (m *AnalyzeIamPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnalyzeIamPolicyRequest.Unmarshal(m, b)
}
func (m *AnalyzeIamPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnalyzeIamPolicyRequest.Marshal(b, m, deterministic)
}
func (m *AnalyzeIamPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnalyzeIamPolicyRequest.Merge(m, src)
}
func (m *AnalyzeIamPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_AnalyzeIamPolicyRequest.Size(m)
}
func (m *AnalyzeIamPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnalyzeIamPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnalyzeIamPolicyRequest proto.InternalMessageInfo

func (m *AnalyzeIamPolicyRequest) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if m != nil {
		return m.AnalysisQuery
	}
	return nil
}

func (m *AnalyzeIamPolicyRequest) GetOptions() *AnalyzeIamPolicyRequest_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

// Contains request options.
type AnalyzeIamPolicyRequest_Options struct {
	// Optional. If true, the identities section of the result will expand any
	// Google groups appearing in an IAM policy binding.
	//
	// If [identity_selector][] is specified, the identity in the result will
	// be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandGroups bool `protobuf:"varint,1,opt,name=expand_groups,json=expandGroups,proto3" json:"expand_groups,omitempty"`
	// Optional. If true, the access section of result will expand any roles
	// appearing in IAM policy bindings to include their permissions.
	//
	// If [access_selector][] is specified, the access section of the result
	// will be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandRoles bool `protobuf:"varint,2,opt,name=expand_roles,json=expandRoles,proto3" json:"expand_roles,omitempty"`
	// Optional. If true, the resource section of the result will expand any
	// resource attached to an IAM policy to include resources lower in the
	// resource hierarchy.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and the results include an IAM policy with P on a GCP
	// folder, the results will also include resources in that folder with
	// permission P.
	//
	// If [resource_selector][] is specified, the resource section of the result
	// will be determined by the selector, and this flag will have no effect.
	// Default is false.
	ExpandResources bool `protobuf:"varint,3,opt,name=expand_resources,json=expandResources,proto3" json:"expand_resources,omitempty"`
	// Optional. If true, the result will output resource edges, starting
	// from the policy attached resource, to any expanded resources.
	// Default is false.
	OutputResourceEdges bool `protobuf:"varint,4,opt,name=output_resource_edges,json=outputResourceEdges,proto3" json:"output_resource_edges,omitempty"`
	// Optional. If true, the result will output group identity edges, starting
	// from the binding's group members, to any expanded identities.
	// Default is false.
	OutputGroupEdges bool `protobuf:"varint,5,opt,name=output_group_edges,json=outputGroupEdges,proto3" json:"output_group_edges,omitempty"`
	// Optional. If true, the response will include access analysis from identities to
	// resources via service account impersonation. This is a very expensive
	// operation, because many derived queries will be executed. We highly
	// recommend you use ExportIamPolicyAnalysis rpc instead.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and there's an IAM policy states user A has
	// iam.serviceAccounts.getAccessToken permission to a service account SA,
	// and there's another IAM policy states service account SA has permission P
	// to a GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Another example, if the request analyzes for who has
	// permission P to a GCP folder F, and there's an IAM policy states user A
	// has iam.serviceAccounts.actAs permission to a service account SA, and
	// there's another IAM policy states service account SA has permission P to
	// the GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Default is false.
	AnalyzeServiceAccountImpersonation bool `protobuf:"varint,6,opt,name=analyze_service_account_impersonation,json=analyzeServiceAccountImpersonation,proto3" json:"analyze_service_account_impersonation,omitempty"`
	// Optional. Amount of time executable has to complete.  See JSON representation of
	// [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json).
	//
	// If this field is set with a value less than the RPC deadline, and the
	// execution of your query hasn't finished in the specified
	// execution timeout,  you will get a response with partial result.
	// Otherwise, your query's execution will continue until the RPC deadline.
	// If it's not finished until then, you will get a  DEADLINE_EXCEEDED error.
	//
	// Default is empty.
	ExecutionTimeout     *duration.Duration `protobuf:"bytes,7,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *AnalyzeIamPolicyRequest_Options) Reset()         { *m = AnalyzeIamPolicyRequest_Options{} }
func (m *AnalyzeIamPolicyRequest_Options) String() string { return proto.CompactTextString(m) }
func (*AnalyzeIamPolicyRequest_Options) ProtoMessage()    {}
func (*AnalyzeIamPolicyRequest_Options) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{1, 0}
}

func (m *AnalyzeIamPolicyRequest_Options) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnalyzeIamPolicyRequest_Options.Unmarshal(m, b)
}
func (m *AnalyzeIamPolicyRequest_Options) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnalyzeIamPolicyRequest_Options.Marshal(b, m, deterministic)
}
func (m *AnalyzeIamPolicyRequest_Options) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnalyzeIamPolicyRequest_Options.Merge(m, src)
}
func (m *AnalyzeIamPolicyRequest_Options) XXX_Size() int {
	return xxx_messageInfo_AnalyzeIamPolicyRequest_Options.Size(m)
}
func (m *AnalyzeIamPolicyRequest_Options) XXX_DiscardUnknown() {
	xxx_messageInfo_AnalyzeIamPolicyRequest_Options.DiscardUnknown(m)
}

var xxx_messageInfo_AnalyzeIamPolicyRequest_Options proto.InternalMessageInfo

func (m *AnalyzeIamPolicyRequest_Options) GetExpandGroups() bool {
	if m != nil {
		return m.ExpandGroups
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetExpandRoles() bool {
	if m != nil {
		return m.ExpandRoles
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetExpandResources() bool {
	if m != nil {
		return m.ExpandResources
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetOutputResourceEdges() bool {
	if m != nil {
		return m.OutputResourceEdges
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetOutputGroupEdges() bool {
	if m != nil {
		return m.OutputGroupEdges
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetAnalyzeServiceAccountImpersonation() bool {
	if m != nil {
		return m.AnalyzeServiceAccountImpersonation
	}
	return false
}

func (m *AnalyzeIamPolicyRequest_Options) GetExecutionTimeout() *duration.Duration {
	if m != nil {
		return m.ExecutionTimeout
	}
	return nil
}

// A response message for [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1p4beta1.AssetService.AnalyzeIamPolicy].
type AnalyzeIamPolicyResponse struct {
	// The main analysis that matches the original request.
	MainAnalysis *AnalyzeIamPolicyResponse_IamPolicyAnalysis `protobuf:"bytes,1,opt,name=main_analysis,json=mainAnalysis,proto3" json:"main_analysis,omitempty"`
	// The service account impersonation analysis if
	// [AnalyzeIamPolicyRequest.analyze_service_account_impersonation][] is
	// enabled.
	ServiceAccountImpersonationAnalysis []*AnalyzeIamPolicyResponse_IamPolicyAnalysis `protobuf:"bytes,2,rep,name=service_account_impersonation_analysis,json=serviceAccountImpersonationAnalysis,proto3" json:"service_account_impersonation_analysis,omitempty"`
	// Represents whether all entries in the [main_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.main_analysis] and
	// [service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis] have been fully explored to
	// answer the query in the request.
	FullyExplored bool `protobuf:"varint,3,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
	// A list of non-critical errors happened during the request handling to
	// explain why `fully_explored` is false, or empty if no error happened.
	NonCriticalErrors    []*IamPolicyAnalysisResult_AnalysisState `protobuf:"bytes,4,rep,name=non_critical_errors,json=nonCriticalErrors,proto3" json:"non_critical_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *AnalyzeIamPolicyResponse) Reset()         { *m = AnalyzeIamPolicyResponse{} }
func (m *AnalyzeIamPolicyResponse) String() string { return proto.CompactTextString(m) }
func (*AnalyzeIamPolicyResponse) ProtoMessage()    {}
func (*AnalyzeIamPolicyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{2}
}

func (m *AnalyzeIamPolicyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnalyzeIamPolicyResponse.Unmarshal(m, b)
}
func (m *AnalyzeIamPolicyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnalyzeIamPolicyResponse.Marshal(b, m, deterministic)
}
func (m *AnalyzeIamPolicyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnalyzeIamPolicyResponse.Merge(m, src)
}
func (m *AnalyzeIamPolicyResponse) XXX_Size() int {
	return xxx_messageInfo_AnalyzeIamPolicyResponse.Size(m)
}
func (m *AnalyzeIamPolicyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnalyzeIamPolicyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnalyzeIamPolicyResponse proto.InternalMessageInfo

func (m *AnalyzeIamPolicyResponse) GetMainAnalysis() *AnalyzeIamPolicyResponse_IamPolicyAnalysis {
	if m != nil {
		return m.MainAnalysis
	}
	return nil
}

func (m *AnalyzeIamPolicyResponse) GetServiceAccountImpersonationAnalysis() []*AnalyzeIamPolicyResponse_IamPolicyAnalysis {
	if m != nil {
		return m.ServiceAccountImpersonationAnalysis
	}
	return nil
}

func (m *AnalyzeIamPolicyResponse) GetFullyExplored() bool {
	if m != nil {
		return m.FullyExplored
	}
	return false
}

func (m *AnalyzeIamPolicyResponse) GetNonCriticalErrors() []*IamPolicyAnalysisResult_AnalysisState {
	if m != nil {
		return m.NonCriticalErrors
	}
	return nil
}

// An analysis message to group the query and results.
type AnalyzeIamPolicyResponse_IamPolicyAnalysis struct {
	// The analysis query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// A list of [IamPolicyAnalysisResult][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult] that matches the analysis query, or
	// empty if no result is found.
	AnalysisResults []*IamPolicyAnalysisResult `protobuf:"bytes,2,rep,name=analysis_results,json=analysisResults,proto3" json:"analysis_results,omitempty"`
	// Represents whether all entries in the [analysis_results][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_results] have been
	// fully explored to answer the query.
	FullyExplored        bool     `protobuf:"varint,3,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) Reset() {
	*m = AnalyzeIamPolicyResponse_IamPolicyAnalysis{}
}
func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) String() string {
	return proto.CompactTextString(m)
}
func (*AnalyzeIamPolicyResponse_IamPolicyAnalysis) ProtoMessage() {}
func (*AnalyzeIamPolicyResponse_IamPolicyAnalysis) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{2, 0}
}

func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis.Unmarshal(m, b)
}
func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis.Marshal(b, m, deterministic)
}
func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis.Merge(m, src)
}
func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) XXX_Size() int {
	return xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis.Size(m)
}
func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) XXX_DiscardUnknown() {
	xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis.DiscardUnknown(m)
}

var xxx_messageInfo_AnalyzeIamPolicyResponse_IamPolicyAnalysis proto.InternalMessageInfo

func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if m != nil {
		return m.AnalysisQuery
	}
	return nil
}

func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetAnalysisResults() []*IamPolicyAnalysisResult {
	if m != nil {
		return m.AnalysisResults
	}
	return nil
}

func (m *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetFullyExplored() bool {
	if m != nil {
		return m.FullyExplored
	}
	return false
}

// Output configuration for export IAM policy analysis destination.
type IamPolicyAnalysisOutputConfig struct {
	// IAM policy analysis export destination.
	//
	// Types that are valid to be assigned to Destination:
	//	*IamPolicyAnalysisOutputConfig_GcsDestination_
	Destination          isIamPolicyAnalysisOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *IamPolicyAnalysisOutputConfig) Reset()         { *m = IamPolicyAnalysisOutputConfig{} }
func (m *IamPolicyAnalysisOutputConfig) String() string { return proto.CompactTextString(m) }
func (*IamPolicyAnalysisOutputConfig) ProtoMessage()    {}
func (*IamPolicyAnalysisOutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{3}
}

func (m *IamPolicyAnalysisOutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisOutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisOutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisOutputConfig.Merge(m, src)
}
func (m *IamPolicyAnalysisOutputConfig) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig.Size(m)
}
func (m *IamPolicyAnalysisOutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisOutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisOutputConfig proto.InternalMessageInfo

type isIamPolicyAnalysisOutputConfig_Destination interface {
	isIamPolicyAnalysisOutputConfig_Destination()
}

type IamPolicyAnalysisOutputConfig_GcsDestination_ struct {
	GcsDestination *IamPolicyAnalysisOutputConfig_GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*IamPolicyAnalysisOutputConfig_GcsDestination_) isIamPolicyAnalysisOutputConfig_Destination() {}

func (m *IamPolicyAnalysisOutputConfig) GetDestination() isIamPolicyAnalysisOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *IamPolicyAnalysisOutputConfig) GetGcsDestination() *IamPolicyAnalysisOutputConfig_GcsDestination {
	if x, ok := m.GetDestination().(*IamPolicyAnalysisOutputConfig_GcsDestination_); ok {
		return x.GcsDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*IamPolicyAnalysisOutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*IamPolicyAnalysisOutputConfig_GcsDestination_)(nil),
	}
}

// A Cloud Storage location.
type IamPolicyAnalysisOutputConfig_GcsDestination struct {
	// Required. The uri of the Cloud Storage object. It's the same uri that is used by
	// gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
	// Editing Object
	// Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
	// for more information.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IamPolicyAnalysisOutputConfig_GcsDestination) Reset() {
	*m = IamPolicyAnalysisOutputConfig_GcsDestination{}
}
func (m *IamPolicyAnalysisOutputConfig_GcsDestination) String() string {
	return proto.CompactTextString(m)
}
func (*IamPolicyAnalysisOutputConfig_GcsDestination) ProtoMessage() {}
func (*IamPolicyAnalysisOutputConfig_GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{3, 0}
}

func (m *IamPolicyAnalysisOutputConfig_GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination.Unmarshal(m, b)
}
func (m *IamPolicyAnalysisOutputConfig_GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination.Marshal(b, m, deterministic)
}
func (m *IamPolicyAnalysisOutputConfig_GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination.Merge(m, src)
}
func (m *IamPolicyAnalysisOutputConfig_GcsDestination) XXX_Size() int {
	return xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination.Size(m)
}
func (m *IamPolicyAnalysisOutputConfig_GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_IamPolicyAnalysisOutputConfig_GcsDestination proto.InternalMessageInfo

func (m *IamPolicyAnalysisOutputConfig_GcsDestination) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// A request message for [AssetService.ExportIamPolicyAnalysis][google.cloud.asset.v1p4beta1.AssetService.ExportIamPolicyAnalysis].
type ExportIamPolicyAnalysisRequest struct {
	// Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// Optional. The request options.
	Options *ExportIamPolicyAnalysisRequest_Options `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	// Required. Output configuration indicating where the results will be output to.
	OutputConfig         *IamPolicyAnalysisOutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ExportIamPolicyAnalysisRequest) Reset()         { *m = ExportIamPolicyAnalysisRequest{} }
func (m *ExportIamPolicyAnalysisRequest) String() string { return proto.CompactTextString(m) }
func (*ExportIamPolicyAnalysisRequest) ProtoMessage()    {}
func (*ExportIamPolicyAnalysisRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{4}
}

func (m *ExportIamPolicyAnalysisRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest.Unmarshal(m, b)
}
func (m *ExportIamPolicyAnalysisRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest.Marshal(b, m, deterministic)
}
func (m *ExportIamPolicyAnalysisRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportIamPolicyAnalysisRequest.Merge(m, src)
}
func (m *ExportIamPolicyAnalysisRequest) XXX_Size() int {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest.Size(m)
}
func (m *ExportIamPolicyAnalysisRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportIamPolicyAnalysisRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportIamPolicyAnalysisRequest proto.InternalMessageInfo

func (m *ExportIamPolicyAnalysisRequest) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if m != nil {
		return m.AnalysisQuery
	}
	return nil
}

func (m *ExportIamPolicyAnalysisRequest) GetOptions() *ExportIamPolicyAnalysisRequest_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ExportIamPolicyAnalysisRequest) GetOutputConfig() *IamPolicyAnalysisOutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Contains request options.
type ExportIamPolicyAnalysisRequest_Options struct {
	// Optional. If true, the identities section of the result will expand any
	// Google groups appearing in an IAM policy binding.
	//
	// If [identity_selector][] is specified, the identity in the result will
	// be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandGroups bool `protobuf:"varint,1,opt,name=expand_groups,json=expandGroups,proto3" json:"expand_groups,omitempty"`
	// Optional. If true, the access section of result will expand any roles
	// appearing in IAM policy bindings to include their permissions.
	//
	// If [access_selector][] is specified, the access section of the result
	// will be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandRoles bool `protobuf:"varint,2,opt,name=expand_roles,json=expandRoles,proto3" json:"expand_roles,omitempty"`
	// Optional. If true, the resource section of the result will expand any
	// resource attached to an IAM policy to include resources lower in the
	// resource hierarchy.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and the results include an IAM policy with P on a GCP
	// folder, the results will also include resources in that folder with
	// permission P.
	//
	// If [resource_selector][] is specified, the resource section of the result
	// will be determined by the selector, and this flag will have no effect.
	// Default is false.
	ExpandResources bool `protobuf:"varint,3,opt,name=expand_resources,json=expandResources,proto3" json:"expand_resources,omitempty"`
	// Optional. If true, the result will output resource edges, starting
	// from the policy attached resource, to any expanded resources.
	// Default is false.
	OutputResourceEdges bool `protobuf:"varint,4,opt,name=output_resource_edges,json=outputResourceEdges,proto3" json:"output_resource_edges,omitempty"`
	// Optional. If true, the result will output group identity edges, starting
	// from the binding's group members, to any expanded identities.
	// Default is false.
	OutputGroupEdges bool `protobuf:"varint,5,opt,name=output_group_edges,json=outputGroupEdges,proto3" json:"output_group_edges,omitempty"`
	// Optional. If true, the response will include access analysis from identities to
	// resources via service account impersonation. This is a very expensive
	// operation, because many derived queries will be executed.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and there's an IAM policy states user A has
	// iam.serviceAccounts.getAccessToken permission to a service account SA,
	// and there's another IAM policy states service account SA has permission P
	// to a GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Another example, if the request analyzes for who has
	// permission P to a GCP folder F, and there's an IAM policy states user A
	// has iam.serviceAccounts.actAs permission to a service account SA, and
	// there's another IAM policy states service account SA has permission P to
	// the GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Default is false.
	AnalyzeServiceAccountImpersonation bool     `protobuf:"varint,6,opt,name=analyze_service_account_impersonation,json=analyzeServiceAccountImpersonation,proto3" json:"analyze_service_account_impersonation,omitempty"`
	XXX_NoUnkeyedLiteral               struct{} `json:"-"`
	XXX_unrecognized                   []byte   `json:"-"`
	XXX_sizecache                      int32    `json:"-"`
}

func (m *ExportIamPolicyAnalysisRequest_Options) Reset() {
	*m = ExportIamPolicyAnalysisRequest_Options{}
}
func (m *ExportIamPolicyAnalysisRequest_Options) String() string { return proto.CompactTextString(m) }
func (*ExportIamPolicyAnalysisRequest_Options) ProtoMessage()    {}
func (*ExportIamPolicyAnalysisRequest_Options) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{4, 0}
}

func (m *ExportIamPolicyAnalysisRequest_Options) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options.Unmarshal(m, b)
}
func (m *ExportIamPolicyAnalysisRequest_Options) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options.Marshal(b, m, deterministic)
}
func (m *ExportIamPolicyAnalysisRequest_Options) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options.Merge(m, src)
}
func (m *ExportIamPolicyAnalysisRequest_Options) XXX_Size() int {
	return xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options.Size(m)
}
func (m *ExportIamPolicyAnalysisRequest_Options) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options.DiscardUnknown(m)
}

var xxx_messageInfo_ExportIamPolicyAnalysisRequest_Options proto.InternalMessageInfo

func (m *ExportIamPolicyAnalysisRequest_Options) GetExpandGroups() bool {
	if m != nil {
		return m.ExpandGroups
	}
	return false
}

func (m *ExportIamPolicyAnalysisRequest_Options) GetExpandRoles() bool {
	if m != nil {
		return m.ExpandRoles
	}
	return false
}

func (m *ExportIamPolicyAnalysisRequest_Options) GetExpandResources() bool {
	if m != nil {
		return m.ExpandResources
	}
	return false
}

func (m *ExportIamPolicyAnalysisRequest_Options) GetOutputResourceEdges() bool {
	if m != nil {
		return m.OutputResourceEdges
	}
	return false
}

func (m *ExportIamPolicyAnalysisRequest_Options) GetOutputGroupEdges() bool {
	if m != nil {
		return m.OutputGroupEdges
	}
	return false
}

func (m *ExportIamPolicyAnalysisRequest_Options) GetAnalyzeServiceAccountImpersonation() bool {
	if m != nil {
		return m.AnalyzeServiceAccountImpersonation
	}
	return false
}

// The export IAM policy analysis response. This message is returned by the
// [google.longrunning.Operations.GetOperation][] method in the returned
// [google.longrunning.Operation.response][] field.
type ExportIamPolicyAnalysisResponse struct {
	// Output configuration indicating where the results were output to.
	OutputConfig         *IamPolicyAnalysisOutputConfig `protobuf:"bytes,1,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ExportIamPolicyAnalysisResponse) Reset()         { *m = ExportIamPolicyAnalysisResponse{} }
func (m *ExportIamPolicyAnalysisResponse) String() string { return proto.CompactTextString(m) }
func (*ExportIamPolicyAnalysisResponse) ProtoMessage()    {}
func (*ExportIamPolicyAnalysisResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d37c6d1bea9ee6a, []int{5}
}

func (m *ExportIamPolicyAnalysisResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportIamPolicyAnalysisResponse.Unmarshal(m, b)
}
func (m *ExportIamPolicyAnalysisResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportIamPolicyAnalysisResponse.Marshal(b, m, deterministic)
}
func (m *ExportIamPolicyAnalysisResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportIamPolicyAnalysisResponse.Merge(m, src)
}
func (m *ExportIamPolicyAnalysisResponse) XXX_Size() int {
	return xxx_messageInfo_ExportIamPolicyAnalysisResponse.Size(m)
}
func (m *ExportIamPolicyAnalysisResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportIamPolicyAnalysisResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportIamPolicyAnalysisResponse proto.InternalMessageInfo

func (m *ExportIamPolicyAnalysisResponse) GetOutputConfig() *IamPolicyAnalysisOutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

func init() {
	proto.RegisterType((*IamPolicyAnalysisQuery)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery")
	proto.RegisterType((*IamPolicyAnalysisQuery_ResourceSelector)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.ResourceSelector")
	proto.RegisterType((*IamPolicyAnalysisQuery_IdentitySelector)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.IdentitySelector")
	proto.RegisterType((*IamPolicyAnalysisQuery_AccessSelector)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.AccessSelector")
	proto.RegisterType((*AnalyzeIamPolicyRequest)(nil), "google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest")
	proto.RegisterType((*AnalyzeIamPolicyRequest_Options)(nil), "google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest.Options")
	proto.RegisterType((*AnalyzeIamPolicyResponse)(nil), "google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse")
	proto.RegisterType((*AnalyzeIamPolicyResponse_IamPolicyAnalysis)(nil), "google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.IamPolicyAnalysis")
	proto.RegisterType((*IamPolicyAnalysisOutputConfig)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig")
	proto.RegisterType((*IamPolicyAnalysisOutputConfig_GcsDestination)(nil), "google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination")
	proto.RegisterType((*ExportIamPolicyAnalysisRequest)(nil), "google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest")
	proto.RegisterType((*ExportIamPolicyAnalysisRequest_Options)(nil), "google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options")
	proto.RegisterType((*ExportIamPolicyAnalysisResponse)(nil), "google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisResponse")
}

func init() {
	proto.RegisterFile("google/cloud/asset/v1p4beta1/asset_service.proto", fileDescriptor_6d37c6d1bea9ee6a)
}

var fileDescriptor_6d37c6d1bea9ee6a = []byte{
	// 1202 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x57, 0x4d, 0x4f, 0x24, 0x45,
	0x18, 0xb6, 0x67, 0x60, 0x77, 0x2d, 0x98, 0x61, 0xa8, 0xcd, 0xba, 0x43, 0xbb, 0xbb, 0x90, 0xd9,
	0xb0, 0x22, 0x89, 0xdd, 0xc2, 0xb2, 0x6e, 0x84, 0x5d, 0xcd, 0x00, 0x13, 0x16, 0x8d, 0x82, 0x8d,
	0xe1, 0xa0, 0x24, 0x4d, 0xd1, 0x53, 0x34, 0x9d, 0x74, 0x57, 0x35, 0x55, 0xd5, 0x7c, 0xb8, 0xf1,
	0xa2, 0x3f, 0xc1, 0xab, 0x26, 0x9e, 0xfd, 0x05, 0x1e, 0xd5, 0x8b, 0x09, 0x07, 0x4d, 0xf4, 0x0f,
	0x78, 0xd0, 0x8b, 0xbf, 0x40, 0x6f, 0xa6, 0xab, 0xaa, 0x67, 0x7a, 0x06, 0x18, 0x77, 0x07, 0xe2,
	0xc9, 0x63, 0xbd, 0x1f, 0xcf, 0xfb, 0xd4, 0xf3, 0xbe, 0x5d, 0xd5, 0x05, 0x5e, 0xf7, 0x29, 0xf5,
	0x43, 0x6c, 0x7b, 0x21, 0x4d, 0x9a, 0x36, 0xe2, 0x1c, 0x0b, 0xfb, 0x60, 0x26, 0x9e, 0xdb, 0xc1,
	0x02, 0xcd, 0xa8, 0xb5, 0xcb, 0x31, 0x3b, 0x08, 0x3c, 0x6c, 0xc5, 0x8c, 0x0a, 0x0a, 0x6f, 0xa9,
	0x0c, 0x4b, 0x66, 0x58, 0x32, 0xc2, 0x6a, 0x65, 0x98, 0xda, 0x6b, 0xa3, 0x38, 0xb0, 0x11, 0x21,
	0x54, 0x20, 0x11, 0x50, 0xc2, 0x55, 0xae, 0x39, 0x9e, 0xf3, 0xee, 0x06, 0x38, 0x6c, 0xba, 0x3b,
	0x78, 0x0f, 0x1d, 0x04, 0x94, 0xe9, 0x80, 0x57, 0xff, 0x9d, 0x4e, 0x86, 0x65, 0xea, 0xd0, 0x00,
	0x45, 0xf6, 0xc1, 0x8c, 0x1d, 0xd3, 0x30, 0xf0, 0x8e, 0xb5, 0xef, 0xae, 0xf6, 0x85, 0x94, 0xf8,
	0x2c, 0x21, 0x24, 0x20, 0xbe, 0x4d, 0x63, 0xcc, 0x3a, 0xc8, 0xdc, 0xd1, 0x41, 0x72, 0xb5, 0x93,
	0xec, 0xda, 0xcd, 0x44, 0x05, 0x68, 0xff, 0xcd, 0x1c, 0x59, 0x2f, 0x0c, 0x30, 0x11, 0xca, 0x51,
	0xfb, 0x73, 0x00, 0xbc, 0xb4, 0x8a, 0xa2, 0x75, 0x59, 0xb1, 0x4e, 0x50, 0x78, 0xcc, 0x03, 0xfe,
	0x41, 0x82, 0xd9, 0x31, 0x7c, 0x19, 0x5c, 0x89, 0x11, 0xc3, 0x44, 0x54, 0x8d, 0x09, 0x63, 0xea,
	0xc5, 0xc5, 0xe2, 0x6f, 0xf5, 0x82, 0xa3, 0x4d, 0xf0, 0x10, 0x8c, 0x32, 0xcc, 0x69, 0xc2, 0x3c,
	0xec, 0x72, 0x1c, 0x62, 0x4f, 0x50, 0x56, 0x2d, 0x4c, 0x18, 0x53, 0x43, 0xb3, 0x0d, 0xab, 0x97,
	0xaa, 0xd6, 0xd9, 0xd5, 0x2c, 0x47, 0xa3, 0x6d, 0x68, 0xb0, 0xb4, 0x9c, 0xe1, 0x54, 0x58, 0x97,
	0x39, 0x2d, 0x1c, 0x34, 0x31, 0x11, 0x81, 0x38, 0x6e, 0x17, 0x2e, 0x5e, 0xa0, 0xf0, 0xaa, 0x46,
	0xeb, 0x2a, 0x1c, 0x74, 0x99, 0xe1, 0x3e, 0x18, 0x41, 0x9e, 0x87, 0x39, 0x6f, 0x97, 0x1d, 0x90,
	0x65, 0x97, 0xfa, 0x2a, 0x5b, 0x97, 0x58, 0x9d, 0x45, 0xcb, 0xa8, 0xc3, 0x68, 0x36, 0x40, 0xa5,
	0x5b, 0x16, 0x38, 0x03, 0xe0, 0x6e, 0x12, 0x86, 0x6e, 0x4b, 0x7d, 0x82, 0x22, 0x9c, 0xef, 0x50,
	0x25, 0x75, 0x67, 0x69, 0xef, 0xa3, 0x08, 0x9b, 0xf7, 0x41, 0xa5, 0x7b, 0x93, 0x70, 0x1c, 0x5c,
	0xcb, 0x76, 0x98, 0x4f, 0x6e, 0x19, 0x4d, 0x07, 0x94, 0x3b, 0x29, 0xc2, 0x31, 0x30, 0xc8, 0x68,
	0x88, 0x79, 0xd5, 0x98, 0x28, 0xaa, 0x78, 0xc3, 0x51, 0x16, 0x38, 0x09, 0x86, 0x62, 0xcc, 0xa2,
	0x80, 0xf3, 0x74, 0x26, 0xab, 0x85, 0x76, 0x40, 0xde, 0x5e, 0xfb, 0x6b, 0x00, 0xdc, 0x94, 0x2a,
	0x7c, 0x82, 0x5b, 0xaa, 0x38, 0x78, 0x3f, 0xc1, 0x5c, 0xc0, 0x6d, 0x50, 0x46, 0x5a, 0x20, 0x77,
	0x3f, 0x55, 0x48, 0xd2, 0x1a, 0x9a, 0x9d, 0xeb, 0x47, 0x5d, 0xb5, 0x99, 0x12, 0xea, 0x98, 0xe7,
	0x2d, 0x70, 0x95, 0xc6, 0x42, 0x13, 0x4c, 0xa1, 0x1f, 0xf7, 0x86, 0x3e, 0x87, 0xa9, 0xb5, 0xa6,
	0x40, 0xd4, 0xfe, 0x32, 0x48, 0xf3, 0xcb, 0x22, 0xb8, 0xaa, 0x3d, 0x70, 0x0a, 0x94, 0xf0, 0x51,
	0x8c, 0x48, 0xd3, 0xf5, 0x19, 0x4d, 0x62, 0x2e, 0xb7, 0x72, 0x4d, 0x25, 0x0c, 0x2b, 0xcf, 0x8a,
	0x74, 0xc0, 0x7b, 0x40, 0xaf, 0x5d, 0x25, 0x6d, 0xa1, 0x1d, 0x38, 0xa4, 0x1c, 0x8e, 0x14, 0xd8,
	0x02, 0x95, 0x2c, 0x4e, 0x77, 0x96, 0xcb, 0xa1, 0xd7, 0xb1, 0x23, 0x3a, 0x36, 0xf3, 0xc1, 0x87,
	0xe0, 0x06, 0x4d, 0x44, 0x9c, 0x88, 0xf6, 0x9c, 0xe0, 0xa6, 0x8f, 0xb9, 0x1c, 0x59, 0x9d, 0x74,
	0x5d, 0x45, 0x64, 0x49, 0x8d, 0xd4, 0x9f, 0x8e, 0x97, 0x4e, 0x94, 0xd4, 0x75, 0xd6, 0x60, 0x3b,
	0xab, 0xa2, 0xdc, 0x92, 0xbf, 0x4a, 0xd9, 0x04, 0x93, 0x48, 0x49, 0x95, 0x9d, 0xae, 0x2e, 0xf2,
	0x3c, 0x9a, 0x10, 0xe1, 0x06, 0x51, 0x8c, 0x19, 0xa7, 0x44, 0x1e, 0x45, 0xd5, 0x2b, 0x6d, 0x94,
	0x9a, 0xce, 0xd8, 0x50, 0x09, 0x75, 0x15, 0xbf, 0x9a, 0x0f, 0x87, 0xef, 0x82, 0x51, 0x7c, 0x84,
	0xbd, 0x24, 0x5d, 0xb8, 0x22, 0x88, 0x30, 0x4d, 0x44, 0xf5, 0xaa, 0xec, 0xdc, 0x58, 0xd6, 0xb9,
	0xec, 0xbc, 0xb3, 0x96, 0xf5, 0x79, 0xa7, 0x49, 0xb6, 0x12, 0x3f, 0x54, 0x79, 0xb5, 0xef, 0x07,
	0x41, 0xf5, 0x74, 0x43, 0x79, 0x4c, 0x09, 0xc7, 0x30, 0x02, 0xa5, 0x08, 0x05, 0xc4, 0xcd, 0xe6,
	0x45, 0x8f, 0xde, 0x93, 0xe7, 0x9d, 0x0f, 0x05, 0x77, 0x7a, 0x26, 0x9d, 0xe1, 0x14, 0x3e, 0x5b,
	0xc1, 0xaf, 0x0c, 0x70, 0xaf, 0xa7, 0x52, 0x6d, 0x22, 0xe9, 0x97, 0x74, 0x99, 0x44, 0xee, 0xf2,
	0xf3, 0x05, 0x6f, 0xf1, 0x9b, 0x04, 0xe5, 0xf4, 0x0c, 0x39, 0x76, 0xf1, 0x51, 0x1c, 0x52, 0x86,
	0x9b, 0x6a, 0xd4, 0x9c, 0x92, 0xb4, 0x36, 0xb4, 0x11, 0x72, 0x70, 0x9d, 0x50, 0xe2, 0x7a, 0x2c,
	0x10, 0x81, 0x87, 0x42, 0x17, 0x33, 0x46, 0x59, 0x3a, 0x61, 0xc5, 0x3e, 0x0e, 0x45, 0x07, 0xf3,
	0x24, 0x14, 0x56, 0xb6, 0xdc, 0x10, 0x48, 0x60, 0x67, 0x94, 0x50, 0xb2, 0xa4, 0xe1, 0x1b, 0x12,
	0xdd, 0xfc, 0xdb, 0x00, 0xa3, 0xa7, 0x92, 0xe1, 0xc7, 0x97, 0x79, 0x78, 0x74, 0x9f, 0x1b, 0xdb,
	0xa0, 0xd2, 0x02, 0x67, 0x92, 0x66, 0xd6, 0x97, 0x07, 0x7d, 0x6d, 0xd2, 0x19, 0x41, 0x1d, 0xeb,
	0x67, 0x15, 0xbc, 0xf6, 0x93, 0x01, 0x6e, 0x9f, 0xc2, 0x5c, 0x93, 0x9f, 0xe3, 0x12, 0x25, 0xbb,
	0x81, 0x0f, 0x13, 0x30, 0xe2, 0x7b, 0xdc, 0x6d, 0x62, 0x2e, 0x02, 0xfd, 0xd1, 0x29, 0x21, 0xde,
	0x79, 0x4e, 0xa6, 0x79, 0x54, 0x6b, 0xc5, 0xe3, 0xcb, 0x6d, 0xc4, 0x27, 0x2f, 0x38, 0x65, 0xbf,
	0xc3, 0x62, 0xbe, 0x02, 0xca, 0x9d, 0x31, 0xf0, 0x06, 0x28, 0x26, 0x2c, 0xc8, 0xdf, 0x2c, 0xe9,
	0x7a, 0xb1, 0x04, 0x86, 0x72, 0xdc, 0x6a, 0x5f, 0x0f, 0x82, 0x3b, 0x8d, 0xa3, 0x98, 0x32, 0x71,
	0x86, 0x54, 0xff, 0xd5, 0xb5, 0xe0, 0x75, 0x5f, 0x0b, 0xcb, 0xbd, 0xa1, 0x7b, 0x13, 0x3e, 0xfb,
	0x76, 0x80, 0x18, 0x94, 0xf4, 0xb1, 0xea, 0x49, 0x4d, 0xf5, 0x1f, 0xcb, 0xc2, 0x05, 0xda, 0xa2,
	0x36, 0x33, 0x4c, 0x73, 0x26, 0xf3, 0xe7, 0xc2, 0xff, 0x97, 0xd0, 0xa5, 0x5e, 0x42, 0xb5, 0xcf,
	0x0d, 0x30, 0x7e, 0x6e, 0xc7, 0xf5, 0xf5, 0xb1, 0xdd, 0xdd, 0x5c, 0xe3, 0xc2, 0xcd, 0xed, 0xec,
	0xeb, 0xec, 0x1f, 0x03, 0x60, 0xb8, 0x9e, 0xe6, 0x6b, 0xaa, 0xf0, 0x07, 0x03, 0x54, 0xba, 0x8f,
	0x7d, 0xf8, 0xa0, 0xaf, 0xff, 0x19, 0xf3, 0x8d, 0xfe, 0x6e, 0x97, 0xda, 0xdb, 0x9f, 0xfd, 0xfa,
	0xfb, 0x17, 0x85, 0x37, 0xe1, 0xc3, 0xdc, 0xab, 0xe6, 0x69, 0xe7, 0xc7, 0x6a, 0xa9, 0xd7, 0xc2,
	0xe3, 0x69, 0x7b, 0xfa, 0xd3, 0x79, 0xd4, 0xcd, 0xf7, 0xbb, 0x02, 0xb8, 0x79, 0x8e, 0xb6, 0xf0,
	0xd1, 0x45, 0x3e, 0x42, 0xf3, 0x76, 0x96, 0x9d, 0x7b, 0x34, 0x59, 0x6b, 0xd9, 0xa3, 0xa9, 0xf6,
	0xa3, 0x71, 0x52, 0x7f, 0x0a, 0x1e, 0xf5, 0x57, 0x41, 0x37, 0x7d, 0xe1, 0x02, 0xfc, 0xa4, 0x70,
	0x4b, 0xb5, 0xb7, 0x9e, 0x51, 0x38, 0x7c, 0x36, 0xd8, 0xbc, 0x31, 0x6d, 0xbe, 0x77, 0x52, 0x1f,
	0x93, 0x0c, 0x14, 0x01, 0xc5, 0x09, 0xc5, 0x01, 0xb7, 0x3c, 0x1a, 0xfd, 0x52, 0xb7, 0xf6, 0x84,
	0x88, 0xf9, 0xbc, 0x6d, 0x1f, 0x1e, 0x1e, 0x76, 0x39, 0x6d, 0x94, 0x88, 0x3d, 0xf5, 0x36, 0x7d,
	0x2d, 0x0e, 0x91, 0xd8, 0xa5, 0x2c, 0x5a, 0xfc, 0xd6, 0x00, 0x13, 0x1e, 0x8d, 0x7a, 0x6a, 0xbf,
	0x38, 0x9a, 0x9f, 0xc4, 0xf5, 0xf4, 0x07, 0x6c, 0xdd, 0xf8, 0xa8, 0xae, 0x53, 0x7c, 0x1a, 0x22,
	0xe2, 0x5b, 0x94, 0xf9, 0xb6, 0x8f, 0x89, 0xfc, 0x3d, 0xb3, 0xdb, 0x85, 0xcf, 0x7e, 0x0b, 0x2f,
	0xc8, 0xf5, 0x37, 0x85, 0x5b, 0x2b, 0x0a, 0x63, 0x49, 0x96, 0x95, 0x55, 0xac, 0xcd, 0x99, 0xf5,
	0xb9, 0xc5, 0x34, 0xe8, 0x24, 0x73, 0x6f, 0x49, 0xf7, 0x96, 0x74, 0x6f, 0x6d, 0x66, 0x18, 0x3b,
	0x57, 0x64, 0xad, 0xfb, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0x84, 0xd6, 0xf8, 0x39, 0x05, 0x10,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Analyzes IAM policies based on the specified request. Returns
	// a list of [IamPolicyAnalysisResult][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult] matching the request.
	AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error)
	// Exports IAM policy analysis based on the specified request. This API
	// implements the [google.longrunning.Operation][google.longrunning.Operation] API allowing you to keep
	// track of the export. The metadata contains the request to help callers to
	// map responses to requests.
	ExportIamPolicyAnalysis(ctx context.Context, in *ExportIamPolicyAnalysisRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error) {
	out := new(AnalyzeIamPolicyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p4beta1.AssetService/AnalyzeIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ExportIamPolicyAnalysis(ctx context.Context, in *ExportIamPolicyAnalysisRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p4beta1.AssetService/ExportIamPolicyAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Analyzes IAM policies based on the specified request. Returns
	// a list of [IamPolicyAnalysisResult][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult] matching the request.
	AnalyzeIamPolicy(context.Context, *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error)
	// Exports IAM policy analysis based on the specified request. This API
	// implements the [google.longrunning.Operation][google.longrunning.Operation] API allowing you to keep
	// track of the export. The metadata contains the request to help callers to
	// map responses to requests.
	ExportIamPolicyAnalysis(context.Context, *ExportIamPolicyAnalysisRequest) (*longrunning.Operation, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) AnalyzeIamPolicy(ctx context.Context, req *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeIamPolicy not implemented")
}
func (*UnimplementedAssetServiceServer) ExportIamPolicyAnalysis(ctx context.Context, req *ExportIamPolicyAnalysisRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportIamPolicyAnalysis not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_AnalyzeIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p4beta1.AssetService/AnalyzeIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, req.(*AnalyzeIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ExportIamPolicyAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportIamPolicyAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ExportIamPolicyAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p4beta1.AssetService/ExportIamPolicyAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ExportIamPolicyAnalysis(ctx, req.(*ExportIamPolicyAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1p4beta1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnalyzeIamPolicy",
			Handler:    _AssetService_AnalyzeIamPolicy_Handler,
		},
		{
			MethodName: "ExportIamPolicyAnalysis",
			Handler:    _AssetService_ExportIamPolicyAnalysis_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1p4beta1/asset_service.proto",
}
