/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/core/v1"
	corev1 "k8s.io/client-go/applyconfigurations/core/v1"
	gentype "k8s.io/client-go/gentype"
	typedcorev1 "k8s.io/client-go/kubernetes/typed/core/v1"
)

// fakePodTemplates implements PodTemplateInterface
type fakePodTemplates struct {
	*gentype.FakeClientWithListAndApply[*v1.PodTemplate, *v1.PodTemplateList, *corev1.PodTemplateApplyConfiguration]
	Fake *FakeCoreV1
}

func newFakePodTemplates(fake *FakeCoreV1, namespace string) typedcorev1.PodTemplateInterface {
	return &fakePodTemplates{
		gentype.NewFakeClientWithListAndApply[*v1.PodTemplate, *v1.PodTemplateList, *corev1.PodTemplateApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("podtemplates"),
			v1.SchemeGroupVersion.WithKind("PodTemplate"),
			func() *v1.PodTemplate { return &v1.PodTemplate{} },
			func() *v1.PodTemplateList { return &v1.PodTemplateList{} },
			func(dst, src *v1.PodTemplateList) { dst.ListMeta = src.ListMeta },
			func(list *v1.PodTemplateList) []*v1.PodTemplate { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.PodTemplateList, items []*v1.PodTemplate) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
