struct SuperGrafxCartridge {
  SuperGrafxCartridge(string location, uint8_t* data, uint size);

  string manifest;

//private:
  struct Information {
  } information;
};

SuperGrafxCartridge::SuperGrafxCartridge(string location, uint8_t* data, uint size) {
  manifest.append("board\n");
  manifest.append("  rom name=program.rom size=0x", hex(size), "\n");
  manifest.append("\n");
  manifest.append("information\n");
  manifest.append("  title:  ", Location::prefix(location), "\n");
  manifest.append("  sha256: ", Hash::SHA256(data, size).digest(), "\n");
  manifest.append("\n");
  manifest.append("note: heuristically generated by icarus\n");
}
