/* { dg-options "-mlasx -w -fno-strict-aliasing" } */
#include "../simd_correctness_check.h"
#include <lasxintrin.h>

int
main ()
{
  __m256i __m256i_op0, __m256i_op1, __m256i_op2, __m256i_out, __m256i_result;
  __m256 __m256_op0, __m256_op1, __m256_op2, __m256_out, __m256_result;
  __m256d __m256d_op0, __m256d_op1, __m256d_op2, __m256d_out, __m256d_result;

  int int_op0, int_op1, int_op2, int_out, int_result, i = 1, fail;
  long int long_op0, long_op1, long_op2, lont_out, lont_result;
  long int long_int_out, long_int_result;
  unsigned int unsigned_int_out, unsigned_int_result;
  unsigned long int unsigned_long_int_out, unsigned_long_int_result;

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0101000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0101000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000200000002;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000008000000080;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000200000002;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000008000000080;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000200000002;
  *((unsigned long *)&__m256i_result[2]) = 0x0101008000000080;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000200000002;
  *((unsigned long *)&__m256i_result[0]) = 0x0101008000000080;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffff000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffff000000;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffff000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffff000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000401000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000401000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000401000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000401000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000402000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000402000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000402000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000402000000;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffffffffffeffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000101;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000100010102;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000102;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000102;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xefefefefefefefef;
  *((unsigned long *)&__m256i_op0[2]) = 0xefefefefefefefef;
  *((unsigned long *)&__m256i_op0[1]) = 0xefefefefefefef6e;
  *((unsigned long *)&__m256i_op0[0]) = 0xeeeeeeeeeeeeeeee;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x1010101010101012;
  *((unsigned long *)&__m256i_result[2]) = 0x1010101010101012;
  *((unsigned long *)&__m256i_result[1]) = 0x1010101010101093;
  *((unsigned long *)&__m256i_result[0]) = 0x1111111111111113;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000080;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000080;
  *((unsigned long *)&__m256i_op1[3]) = 0xfff0000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xfff0000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0xfff0000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xfff0000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0110000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0110000000000080;
  *((unsigned long *)&__m256i_result[1]) = 0x0110000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0110000000000080;
  __m256i_out = __lasx_xvadda_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xf000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xf000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0xf000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xf000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x1000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x1000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x1000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x1000000000000000;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x1fe01e0000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x1fe01e0000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x1fe01e0000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x1fe01e0000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xce7ffffffffffffe;
  *((unsigned long *)&__m256i_op1[2]) = 0x6300000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0xce7ffffffffffffe;
  *((unsigned long *)&__m256i_op1[0]) = 0x6300000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x327f010101010102;
  *((unsigned long *)&__m256i_result[2]) = 0x6300000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x327f010101010102;
  *((unsigned long *)&__m256i_result[0]) = 0x6300000000000000;
  __m256i_out = __lasx_xvadda_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffff5556aaaa;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffff5556aaaa;
  *((unsigned long *)&__m256i_op1[3]) = 0x0006ffff0004ffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x0002000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0006ffff0004ffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x0002000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0006ffff0004ffff;
  *((unsigned long *)&__m256i_result[2]) = 0x00020000aaa95556;
  *((unsigned long *)&__m256i_result[1]) = 0x0006ffff0004ffff;
  *((unsigned long *)&__m256i_result[0]) = 0x00020000aaa95556;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0006000000040000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0006000000040000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0006000000040000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0006000000040000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_result[2]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_result[1]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_result[0]) = 0x0001000100010001;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0xdb801b6d0962003f;
  *((unsigned long *)&__m256i_op1[2]) = 0xdb8a3109fe0f0024;
  *((unsigned long *)&__m256i_op1[1]) = 0x9a7f997fff01ffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xbe632a4f1c3c5653;
  *((unsigned long *)&__m256i_result[3]) = 0x247fe49409620040;
  *((unsigned long *)&__m256i_result[2]) = 0x2475cef801f0ffdd;
  *((unsigned long *)&__m256i_result[1]) = 0x6580668200fe0002;
  *((unsigned long *)&__m256i_result[0]) = 0x419cd5b11c3c5654;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x017e01fe01fe01fe;
  *((unsigned long *)&__m256i_op0[2]) = 0x0586060601fe0202;
  *((unsigned long *)&__m256i_op0[1]) = 0x017e01fe01fe0000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0586060601fe0004;
  *((unsigned long *)&__m256i_op1[3]) = 0x0001000000010000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0010001000100001;
  *((unsigned long *)&__m256i_op1[1]) = 0x0001000000010000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0010001000100001;
  *((unsigned long *)&__m256i_result[3]) = 0x017f01fe01ff01fe;
  *((unsigned long *)&__m256i_result[2]) = 0x05960616020e0203;
  *((unsigned long *)&__m256i_result[1]) = 0x017f01fe01ff0000;
  *((unsigned long *)&__m256i_result[0]) = 0x05960616020e0005;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000045;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000000d0005;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000045;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000000d0005;
  *((unsigned long *)&__m256i_op1[3]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_op1[2]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_op1[1]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_op1[0]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_result[3]) = 0x0101010101010146;
  *((unsigned long *)&__m256i_result[2]) = 0x01010101010e0106;
  *((unsigned long *)&__m256i_result[1]) = 0x0101010101010146;
  *((unsigned long *)&__m256i_result[0]) = 0x01010101010e0106;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0010000000100000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0010000000100000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0010000000100000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0010000000100000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0010000000100000;
  *((unsigned long *)&__m256i_result[2]) = 0x0010000000100000;
  *((unsigned long *)&__m256i_result[1]) = 0x0010000000100000;
  *((unsigned long *)&__m256i_result[0]) = 0x0010000000100000;
  __m256i_out = __lasx_xvadda_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xfffffffffb79fb74;
  *((unsigned long *)&__m256i_op1[2]) = 0xfffffffffffffffa;
  *((unsigned long *)&__m256i_op1[1]) = 0xfffffffffb79fb74;
  *((unsigned long *)&__m256i_op1[0]) = 0xfffffffffffffffa;
  *((unsigned long *)&__m256i_result[3]) = 0x000000010486048c;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000100000006;
  *((unsigned long *)&__m256i_result[1]) = 0x000000010486048c;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000100000006;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000010000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000010000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000020000;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000004411;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000004411;
  *((unsigned long *)&__m256i_op1[3]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op1[2]) = 0x00ff00ff000c0000;
  *((unsigned long *)&__m256i_op1[1]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op1[0]) = 0x00ff00ff00040000;
  *((unsigned long *)&__m256i_result[3]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_result[2]) = 0x00010001000c4411;
  *((unsigned long *)&__m256i_result[1]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_result[0]) = 0x0001000100044411;
  __m256i_out = __lasx_xvadda_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000002000000018;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000002000000019;
  *((unsigned long *)&__m256i_op0[1]) = 0x000000200000001e;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000002000000019;
  *((unsigned long *)&__m256i_op1[3]) = 0x223d76f09f3881ff;
  *((unsigned long *)&__m256i_op1[2]) = 0x3870ca8d013e76a0;
  *((unsigned long *)&__m256i_op1[1]) = 0x223d76f09f37e357;
  *((unsigned long *)&__m256i_op1[0]) = 0x43ec0a1b2aba7ed0;
  *((unsigned long *)&__m256i_result[3]) = 0x223d771060c77e19;
  *((unsigned long *)&__m256i_result[2]) = 0x3870caad013e76b9;
  *((unsigned long *)&__m256i_result[1]) = 0x223d771060c81cc7;
  *((unsigned long *)&__m256i_result[0]) = 0x43ec0a3b2aba7ee9;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xdbcbdbcbecececec;
  *((unsigned long *)&__m256i_op0[2]) = 0xdbcbdbcb0000dbcb;
  *((unsigned long *)&__m256i_op0[1]) = 0xdbcbdbcbecececec;
  *((unsigned long *)&__m256i_op0[0]) = 0xdbcbdbcb0000dbcb;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x2535253514141414;
  *((unsigned long *)&__m256i_result[2]) = 0x2535253500002535;
  *((unsigned long *)&__m256i_result[1]) = 0x2535253514141414;
  *((unsigned long *)&__m256i_result[0]) = 0x2535253500002535;
  __m256i_out = __lasx_xvadda_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0020000f0000000f;
  *((unsigned long *)&__m256i_op0[2]) = 0x0010000f0000000f;
  *((unsigned long *)&__m256i_op0[1]) = 0x0020000f0000000f;
  *((unsigned long *)&__m256i_op0[0]) = 0x0010000f0000000f;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0020000f0000000f;
  *((unsigned long *)&__m256i_result[2]) = 0x0010000f0000000f;
  *((unsigned long *)&__m256i_result[1]) = 0x0020000f0000000f;
  *((unsigned long *)&__m256i_result[0]) = 0x0010000f0000000f;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000504f00002361;
  *((unsigned long *)&__m256i_op0[2]) = 0xffff8f81000040e4;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000504f00002361;
  *((unsigned long *)&__m256i_op0[0]) = 0xffff8f81000040e4;
  *((unsigned long *)&__m256i_op1[3]) = 0x000007ff000007ff;
  *((unsigned long *)&__m256i_op1[2]) = 0x000007ff00000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x000007ff000007ff;
  *((unsigned long *)&__m256i_op1[0]) = 0x000007ff00000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000584e00002b60;
  *((unsigned long *)&__m256i_result[2]) = 0x0000787dffffbf1c;
  *((unsigned long *)&__m256i_result[1]) = 0x0000584e00002b60;
  *((unsigned long *)&__m256i_result[0]) = 0x0000787dffffbf1c;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xfffffffe00000000;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xfffffffe00000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_result[2]) = 0x0101010200000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_result[0]) = 0x0101010200000000;
  __m256i_out = __lasx_xvadda_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x7fefffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x7fefffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x7fefffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x7fefffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_op1[2]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_op1[1]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_op1[0]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_result[3]) = 0x7fef010000010100;
  *((unsigned long *)&__m256i_result[2]) = 0x7fef010000010100;
  *((unsigned long *)&__m256i_result[1]) = 0x7fef010000010100;
  *((unsigned long *)&__m256i_result[0]) = 0x7fef010000010100;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000000000ff;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000000000ff;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000000001fe;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x40b2bf4d30313031;
  *((unsigned long *)&__m256i_op0[2]) = 0x7fff7fffa2bea2be;
  *((unsigned long *)&__m256i_op0[1]) = 0x40b2bf4d30313031;
  *((unsigned long *)&__m256i_op0[0]) = 0x7fff7fffa2bea2be;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x40b240b330313031;
  *((unsigned long *)&__m256i_result[2]) = 0x7fff7fff5d425d42;
  *((unsigned long *)&__m256i_result[1]) = 0x40b240b330313031;
  *((unsigned long *)&__m256i_result[0]) = 0x7fff7fff5d425d42;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000001;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000100040;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000100040;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000100040;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000100040;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000100040;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000100040;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000080;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000100080;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000080;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000100080;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xff896099cbdbfff1;
  *((unsigned long *)&__m256i_op0[2]) = 0xc987ffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xff896099cbdbfff1;
  *((unsigned long *)&__m256i_op0[0]) = 0xc987ffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x00769f673424000f;
  *((unsigned long *)&__m256i_result[2]) = 0x3678000100000001;
  *((unsigned long *)&__m256i_result[1]) = 0x00769f673424000f;
  *((unsigned long *)&__m256i_result[0]) = 0x3678000100000001;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_result[2]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_result[1]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_result[0]) = 0x0001000100010001;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x8000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x8000000000000000;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000001;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvadda_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000005ffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000007ffffffce;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000005ffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000007ffffffce;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000500000001;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000700000032;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000500000001;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000700000032;
  __m256i_out = __lasx_xvadda_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000400000004000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000400000004000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000400000004000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000400000004000;
  *((unsigned long *)&__m256i_op1[3]) = 0x00003feec0108022;
  *((unsigned long *)&__m256i_op1[2]) = 0x00003fe9c015802c;
  *((unsigned long *)&__m256i_op1[1]) = 0x00003feec0108022;
  *((unsigned long *)&__m256i_op1[0]) = 0x00003fe9c015802c;
  *((unsigned long *)&__m256i_result[3]) = 0x00007f124010c022;
  *((unsigned long *)&__m256i_result[2]) = 0x00007f174015c02c;
  *((unsigned long *)&__m256i_result[1]) = 0x00007f124010c022;
  *((unsigned long *)&__m256i_result[0]) = 0x00007f174015c02c;
  __m256i_out = __lasx_xvadda_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op0[2]) = 0xfa15fa15fa15fa14;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op0[0]) = 0xfa15fa15fa15fa14;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[2]) = 0x05ea05ea05ea05ec;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[0]) = 0x05ea05ea05ea05ec;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000010101010101;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000010101010101;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000010101010101;
  *((unsigned long *)&__m256i_op1[2]) = 0x0101000000010000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000010101010101;
  *((unsigned long *)&__m256i_op1[0]) = 0x0101000000010000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000020202020202;
  *((unsigned long *)&__m256i_result[2]) = 0x0101000000010000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000020202020202;
  *((unsigned long *)&__m256i_result[0]) = 0x0101000000010000;
  __m256i_out = __lasx_xvadda_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  return 0;
}
