/*
 * unity-webapps-package-mechanism.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <glib.h>
#include <gio/gio.h>

#include "unity-webapps-package-mechanism.h"

#include "../unity-webapps-debug.h"

struct _UnityWebappsPackageMechanismPrivate {
  gpointer fill;
};


G_DEFINE_ABSTRACT_TYPE(UnityWebappsPackageMechanism, unity_webapps_package_mechanism, G_TYPE_OBJECT)

#define UNITY_WEBAPPS_PACKAGE_MECHANISM_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE ((object), UNITY_WEBAPPS_TYPE_PACKAGE_MECHANISM, UnityWebappsPackageMechanismPrivate))

static void
unity_webapps_package_mechanism_class_init (UnityWebappsPackageMechanismClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  
  g_type_class_add_private (object_class, sizeof(UnityWebappsPackageMechanismPrivate));
}

static void
unity_webapps_package_mechanism_init (UnityWebappsPackageMechanism *mechanism)
{
  mechanism->priv = UNITY_WEBAPPS_PACKAGE_MECHANISM_GET_PRIVATE (mechanism);
}

gboolean
unity_webapps_package_mechanism_get_package_status (UnityWebappsPackageMechanism *mechanism,
						    const gchar *name,
						    UnityWebappsPackageMechanismStatusCallback callback,
						    gpointer user_data)
{
  return UNITY_WEBAPPS_PACKAGE_MECHANISM_GET_CLASS (mechanism)->get_package_status (mechanism, name, callback, user_data);
}

gboolean
unity_webapps_package_mechanism_install_package (UnityWebappsPackageMechanism *mechanism,
						 const gchar *name,
						 UnityWebappsPackageMechanismStatusCallback callback,
						 gpointer user_data)
{
  return UNITY_WEBAPPS_PACKAGE_MECHANISM_GET_CLASS (mechanism)->install_package (mechanism, name, callback, user_data);
}
