// Tags: JDK1.2
// Uses: MyMetalScrollBarUI

// Copyright (C) 2005 David Gilbert <david.gilbert@object-refinery.com>

// This file is part of Mauve.

// Mauve is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// Mauve is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with Mauve; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.  */

package gnu.testlet.javax.swing.plaf.metal.MetalScrollBarUI;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

import java.awt.Dimension;

import javax.swing.JScrollBar;
import javax.swing.plaf.metal.MetalScrollBarUI;

/**
 * Some checks for the getMinimumThumbSize() method in the 
 * {@link MetalScrollBarUI} class.  
 */
public class getMinimumThumbSize implements Testlet 
{

  /**
   * Runs the test using the specified harness.
   * 
   * @param harness  the test harness (<code>null</code> not permitted).
   */
  public void test(TestHarness harness)  
  {
    MyMetalScrollBarUI ui = new MyMetalScrollBarUI();
    harness.check(ui.getMinimumThumbSize(), new Dimension(0, 0));
    JScrollBar sb = new JScrollBar(JScrollBar.HORIZONTAL);
    sb.setUI(ui);
    sb.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
    harness.check(ui.getMinimumThumbSize(), new Dimension(15, 15));
    sb.putClientProperty("JScrollBar.isFreeStanding", Boolean.TRUE);
    harness.check(ui.getMinimumThumbSize(), new Dimension(17, 17));
  }

}
