#if CODE_ANALYSIS_BASELINE
using System.Diagnostics.CodeAnalysis;
#endif

//////////////////////////////////////////////////////////////////////////////
// Date: June 4, 2009
// Description: Temporarily suppress System.dll v4 violations
// User: REDMOND\[....]
//////////////////////////////////////////////////////////////////////////////
#if CODE_ANALYSIS_BASELINE

//
// System.CodeDom
//
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Goto", Scope="type", Target="System.CodeDom.CodeGotoStatement", Justification="Goto is spelled correctly.")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Goto", Scope="member", Target="System.CodeDom.Compiler.CodeGenerator.#GenerateGotoStatement(System.CodeDom.CodeGotoStatement)", Justification="Goto is spelled correctly.")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Goto", Scope="member", Target="System.CodeDom.Compiler.GeneratorSupport.#GotoStatements", Justification="Goto is spelled correctly.")]

//
// System.Collections.Concurrent
//
[module: SuppressMessage("Microsoft.Naming","CA1710:IdentifiersShouldHaveCorrectSuffix", Scope="type", Target="System.Collections.Concurrent.ConcurrentBag`1", Justification="We do not want to rename this class at this point.")]
[module: SuppressMessage("Microsoft.Security","CA2123:OverrideLinkDemandsShouldBeIdenticalToBase", Scope="member", Target="System.Collections.Concurrent.ConcurrentBag`1.#System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo,System.Runtime.Serialization.StreamingContext)", Justification="From [....]: leave the attribute in place and suppress the FxCop warning until we can get the rule updated to understand that this is valid")]
[module: SuppressMessage("Microsoft.Naming","CA1710:IdentifiersShouldHaveCorrectSuffix", Scope="type", Target="System.Collections.Generic.ISet`1", Justification="PFX: Not fixing this, not even sure that we own this.")]
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="System.Collections.Concurrent.BlockingCollection`1.#Dispose()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA2208:InstantiateArgumentExceptionsCorrectly", Scope="member", Target="System.Collections.Concurrent.BlockingCollection`1.#ValidateCollectionsArray(System.Collections.Concurrent.BlockingCollection`1<!0>[],System.Collections.Concurrent.BlockingCollection`1<!0>+OperationMode)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1710:IdentifiersShouldHaveCorrectSuffix", Scope="type", Target="System.Collections.Concurrent.ConcurrentBag`1", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA2235:MarkAllNonSerializableFields", Scope="member", Target="System.Collections.Concurrent.ConcurrentBag`1+ThreadLocalList.#m_ownerThread", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1710:IdentifiersShouldHaveCorrectSuffix", Scope="type", Target="System.Collections.Generic.ISet`1", Justification="batch baselining v4 violations")]

//
// System.ComponentModel
//
[module: SuppressMessage("Microsoft.Performance","CA1819:PropertiesShouldNotReturnArrays", Scope="member", Target="System.ComponentModel.AttributeCollection.#Attributes", Justification="tracked by Dev10 723291")]

//
// System.Net
//
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="type", Target="System.Net.BindIPEndPoint", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Reliability","CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope="member", Target="System.Net.Connection.#CompleteStartConnection(System.Boolean,System.Net.HttpWebRequest)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.CookieContainer.#Dump()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Security","CA2106:SecureAsserts", Scope="member", Target="System.Net.DebugCriticalHandleMinusOneIsInvalid.#Trace()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.DebugCriticalHandleZeroOrMinusOneIsInvalid.#Trace()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Security","CA2106:SecureAsserts", Scope="member", Target="System.Net.DebugSafeHandle.#Trace()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Security","CA2106:SecureAsserts", Scope="member", Target="System.Net.DebugSafeHandleMinusOneIsInvalid.#Trace()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="type", Target="System.Net.EndPoint", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="System.Net.GlobalLog+ThreadKindFrame.#System.IDisposable.Dispose()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Reliability","CA2001:AvoidCallingProblematicMethods", MessageId="System.Runtime.InteropServices.SafeHandle.DangerousGetHandle", Scope="member", Target="System.Net.HttpDigest.#formatChannelBindingForHash(System.Security.Authentication.ExtendedProtection.ChannelBinding)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Cryptographic.Standard","CA5350:MD5CannotBeUsed", Scope="member", Target="System.Net.HttpDigestChallenge.#.ctor()", Justification="MD5 is required for Digest authentication")]
[module: SuppressMessage("Microsoft.Cryptographic.Standard","CA5350:MD5CannotBeUsed", Scope="member", Target="System.Net.HttpDigestChallenge.#CopyAndIncrementNonce()", Justification="MD5 is required for Digest authentication")]
[module: SuppressMessage("Microsoft.Usage","CA2208:InstantiateArgumentExceptionsCorrectly", Scope="member", Target="System.Net.HttpListener.#set_ExtendedProtectionPolicy(System.Security.Authentication.ExtendedProtection.ExtendedProtectionPolicy)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA2208:InstantiateArgumentExceptionsCorrectly", Scope="member", Target="System.Net.HttpListener.#set_ExtendedProtectionSelectorDelegate(System.Net.HttpListener+ExtendedProtectionSelector)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Reliability","CA2001:AvoidCallingProblematicMethods", MessageId="System.Runtime.InteropServices.SafeHandle.DangerousGetHandle", Scope="member", Target="System.Net.HttpListener.#GetChannelBindingFromTls(System.UInt64)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Globalization","CA1305:SpecifyIFormatProvider", MessageId="System.UInt64.ToString", Scope="member", Target="System.Net.HttpListener.#GetChannelBindingFromTls(System.UInt64)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Design","CA1034:NestedTypesShouldNotBeVisible", Scope="type", Target="System.Net.HttpListener+ExtendedProtectionSelector", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="member", Target="System.Net.HttpListenerRequest.#LocalEndPoint", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="member", Target="System.Net.HttpListenerRequest.#RemoteEndPoint", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Reliability","CA2002:DoNotLockOnObjectsWithWeakIdentity", Scope="member", Target="System.Net.HttpWebRequest.#GetRequestStream(System.Net.TransportContext&)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.IPAddress.#IPv6Any", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.IPAddress.#IPv6Loopback", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.IPAddress.#IPv6None", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.IPAddress.#IsIPv6LinkLocal", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.IPAddress.#IsIPv6Multicast", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.IPAddress.#IsIPv6SiteLocal", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="type", Target="System.Net.IPEndPoint", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="System.Net.ListenerPrefixEnumerator.#Dispose()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="System.Net.NetworkAddressChangePolled.#Dispose()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Security","CA2106:SecureAsserts", Scope="member", Target="System.Net.NTAuthentication.#.ctor(System.Boolean,System.String,System.String,System.Net.ContextFlags,System.Security.Authentication.ExtendedProtection.ChannelBinding)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.PathList.#Dump()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="System.Net.ProxyChain.#Dispose()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="System.Net.ProxyChain+ProxyEnumerator.#Dispose()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.SafeDeleteContext.#DangerousGetHandle()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.SafeFreeCredentials.#DangerousGetHandle()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.SafeUnlockUrlCacheEntryFile.#DangerousGetHandle()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Globalization","CA1309:UseOrdinalStringComparison", MessageId="System.String.Compare(System.String,System.String,System.StringComparison)", Scope="member", Target="System.Net.ServiceNameStore.#Contains(System.String)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="member", Target="System.Net.ServicePoint.#BindIPEndPointDelegate", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="System.Net.TimerThread+Timer.#Dispose()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Globalization","CA1305:SpecifyIFormatProvider", MessageId="System.Int32.ToString", Scope="member", Target="System.Net.TimerThread+TimerNode.#Fire()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Globalization","CA1305:SpecifyIFormatProvider", MessageId="System.Int32.ToString", Scope="member", Target="System.Net.TimerThread+TimerQueue.#CreateTimer(System.Net.TimerThread+Callback,System.Object)", Justification="batch baselining post-3.5 SP1 violations")]
[module: SuppressMessage("Microsoft.Security","CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope="member", Target="System.Net.UnsafeNclNativeMethods.#ReleaseSemaphore(System.IntPtr,System.Int32,System.Int32&)", Justification="batch baselining post-3.5 SP1 violations")]
[module: SuppressMessage("Microsoft.Security","CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope="member", Target="System.Net.UnsafeNclNativeMethods.#CancelIoEx(System.Runtime.InteropServices.CriticalHandle,System.Threading.NativeOverlapped*)", Justification="Native code is required here")]
[module: SuppressMessage("Microsoft.Security","CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope="member", Target="System.Net.UnsafeNclNativeMethods+HttpApi.#HttpReceiveClientCertificate(System.Net.SafeCloseHandle,System.UInt64,System.UInt32,System.Byte*,System.UInt32,System.UInt32*,System.Threading.NativeOverlapped*)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Security","CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope="member", Target="System.Net.UnsafeNclNativeMethods+SafeNetHandles.#LocalAllocChannelBinding(System.Int32,System.UIntPtr)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Security","CA2118:ReviewSuppressUnmanagedCodeSecurityUsage", Scope="member", Target="System.Net.UnsafeNclNativeMethods.#CoCreateInstance(System.Guid&,System.IntPtr,System.Int32,System.Guid&,System.Object&)", Justification="Only exposed through Uri.IsIntranet.")]
[module: SuppressMessage("Microsoft.Globalization","CA1307:SpecifyStringComparison", MessageId="System.String.IndexOf(System.String)", Scope="member", Target="System.Net.WebProxyDataBuilder.#ParseProxyUri(System.String,System.Boolean)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Interoperability","CA1404:CallGetLastErrorImmediatelyAfterPInvoke", Scope="member", Target="System.Net.WinHttpWebProxyBuilder.#BuildInternal()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.Mail.MailAddress.#.ctor(System.String,System.String,System.UInt32)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Globalization","CA1309:UseOrdinalStringComparison", MessageId="System.String.Compare(System.String,System.String,System.StringComparison)", Scope="member", Target="System.Net.Mail.Message.#IsHeaderSet(System.String)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="System.Net.Mime.MimePart.#Dispose()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.IPGlobalProperties.#GetIPv4GlobalStatistics()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.IPGlobalProperties.#GetIPv6GlobalStatistics()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.IPGlobalProperties.#GetTcpIPv4Statistics()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.IPGlobalProperties.#GetTcpIPv6Statistics()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.IPGlobalProperties.#GetUdpIPv4Statistics()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.IPGlobalProperties.#GetUdpIPv6Statistics()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.IPInterfaceProperties.#GetIPv4Properties()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.IPInterfaceProperties.#GetIPv6Properties()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="type", Target="System.Net.NetworkInformation.IPv4InterfaceProperties", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="type", Target="System.Net.NetworkInformation.IPv4InterfaceStatistics", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="type", Target="System.Net.NetworkInformation.IPv6InterfaceProperties", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.NetworkInterface.#GetIPv4Statistics()", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.NetworkInterfaceComponent.#IPv4", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.NetworkInterfaceComponent.#IPv6", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="member", Target="System.Net.NetworkInformation.TcpConnectionInformation.#LocalEndPoint", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="member", Target="System.Net.NetworkInformation.TcpConnectionInformation.#RemoteEndPoint", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.NetworkInformation.UnicastIPAddressInformation.#IPv4Mask", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="type", Target="System.Net.Sockets.IPv6MulticastOption", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.ProtocolType.#IPv4", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.ProtocolType.#IPv6", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.ProtocolType.#IPv6DestinationOptions", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.ProtocolType.#IPv6FragmentHeader", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.ProtocolType.#IPv6HopByHopOptions", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.ProtocolType.#IPv6NoNextHeader", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.ProtocolType.#IPv6RoutingHeader", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Reliability","CA2001:AvoidCallingProblematicMethods", MessageId="System.Runtime.InteropServices.SafeHandle.DangerousGetHandle", Scope="member", Target="System.Net.Sockets.Socket.#DoBeginReceive(System.Byte[],System.Int32,System.Int32,System.Net.Sockets.SocketFlags,System.Net.Sockets.OverlappedAsyncResult)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Reliability","CA2001:AvoidCallingProblematicMethods", MessageId="System.Runtime.InteropServices.SafeHandle.DangerousGetHandle", Scope="member", Target="System.Net.Sockets.Socket.#DoBeginReceive(System.Collections.Generic.IList`1<System.ArraySegment`1<System.Byte>>,System.Net.Sockets.SocketFlags,System.Net.Sockets.OverlappedAsyncResult)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="endPoint", Scope="member", Target="System.Net.Sockets.Socket.#EndReceiveFrom(System.IAsyncResult,System.Net.EndPoint&)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="endPoint", Scope="member", Target="System.Net.Sockets.Socket.#EndReceiveMessageFrom(System.IAsyncResult,System.Net.Sockets.SocketFlags&,System.Net.EndPoint&,System.Net.Sockets.IPPacketInformation&)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="member", Target="System.Net.Sockets.Socket.#LocalEndPoint", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.Socket.#OSSupportsIPv6", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="member", Target="System.Net.Sockets.Socket.#RemoteEndPoint", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.Socket.#SupportsIPv4", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="member", Target="System.Net.Sockets.SocketAsyncEventArgs.#RemoteEndPoint", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.SocketOptionLevel.#IPv6", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="endPoint", Scope="member", Target="System.Net.Sockets.UdpClient.#BeginSend(System.Byte[],System.Int32,System.Net.IPEndPoint,System.AsyncCallback,System.Object)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="endPoint", Scope="member", Target="System.Net.Sockets.UdpClient.#Connect(System.Net.IPEndPoint)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="endPoint", Scope="member", Target="System.Net.Sockets.UdpClient.#Send(System.Byte[],System.Int32,System.Net.IPEndPoint)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Unescape", Scope="member", Target="System.GenericUriParserOptions.#DontUnescapePathDotsAndSlashes", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Idn", Scope="member", Target="System.GenericUriParserOptions.#Idn", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.SR.#GetString(System.String,System.Boolean&)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Unescape", Scope="member", Target="System.Uri.#HexUnescape(System.String,System.Int32&)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Unc", Scope="member", Target="System.Uri.#IsUnc", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Unescape", Scope="member", Target="System.Uri.#UnescapeDataString(System.String)", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.UriHostNameType.#IPv4", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.UriHostNameType.#IPv6", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Idn", Scope="type", Target="System.UriIdnScope", Justification="batch baselining v4 violations")]
[module: SuppressMessage("Microsoft.Usage","CA2303:FlagTypeGetHashCode", Scope="member", Target="System.Net.Configuration.WebRequestModuleElement+TypeAndName.#GetHashCode()", Justification="batch baselining v4 violations")]


//
// System.Net 2
//
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="e", Scope="member", Target="System.UriFormatException.#.ctor(System.String,System.Exception)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1720:IdentifiersShouldNotContainTypeNames", MessageId="string", Scope="member", Target="System.UriFormatException.#.ctor(System.String,System.Exception)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Globalization","CA1309:UseOrdinalStringComparison", MessageId="System.String.Equals(System.String,System.StringComparison)", Scope="member", Target="System.Net.AuthenticationManager.#FindSubstringNotInQuotes(System.String,System.String)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Reliability","CA2001:AvoidCallingProblematicMethods", MessageId="System.Runtime.InteropServices.SafeHandle.DangerousGetHandle", Scope="member", Target="System.Net.Dns.#TryGetAddrInfo(System.String,System.Net.AddressInfoHints,System.Net.IPHostEntry&)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1702:CompoundWordsShouldBeCasedCorrectly", MessageId="EndPoint", Scope="type", Target="System.Net.DnsEndPoint", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Usage","CA2208:InstantiateArgumentExceptionsCorrectly", Scope="member", Target="System.Net.HttpWebRequest.#AddRange(System.String,System.Int64,System.Int64)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.HttpWebRequest.#get_RequireBody()", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.IPAddress.#IsIPv6Teredo", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Teredo", Scope="member", Target="System.Net.IPAddress.#IsIPv6Teredo", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Globalization","CA1305:SpecifyIFormatProvider", MessageId="System.String.Format(System.String,System.Object,System.Object)", Scope="member", Target="System.Net.IPEndPoint.#ToString()", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.NetworkingPerfCounters.#Decrement(System.Net.NetworkingPerfCounterName)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.NetworkingPerfCounters.#Decrement(System.Net.NetworkingPerfCounterName,System.Int64)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Globalization","CA1309:UseOrdinalStringComparison", MessageId="System.String.Compare(System.String,System.String,System.StringComparison)", Scope="member", Target="System.Net.ServiceNameStore.#BuildServiceNames(System.String)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Globalization","CA1307:SpecifyStringComparison", MessageId="System.String.IndexOf(System.String)", Scope="member", Target="System.Net.ServiceNameStore.#ExtractHostname(System.String,System.Boolean)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Globalization","CA1307:SpecifyStringComparison", MessageId="System.String.IndexOf(System.String)", Scope="member", Target="System.Net.WebProxyDataBuilder.#ParseProxyUri(System.String)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Globalization","CA1305:SpecifyIFormatProvider", MessageId="System.String.Format(System.String,System.Object)", Scope="member", Target="System.Net.Mail.MailAddress.#Encode(System.Int32)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Globalization","CA1305:SpecifyIFormatProvider", MessageId="System.String.Format(System.String,System.Object,System.Object)", Scope="member", Target="System.Net.Mail.MailAddress.#ToString()", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Globalization","CA1305:SpecifyIFormatProvider", MessageId="System.String.Format(System.String,System.Object,System.Object)", Scope="member", Target="System.Net.Mime.EncodedStreamFactory.#CreateHeader(System.Text.Encoding,System.Boolean)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.Mime.EncodedStreamFactory.#GetEncoder(System.Net.Mime.TransferEncoding,System.IO.Stream)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="System.Text.StringBuilder", Scope="member", Target="System.Net.Mime.MimeBasePart.#EncodeHeaderValue(System.String,System.Text.Encoding,System.Boolean,System.Int32)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.Mime.MimeBasePart.#IsAnsi(System.String,System.Boolean)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.Mime.QEncodedStream.#.ctor(System.Int32)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.Mime.QEncodedStream.#.ctor(System.IO.Stream)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.Mime.QEncodedStream.#.ctor(System.IO.Stream,System.Int32)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.Mime.QuotedPrintableStream.#.ctor(System.Int32)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Unicast", Scope="member", Target="System.Net.NetworkInformation.IPGlobalProperties.#BeginGetStableUnicastAddresses(System.AsyncCallback,System.Object)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Unicast", Scope="member", Target="System.Net.NetworkInformation.IPGlobalProperties.#EndGetStableUnicastAddresses(System.IAsyncResult)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId="Unicast", Scope="member", Target="System.Net.NetworkInformation.IPGlobalProperties.#GetStableUnicastAddresses()", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Reliability","CA2004:RemoveCallsToGCKeepAlive", Scope="member", Target="System.Net.NetworkInformation.Ping.#InternalSend(System.Net.IPAddress,System.Byte[],System.Int32,System.Net.NetworkInformation.PingOptions,System.Boolean)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.NetworkInformation.PingReply.#.ctor(System.Byte[],System.Int32,System.Net.IPAddress,System.Int32)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.NetworkInformation.PingReply.#GetIPStatus(System.Net.NetworkInformation.IcmpV4Type,System.Net.NetworkInformation.IcmpV4Code)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Reliability","CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="System.Net.NetworkInformation.TeredoHelper.#cancelHandle", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Usage","CA1806:DoNotIgnoreMethodResults", MessageId="System.Net.NetworkInformation.UnsafeNetInfoNativeMethods.CancelMibChangeNotify2(System.IntPtr)", Scope="member", Target="System.Net.NetworkInformation.TeredoHelper.#RunCallback(System.Object)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Performance","CA1811:AvoidUncalledPrivateCode", Scope="member", Target="System.Net.NetworkInformation.UnsafeNetInfoNativeMethods.#Icmp6ParseReplies(System.IntPtr,System.UInt32)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Interoperability","CA1404:CallGetLastErrorImmediatelyAfterPInvoke", Scope="member", Target="System.Net.Security.SecureChannel.#VerifyRemoteCertificate(System.Net.Security.RemoteCertValidationCallback)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Design","CA1008:EnumsShouldHaveZeroValue", Scope="type", Target="System.Net.Sockets.IPv6ProtectionLevel", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="type", Target="System.Net.Sockets.IPv6ProtectionLevel", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Interoperability","CA1404:CallGetLastErrorImmediatelyAfterPInvoke", Scope="member", Target="System.Net.Sockets.Socket.#AcceptAsync(System.Net.Sockets.SocketAsyncEventArgs)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Usage","CA2208:InstantiateArgumentExceptionsCorrectly", Scope="member", Target="System.Net.Sockets.Socket.#ConnectAsync(System.Net.Sockets.SocketType,System.Net.Sockets.ProtocolType,System.Net.Sockets.SocketAsyncEventArgs)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Interoperability","CA1404:CallGetLastErrorImmediatelyAfterPInvoke", Scope="member", Target="System.Net.Sockets.Socket.#DoBeginAccept(System.Net.Sockets.Socket,System.Int32,System.Net.Sockets.AcceptOverlappedAsyncResult)", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.Socket.#IPv6ProtectionLevel", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.Socket.#OSSupportsIPv4", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.SocketOptionName.#IPv6ProtectionLevel", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.TcpListener.#AllowIPv6NatTraversal", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1709:IdentifiersShouldBeCasedCorrectly", MessageId="Pv", Scope="member", Target="System.Net.Sockets.UdpClient.#AllowIPv6NatTraversal", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Security","CA2103:ReviewImperativeSecurity", Scope="member", Target="System.Security.Permissions.TypeDescriptorPermission.#Copy()", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Security","CA2103:ReviewImperativeSecurity", Scope="member", Target="System.Security.Permissions.TypeDescriptorPermissionAttribute.#CreatePermission()", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Design","CA1008:EnumsShouldHaveZeroValue", Scope="type", Target="System.Security.Permissions.TypeDescriptorPermissionFlags", Justification="waiting for System.Net integration")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="wss", Scope = "resource", Target="System.resources", Justification="wss is the correct identifier")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="subprotocol", Scope="resource", Target="System.resources", Justification="subprotocol is the correct identifier")]

//
// System.Threading
//
[module: SuppressMessage("Microsoft.Usage","CA1816:CallGCSuppressFinalizeCorrectly", Scope="member", Target="System.Threading.Barrier.#Dispose()", Justification="batch baselining v4 violations")]


#endif
