# Copyright 2011 OpenStack Foundation
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from nova.api.openstack import extensions


class Createserverext(extensions.ExtensionDescriptor):
    """Extended support to the Create Server v1.1 API."""

    name = "Createserverext"
    alias = "os-create-server-ext"
    namespace = ("http://docs.openstack.org/compute/ext/"
                 "createserverext/api/v1.1")
    updated = "2011-07-19T00:00:00Z"

    def get_resources(self):
        res = extensions.ResourceExtension('os-create-server-ext',
                                           inherits='servers')
        return [res]
