/*
 *	Copyright (C) 2011-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 */

#ifndef PLATFORMERRORS_H_
#define PLATFORMERRORS_H_

#ifdef WIN32

#include <winerror.h>

#else

const HRESULT S_OK			= 0;
const HRESULT S_FALSE		= 1;
const HRESULT E_FAIL		= 0x80004005;
const HRESULT E_NOTIMPL		= 0x80004001;
const HRESULT E_INVALIDARG	= 0x80070057;
const HRESULT E_OUTOFMEMORY	= 0x8007000E;
const HRESULT E_POINTER		= 0x80004003;
const HRESULT E_NOINTERFACE = 0x80004002;
const HRESULT E_UNEXPECTED  = 0x8000FFFF;

const HRESULT OLE_E_BLANK	= 0x80040007;

const HRESULT ERROR_SUCCESS = 0;
const HRESULT NO_ERROR = 0;
const HRESULT ERROR_INVALID_FUNCTION= 1;
const HRESULT ERROR_FILE_NOT_FOUND = 2;
const HRESULT ERROR_PATH_NOT_FOUND = 3;
const HRESULT ERROR_ACCESS_DENIED = 5;
const HRESULT ERROR_INVALID_HANDLE = 6;
const HRESULT ERROR_INVALID_DATA = 13;
const HRESULT ERROR_OUTOFMEMORY = 14;
const HRESULT ERROR_NOT_SAME_DEVICE= 17;
const HRESULT ERROR_HANDLE_EOF = 38;
const HRESULT ERROR_NOT_SUPPORTED = 50;
const HRESULT ERROR_FILE_EXISTS= 80;
const HRESULT ERROR_INVALID_PARAMETER = 87;
const HRESULT ERROR_BUFFER_OVERFLOW = 111;
const HRESULT ERROR_CALL_NOT_IMPLEMENTED = 120;
const HRESULT ERROR_INSUFFICIENT_BUFFER = 122;
const HRESULT ERROR_BAD_PATHNAME = 161;
const HRESULT ERROR_BUSY = 170;
const HRESULT ERROR_ALREADY_EXISTS= 183;
const HRESULT ERROR_NOT_FOUND = 1168;
const HRESULT ERROR_MORE_DATA = 234;
const HRESULT ERROR_NO_MORE_ITEMS = 259;
const HRESULT ERROR_SHUTDOWN_IN_PROGRESS = 1115;
const HRESULT ERROR_INVALID_INDEX = 1413;
const HRESULT ERROR_INTERNAL_ERROR = 1359;
const HRESULT ERROR_DISCARDED = 157;
const HRESULT ERROR_CLASS_ALREADY_EXISTS = 1410;
const HRESULT ERROR_CLASS_DOES_NOT_EXIST = 1411;
const HRESULT ERROR_TIMEOUT   = 1460;
const HRESULT ERROR_UNSUPPORTED_TYPE   = 1630;
const HRESULT ERROR_TAG_NOT_FOUND =2012;
const HRESULT ERROR_TAG_NOT_PRESENT =2013;
const HRESULT ERROR_DUPLICATE_TAG =2014;
const HRESULT ERROR_INVALID_STATE = 5023;
const HRESULT ERROR_FILE_READ_ONLY = 6009;
const HRESULT ERROR_REVISION_MISMATCH = 1306;
const HRESULT ERROR_ALREADY_INITIALIZED = 1247;

const HRESULT DISP_E_BADVARTYPE = 0x80020008;
const HRESULT DISP_E_OVERFLOW = 0x8002000A;
const HRESULT DISP_E_TYPEMISMATCH = 0x80020005;
const HRESULT DISP_E_EXCEPTION = 0x80020009;
const HRESULT DISP_E_PARAMNOTOPTIONAL   = 0x8002000F;
const HRESULT DISP_E_UNKNOWNNAME   = 0x80020006;
const HRESULT DISP_E_BADPARAMCOUNT = 0x8002000E;
const HRESULT NTE_BAD_LEN = 0x80090004;

const HRESULT RPC_S_OK = 0;
const HRESULT RPC_S_OUT_OF_MEMORY = ERROR_OUTOFMEMORY;
const HRESULT RPC_S_INVALID_STRING_BINDING    = 1700;
const HRESULT RPC_S_WRONG_KIND_OF_BINDING     = 1701;
const HRESULT RPC_S_INVALID_BINDING           = 1702;
const HRESULT RPC_S_PROTSEQ_NOT_SUPPORTED     = 1703;
const HRESULT RPC_S_INVALID_RPC_PROTSEQ       = 1704;
const HRESULT RPC_S_INVALID_STRING_UUID       = 1705;
const HRESULT RPC_S_INVALID_ENDPOINT_FORMAT   = 1706;
const HRESULT RPC_S_INVALID_NET_ADDR          = 1707;
const HRESULT RPC_S_NO_ENDPOINT_FOUND         = 1708;
const HRESULT RPC_S_INVALID_TIMEOUT           = 1709;
const HRESULT RPC_S_OBJECT_NOT_FOUND          = 1710;
const HRESULT RPC_S_ALREADY_REGISTERED        = 1711;
const HRESULT RPC_S_TYPE_ALREADY_REGISTERED   = 1712;
const HRESULT RPC_S_ALREADY_LISTENING         = 1713;
const HRESULT RPC_S_NO_PROTSEQS_REGISTERED    = 1714;
const HRESULT RPC_S_NOT_LISTENING             = 1715;
const HRESULT RPC_S_UNKNOWN_MGR_TYPE          = 1716;
const HRESULT RPC_S_UNKNOWN_IF                = 1717;
const HRESULT RPC_S_NO_BINDINGS               = 1718;
const HRESULT RPC_S_NO_PROTSEQS               = 1719;
const HRESULT RPC_S_CANT_CREATE_ENDPOINT      = 1720;
const HRESULT RPC_S_OUT_OF_RESOURCES          = 1721;
const HRESULT RPC_S_SERVER_UNAVAILABLE        = 1722;
const HRESULT RPC_S_SERVER_TOO_BUSY           = 1723;
const HRESULT RPC_S_INVALID_NETWORK_OPTIONS   = 1724;
const HRESULT RPC_S_NO_CALL_ACTIVE            = 1725;
const HRESULT RPC_S_CALL_FAILED               = 1726;
const HRESULT RPC_S_CALL_FAILED_DNE           = 1727;
const HRESULT RPC_S_PROTOCOL_ERROR            = 1728;
const HRESULT RPC_S_UNSUPPORTED_TRANS_SYN     = 1730;
const HRESULT RPC_S_UNSUPPORTED_TYPE          = 1732;
const HRESULT RPC_S_INVALID_TAG               = 1733;
const HRESULT RPC_S_INVALID_BOUND             = 1734;
const HRESULT RPC_S_NO_ENTRY_NAME             = 1735;
const HRESULT RPC_S_INVALID_NAME_SYNTAX       = 1736;
const HRESULT RPC_S_UNSUPPORTED_NAME_SYNTAX   = 1737;
const HRESULT RPC_S_UUID_NO_ADDRESS           = 1739;
const HRESULT RPC_S_DUPLICATE_ENDPOINT        = 1740;
const HRESULT RPC_S_UNKNOWN_AUTHN_TYPE        = 1741;
const HRESULT RPC_S_MAX_CALLS_TOO_SMALL       = 1742;
const HRESULT RPC_S_STRING_TOO_LONG           = 1743;
const HRESULT RPC_S_PROTSEQ_NOT_FOUND         = 1744;
const HRESULT RPC_S_PROCNUM_OUT_OF_RANGE      = 1745;
const HRESULT RPC_S_BINDING_HAS_NO_AUTH       = 1746;
const HRESULT RPC_S_UNKNOWN_AUTHN_SERVICE     = 1747;
const HRESULT RPC_S_UNKNOWN_AUTHN_LEVEL       = 1748;
const HRESULT RPC_S_INVALID_AUTH_IDENTITY     = 1749;
const HRESULT RPC_S_UNKNOWN_AUTHZ_SERVICE     = 1750;

const HRESULT FACILITY_WINDOWS = 8;
const HRESULT FACILITY_URT = 19;
const HRESULT FACILITY_STORAGE = 3;
const HRESULT FACILITY_SSPI = 9;
const HRESULT FACILITY_SCARD = 16;
const HRESULT FACILITY_SETUPAPI = 15;
const HRESULT FACILITY_SECURITY = 9;
const HRESULT FACILITY_RPC = 1;
const HRESULT FACILITY_WIN32 = 7;
const HRESULT FACILITY_CONTROL = 10;
const HRESULT FACILITY_NULL = 0;
const HRESULT FACILITY_MSMQ = 14;
const HRESULT FACILITY_MEDIASERVER = 13;
const HRESULT FACILITY_INTERNET = 12;
const HRESULT FACILITY_ITF = 4;
const HRESULT FACILITY_DISPATCH = 2;
const HRESULT FACILITY_COMPLUS = 17;
const HRESULT FACILITY_CERT = 11;
const HRESULT FACILITY_ACS = 20;
const HRESULT FACILITY_AAF = 18;

const HRESULT SEVERITY_SUCCESS = 0;
const HRESULT SEVERITY_ERROR   = 1;

#define HRESULT_FROM_WIN32(x) ((HRESULT)(x) <= 0 ? ((HRESULT)(x)) : ((HRESULT) (((x) & 0x0000FFFF) | (FACILITY_WIN32 << 16) | 0x80000000)))

#define SUCCEEDED(status) ((HRESULT)(status) >= 0)
#define FAILED(status) ((HRESULT)(status) < 0)
#define IS_ERROR(status) ((uint32)(status) >> 31 == SEVERITY_ERROR)

#define HRESULT_CODE(hr) ((hr) & 0xFFFF)
#define SCODE_CODE(sc) ((sc) & 0xFFFF)

#define HRESULT_FACILITY(hr) (((hr) >> 16) & 0x1FFF)
#define SCODE_FACILITY(sc) (((sc) >> 16) & 0x1FFF)

#define HRESULT_SEVERITY(hr) (((hr) >> 31) & 0x1
#define SCODE_SEVERITY(sc) (((sc) >> 31) & 0x1)

#define MAKE_HRESULT(sev,fac,code) \
	((HRESULT) (((uint32)(sev)<<31) | ((uint32)(fac)<<16) | ((uint32)(code))) )
#define MAKE_SCODE(sev,fac,code) \
	((HRESULT) (((uint32)(sev)<<31) | ((uint32)(fac)<<16) | ((uint32)(code))) )

#endif

#endif /* PLATFORMERRORS_H_ */
