/* shotwell-graphics-processor.vapi generated by valac 0.36.6, do not modify. */

namespace AutoEnhance {
	[CCode (cheader_filename = "shotwell-graphics-processor.h")]
	public static PixelTransformationBundle create_auto_enhance_adjustments (Gdk.Pixbuf pixbuf);
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public enum CompositionMode {
	NONE,
	RGB_MATRIX,
	HSV_LOOKUP
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public enum PixelFormat {
	RGB,
	HSV
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public enum PixelTransformationType {
	TONE_EXPANSION,
	SHADOWS,
	HIGHLIGHTS,
	TEMPERATURE,
	TINT,
	SATURATION,
	EXPOSURE,
	CONTRAST
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class PixelTransformationBundle {
	public PixelTransformationBundle ();
	public PixelTransformationBundle copy ();
	public PixelTransformer generate_transformer ();
	public static PixelTransformationBundle? get_copied_color_adjustments ();
	public int get_count ();
	public PixelTransformation? get_transformation (PixelTransformationType type);
	public Gee.Iterable<PixelTransformation> get_transformations ();
	public static bool has_copied_color_adjustments ();
	public bool is_identity ();
	public void load (KeyValueMap store);
	public KeyValueMap save (string group);
	public void @set (PixelTransformation transformation);
	public static void set_copied_color_adjustments (PixelTransformationBundle adjustments);
	public void set_to_identity ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public abstract class PixelTransformation {
	public PixelTransformation (PixelTransformationType type, PixelFormat preferred_format);
	public virtual void compose_with (PixelTransformation other);
	public abstract PixelTransformation copy ();
	public virtual CompositionMode get_composition_mode ();
	public PixelFormat get_preferred_format ();
	public PixelTransformationType get_transformation_type ();
	public virtual bool is_identity ();
	public virtual string to_string ();
	public virtual HSVAnalyticPixel transform_pixel_hsv (HSVAnalyticPixel p);
	public virtual RGBAnalyticPixel transform_pixel_rgb (RGBAnalyticPixel p);
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class RGBTransformation : PixelTransformation {
	protected bool identity;
	protected float[] matrix_entries;
	protected const int MATRIX_SIZE;
	public RGBTransformation (PixelTransformationType type);
	public override void compose_with (PixelTransformation other);
	public override PixelTransformation copy ();
	public override CompositionMode get_composition_mode ();
	public override bool is_identity ();
	public override HSVAnalyticPixel transform_pixel_hsv (HSVAnalyticPixel p);
	public override RGBAnalyticPixel transform_pixel_rgb (RGBAnalyticPixel p);
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public abstract class HSVTransformation : PixelTransformation {
	protected float remap_table[256];
	public HSVTransformation (PixelTransformationType type);
	public override void compose_with (PixelTransformation other);
	public override CompositionMode get_composition_mode ();
	public override HSVAnalyticPixel transform_pixel_hsv (HSVAnalyticPixel pixel);
	public override RGBAnalyticPixel transform_pixel_rgb (RGBAnalyticPixel p);
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class TintTransformation : RGBTransformation {
	public const float MAX_PARAMETER;
	public const float MIN_PARAMETER;
	public TintTransformation (float client_param);
	public float get_parameter ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class TemperatureTransformation : RGBTransformation {
	public const float MAX_PARAMETER;
	public const float MIN_PARAMETER;
	public TemperatureTransformation (float client_parameter);
	public float get_parameter ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class SaturationTransformation : RGBTransformation {
	public const float MAX_PARAMETER;
	public const float MIN_PARAMETER;
	public SaturationTransformation (float client_parameter);
	public float get_parameter ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class ExposureTransformation : RGBTransformation {
	public const float MAX_PARAMETER;
	public const float MIN_PARAMETER;
	public ExposureTransformation (float client_parameter);
	public float get_parameter ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class ContrastTransformation : RGBTransformation {
	public const float MAX_PARAMETER;
	public const float MIN_PARAMETER;
	public ContrastTransformation (float client_parameter);
	public float get_parameter ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class PixelTransformer {
	public int optimized_slots_used;
	public PixelTransformation[] optimized_transformations;
	public PixelTransformer ();
	public void attach_transformation (PixelTransformation trans);
	public PixelTransformer copy ();
	public void detach_transformation (PixelTransformation victim);
	public void replace_transformation (PixelTransformation old_trans, PixelTransformation new_trans);
	public void transform_from_fp (ref float[] fp_pixel_cache, Gdk.Pixbuf dest);
	public void transform_pixbuf (Gdk.Pixbuf pixbuf, GLib.Cancellable? cancellable = null);
	public void transform_to_other_pixbuf (Gdk.Pixbuf source, Gdk.Pixbuf dest, GLib.Cancellable? cancellable = null, int jobs = -1);
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class RGBHistogram {
	public const int GRAPHIC_HEIGHT;
	public const int GRAPHIC_WIDTH;
	public RGBHistogram (Gdk.Pixbuf pixbuf);
	public Gdk.Pixbuf get_graphic ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class IntensityHistogram {
	public IntensityHistogram (Gdk.Pixbuf pixbuf);
	public float get_cumulative_probability (int level);
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class ExpansionTransformation : HSVTransformation {
	public ExpansionTransformation (IntensityHistogram histogram);
	public override PixelTransformation copy ();
	public ExpansionTransformation.from_extrema (int black_point, int white_point);
	public ExpansionTransformation.from_string (string encoded_transformation);
	public int get_black_point ();
	public int get_white_point ();
	public override bool is_identity ();
	public override string to_string ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class ShadowDetailTransformation : HSVTransformation {
	public const float MAX_PARAMETER;
	public const float MIN_PARAMETER;
	public ShadowDetailTransformation (float user_intensity);
	public override PixelTransformation copy ();
	public float get_parameter ();
	public override bool is_identity ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class HermiteGammaApproximationFunction {
	public HermiteGammaApproximationFunction (float user_interval_upper);
	public float evaluate (float x);
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class HighlightDetailTransformation : HSVTransformation {
	public const float MAX_PARAMETER;
	public const float MIN_PARAMETER;
	public HighlightDetailTransformation (float user_intensity);
	public override PixelTransformation copy ();
	public float get_parameter ();
	public override bool is_identity ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public class KeyValueMap {
	public KeyValueMap (string group);
	public KeyValueMap copy ();
	public bool get_bool (string key, bool def);
	public double get_double (string key, double def);
	public float get_float (string key, float def);
	public string get_group ();
	public int get_int (string key, int def);
	public Gee.Set<string> get_keys ();
	public Gdk.Point get_point (string key, Gdk.Point def);
	public string get_string (string key, string? def);
	public bool has_key (string key);
	public void set_bool (string key, bool value);
	public void set_double (string key, double value);
	public void set_float (string key, float value);
	public void set_int (string key, int value);
	public void set_point (string key, Gdk.Point point);
	public void set_string (string key, string value);
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public struct RGBAnalyticPixel {
	public float red;
	public float green;
	public float blue;
	public RGBAnalyticPixel ();
	public bool equals (RGBAnalyticPixel? rhs);
	public RGBAnalyticPixel.from_components (float red, float green, float blue);
	public RGBAnalyticPixel.from_hsv (HSVAnalyticPixel hsv_pixel);
	public RGBAnalyticPixel.from_quantized_components (uchar red_quantized, uchar green_quantized, uchar blue_quantized);
	public uint hash_code ();
	public uchar quantized_blue ();
	public uchar quantized_green ();
	public uchar quantized_red ();
	public HSVAnalyticPixel to_hsv ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public struct HSVAnalyticPixel {
	public float hue;
	public float saturation;
	public float light_value;
	public HSVAnalyticPixel ();
	public bool equals (ref HSVAnalyticPixel rhs);
	public HSVAnalyticPixel.from_components (float hue, float saturation, float light_value);
	public HSVAnalyticPixel.from_quantized_components (uchar hue_quantized, uchar saturation_quantized, uchar light_value_quantized);
	public HSVAnalyticPixel.from_rgb (RGBAnalyticPixel p);
	public uint hash_code ();
	public RGBAnalyticPixel to_rgb ();
}
[CCode (cheader_filename = "shotwell-graphics-processor.h")]
public const float[] rgb_lookup_table;
