//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Sample/SampleValidator.h
//! @brief     Defines class SampleValidator
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_SAMPLE_SAMPLEVALIDATOR_H
#define BORNAGAIN_GUI_MODEL_SAMPLE_SAMPLEVALIDATOR_H

#include <QString>

class SampleItem;
class LayerItem;
class ItemWithParticles;

//! Validates whether SampleItem is suitable for simulation
class SampleValidator {
public:
    bool isValidSample(const SampleItem* sample);

    QString getValidationMessage() const { return m_messages; }

private:
    void validateItem(const ItemWithParticles* item);

    //! Adds this message to the report.
    void addMessage(const QString& m);

    QString m_messages;
};

#endif // BORNAGAIN_GUI_MODEL_SAMPLE_SAMPLEVALIDATOR_H
