#ifndef sjr_parser_h_
#define sjr_parser_h_ 1

#include <iterator>
#include <memory>

namespace sjr {

/** This class is similar to an input iterator, however it does not define
 * comparison operators. Instead, operator! is used to indicate a past-the-end
 * condition. The class parser<T_> provides the iterator compatible interface
 * on top of this.
 */
template<typename T_>
class parser_impl
{
public:
	virtual ~parser_impl(void) throw();

	typedef T_ value_type;
	typedef T_ const &reference;
	typedef T_ const *pointer;

	virtual reference operator*(void) const = 0;
	virtual pointer operator->(void) const = 0;

	virtual parser_impl<T_> &operator++(void) = 0;

	operator void const *(void) const throw();
	virtual bool operator!(void) const throw() = 0;
};

template<typename T_>
parser_impl<T_>::~parser_impl(void) throw()
{
	return;
}

template<typename T_>
parser_impl<T_>::operator void const *(void) const throw()
{
	if(!*this)
		return 0;
	return reinterpret_cast<void const *>(-1);
}

template<typename T_>
class parser :
	public std::iterator<
		std::input_iterator_tag,
		T_,
		void,
		T_ const *,
		T_ const &>
{
public:
	parser(void);
	parser(std::auto_ptr<parser_impl<T_> > impl);

	typedef typename std::iterator<
		std::input_iterator_tag,
		T_,
		void,
		T_ const *,
		T_ const &>::iterator_category iterator_category;
	typedef typename std::iterator<
		std::input_iterator_tag,
		T_,
		void,
		T_ const *,
		T_ const &>::difference_type difference_type;
	typedef typename std::iterator<
		std::input_iterator_tag,
		T_,
		void,
		T_ const *,
		T_ const &>::value_type value_type;
	typedef typename std::iterator<
		std::input_iterator_tag,
		T_,
		void,
		T_ const *,
		T_ const &>::reference reference;
	typedef typename std::iterator<
		std::input_iterator_tag,
		T_,
		void,
		T_ const *,
		T_ const &>::pointer pointer;
		
	reference operator*(void) const;
	pointer operator->(void) const;

	parser<T_> &operator++(void);

	bool operator==(parser<T_> const &) const;
	bool operator!=(parser<T_> const &) const;
private:
	std::auto_ptr<parser_impl<T_> > impl;
};

}

#endif
