/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.IOException;
import java.io.InputStream;
import org.python.core.io.TextIOBase;

public class TextIOInputStream
extends InputStream {
    private TextIOBase textIO;

    public TextIOInputStream(TextIOBase textIO) {
        this.textIO = textIO;
    }

    public int read() throws IOException {
        String result = this.textIO.read(1);
        if (result.length() == 0) {
            return -1;
        }
        return result.charAt(0);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        String result = this.textIO.read(len);
        len = result.length();
        for (int i = 0; i < len; ++i) {
            b[off + i] = (byte)result.charAt(i);
        }
        return len == 0 ? -1 : len;
    }

    public void close() throws IOException {
        this.textIO.close();
    }

    public long skip(long n) throws IOException {
        return this.textIO.seek(n, 1);
    }
}

