#!/bin/sh          

# Run each test in a separate directory, to allow "make check -j" to work properly.
currtestdirname=tmpdir_test_many_dft

if test "$top_builddir" = ""; then
    top_builddir=..
fi
if test "$top_srcdir" = ""; then
    top_srcdir=..
fi

. "$top_srcdir"/test/functions

# Run each test in a separate directory, to allow "make check -j" to work properly.
currdir=`pwd` ; cd $top_builddir ; top_builddir_pwd=`pwd` ; cd $currdir
currdir=`pwd` ; cd $top_srcdir ; top_srcdir_pwd=`pwd` ; cd $currdir
rm -rf $currtestdirname ; mkdir $currtestdirname ; cd $currtestdirname
ln -s "$top_builddir_pwd"/source/ergo ./ergo
script=./ergo

check_eigenvectors="$top_srcdir_pwd"/test/check_eigenvectors.sh


if test `./ergo -e precision` = 'single'; then
    echo SKIPPED
    cd .. ; rm -r $currtestdirname
    exit 0
fi

if test `./ergo -e is_cht_used` = 'chunks_and_tasks_is_used'; then
    echo SKIPPED
    cd .. ; rm -r $currtestdirname
    exit 0
fi


errorfilename=ergoscf.out.error.eigenvectors


TOL=1e-5 # maximum norm of the difference between 
         #eigenvectors computed using the diagonalization and purification


OCC=3
UNOCC=4

echo Testing twisted h2o BLYP/6-31G** with HiCu grid - diagonalization
rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.3       0.11      0.23
H    -1.89      0.18     -0.07
H     0.55      1.66      0.27
EOF
basis = "6-31Gss"
XC.type="HICU"
scf.convergence_threshold = 1e-6
scf.output_homo_and_lumo_eigenvectors = 1 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.use_diagonalization = 1
run "BLYP"
EOINPUT
if 
check_final_energy -76.3474656 8e-5 ; 
then
echo Energy OK
else
echo Energy ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi


mv homo_coefficient_vec.txt  homo_coefficient_vec_diag.txt
mv lumo_coefficient_vec.txt  lumo_coefficient_vec_diag.txt
mv occupied_spectrum.txt occupied_spectrum_diag.txt
mv unoccupied_spectrum.txt unoccupied_spectrum_diag.txt

i=1
while [ "$i" -lt $OCC ]
do
        mv occ_${i}_coefficient_vec.txt occ_${i}_coefficient_vec_diag.txt
        i=`expr $i + 1 `
done

i=1
while [ "$i" -lt $UNOCC ]
do
        mv unocc_${i}_coefficient_vec.txt unocc_${i}_coefficient_vec_diag.txt
        i=`expr $i + 1 `
done



echo;

echo Testing twisted h2o BLYP/6-31G** with HiCu grid - non-accelerated purification
rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.3       0.11      0.23
H    -1.89      0.18     -0.07
H     0.55      1.66      0.27
EOF
basis = "6-31Gss"
XC.type="HICU"
scf.convergence_threshold = 1e-6
scf.purification_with_acceleration = 0  
scf.output_homo_and_lumo_eigenvectors = 1 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.eigenvectors_method  = "projection"
run "BLYP"
EOINPUT
if 
check_final_energy -76.3474656 8e-5 ; 
then
echo Energy OK
else
echo Energy ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi



echo "Comparing eigenvectors"
if
$check_eigenvectors $OCC $UNOCC $TOL
then
echo Eigenvectors OK
else
echo Eigenvectors ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi




cd ..
rm -r $currtestdirname

echo
echo Eigenvectors test completed successfully!
echo
