#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("selects the previous clipboard")

    def run(self):
        if self.env["runtime"]["MemoryManager"].is_index_list_empty(
            "clipboardHistory"
        ):
            self.env["runtime"]["OutputManager"].present_text(
                _("clipboard empty"), interrupt=True
            )
            return
        self.env["runtime"]["MemoryManager"].set_pref_index("clipboardHistory")
        is_first = self.env["runtime"]["MemoryManager"].is_first_index(
            "clipboardHistory"
        )
        is_last = self.env["runtime"]["MemoryManager"].is_last_index(
            "clipboardHistory"
        )
        clipboard = self.env["runtime"][
            "MemoryManager"
        ].get_index_list_element("clipboardHistory")
        if is_first:
            self.env["runtime"]["OutputManager"].present_text(
                _("First clipboard "), interrupt=True
            )
        if is_last:
            self.env["runtime"]["OutputManager"].present_text(
                _("Last clipboard "), interrupt=True
            )
        speech_interrupt = not (is_last or is_first)
        self.env["runtime"]["OutputManager"].present_text(
            clipboard, interrupt=speech_interrupt
        )

    def set_callback(self, callback):
        pass
