#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return ""

    def run(self):
        if self.env["screen"]["newAttribDelta"] != "":
            return
        if self.env["runtime"]["ScreenManager"].is_screen_change():
            return
        if self.env["runtime"]["CursorManager"].is_cursor_vertical_move():
            return
        if self.env["runtime"]["AttributeManager"].is_attribute_change():
            return
        # hack for pdmenu and maybe other dialog apps that place the cursor at 
        # last cell/row
        # this is not to be identified as history
        if (
            self.env["screen"]["new_cursor"]["x"]
            == self.env["runtime"]["ScreenManager"].get_columns() - 1
        ) and (
            self.env["screen"]["new_cursor"]["y"]
            == self.env["runtime"]["ScreenManager"].get_rows() - 1
        ):
            return
        if self.env["runtime"]["InputManager"].get_shortcut_type() in ["KEY"]:
            if not (
                self.env["runtime"]["InputManager"].get_last_deepest_input()
                in [["KEY_UP"], ["KEY_DOWN"]]
            ):
                return
        elif self.env["runtime"]["InputManager"].get_shortcut_type() in [
            "BYTE"
        ]:
            if not (
                self.env["runtime"]["ByteManager"].get_last_byte_key()
                in [b"^[[A", b"^[[B"]
            ):
                return

        # Get the current cursor's line from both old and new content
        prev_line = self.env["screen"]["old_content_text"].split("\n")[
            self.env["screen"]["new_cursor"]["y"]
        ]
        curr_line = self.env["screen"]["new_content_text"].split("\n")[
            self.env["screen"]["new_cursor"]["y"]
        ]

        is_blank = curr_line.strip() == ""

        if prev_line == curr_line:
            if self.env["screen"]["new_delta"] != "":
                return

        announce = curr_line
        if not is_blank:
            curr_prompt = curr_line.find("$")
            root_prompt = curr_line.find("#")
            if curr_prompt <= 0:
                if root_prompt > 0:
                    curr_prompt = root_prompt
                else:
                    announce = curr_line
            if curr_prompt > 0:
                remove_digits = str.maketrans("0123456789", "          ")
                if prev_line[:curr_prompt].translate(
                    remove_digits
                ) == curr_line[:curr_prompt].translate(remove_digits):
                    announce = curr_line[curr_prompt + 1 :]
                else:
                    announce = curr_line

        if is_blank:
            self.env["runtime"]["OutputManager"].present_text(
                _("blank"), sound_icon="EmptyLine", interrupt=True, flush=False
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                announce, interrupt=True, flush=False
            )

        self.env["commandsIgnore"]["onScreenUpdate"]["CHAR_DELETE_ECHO"] = True
        self.env["commandsIgnore"]["onScreenUpdate"]["CHAR_ECHO"] = True
        self.env["commandsIgnore"]["onScreenUpdate"]["INCOMING_IGNORE"] = True

    def set_callback(self, callback):
        pass
