/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#ifndef _H_MPAV_
#define _H_MPAV_

#include <config.h>

#ifndef MPAV_VERSION
#   define MPAV_VERSION "0.0.1a"
#endif

/* Common area */


#define mpav_fmsg( stream, format, args... ) \
   do { \
      fprintf( stream, format, ##args ); \
   } while ( 0 )

#ifdef DEBUG

#define mpav_debug( format, args... ) \
   do { \
      if ( DEBUG ) \
         mpav_fmsg( stderr, "DEBUG: " format, ##args ); \
   } while ( 0 )


int _SDL_mutexP( SDL_mutex *mutex, char *file, int line );
int _SDL_mutexV( SDL_mutex *mutex, char *file, int line );

#ifdef _C_MPAV_
inline int _SDL_mutexP( SDL_mutex *mutex, char *file, int line )
{
  int i = 0;
  mpav_debug( "locking mutex....: +%p (%d) (%s:%d)\n", mutex, i, file, line ); 
  i = SDL_mutexP( mutex );
  mpav_debug( "...mutex locked..: +%p (%d) (%s:%d)\n", mutex, i, file, line );
  return i;
}

inline int _SDL_mutexV( SDL_mutex *mutex, char *file, int line )
{
  int i = 0;
  mpav_debug( "UNlocking mutex..: +%p (%d) (%s:%d)\n", mutex, i, file, line );
  i = SDL_mutexV( mutex );
  mpav_debug( "...mutex UNlocked: +%p (%d) (%s:%d)\n", mutex, i, file, line );
  return i;
}

#define SDL_mutexP( m )  _SDL_mutexP( m, __FILE__, __LINE__ )
#define SDL_mutexV( m )  _SDL_mutexV( m, __FILE__, __LINE__ )


#endif 

#else // DEBUG
#define mpav_debug( format, args... )

#endif // DEBUG

#ifndef _C_MPAV_

/*
 * Global Area
 */

/* Global Vars */
extern int the_end;      /**< notify the end of threads and the run itself. */
extern char *sharedfile; /**< the file shared with mplayer */

#else // _C_MPAV_

/*
 * Local Area: use only in mpav.c 
 */

#include <config.h>
#include <unistd.h>
#include <stdio.h>
#include <SDL.h>
#include <SDL/SDL_ttf.h>
#include <screen.h>
#include <event.h>
#include <slave.h>
#include <data_import.h>
#include <render.h>

#include <getopt.h>

/* Local Vars */
int the_end = 0;         /**< notify the end of threads and the run itself. */
char *sharedfile = NULL; /**< the file shared with mplayer */

extern char *optarg;
extern int optind,  opterr, optopt;

struct option long_options[] = {
  { "slave",          no_argument,       NULL, 's' },
  { "help",           no_argument,       NULL, 'h' },
  { "version",        no_argument,       NULL, 'v' },
  { "mpfile",         required_argument, NULL, 'f' },
  { "render-plugin",  required_argument, NULL, 'r' },
  { 0,         0,                 0,     0  }
};

char *long_options_desc[] = {
  "Turn on slave mode. So you can control it via stdin",
  "Show this help",
  "Show version",
  "MPlayer shared file. The file you gave to mplayer -af export",
  "Dynamic loadable plugin that renders sound data to screen",
  NULL
};

char *long_options_arg_desc[] = {
  NULL,
  NULL,
  NULL,
  "FILENAME",
  "PLUGIN",
  NULL
};

char short_options[] = "shvf:r:";

/* Local functions */

/**
 * The main function
 *
 * @param argc the number of arguments given in argv
 * @param argv the arguments
 * @return 0 on succes, -1 otherwise
 */
int main( int argc, char *argv[] );

/**
 * Show program help
 *
 * @param progname the program name (argv[0])
 * @see long_options
 * @see long_options_desc
 * @see long_options_arg_desc
 */
void show_help( char *progname );

/**
 * Show program version
 */
void show_version();


#endif // _C_MPAV_

#endif // _H_MPAV_
