# -*- coding: iso-8859-1 -*-
# vim:autoindent:tabstop=4:softtabstop=4:shiftwidth=4:expandtab:filetype=python:
# -----------------------------------------------------------------------
# Web interface to edit your favorites.
# -----------------------------------------------------------------------
# $Id: edit_favorite.rpy 11723 2010-11-11 13:19:33Z adam $
#
# Notes:
# Todo:
#
# -----------------------------------------------------------------------
# Freevo - A Home Theater PC framework
# Copyright (C) 2002 Krister Lagerstrom, et al.
# Please see the file freevo/Docs/CREDITS for a complete list of authors.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MER-
# CHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# -----------------------------------------------------------------------

import sys, time, string

import config
import tv.epg_xmltv
from tv.record_types import Favorite
from www.web_types import HTMLResource, FreevoResource, RecordClientResource

TRUE = 1
FALSE = 0


class EditFavoriteResource(FreevoResource):
    def __init__(self):
        self.recordclient = RecordClientResource()


    def _render(self, request):
        fv = HTMLResource()
        form = request.args

        server_available = self.recordclient().pingNow()
        if not server_available:
            fv.printHeader(_('Edit Favorite'), 'styles/main.css')
            fv.printMessagesFinish([ '<b>'+_('ERROR')+'</b>: '+_('Recording server is not available') ])
            return String( fv.res )

        chan = Unicode(fv.formValue(form, 'chan'))
        if isinstance( chan, str ):
            chan = Unicode( chan, 'latin-1' )

        start = fv.formValue(form, 'start')
        action = fv.formValue(form, 'action')
        name = Unicode(fv.formValue(form, 'name'))
        name = string.replace(name,'%26','&')
        if isinstance( name, str ):
            name = Unicode( name, 'latin-1' )

        (status, favorites) = self.recordclient().getFavoritesNow()
        if status:
            num_favorites = len(favorites)
        else:
            num_favorites = 0

        priority = num_favorites + 1

        # add new favorite from epg
        if action == 'add' and chan and start:
            (result, prog) = self.recordclient().findProgNow(chan, start)

            if not result:
                fv.printHeader('Edit Favorite', 'styles/main.css')
                fv.printMessagesFinish(
                    [ '<b>'+_('ERROR') + '</b>: ' + \
                      ( _('No program found on %(chan)s at %(start)s.') % ({
                        'chan': '<b>'+chan+'</b>',
                        'start': '<b>'+time.strftime('%x %X', time.localtime(int(start))) + '</b>'})
                      ) + ' <i>(%s)</i>' % String(prog)
                    ])
                return String(fv.res)

            fav = Favorite(prog.title, prog, TRUE, TRUE, TRUE, priority, FALSE)

        # edit existing favorite
        elif action == 'edit' and name:
            (result, fav) = self.recordclient().getFavoriteNow(name)

        # default: add new favorite by hand
        else:
            action = 'new'            
            result = True
            fav = Favorite(FALSE, FALSE, TRUE, 'ANY', 'ANY', priority, FALSE)
            fav.name = ''
            fav.title = ''            
            fav.mod = 'ANY'

        if not result:
            fv.printHeader('Edit Favorite', 'styles/main.css')
            fv.printMessagesFinish(
                ['<b>'+_('ERROR') + '</b>: ' + _('Favorite %s doesn\'t exists.') % ('<b>'+name+'</b>')+\
                  (' <i>(%s)</i>' % fav)
                ])
            return String(fv.res)

        guide = tv.epg_xmltv.get_guide()

        fv.printHeader(_('Edit Favorite'), 'styles/main.css', selected=_('Favorites'))
        fv.res += '&nbsp;<br/>\n'
        # This seems out of place.
        #fv.tableOpen('border="0" cellpadding="4" cellspacing="1" width="100%"')
        #fv.tableRowOpen('class="chanrow"')
        #fv.tableCell('<img src="images/logo_200x100.png" />', 'align="left"')
        #fv.tableCell(_('Edit Favorite'), 'class="heading" align="left"')
        #fv.tableRowClose()
        #fv.tableClose()

        fv.res += '<br><form name="editfavorite" method="get" action="favorites.rpy">'
        
        # table header
        fv.tableOpen('border="0" cellpadding="4" cellspacing="1" width="100%"')
        fv.tableRowOpen('class="chanrow"')
        fv.tableCell(_('Name of Favorite'), 'class="guidehead" colspan="1"')
        fv.tableCell(_('Program'), 'class="guidehead" colspan="1"')
        fv.tableCell(_('Channel'), 'class="guidehead" colspan="1"')
        fv.tableCell(_('Day of week'), 'class="guidehead" colspan="1"')
        fv.tableCell(_('Time of day'), 'class="guidehead" colspan="1"')
        if config.TV_RECORD_DUPLICATE_DETECTION:
            fv.tableCell(_('Duplicates'), 'class="guidehead" colspan="1"')
        if config.TV_RECORD_ONLY_NEW_DETECTION:
            fv.tableCell(_('Episodes'), 'class="guidehead" colspan="1"')
        fv.tableCell(_('Action'), 'class="guidehead" colspan="1"')
        fv.tableRowClose()

        status = 'basic'

        fv.tableRowOpen('class="chanrow"')

        # favorite name
        cell = '<input type="hidden" name="oldname" value="%s">' % fav.name
        cell += '<input type="text" size="20" name="name" value="%s">' % fav.name
        fv.tableCell(cell, 'class="'+status+'" colspan="1"')

        # program title
        if action == 'new':
            cell = '<input type="text" size="20" name="title" value="%s">' % fav.title
        else:
            cell = '<input type="hidden" name="title" value="%s">%s' % (fav.title, fav.title)
        fv.tableCell(cell, 'class="'+status+'" colspan="1"')

        # channel
        cell = '\n<select name="chan" selected="%s">\n' % fav.channel
        cell += '  <option value=ANY'
        if fav.channel == 'ANY':
            cell += ' SELECTED'
        cell += '>'+_('ANY CHANNEL')+'</option>\n'

        chan_index = 0
        for ch in guide.chan_list:
            cell += '  <option value="%s"' % (ch.displayname)
            if ch.displayname == fav.channel:
                cell += ' SELECTED'
            cell += '>%s</option>\n' % (ch.displayname)

        cell += '</select>\n'
        fv.tableCell(cell, 'class="'+status+'" colspan="1"')

        # day of week
        cell = '\n<select name="dow">\n' \
               '   <option value="ANY">'+_('ANY DAY')+'</option>\n' \
               '   <option value="0">'+_('Mon')+'</option>\n' \
               '   <option value="1">'+_('Tue')+'</option>\n' \
               '   <option value="2">'+_('Wed')+'</option>\n' \
               '   <option value="3">'+_('Thu')+'</option>\n' \
               '   <option value="4">'+_('Fri')+'</option>\n' \
               '   <option value="5">'+_('Sat')+'</option>\n' \
               '   <option value="6">'+_('Sun')+'</option>\n' \
               '</select>\n'

        fv.tableCell(cell, 'class="'+status+'" colspan="1"')

        # time of day
        cell = '\n<select name="mod" selected="%s">\n' % fav.mod
        cell += '          <option value="ANY">'+_('ANY TIME')+'</option>\n'
        cell += """
          <option value="0">12:00 AM</option>
          <option value="30">12:30 AM</option>
          <option value="60">1:00 AM</option>
          <option value="90">1:30 AM</option>
          <option value="120">2:00 AM</option>
          <option value="150">2:30 AM</option>
          <option value="180">3:00 AM</option>
          <option value="210">3:30 AM</option>
          <option value="240">4:00 AM</option>
          <option value="270">4:30 AM</option>
          <option value="300">5:00 AM</option>
          <option value="330">5:30 AM</option>
          <option value="360">6:00 AM</option>
          <option value="390">6:30 AM</option>
          <option value="420">7:00 AM</option>
          <option value="450">7:30 AM</option>
          <option value="480">8:00 AM</option>
          <option value="510">8:30 AM</option>
          <option value="540">9:00 AM</option>
          <option value="570">9:30 AM</option>
          <option value="600">10:00 AM</option>
          <option value="630">10:30 AM</option>
          <option value="660">11:00 AM</option>
          <option value="690">11:30 AM</option>
          <option value="720">12:00 PM</option>
          <option value="750">12:30 PM</option>
          <option value="780">1:00 PM</option>
          <option value="810">1:30 PM</option>
          <option value="840">2:00 PM</option>
          <option value="870">2:30 PM</option>
          <option value="900">3:00 PM</option>
          <option value="930">3:30 PM</option>
          <option value="960">4:00 PM</option>
          <option value="990">4:30 PM</option>
          <option value="1020">5:00 PM</option>
          <option value="1050">5:30 PM</option>
          <option value="1080">6:00 PM</option>
          <option value="1110">6:30 PM</option>
          <option value="1140">7:00 PM</option>
          <option value="1170">7:30 PM</option>
          <option value="1200">8:00 PM</option>
          <option value="1230">8:30 PM</option>
          <option value="1260">9:00 PM</option>
          <option value="1290">9:30 PM</option>
          <option value="1320">10:00 PM</option>
          <option value="1350">10:30 PM</option>
          <option value="1380">11:00 PM</option>
          <option value="1410">11:30 PM</option>
        </select>
        """
        fv.tableCell(cell, 'class="'+status+'" colspan="1"')

        # record duplicates
        if config.TV_RECORD_DUPLICATE_DETECTION:
            if hasattr(fav, 'allowDuplicates'):
                cell = '\n<select name="allowDuplicates" selected="%s">\n' % \
                fav.allowDuplicates
            else:
                cell = '\n<select name="allowDuplicates">\n'
            cell += '          <option value="1">'+_('ALLOW')+'</option>\n'
            cell += '          <option value="0">'+_('PREVENT')+'</option>\n'
            cell += '</select>\n'
            fv.tableCell(cell, 'class="'+status+'" colspan="1"')

        # record only new episodes
        if config.TV_RECORD_ONLY_NEW_DETECTION:
            if hasattr(fav, 'onlyNew'):
                cell = '\n<select name="onlyNew" selected="%s">\n' % fav.onlyNew
            else:
                cell = '\n<select name="onlyNew">\n'
            cell += '          <option value="0">'+_('ALL')+'</option>\n'
            cell += '          <option value="1">'+_('ONLY NEW')+'</option>\n'
            cell += '</select>\n'
            fv.tableCell(cell, 'class="'+status+'" colspan="1"')


        # cell = '\n<select name="priority" selected="%s">\n' % fav.priority
        # for i in range(num_favorites+1):
        #     cell += '  <option value="%s">%s</option>\n' % (i+1, i+1)
        # cell += '</select>\n'
        # fv.tableCell(cell, 'class="'+status+'" colspan="1"')
        
        # action
        cell = '<input type="hidden" name="priority" value="%s">' % fav.priority
        cell += '<input type="hidden" name="action" value="%s">' % action
        cell += '<input type="submit" value="'+_('Save')+'">'
        fv.tableCell(cell, 'class="'+status+'" colspan="1"')

        fv.tableRowClose()

        fv.tableClose()

        fv.res += '</form>'

        fv.res += '<script language="JavaScript">'

        if fav.channel == 'ANY':
            fv.res += 'document.editfavorite.chan.options[0].selected=true\n'
        else:
            fv.res += 'document.editfavorite.chan.options[%s].selected=true\n' % chan_index

        if fav.dow == 'ANY':
            fv.res += 'document.editfavorite.dow.options[0].selected=true\n'
        else:
            fv.res += 'document.editfavorite.dow.options[(1+%s)].selected=true\n' % fav.dow

        if fav.mod == 'ANY':
            fv.res += 'document.editfavorite.mod.options[0].selected=true\n'
        else:
            mod_index = int(fav.mod)/30 + 1
            fv.res += 'document.editfavorite.mod.options[%s].selected=true\n' % mod_index


        if config.TV_RECORD_DUPLICATE_DETECTION:
            (tempStatus, tempFav) = self.recordclient().getFavoriteNow(fav.name)
            if hasattr(tempFav, 'allowDuplicates'):
                fv.res += 'document.editfavorite.allowDuplicates.options[%s].selected=true\n' % \
                    abs(int(tempFav.allowDuplicates)-1)

        if config.TV_RECORD_ONLY_NEW_DETECTION:
            (tempStatus, tempFav) = self.recordclient().getFavoriteNow(fav.name)
            if hasattr(tempFav, 'onlyNew'):
                fv.res += 'document.editfavorite.onlyNew.options[%s].selected=true\n' % int(tempFav.onlyNew)

        fv.res += '</script>'

        fv.printSearchForm()
        fv.printLinks()
        fv.printFooter()
        return String(fv.res)

resource = EditFavoriteResource()
