with GNAT.Source_Info;
with Ada.Directories; use Ada.Directories;
package body GNU.Db.Sqlite3.Tests.Testcases.Tc_001_Bind is
   use AUnit.Test_Cases.Registration;
   use AUnit.Assertions;
   ----------
   -- Name --
   ----------

   Db_Name  : constant String := Base_Name (GNAT.Source_Info.File) & ".db";
   --   TxT_Name : constant String := Base_Name (GNAT.Source_Info.File) & ".txt";
   function Name (T : Test_Case)
                  return Message_String is
      pragma Unreferenced (T);
   begin
      return Format (GNAT.Source_Info.File);
   end Name;

   -------------------------
   --  t_column_count
   -------------------------
   procedure T_Column_Count (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      Assert (T.Stmt.Column_Count = 4, "Incorrcet columncount returned");
      Assert (T.Stmt.Column_Name (0) = "bla", "Column 0 not 'bla'");
   end T_Column_Count;

   -------------------------
   --  t_column_name
   -------------------------
   procedure T_Column_Name (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      Assert (T.Stmt.Column_Name (3) = "x", "Column 3 not 'x'");
   end T_Column_Name;
   -------------------------
   --  T_Column_Decltype_INT
   -------------------------
   procedure T_Column_Decltype_INT (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      Assert (T.Stmt.Column_Decltype (0) = "INT", "Column 0 not 'INT'");
   end T_Column_Decltype_INT;
   -------------------------
   --  T_Column_Decltype_TEXT
   -------------------------
   procedure T_Column_Decltype_TEXT (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      Assert (T.Stmt.Column_Decltype (3) = "TEXT", "Column 3 not 'TEXT'");
   end T_Column_Decltype_TEXT;

   -------------------------
   --  T_Column_Type_SQLITE_INTEGER
   -------------------------
   procedure T_Column_Type_SQLITE_INTEGER (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      T.Ret := T.Stmt.Step;
      Assert (T.Stmt.Column_Type (0) = SQLITE_INTEGER, "Expected " &  SQLITE_INTEGER'Img & " Got " & T.Stmt.Column_Type (0)'Img);
   end T_Column_Type_SQLITE_INTEGER;
   -------------------------
   --  T_Column_Type_SQLITE_TEXT
   -------------------------
   procedure T_Column_Type_SQLITE_TEXT (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      T.Ret := T.Stmt.Step;
      Assert (T.Stmt.Column_Type (3) = SQLITE_TEXT, "Expected " &  SQLITE_TEXT'Img & " Got " & T.Stmt.Column_Type (0)'Img);
   end T_Column_Type_SQLITE_TEXT;

   -------------------------
   --  t_Data_Count
   -------------------------

   procedure T_Data_Count (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      T.Ret := T.Stmt.Step;
      Assert (T.Stmt.Data_Count = 4, "Expected 4 rows got:" & T.Stmt.Data_Count'Img);
   end T_Data_Count;

   -------------------------
   --  t_step
   -------------------------
   procedure T_Step (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
   begin
      T.Ret := T.Stmt.Step;
      Assert (T.Stmt.Column_Int (0) = 5, "Expected 5 Got " & T.Stmt.Column_Int (0)'Img);
   end T_Step;


   -------------------------
   --  t_bind
   -------------------------
   procedure t_bind (Test : in out AUnit.Test_Cases.Test_Case'Class) is
      T : Test_Case renames Test_Case (Test);
      pragma Unreferenced (T);
      St : aliased Statement;
   begin
      Test.Db.Prepare ("SELECT * FROM demo_I where bla > 4;", Test.Stmt'Unrestricted_Access);
   end t_bind;
   --------------------
   -- Register_Tests --
   --------------------

   procedure Register_Tests (T : in out Test_Case) is
   begin
      Register_Routine (T, T_Column_Count'Access, "T_Column_Count");
      Register_Routine (T, T_Column_Name'Access, "T_Column_Name");
      Register_Routine (T, T_Column_Decltype_INT'Access, "T_Column_Decltype_INT");
      Register_Routine (T, T_Column_Decltype_TEXT'Access, "T_Column_Decltype_TEXT");
      Register_Routine (T, T_Column_Type_SQLITE_INTEGER'Access, "T_Column_Type_SQLITE_INTEGER");
      Register_Routine (T, T_Column_Type_SQLITE_TEXT'Access, "T_Column_Type_SQLITE_TEXT");
      Register_Routine (T, T_Data_Count'Access, "T_Data_Count");
      Register_Routine (T, T_Step'Access, "T_Step");
   end Register_Tests;

   procedure Set_Up_Case (Test : in out Test_Case) is
      Ret : Return_Value;
      pragma Unreferenced (Ret);

   begin
      Test.Db.Open (Db_Name);

      Ret := Test.Db.Exec ("DROP TABLE demo_I;");
      Test.Db.Exec ("CREATE TABLE demo_I(bla INT, ble INT, blo INT, x TEXT);");
      begin
         for I in 1 .. 10 loop
            Test.Db.Exec ("INSERT INTO demo_I VALUES(" & I'Img & ", 200, 300, 'Miko');");
         end loop;
      exception
         when others =>
            null;
      end;
   end Set_Up_Case;

   procedure Tear_Down_Case (Test : in out Test_Case) is
      pragma Unreferenced (Test);
   begin

      --Test.Db.Close;
      --Ada.Directories.Delete_File (Db_Name);
      null;
   end Tear_Down_Case;

   procedure Set_Up (Test : in out Test_Case) is
   begin
      Test.Db.Prepare ("SELECT * FROM demo_I where bla > 4;", Test.Stmt'Unrestricted_Access);
   end Set_Up;
   procedure Tear_Down (Test : in out Test_Case) is
   begin
      Test.Stmt.Finalize;
   end Tear_Down;

end GNU.DB.SQLite3.Tests.Testcases.Tc_001_Bind;
