{-# LANGUAGE ForeignFunctionInterface #-}
module DB.HSQL.ODBC.Type where

import Data.Int(Int32, Int16)
import Data.Word(Word32, Word16)
import Foreign(Ptr,ForeignPtr)

import Database.HSQL.Types(SqlType(..))

#include <HsODBC.h>

type SQLHANDLE = Ptr ()
type HENV = SQLHANDLE
type HDBC = SQLHANDLE
type HSTMT = SQLHANDLE
type HENVRef = ForeignPtr ()

type SQLSMALLINT  = #type SQLSMALLINT
type SQLUSMALLINT = #type SQLUSMALLINT
type SQLINTEGER   = #type SQLINTEGER
type SQLUINTEGER  = #type SQLUINTEGER
type SQLRETURN	  = SQLSMALLINT
type SQLLEN       = SQLINTEGER
type SQLULEN      = SQLINTEGER

-- |
mkSqlType :: SQLSMALLINT -> SQLULEN -> SQLSMALLINT -> SqlType
mkSqlType sqlChar         size    _    = SqlChar (fromIntegral size)
mkSqlType sqlVarChar      size    _    = SqlVarChar (fromIntegral size)
mkSqlType sqlLongVarChar  size    _    = SqlLongVarChar (fromIntegral size)
mkSqlType sqlDecimal      size    prec = 
    SqlDecimal (fromIntegral size) (fromIntegral prec)
mkSqlType sqlNumeric      size    prec = 
    SqlNumeric (fromIntegral size) (fromIntegral prec)
mkSqlType sqlSmallint     _       _    = SqlSmallInt
mkSqlType sqlInteger      _       _    = SqlInteger
mkSqlType sqlReal          _       _    = SqlReal
-- From: http://msdn.microsoft.com/library/en-us/odbc/htm/odappdpr_2.asp
-- "Depending on the implementation, the precision of SQL_FLOAT can be
-- either 24 or 53:
-- if it is 24, the SQL_FLOAT data type is the same as SQL_REAL;
-- if it is 53, the SQL_FLOAT data type is the same as SQL_DOUBLE."
mkSqlType sqlFloat        _        _    = SqlFloat
mkSqlType sqlDouble		_    	_    = SqlDouble
mkSqlType sqlBit          _       	_    = SqlBit
mkSqlType sqlTinyInt      _    	_    = SqlTinyInt
mkSqlType sqlBigint       _    	_    = SqlBigInt
mkSqlType sqlBinary       size    _    = SqlBinary (fromIntegral size)
mkSqlType sqlVarBinary    size    _    = SqlVarBinary (fromIntegral size)
mkSqlType sqlLongVarBinary size    _    = SqlLongVarBinary (fromIntegral size)
mkSqlType sqlDate         _    	_    = SqlDate
mkSqlType sqlTime         _    	_    = SqlTime
mkSqlType sqlTimestamp	_    	_    = SqlDateTime
mkSqlType sqlWChar        size	_    = SqlWChar (fromIntegral size)
mkSqlType sqlWVarChar     size    _    = SqlWVarChar (fromIntegral size)
mkSqlType sqlWLongVarChar	size    _    = 
    SqlWLongVarChar (fromIntegral size)
mkSqlType tp                        _       _    = SqlUnknown (fromIntegral tp)

-- | #const
sqlChar = #const SQL_CHAR

sqlVarChar = #const SQL_VARCHAR

sqlLongVarChar = #const SQL_LONGVARCHAR

sqlDecimal = #const SQL_DECIMAL

sqlNumeric = #const SQL_NUMERIC

sqlSmallint = #const SQL_SMALLINT

sqlInteger = #const SQL_INTEGER

sqlReal = #const SQL_REAL

sqlFloat = #const SQL_FLOAT

sqlDouble = #const SQL_DOUBLE

sqlBit = #const SQL_BIT

sqlTinyInt = #const SQL_TINYINT

sqlBigint = #const SQL_BIGINT

sqlBinary = #const SQL_BINARY

sqlVarBinary = #const SQL_VARBINARY

sqlLongVarBinary = #const SQL_LONGVARBINARY

sqlDate = #const SQL_DATE

sqlTime = #const SQL_TIME

sqlTimestamp = #const SQL_TIMESTAMP

sqlWChar = #const SQL_WCHAR

sqlWVarChar = #const SQL_WVARCHAR

sqlWLongVarChar = #const SQL_WLONGVARCHAR

