#!/bin/sh

set -e

if [ -z "$DEBUG" ]; then
  export DEBUG="testsuite"
fi

SUITE=./dist/build/testsuite/testsuite

export LC_ALL=C
export LANG=C

rm -f testsuite.tix

if [ ! -f $SUITE ]; then
cat <<EOF
Testsuite executable not found, please run:
cabal configure --enable-tests --enable-library-coverage
then
cabal build
EOF
    exit;
fi

./dist/build/testsuite/testsuite -j4 -a1000 $*

DIR=dist/hpc

MIXDIR=$DIR/mix/testsuite
OUTDIR=$DIR/html

rm -Rf $OUTDIR
mkdir -p $OUTDIR

EXCLUDES='Main
Data.Map.Syntax.Tests
Data.Map.Syntax.Util'

EXCL=""

for m in $EXCLUDES; do
    EXCL="$EXCL --exclude=$m"
done

hpc markup $EXCL --hpcdir=$MIXDIR --destdir=$OUTDIR testsuite # >/dev/null 2>&1

rm -f testsuite.tix

cat <<EOF

Test coverage report written to $DIR.
EOF
