/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "hoz.h"
#include "hozgtk.h"
#include "hozgtk_i.h"
#include "hozgtk_s.h"


GtkWidget *window_hoz;
GtkWidget *window_bs;           /* badsize */
GtkWidget *window_ra;           /* replaceask */
GtkWidget *window_fd;           /* file dialog */
GtkTextView *rprttextview;
GtkTextBuffer *rprtbuf;
char hozfile[MAXLEN + 1];
int hozaction;                  /* 0=debug, 1=cut, 2=paste */

extern char outpath[MAXLEN];
extern size_t fullsize, partsize, headersize;
extern int showprogress, forceow, simulate;


void hoz_print(const char *str)
{
    GtkTextIter iter;
    GtkTextMark *mark;
    gtk_text_buffer_get_end_iter(rprtbuf, &iter);
    gtk_text_buffer_insert(rprtbuf, &iter, str, -1);
/*    gtk_text_buffer_insert_with_tags_by_name (rprtbuf, &iter,
					    str, -1,
					    "char_wrap", NULL);
    */
    mark = gtk_text_buffer_get_insert(rprtbuf);
    gtk_text_view_scroll_to_mark(rprttextview, mark, 0, FALSE, 0, 0);

}

void hoz_lf()
{
    hoz_print("\n");
}

/**
 * hoz_replace_ask - ask the user if an output file should be replaced
 * @s: filename
 */
int hoz_replace_ask(const char *s)
{
    char foo[1024];

    sprintf(foo, HOZ_REPLACE_W, s);
    window_ra = create_dialog_ra();
    gtk_window_set_title(GTK_WINDOW(window_ra), HOZ_PROGRAM);
    gtk_label_set_label(GTK_LABEL
                        (lookup_widget
                         (GTK_WIDGET(window_ra), "label_msg_ra")), foo);
    gtk_button_set_label(GTK_BUTTON
                         (lookup_widget
                          (GTK_WIDGET(window_ra), "button_yes_ra")), "Ok");
    gtk_button_set_label(GTK_BUTTON
                         (lookup_widget
                          (GTK_WIDGET(window_ra), "button_no_ra")),
                         "Cancel");
    gtk_widget_show(window_ra);
    /* this is an ugly hack... damn gtk "modal" dialogs */
    return 0;
}

/**
 * hoz_ready - useless...
 */
void hoz_ready()
{
    hoz_lf();
    hoz_print(HOZ_READY);
    hoz_lf();
}

/**
 * hoz_getsize - Gets the size in bytes from the size editbox
 */
size_t hoz_getsize()
{
    gchar baz[101];
    const gchar *foo, *qux;
    size_t bar, mult;

    foo =
        gtk_entry_get_text(GTK_ENTRY
                           (lookup_widget
                            (GTK_WIDGET(window_hoz), "entry_size")));
    qux = gtk_entry_get_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(window_hoz),\
		    "combo_entry_size")));
    if (!strcmp(qux, "MiB")) {
	mult = 1024*1024;
    } else if (!strcmp(qux, "KiB")) {
	mult = 1024;
    } else {
	mult = 1;
    }
    bar = (size_t) atolmp((char *) foo, mult);
    partsize = (bar) ? bar : 0;
    if (!partsize && strlen(foo)) {
        sprintf(baz, HOZ_BADSIZE, foo);
        if (!window_bs) {
            window_bs = create_dialog_bs();
        }
        gtk_window_set_title(GTK_WINDOW(window_bs), HOZ_PROGRAM);
        gtk_label_set_label(GTK_LABEL
                            (lookup_widget
                             (GTK_WIDGET(window_bs), "label_msg_bs")),
                            baz);
        gtk_button_set_label(GTK_BUTTON
                             (lookup_widget
                              (GTK_WIDGET(window_bs), "okbutton_bs")),
                             "Ok");
        gtk_widget_show(window_bs);
    }
    return partsize;
}

/**
 * hoz_getoutpdir - Gets the output path from the entrybox
 */
int hoz_getoutpdir()
{
    strcpy(outpath,
           gtk_entry_get_text(GTK_ENTRY
                              (lookup_widget
                               (GTK_WIDGET(window_hoz), "entry_outp"))));
    if (!isdir(outpath)) {
        hoz_echo(411, outpath);
        return 411;
    }
    return 0;
}

/**
 * hoz_fileop - pops up an open/save file dialog
 * @cutpaste: 0=cut, 1=paste
 */
int hoz_fileop(const int cutpaste)
{
    window_fd = create_fileselection_fd();
    {
        char foo[60];
        sprintf(foo, "%s - %s", HOZ_PROGRAM,
                ((cutpaste) ? (HOZ_BTNPASTECAPTION)
                 : (HOZ_BTNCUTCAPTION)));
        gtk_window_set_title(GTK_WINDOW(window_fd), foo);
    }
    gtk_widget_show(window_fd);
    return 0;
}

int main(int argc, char *argv[])
{

    gtk_set_locale();
    gtk_init(&argc, &argv);

    getcwd(outpath, MAXLEN);

    window_hoz = create_window_hoz();
    window_bs = NULL;
    window_fd = NULL;
    window_ra = NULL;
    hozaction = 0;


    rprttextview =
        GTK_TEXT_VIEW(lookup_widget
                      (GTK_WIDGET(window_hoz), "textview_rprt"));
    rprtbuf = gtk_text_view_get_buffer(rprttextview);
    /*
       gtk_text_buffer_create_tag (rprtbuf, "char_wrap", "wrap_mode", GTK_WRAP_CHAR, NULL);
     */

    gtk_entry_set_text(GTK_ENTRY
                       (lookup_widget
                        (GTK_WIDGET(window_hoz), "entry_size")),
                       "1457152");
    gtk_entry_set_text(GTK_ENTRY
                       (lookup_widget
                        (GTK_WIDGET(window_hoz), "entry_outp")), outpath);
    gtk_label_set_label(GTK_LABEL
                        (lookup_widget
                         (GTK_WIDGET(window_hoz), "label_outp")),
                        HOZ_OUTPCAPTION);
    gtk_label_set_label(GTK_LABEL
                        (lookup_widget
                         (GTK_WIDGET(window_hoz), "label_size")),
                        HOZ_PSIZECAPTION);
    gtk_button_set_label(GTK_BUTTON
                         (lookup_widget
                          (GTK_WIDGET(window_hoz), "checkbutton_prgr")),
                         HOZ_CBPRGRCAPTION);
    gtk_button_set_label(GTK_BUTTON
                         (lookup_widget
                          (GTK_WIDGET(window_hoz), "button_cut")),
                         HOZ_BTNCUTCAPTION);
    gtk_button_set_label(GTK_BUTTON
                         (lookup_widget
                          (GTK_WIDGET(window_hoz), "button_paste")),
                         HOZ_BTNPASTECAPTION);

    {
        char foo[60];
        sprintf(foo, "%s - Hacha Open Zource", HOZ_PROGNAME);
        gtk_window_set_title(GTK_WINDOW(window_hoz), foo);
    }
    hoz_echo(301, NULL);
    hoz_ready();
    fullsize = 0;

    gtk_widget_show(window_hoz);

    gtk_main();
    return 0;
}
