/*
 * Copyright (C) 2004-2010 by CERN/IT/GD/CT
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)$RCSfile: dpm_copy.c,v $ $Revision: 3444 $ $Date: 2010-02-24 08:53:25 +0100 (Wed, 24 Feb 2010) $ CERN IT-GD/CT Jean-Philippe Baud";
#endif /* not lint */

/*	dpm_copy - copy a set of existing files */

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#if defined(_WIN32)
#include <winsock2.h>
#else
#include <unistd.h>
#include <netinet/in.h>
#endif
#include "Csec_constants.h"
#include "dpm_api.h"
#include "dpm.h"
#include "marshall.h"
#include "serrno.h"

int DLL_DECL
dpm_copy (int nbreqfiles, struct dpm_copyfilereq *reqfiles, char *u_token, int flags, time_t retrytime, char *r_token, int *nbreplies, struct dpm_copyfilestatus **filestatuses)
{
	int c;
	char errstring[256];
	char func[16];
	gid_t gid;
	int i;
	int msglen;
	char *rbp;
	char repbuf[4+256+CA_MAXDPMTOKENLEN+1];
	char *sbp;
	char *sendbuf;
	char surl[CA_MAXSFNLEN+1];
	struct dpm_api_thread_info *thip;
	uid_t uid;

	strcpy (func, "dpm_copy");
	if (dpm_apiinit (&thip))
		return (-1);
	uid = geteuid();
	gid = getegid();
#if defined(_WIN32)
	if (uid < 0 || gid < 0) {
		dpm_errmsg (func, DP053);
		serrno = SENOMAPFND;
		return (-1);
	}
#endif

	if (nbreqfiles <= 0) {
		serrno = EINVAL;
		return (-1);
	}
	if (! reqfiles || ! r_token || ! nbreplies || ! filestatuses) {
		serrno = EFAULT;
		return (-1);
	}

	/* Compute size of send buffer */

	msglen = 5 * LONGSIZE;
	if (u_token)
		msglen += strlen (u_token) + 1;
	else
		msglen++;
	msglen += LONGSIZE;
	msglen += TIME_TSIZE;
	msglen += LONGSIZE;
	for (i = 0; i < nbreqfiles; i++) {
		msglen += strlen ((reqfiles+i)->from_surl) + 1;
		msglen += strlen ((reqfiles+i)->to_surl) + 1;
		msglen += TIME_TSIZE;
		msglen++;
		msglen += strlen ((reqfiles+i)->s_token) + 1;
		msglen += LONGSIZE;
		msglen++;
		msglen++;
	}

	/* Allocate send buffer */

	if ((sendbuf = malloc (msglen)) == NULL) {
		serrno = ENOMEM;
		return (-1);
	}

	/* Build request header */

	sbp = sendbuf;
	marshall_LONG (sbp, DPM_MAGIC2);
	marshall_LONG (sbp, DPM_COPY);
	marshall_LONG (sbp, msglen);

	/* Build request body */

	marshall_LONG (sbp, uid);
	marshall_LONG (sbp, gid);
	if (u_token) {
		marshall_STRING (sbp, u_token);
	} else {
		marshall_STRING (sbp, "");
	}
	marshall_LONG (sbp, flags);
	marshall_TIME_T (sbp, retrytime);
	marshall_LONG (sbp, nbreqfiles);
	for (i = 0; i < nbreqfiles; i++) {
		marshall_STRING (sbp, (reqfiles+i)->from_surl);
		marshall_STRING (sbp, (reqfiles+i)->to_surl);
		marshall_TIME_T (sbp, (reqfiles+i)->lifetime);
		marshall_BYTE (sbp, (reqfiles+i)->f_type);
		marshall_STRING (sbp, (reqfiles+i)->s_token);
		marshall_LONG (sbp, (reqfiles+i)->flags);
		marshall_BYTE (sbp, (reqfiles+i)->ret_policy);
		marshall_BYTE (sbp, (reqfiles+i)->ac_latency);
	}
	(void) dpm_client_setSecurityOpts (CSEC_OPT_DELEG_FLAG);
	c = send2dpm (NULL, sendbuf, msglen, repbuf, sizeof(repbuf),
	    (void **)filestatuses, nbreplies);
	(void) dpm_client_setSecurityOpts (0);
	free (sendbuf);

	if (c == 0) {
		rbp = repbuf;
		unmarshall_LONG (rbp, c);
		if ((c & 0xF000) == DPM_FAILED) {
			serrno = c - DPM_FAILED;
			c = -1;
		}
		unmarshall_STRING (rbp, errstring);
		if (*errstring)
			dpm_errmsg (func, "%s\n", errstring);
		unmarshall_STRING (rbp, r_token);
	}
	return (c);
}
