/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGETENTRYPICKER_HEADER
#define LIFEOGRAPH_WIDGETENTRYPICKER_HEADER


#include <gtkmm.h>

#include "../diary.hpp"


namespace LIFEO
{

// TREESTORE FOR DIARY ELEMENT LISTS (NOT USED ANY MORE) ===========================================
/*class TreeStoreDiaryElem : public Gtk::TreeStore
{
    protected:
        TreeStoreDiaryElem();

    public:
        class Colrec : public Gtk::TreeModel::ColumnRecord
        {
            public:
                Colrec()
                {
                    add( icon );
                    add( name );
                    add( ptr );
                }
                Gtk::TreeModelColumn< Icon >            icon;
                Gtk::TreeModelColumn< Ustring >         name;
                Gtk::TreeModelColumn< DiaryElement* >   ptr;
        };

        Colrec colrec;

        static Glib::RefPtr< TreeStoreDiaryElem > create();
};*/

// COMPLETION POPOVER ==============================================================================
class EntryPickerCompletion
{
    public:
                                    EntryPickerCompletion( const Gtk::Widget&, bool = true );
                                    ~EntryPickerCompletion();

        void                        set_offer_new( bool flag_offer_new )
        { m_flag_offer_new = flag_offer_new; }

        void                        set_diary( Diary* diary )
        { m_ptr2diary = diary; }
        Diary*                      get_diary() const
        { return m_ptr2diary; }

        void                        add_item( Entry* );
        void                        add_new_item( const Ustring& );
        void                        clear();

        void                        popup( const Ustring& );
        void                        popup( const Gdk::Rectangle&, const Ustring& );
        void                        popdown();
        bool                        is_on_display() const
        { return m_Po->get_visible(); }
        void                        select_next();
        void                        select_prev();
        void                        update_list( const Ustring& );

        bool                        handle_key( guint );

        SignalVoidEntry             signal_entry_activated()
        { return m_Sg_entry_activated; }

        Entry*                      get_selected() const;

    protected:
        Gtk::Popover*               m_Po{ nullptr };
        Gtk::ListBox*               m_LB;

        VecEntries                  m_items;

        SignalVoidEntry             m_Sg_entry_activated;

        Diary*                      m_ptr2diary{ nullptr };
        bool                        m_flag_offer_new;
};

// WIDGET FOR ENTERING ENTRY NAMES WITH AUTOCOMPLETION =============================================
class WidgetEntryPicker : public EntryClear
{
    public:
        WidgetEntryPicker( BaseObjectType*, const Glib::RefPtr< Gtk::Builder >& );
        WidgetEntryPicker( bool, const std::string& = "" );

        void                        set_offer_new( bool flag_offer_new )
        { m_completion.set_offer_new( flag_offer_new ); }

        void                        set_diary( Diary* diary )
        { m_completion.set_diary( diary ); }

        void                        set_text( const Ustring& text ) = delete;

        void                        set_entry( LIFEO::Entry* );
        void                        clear()
        { Gtk::Entry::set_text( "" ); }
        LIFEO::Entry*               get_entry()
        { return m_ptr2entry; }
        DEID                        get_entry_id()
        { return( m_ptr2entry ? m_ptr2entry->get_id() : DEID_UNSET ); }
        LIFEO::Entry*               get_entry_create( Diary* );

        SignalVoidEntry             signal_updated()
        { return m_Sg_updated; }

    protected:
        void                        initialize();

        void                        on_changed() override;
        bool                        on_key_press_event( GdkEventKey* ) override;
        bool                        on_drag_motion( const Glib::RefPtr< Gdk::DragContext >&,
                                                    int, int, guint ) override;
        bool                        on_drag_drop( const Glib::RefPtr< Gdk::DragContext >&,
                                                  int x, int y, guint time ) override;

        void                        handle_entry_selected( LIFEO::Entry* );

        LIFEO::Entry*               m_ptr2entry{ nullptr };

        EntryPickerCompletion       m_completion;

        SignalVoidEntry             m_Sg_updated;
};

// SIMPLE POPOVER FOR SELECTING AN ENTRY FROM A GROUP
void show_entry_selection_list( const VecEntries&,
                                std::function< void( LIFEO::Entry* ) >&&,
                                Gtk::Widget& );

} // end of namespace LIFEO

#endif
