{
    'Analysis': {
        'required': False,
        'type': 'list',
        'nullable': True,
        'schema': {
            'type': 'dict',
            'schema': {
                'id': {'type': 'string', 'nullable': True, 'default': None},
                'type': {'type': 'analysistype', 'coerce': 'toanalysistype', 'required': True},
                'paths': {'type': 'list', 'schema': {'type': 'string'}, 'nullable': True, 'default': None},
                'labels': {'type': 'list', 'schema': {'type': 'string'}, 'nullable': True, 'default': None},
                'persistence_id': {'type': 'string', 'default': 'Default'},
                'output_logline': {'type': 'boolean', 'default': False},
                'learn_mode': {'type': 'boolean'},
                'num_windows': {'type': 'integer', 'required': True, 'default': 50},
                'min_anomaly_score': {'type': 'float', 'required': False, 'default': 1.1},
                'min_variance': {'type': 'float', 'required': False, 'default': 0.98},
                'allow_missing_values': {'type': 'boolean', 'default': False},
                'check_interval': {'type': 'integer', 'default': 3600},
                'realert_interval': {'type': 'integer', 'default': 36000},
                'report_interval': {'type': 'integer', 'default': 10},
                'reset_after_report_flag': {'type': 'boolean', 'default': False},
                'path': {'type': 'string', 'nullable': True, 'default': 'Default'},
                'parallel_check_count': {'type': 'integer', 'required': True, 'default': 10},
                'record_count_before_event': {'type': 'integer', 'default': 1000},
                'use_path_match': {'type': 'boolean', 'default': True},
                'use_value_match': {'type': 'boolean', 'default': True},
                'min_rule_attributes': {'type': 'integer', 'default': 1},
                'max_rule_attributes': {'type': 'integer', 'default': 5},
                'max_hypotheses': {'type': 'integer', 'default': 1000},
                'hypothesis_max_delta_time': {'type': 'float', 'default': 5.0},
                'generation_probability': {'type': 'float', 'default': 1.0},
                'generation_factor': {'type': 'float', 'default': 1.0},
                'max_observations': {'type': 'integer', 'default': 500},
                'p0': {'type': 'float', 'default': 0.9},
                'alpha': {'type': 'float', 'default': 0.05},
                'candidates_size': {'type': 'integer', 'default': 10},
                'hypotheses_eval_delta_time': {'type': 'float', 'default': 120.0},
                'delta_time_to_discard_hypothesis': {'type': 'float', 'default': 180.0},
                'check_rules_flag': {'type': 'boolean', 'default': True},
                'constraint_list': {
                    'type': 'list', 'schema': {'type': 'string'}, 'nullable': True, 'default': None},
                'ignore_list': {
                    'type': 'list', 'schema': {'type': 'string'}, 'nullable': True, 'default': None},
                'id_path_list': {'type': 'list', 'default': []},
                'scoring_path_list': {
                    'type': 'list', 'schema': {'type': 'string'}, 'nullable': True, 'default': None},
                'unique_path_list': {
                    'type': 'list', 'schema': {'type': 'string'}, 'nullable': True, 'default': None},
                'prob_thresh': {'type': 'float', 'default': 0.05},
                'default_freqs': {'type': 'boolean', 'default': False},
                'skip_repetitions': {'type': 'boolean', 'default': False},
                'seq_len': {'type': 'integer', 'default': 3},
                'timeout': {'type': ['integer', 'float'], 'default': -1},
                'allow_missing_id': {'type': 'boolean', 'default': False},
                'window_size': {'type': ['integer', 'float'], 'default': 600},
                'confidence_factor': {'type': 'float', 'default': 0.33},
                'min_allowed_time_diff': {'type': 'float', 'default': 5.0},
                'lower_limit': {'type': ['integer', 'float']},
                'upper_limit': {'type': ['integer', 'float']},
                'idf': {'type': 'boolean', 'default': False},
                'norm': {'type': 'boolean', 'default': False},
                'add_normal': {'type': 'boolean', 'default': False},
                'check_empty_windows': {'type': 'boolean', 'default': False},
                'bin_size': {'type': 'integer'},
                'bin_count': {'type': 'integer'},
                'outlier_bins_flag': {'type': 'boolean', 'default': False},
                'modulo_value': {'type': 'integer'},
                'time_unit': {'type': 'integer'},
                'histogram_defs': {'type': 'list', 'schema': {'type': 'list', 'schema': {'type': 'string'}}},
                'bin_definition': {'type': 'string'},
                'tuple_transformation_function': {'type': 'string', 'allowed': ['demo'], 'nullable': True, 'default': None},
                'value_list': {
                    'type': 'list', 'schema': {'type': ['boolean', 'float', 'integer', 'string']}, 'nullable': True, 'default': None},
                'timestamp_path': {'type': 'string', 'nullable': True},
                'min_bin_elements': {'type': 'integer'},
                'min_bin_time': {'type': 'integer'},
                'debug_mode': {'type': 'boolean', 'default': False},
                # skipcq: PYL-W0511
                # TODO check which streams should be allowed
                'stream': {'type': 'string', 'allowed': ['sys.stdout', 'sys.stderr']},
                'separator': {'type': 'string'},
                'missing_value_string': {'type': 'string'},
                'subhandler_list': {'type': 'list', 'schema': {'type': 'string'}},
                'stop_when_handled_flag': {'type': 'boolean', 'default': False},
                'delete_components': {'type': 'boolean', 'default': True},
                'event_type': {'type': 'string'},
                'event_message': {'type': 'string'},
                'sub_rules': {'type': 'list', 'schema': {'type': 'string'}},
                'sub_rule': {'type': 'string'},
                'match_action': {'type': 'string', 'nullable': True, 'default': None},
                'rule_lookup_dict': {'type': 'dict'},
                'default_rule': {'type': 'string', 'nullable': True, 'default': None},
                'value': {'type': ['boolean', 'float', 'integer', 'string']},
                'regex': {'type': 'string'},
                'seconds_modulo': {'type': 'integer'},
                'limit_lookup_dict': {'type': 'dict', 'valuesrules': {'type': 'list', 'schema': {
                    'type': ['integer', 'float'], 'min': 0}}},
                'default_limit': {'type': 'list', 'schema': {'type': 'integer'}, 'nullable': True, 'default': None},
                'rule_id': {'type': 'string'},
                'min_time_delta': {'type': 'integer'},
                'max_time_delta': {'type': 'integer'},
                'artefact_match_parameters': {'type': 'list', 'schema': {'type': 'list', 'schema': {'type': 'string'}},
                                              'nullable': True, 'default': None},
                'action_id': {'type': 'string'},
                'artefact_a_rules': {'type': 'list', 'schema': {'type': 'string'}, 'nullable': True, 'default': None},
                'artefact_b_rules': {'type': 'list', 'schema': {'type': 'string'}, 'nullable': True, 'default': None},
                'ruleset': {'type': 'list', 'schema': {'type': 'string'}},
                'exit_on_error_flag': {'type': 'boolean', 'default': False},
                'allowlist_rules': {'type': 'list', 'schema': {'type': 'string'}},
                'parsed_atom_handler_lookup_list': {
                    'type': 'list', 'schema': {'type': 'list', 'schema': {'type': 'string', 'nullable': True}}},
                'default_parsed_atom_handler': {'type': 'string', 'nullable': True, 'default': None},
                'parsed_atom_handler_dict': {'type': 'dict', 'schema': {'id': {'type': 'string'}, 'type': {'type': 'string'}}},
                'min_num_vals': {'type': 'integer', 'default': 1000},
                'max_num_vals': {'type': 'integer', 'default': 1500},
                'save_values': {'type': 'boolean', 'default': True},
                'waiting_time': {'type': 'integer', 'default': 300},
                'num_sections_waiting_time': {'type': 'integer', 'default': 10},
                'event_type_detector': {'type': 'string'},
                'used_gof_test': {'type': 'string', 'allowed': ['CM', 'KS'], 'default': 'CM'},
                'gof_alpha': {'type': 'float', 'default': 0.05},
                's_gof_alpha': {'type': 'float', 'default': 0.05},
                's_gof_bt_alpha': {'type': 'float', 'default': 0.05},
                'd_alpha': {'type': 'float', 'default': 0.1},
                'd_bt_alpha': {'type': 'float', 'default': 0.1},
                'range_alpha': {'type': 'float', 'default': 0.05},
                'dw_alpha': {'type': 'float', 'default': 0.05},
                'div_thres': {'type': 'float', 'default': 0.3},
                'sim_thres': {'type': 'float', 'default': 0.1},
                'indicator_thres': {'type': 'float', 'default': 0.4},
                'num_init': {'type': 'integer', 'default': 100},
                'num_update': {'type': 'integer', 'default': 50},
                'num_update_unq': {'type': 'integer', 'default': 200},
                'num_s_gof_values': {'type': 'integer', 'default': 50},
                'num_s_gof_bt': {'type': 'integer', 'default': 30},
                'num_d_bt': {'type': 'integer', 'default': 30},
                'num_pause_discrete': {'type': 'integer', 'default': 5},
                'num_pause_others': {'type': 'integer', 'default': 2},
                'test_gof_int': {'type': 'boolean', 'default': True},
                'num_stop_update': {'type': 'boolean', 'default': False},
                'silence_output_without_confidence': {'type': 'boolean', 'default': False},
                'silence_output_except_indicator': {'type': 'boolean', 'default': True},
                'num_var_type_hist_ref': {'type': 'integer', 'default': 10},
                'num_update_var_type_hist_ref': {'type': 'integer', 'default': 10},
                'num_var_type_considered_ind': {'type': 'integer', 'default': 10},
                'num_stat_stop_update': {'type': 'integer', 'default': 200},
                'num_updates_until_var_reduction': {'type': 'integer', 'default': 20},
                'var_reduction_thres': {'type': 'float', 'default': 0.6},
                'num_skipped_ind_for_weights': {'type': 'integer', 'default': 1},
                'num_ind_for_weights': {'type': 'integer', 'default': 100},
                'used_multinomial_test': {'type': 'string', 'allowed': ['Approx', 'MT', 'Chi'], 'default': 'Chi'},
                'use_empiric_distr': {'type': 'boolean', 'default': True},
                'save_statistics': {'type': 'boolean', 'default': True},
                'split_reports_flag': {'type': 'boolean', 'default': False},
                'disc_div_thres': {'type': 'float', 'default': 0.3},
                'num_steps_create_new_rules': {'type': 'integer', 'default': -1},
                'num_upd_until_validation': {'type': 'integer', 'default': 20},
                'num_end_learning_phase': {'type': 'integer', 'default': -1},
                'check_cor_thres': {'type': 'float', 'default': 0.5},
                'check_cor_prob_thres': {'type': 'float', 'default': 1.0},
                'check_cor_num_thres': {'type': 'integer', 'default': 10},
                'min_values_cors_thres': {'type': 'integer', 'default': 5},
                'new_vals_alarm_thres': {'type': 'float', 'default': 3.5},
                'num_bt': {'type': 'integer', 'default': 30},
                'alpha_bt': {'type': 'float', 'default': 0.1},
                'used_homogeneity_test': {'type': 'string', 'allowed': ['Chi', 'MaxDist'], 'default': 'Chi'},
                'used_range_test': {'type': 'string', 'allowed': ['MeanSD', 'EmpiricQuantiles', 'MinMax'], 'default': 'MinMax'},
                'range_threshold': {'type': 'float', 'default': 1},
                'range_limits_factor': {'type': 'float', 'default': 1},
                'num_reinit_range': {'type': 'integer', 'default': 100},
                'alpha_chisquare_test': {'type': 'float', 'default': 0.05},
                'max_dist_rule_distr': {'type': 'float', 'default': 0.1},
                'used_presel_meth': {'type': 'list', 'schema': {'type': 'string', 'allowed': [
                    'matchDiscDistr', 'excludeDueDistr', 'matchDiscVals', 'random']}, 'nullable': True, 'default': None},
                'intersect_presel_meth': {'type': 'boolean', 'default': False},
                'percentage_random_cors': {'type': 'float', 'default': 0.20},
                'match_disc_vals_sim_tresh': {'type': 'float', 'default': 0.7},
                'exclude_due_distr_lower_limit': {'type': 'float', 'default': 0.4},
                'match_disc_distr_threshold': {'type': 'float', 'default': 0.5},
                'used_cor_meth': {'type': 'list', 'schema': {'type': 'string', 'allowed': ['Rel', 'WRel']},
                                  'nullable': True, 'default': None},
                'used_validate_cor_meth': {'type': 'list', 'schema': {'type': 'string', 'allowed': [
                    'coverVals', 'distinctDistr']}, 'nullable': True, 'default': None},
                'validate_cor_cover_vals_thres': {'type': 'float', 'default': 0.7},
                'validate_cor_distinct_thres': {'type': 'float', 'default': 0.05},
                'time_period_length': {'type': 'integer', 'min': 1, 'required': True, 'default': 86400},
                'max_time_diff': {'type': 'integer', 'min': 1, 'required': True, 'default': 360},
                'num_reduce_time_list': {'type': 'integer', 'min': 1, 'required': True, 'default': 10},
                'output_event_handlers': {'type': 'list', 'nullable': True, 'default': None},
                'suppress': {'type': 'boolean', 'default': False},
                'build_sum_over_values': {'type': 'boolean', 'default': False},
                'num_division_time_step': {'type': 'integer', 'default': 10},
                'num_min_time_history': {'type': 'integer', 'default': 20},
                'num_max_time_history': {'type': 'integer', 'default': 30},
                'num_results_bt': {'type': 'integer', 'default': 15},
                'round_time_interval_threshold': {'type': 'float', 'default': 0.02},
                'acf_threshold': {'type': 'float', 'default': 0.2},
                'acf_pause_interval_percentage': {'type': 'float', 'default': 0.2},
                'acf_auto_pause_interval': {'type': 'boolean', 'default': True},
                'acf_auto_pause_interval_num_min': {'type': 'integer', 'min': 1, 'required': True, 'default': 10},
                'num_log_lines_solidify_matrix': {'type': 'integer', 'default': 10000},
                'time_output_threshold': {'type': 'integer', 'default': 0},
                'anomaly_threshold': {'type': 'float', 'default': 0.05},
                'num_periods_tsa_ini': {'type': 'integer', 'default': 20},
                'allowed_id_tuples': {'type': 'list', 'schema': {'type': 'list', 'schema': {'type': 'string'}}, 'nullable': True,
                                      'default': None},
                'force_period_length': {'type': 'boolean', 'default': False},
                'set_period_length': {'type': 'integer', 'default': 604800},
                'min_log_lines_per_time_step': {'type': 'integer', 'default': 10},
                'empty_window_warnings': {'type': 'boolean', 'default': True},
                'early_exceeding_anomaly_output': {'type': 'boolean', 'default': False},
                'set_lower_limit': {'type': 'integer', 'min': 0, 'nullable': True, 'default': None},
                'set_upper_limit': {'type': 'integer', 'min': 0, 'nullable': True, 'default': None},
                'local_maximum_threshold': {'type': 'float', 'default': 0.2},
                'combine_values': {'type': 'boolean', 'nullable': True, 'default': True},
            }
        }
    }
}
