/***************************************************************************
                           csharelisr.h  -  description
                             -------------------
    begin                : Mon May 12 2003
    copyright            : (C) 2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSHARELIST_H
#define CSHARELIST_H

/**
  *@author Mathias Küster
  *
  * This generates the filelist, both in obsolete text, and XML
  * formats. The index.lst text file is used because CSearchIndex
  * does not store directory structure. index.lst is basically a text
  * filelist but with indexes to the file in CSearchIndex in place of
  * the file size.
  *
  * To handle partial list requests ($ADCGET list ...),
  * CShareTreeFolder was added, which forms a tree structure, rather
  * than attempting to parse index.lst.
  */

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/types.h>
#include <dclib/core/cmutex.h>

class CByteArray;
class CSearchIndex;
class CShareTreeFolder;

class CShareList {

public:
	/** */
	CShareList();
	/** */
	virtual ~CShareList();

	/** */
	bool Load();

	/** */
	void SetIndexBuffer( const CString & s );
	/**
	 * The share index buffer (contents of index.lst) is
	 * no longer kept in memory after being used
	 * so either Load() or SetIndexBuffer() must be used
	 * before creating the listings.
	 */
	void CreateList( CSearchIndex * si );
	/** */
	ulonglong GetShareSize() const;
	/** */
	unsigned long GetShareBufferSize( eShareBufferType type );
	/** */
	int GetShareBuffer( eShareBufferType type, CByteArray * sharebuffer, bool decompress = false );
	/** */
	void GetPartialListing( const CString & dir, CString & result, int depth, CSearchIndex * si );

private:
	/** */
	void CreateBuffer( enum eShareBufferType e, const CString & sharebuffer );
	/** */
	void Save();

	/** */
	ulonglong m_nShareSize;
	/** */
	CString m_sIndexShareBuffer;
	/** */
	CByteArray * m_pHE3ShareBuffer;
	/** */
	CByteArray * m_pBZShareBuffer;
	/** */
	CByteArray * m_pXMLBZShareBuffer;
	/** */
	CMutex m_MutexShareList;
	
	/** */
	CShareTreeFolder * m_pRootItem;
};

#endif
