/* vfs-volume-impl-gnome-vfs.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-volume-impl-gnome-vfs.vala, do not modify */

/*
 * Desktop Agnostic Library: VFS Volume implementation (GNOME VFS).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libdesktop-agnostic/vfs.h>
#include <libgnomevfs/gnome-vfs.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_RESULT (desktop_agnostic_vfs_volume_result_get_type ())
typedef struct _DesktopAgnosticVFSVolumeResult DesktopAgnosticVFSVolumeResult;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS (desktop_agnostic_vfs_volume_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS, DesktopAgnosticVFSVolumeGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS, DesktopAgnosticVFSVolumeGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS, DesktopAgnosticVFSVolumeGnomeVFSClass))

typedef struct _DesktopAgnosticVFSVolumeGnomeVFS DesktopAgnosticVFSVolumeGnomeVFS;
typedef struct _DesktopAgnosticVFSVolumeGnomeVFSClass DesktopAgnosticVFSVolumeGnomeVFSClass;
typedef struct _DesktopAgnosticVFSVolumeGnomeVFSPrivate DesktopAgnosticVFSVolumeGnomeVFSPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _desktop_agnostic_vfs_volume_result_free0(var) ((var == NULL) ? NULL : (var = (desktop_agnostic_vfs_volume_result_free (var), NULL)))

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS (desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS, DesktopAgnosticVFSVolumeMonitorGnomeVFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS, DesktopAgnosticVFSVolumeMonitorGnomeVFSClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_GNOME_VFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_GNOME_VFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS, DesktopAgnosticVFSVolumeMonitorGnomeVFSClass))

typedef struct _DesktopAgnosticVFSVolumeMonitorGnomeVFS DesktopAgnosticVFSVolumeMonitorGnomeVFS;
typedef struct _DesktopAgnosticVFSVolumeMonitorGnomeVFSClass DesktopAgnosticVFSVolumeMonitorGnomeVFSClass;
typedef struct _DesktopAgnosticVFSVolumeMonitorGnomeVFSPrivate DesktopAgnosticVFSVolumeMonitorGnomeVFSPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

struct _DesktopAgnosticVFSVolumeResult {
	gboolean succeeded;
	char* error;
	char* detailed_error;
};

struct _DesktopAgnosticVFSVolumeGnomeVFS {
	GObject parent_instance;
	DesktopAgnosticVFSVolumeGnomeVFSPrivate * priv;
};

struct _DesktopAgnosticVFSVolumeGnomeVFSClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSVolumeGnomeVFSPrivate {
	GnomeVFSDrive* drive;
	DesktopAgnosticVFSFile* _uri;
	DesktopAgnosticVFSVolumeResult* result;
	DesktopAgnosticVFSVolumeCallback _mount_callback;
	gpointer _mount_callback_target;
	GDestroyNotify _mount_callback_target_destroy_notify;
	DesktopAgnosticVFSVolumeCallback _unmount_callback;
	gpointer _unmount_callback_target;
	GDestroyNotify _unmount_callback_target_destroy_notify;
	DesktopAgnosticVFSVolumeCallback _eject_callback;
	gpointer _eject_callback_target;
	GDestroyNotify _eject_callback_target_destroy_notify;
};

struct _DesktopAgnosticVFSVolumeMonitorGnomeVFS {
	GObject parent_instance;
	DesktopAgnosticVFSVolumeMonitorGnomeVFSPrivate * priv;
};

struct _DesktopAgnosticVFSVolumeMonitorGnomeVFSClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSVolumeMonitorGnomeVFSPrivate {
	GnomeVFSVolumeMonitor* monitor;
	GHashTable* _volumes;
};


static gpointer desktop_agnostic_vfs_volume_gnome_vfs_parent_class = NULL;
static DesktopAgnosticVFSVolumeIface* desktop_agnostic_vfs_volume_gnome_vfs_desktop_agnostic_vfs_volume_parent_iface = NULL;
static gpointer desktop_agnostic_vfs_volume_monitor_gnome_vfs_parent_class = NULL;
static DesktopAgnosticVFSVolumeMonitorIface* desktop_agnostic_vfs_volume_monitor_gnome_vfs_desktop_agnostic_vfs_volume_monitor_parent_iface = NULL;

GType desktop_agnostic_vfs_volume_result_get_type (void) G_GNUC_CONST;
DesktopAgnosticVFSVolumeResult* desktop_agnostic_vfs_volume_result_dup (const DesktopAgnosticVFSVolumeResult* self);
void desktop_agnostic_vfs_volume_result_free (DesktopAgnosticVFSVolumeResult* self);
void desktop_agnostic_vfs_volume_result_copy (const DesktopAgnosticVFSVolumeResult* self, DesktopAgnosticVFSVolumeResult* dest);
void desktop_agnostic_vfs_volume_result_destroy (DesktopAgnosticVFSVolumeResult* self);
GType desktop_agnostic_vfs_volume_gnome_vfs_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS, DesktopAgnosticVFSVolumeGnomeVFSPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_IMPLEMENTATION,
	DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_NAME,
	DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_URI,
	DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_ICON
};
static gboolean desktop_agnostic_vfs_volume_gnome_vfs_real_is_mounted (DesktopAgnosticVFSVolume* base);
static void desktop_agnostic_vfs_volume_gnome_vfs_on_drive_mounted (DesktopAgnosticVFSVolumeGnomeVFS* self, gboolean succeeded, const char* _error_, const char* detailed_error);
static void desktop_agnostic_vfs_volume_gnome_vfs_real_mount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
static gboolean desktop_agnostic_vfs_volume_gnome_vfs_real_mount_finish (DesktopAgnosticVFSVolume* base, GError** error);
static void desktop_agnostic_vfs_volume_gnome_vfs_on_drive_unmounted (DesktopAgnosticVFSVolumeGnomeVFS* self, gboolean succeeded, const char* _error_, const char* detailed_error);
static void desktop_agnostic_vfs_volume_gnome_vfs_real_unmount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
static gboolean desktop_agnostic_vfs_volume_gnome_vfs_real_unmount_finish (DesktopAgnosticVFSVolume* base, GError** error);
static gboolean desktop_agnostic_vfs_volume_gnome_vfs_real_can_eject (DesktopAgnosticVFSVolume* base);
static void desktop_agnostic_vfs_volume_gnome_vfs_on_drive_ejected (DesktopAgnosticVFSVolumeGnomeVFS* self, gboolean succeeded, const char* _error_, const char* detailed_error);
static void desktop_agnostic_vfs_volume_gnome_vfs_real_eject (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
static gboolean desktop_agnostic_vfs_volume_gnome_vfs_real_eject_finish (DesktopAgnosticVFSVolume* base, GError** error);
DesktopAgnosticVFSVolumeGnomeVFS* desktop_agnostic_vfs_volume_gnome_vfs_new (void);
DesktopAgnosticVFSVolumeGnomeVFS* desktop_agnostic_vfs_volume_gnome_vfs_construct (GType object_type);
static void desktop_agnostic_vfs_volume_gnome_vfs_set_implementation (DesktopAgnosticVFSVolumeGnomeVFS* self, GnomeVFSDrive* value);
static void desktop_agnostic_vfs_volume_gnome_vfs_finalize (GObject* obj);
static void desktop_agnostic_vfs_volume_gnome_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_vfs_volume_gnome_vfs_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS, DesktopAgnosticVFSVolumeMonitorGnomeVFSPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_IMPLEMENTATION,
	DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_VOLUMES
};
static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gnome_vfs_create_volume (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSDrive* drive);
static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gnome_vfs_check_volume (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSDrive* drive);
static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_connected (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSVolumeMonitor* vmonitor, GnomeVFSDrive* drive);
static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_disconnected (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSVolumeMonitor* vmonitor, GnomeVFSDrive* drive);
static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_volume (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSVolume* gvol);
static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_mounted (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSVolumeMonitor* vmonitor, GnomeVFSVolume* gvol);
static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_unmounted (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSVolumeMonitor* vmonitor, GnomeVFSVolume* gvol);
DesktopAgnosticVFSVolumeMonitorGnomeVFS* desktop_agnostic_vfs_volume_monitor_gnome_vfs_new (void);
DesktopAgnosticVFSVolumeMonitorGnomeVFS* desktop_agnostic_vfs_volume_monitor_gnome_vfs_construct (GType object_type);
static void _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_connected_gnome_vfs_volume_monitor_drive_connected (GnomeVFSVolumeMonitor* _sender, GnomeVFSDrive* drive, gpointer self);
static void _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_disconnected_gnome_vfs_volume_monitor_drive_disconnected (GnomeVFSVolumeMonitor* _sender, GnomeVFSDrive* drive, gpointer self);
static void _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_mounted_gnome_vfs_volume_monitor_volume_mounted (GnomeVFSVolumeMonitor* _sender, GnomeVFSVolume* volume, gpointer self);
static void _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_unmounted_gnome_vfs_volume_monitor_volume_unmounted (GnomeVFSVolumeMonitor* _sender, GnomeVFSVolume* volume, gpointer self);
static void _g_list_free_g_object_unref (GList* self);
static GObject * desktop_agnostic_vfs_volume_monitor_gnome_vfs_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_finalize (GObject* obj);
static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



void desktop_agnostic_vfs_volume_result_copy (const DesktopAgnosticVFSVolumeResult* self, DesktopAgnosticVFSVolumeResult* dest) {
	dest->succeeded = self->succeeded;
	dest->error = g_strdup (self->error);
	dest->detailed_error = g_strdup (self->detailed_error);
}


void desktop_agnostic_vfs_volume_result_destroy (DesktopAgnosticVFSVolumeResult* self) {
	_g_free0 (self->error);
	_g_free0 (self->detailed_error);
}


DesktopAgnosticVFSVolumeResult* desktop_agnostic_vfs_volume_result_dup (const DesktopAgnosticVFSVolumeResult* self) {
	DesktopAgnosticVFSVolumeResult* dup;
	dup = g_new0 (DesktopAgnosticVFSVolumeResult, 1);
	desktop_agnostic_vfs_volume_result_copy (self, dup);
	return dup;
}


void desktop_agnostic_vfs_volume_result_free (DesktopAgnosticVFSVolumeResult* self) {
	desktop_agnostic_vfs_volume_result_destroy (self);
	g_free (self);
}


GType desktop_agnostic_vfs_volume_result_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_volume_result_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_volume_result_type_id__volatile)) {
		GType desktop_agnostic_vfs_volume_result_type_id;
		desktop_agnostic_vfs_volume_result_type_id = g_boxed_type_register_static ("DesktopAgnosticVFSVolumeResult", (GBoxedCopyFunc) desktop_agnostic_vfs_volume_result_dup, (GBoxedFreeFunc) desktop_agnostic_vfs_volume_result_free);
		g_once_init_leave (&desktop_agnostic_vfs_volume_result_type_id__volatile, desktop_agnostic_vfs_volume_result_type_id);
	}
	return desktop_agnostic_vfs_volume_result_type_id__volatile;
}


static gboolean desktop_agnostic_vfs_volume_gnome_vfs_real_is_mounted (DesktopAgnosticVFSVolume* base) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	result = gnome_vfs_drive_is_mounted (self->priv->drive);
	return result;
}


static gpointer _desktop_agnostic_vfs_volume_result_dup0 (gpointer self) {
	return self ? desktop_agnostic_vfs_volume_result_dup (self) : NULL;
}


static void desktop_agnostic_vfs_volume_gnome_vfs_on_drive_mounted (DesktopAgnosticVFSVolumeGnomeVFS* self, gboolean succeeded, const char* _error_, const char* detailed_error) {
	DesktopAgnosticVFSVolumeResult _tmp0_ = {0};
	DesktopAgnosticVFSVolumeResult _tmp1_;
	DesktopAgnosticVFSVolumeResult _tmp2_;
	DesktopAgnosticVFSVolumeResult* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	DesktopAgnosticVFSVolumeCallback _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_error_ != NULL);
	g_return_if_fail (detailed_error != NULL);
	self->priv->result = (_tmp3_ = _desktop_agnostic_vfs_volume_result_dup0 ((_tmp2_ = _tmp1_ = (memset (&_tmp0_, 0, sizeof (DesktopAgnosticVFSVolumeResult)), _tmp0_), &_tmp2_)), _desktop_agnostic_vfs_volume_result_free0 (self->priv->result), _tmp3_);
	desktop_agnostic_vfs_volume_result_destroy (&_tmp1_);
	(*self->priv->result).succeeded = succeeded;
	(*self->priv->result).error = (_tmp4_ = g_strdup (_error_), _g_free0 ((*self->priv->result).error), _tmp4_);
	(*self->priv->result).detailed_error = (_tmp5_ = g_strdup (detailed_error), _g_free0 ((*self->priv->result).detailed_error), _tmp5_);
	self->priv->_mount_callback (self->priv->_mount_callback_target);
	self->priv->_mount_callback = (_tmp6_ = NULL, ((self->priv->_mount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_mount_callback_target_destroy_notify (self->priv->_mount_callback_target), NULL), self->priv->_mount_callback = NULL, self->priv->_mount_callback_target = NULL, self->priv->_mount_callback_target_destroy_notify = NULL), self->priv->_mount_callback_target = NULL, self->priv->_mount_callback_target_destroy_notify = NULL, _tmp6_);
}


static void desktop_agnostic_vfs_volume_gnome_vfs_real_mount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	if (self->priv->_mount_callback == NULL) {
		DesktopAgnosticVFSVolumeCallback _tmp0_;
		self->priv->_mount_callback = (_tmp0_ = callback, ((self->priv->_mount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_mount_callback_target_destroy_notify (self->priv->_mount_callback_target), NULL), self->priv->_mount_callback = NULL, self->priv->_mount_callback_target = NULL, self->priv->_mount_callback_target_destroy_notify = NULL), self->priv->_mount_callback_target = callback_target, self->priv->_mount_callback_target_destroy_notify = NULL, _tmp0_);
		gnome_vfs_drive_mount (self->priv->drive, (GnomeVFSVolumeOpCallback) desktop_agnostic_vfs_volume_gnome_vfs_on_drive_mounted, NULL);
	}
}


static gboolean desktop_agnostic_vfs_volume_gnome_vfs_real_mount_finish (DesktopAgnosticVFSVolume* base, GError** error) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	gboolean result = FALSE;
	gboolean _result_;
	DesktopAgnosticVFSVolumeResult* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	_result_ = (*self->priv->result).succeeded;
	if (!_result_) {
		char* msg;
		DesktopAgnosticVFSVolumeResult* _tmp0_;
		msg = g_strdup_printf ("%s (%s)", (*self->priv->result).error, (*self->priv->result).detailed_error);
		self->priv->result = (_tmp0_ = NULL, _desktop_agnostic_vfs_volume_result_free0 (self->priv->result), _tmp0_);
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR, DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_MOUNT, msg);
		{
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_g_free0 (msg);
	}
	self->priv->result = (_tmp1_ = NULL, _desktop_agnostic_vfs_volume_result_free0 (self->priv->result), _tmp1_);
	result = _result_;
	return result;
}


static void desktop_agnostic_vfs_volume_gnome_vfs_on_drive_unmounted (DesktopAgnosticVFSVolumeGnomeVFS* self, gboolean succeeded, const char* _error_, const char* detailed_error) {
	DesktopAgnosticVFSVolumeResult _tmp0_ = {0};
	DesktopAgnosticVFSVolumeResult _tmp1_;
	DesktopAgnosticVFSVolumeResult _tmp2_;
	DesktopAgnosticVFSVolumeResult* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	DesktopAgnosticVFSVolumeCallback _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_error_ != NULL);
	g_return_if_fail (detailed_error != NULL);
	self->priv->result = (_tmp3_ = _desktop_agnostic_vfs_volume_result_dup0 ((_tmp2_ = _tmp1_ = (memset (&_tmp0_, 0, sizeof (DesktopAgnosticVFSVolumeResult)), _tmp0_), &_tmp2_)), _desktop_agnostic_vfs_volume_result_free0 (self->priv->result), _tmp3_);
	desktop_agnostic_vfs_volume_result_destroy (&_tmp1_);
	(*self->priv->result).succeeded = succeeded;
	(*self->priv->result).error = (_tmp4_ = g_strdup (_error_), _g_free0 ((*self->priv->result).error), _tmp4_);
	(*self->priv->result).detailed_error = (_tmp5_ = g_strdup (detailed_error), _g_free0 ((*self->priv->result).detailed_error), _tmp5_);
	self->priv->_unmount_callback (self->priv->_unmount_callback_target);
	self->priv->_unmount_callback = (_tmp6_ = NULL, ((self->priv->_unmount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_unmount_callback_target_destroy_notify (self->priv->_unmount_callback_target), NULL), self->priv->_unmount_callback = NULL, self->priv->_unmount_callback_target = NULL, self->priv->_unmount_callback_target_destroy_notify = NULL), self->priv->_unmount_callback_target = NULL, self->priv->_unmount_callback_target_destroy_notify = NULL, _tmp6_);
}


static void desktop_agnostic_vfs_volume_gnome_vfs_real_unmount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	if (self->priv->_unmount_callback == NULL) {
		DesktopAgnosticVFSVolumeCallback _tmp0_;
		self->priv->_unmount_callback = (_tmp0_ = callback, ((self->priv->_unmount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_unmount_callback_target_destroy_notify (self->priv->_unmount_callback_target), NULL), self->priv->_unmount_callback = NULL, self->priv->_unmount_callback_target = NULL, self->priv->_unmount_callback_target_destroy_notify = NULL), self->priv->_unmount_callback_target = callback_target, self->priv->_unmount_callback_target_destroy_notify = NULL, _tmp0_);
		gnome_vfs_drive_unmount (self->priv->drive, (GnomeVFSVolumeOpCallback) desktop_agnostic_vfs_volume_gnome_vfs_on_drive_unmounted, NULL);
	}
}


static gboolean desktop_agnostic_vfs_volume_gnome_vfs_real_unmount_finish (DesktopAgnosticVFSVolume* base, GError** error) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	gboolean result = FALSE;
	gboolean _result_;
	DesktopAgnosticVFSVolumeResult* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	_result_ = (*self->priv->result).succeeded;
	if (!_result_) {
		char* msg;
		DesktopAgnosticVFSVolumeResult* _tmp0_;
		msg = g_strdup_printf ("%s (%s)", (*self->priv->result).error, (*self->priv->result).detailed_error);
		self->priv->result = (_tmp0_ = NULL, _desktop_agnostic_vfs_volume_result_free0 (self->priv->result), _tmp0_);
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR, DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_UNMOUNT, msg);
		{
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_g_free0 (msg);
	}
	self->priv->result = (_tmp1_ = NULL, _desktop_agnostic_vfs_volume_result_free0 (self->priv->result), _tmp1_);
	result = _result_;
	return result;
}


static gboolean desktop_agnostic_vfs_volume_gnome_vfs_real_can_eject (DesktopAgnosticVFSVolume* base) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	result = TRUE;
	return result;
}


static void desktop_agnostic_vfs_volume_gnome_vfs_on_drive_ejected (DesktopAgnosticVFSVolumeGnomeVFS* self, gboolean succeeded, const char* _error_, const char* detailed_error) {
	DesktopAgnosticVFSVolumeResult _tmp0_ = {0};
	DesktopAgnosticVFSVolumeResult _tmp1_;
	DesktopAgnosticVFSVolumeResult _tmp2_;
	DesktopAgnosticVFSVolumeResult* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	DesktopAgnosticVFSVolumeCallback _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_error_ != NULL);
	g_return_if_fail (detailed_error != NULL);
	self->priv->result = (_tmp3_ = _desktop_agnostic_vfs_volume_result_dup0 ((_tmp2_ = _tmp1_ = (memset (&_tmp0_, 0, sizeof (DesktopAgnosticVFSVolumeResult)), _tmp0_), &_tmp2_)), _desktop_agnostic_vfs_volume_result_free0 (self->priv->result), _tmp3_);
	desktop_agnostic_vfs_volume_result_destroy (&_tmp1_);
	(*self->priv->result).succeeded = succeeded;
	(*self->priv->result).error = (_tmp4_ = g_strdup (_error_), _g_free0 ((*self->priv->result).error), _tmp4_);
	(*self->priv->result).detailed_error = (_tmp5_ = g_strdup (detailed_error), _g_free0 ((*self->priv->result).detailed_error), _tmp5_);
	self->priv->_eject_callback (self->priv->_eject_callback_target);
	self->priv->_eject_callback = (_tmp6_ = NULL, ((self->priv->_eject_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_eject_callback_target_destroy_notify (self->priv->_eject_callback_target), NULL), self->priv->_eject_callback = NULL, self->priv->_eject_callback_target = NULL, self->priv->_eject_callback_target_destroy_notify = NULL), self->priv->_eject_callback_target = NULL, self->priv->_eject_callback_target_destroy_notify = NULL, _tmp6_);
}


static void desktop_agnostic_vfs_volume_gnome_vfs_real_eject (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	if (self->priv->_eject_callback == NULL) {
		DesktopAgnosticVFSVolumeCallback _tmp0_;
		self->priv->_eject_callback = (_tmp0_ = callback, ((self->priv->_eject_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_eject_callback_target_destroy_notify (self->priv->_eject_callback_target), NULL), self->priv->_eject_callback = NULL, self->priv->_eject_callback_target = NULL, self->priv->_eject_callback_target_destroy_notify = NULL), self->priv->_eject_callback_target = callback_target, self->priv->_eject_callback_target_destroy_notify = NULL, _tmp0_);
		gnome_vfs_drive_eject (self->priv->drive, (GnomeVFSVolumeOpCallback) desktop_agnostic_vfs_volume_gnome_vfs_on_drive_ejected, NULL);
	}
}


static gboolean desktop_agnostic_vfs_volume_gnome_vfs_real_eject_finish (DesktopAgnosticVFSVolume* base, GError** error) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	gboolean result = FALSE;
	gboolean _result_;
	DesktopAgnosticVFSVolumeResult* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	_result_ = (*self->priv->result).succeeded;
	if (!_result_) {
		char* msg;
		DesktopAgnosticVFSVolumeResult* _tmp0_;
		msg = g_strdup_printf ("%s (%s)", (*self->priv->result).error, (*self->priv->result).detailed_error);
		self->priv->result = (_tmp0_ = NULL, _desktop_agnostic_vfs_volume_result_free0 (self->priv->result), _tmp0_);
		_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR, DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_EJECT, msg);
		{
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				return FALSE;
			} else {
				_g_free0 (msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_g_free0 (msg);
	}
	self->priv->result = (_tmp1_ = NULL, _desktop_agnostic_vfs_volume_result_free0 (self->priv->result), _tmp1_);
	result = _result_;
	return result;
}


DesktopAgnosticVFSVolumeGnomeVFS* desktop_agnostic_vfs_volume_gnome_vfs_construct (GType object_type) {
	DesktopAgnosticVFSVolumeGnomeVFS * self = NULL;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSVolumeGnomeVFS* desktop_agnostic_vfs_volume_gnome_vfs_new (void) {
	return desktop_agnostic_vfs_volume_gnome_vfs_construct (DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_vfs_volume_gnome_vfs_set_implementation (DesktopAgnosticVFSVolumeGnomeVFS* self, GnomeVFSDrive* value) {
	GnomeVFSDrive* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->drive = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->drive), _tmp0_);
	g_object_notify ((GObject *) self, "implementation");
}


static const char* desktop_agnostic_vfs_volume_gnome_vfs_real_get_name (DesktopAgnosticVFSVolume* base) {
	const char* result;
	DesktopAgnosticVFSVolumeGnomeVFS* self;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	result = gnome_vfs_drive_get_display_name (self->priv->drive);
	return result;
}


static DesktopAgnosticVFSFile* desktop_agnostic_vfs_volume_gnome_vfs_real_get_uri (DesktopAgnosticVFSVolume* base) {
	DesktopAgnosticVFSFile* result;
	DesktopAgnosticVFSVolumeGnomeVFS* self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	if (self->priv->_uri == NULL) {
		char* activation_uri;
		DesktopAgnosticVFSFile* _tmp0_;
		DesktopAgnosticVFSFile* _tmp1_;
		activation_uri = g_strdup (gnome_vfs_drive_get_activation_uri (self->priv->drive));
		_tmp0_ = desktop_agnostic_vfs_file_new_for_uri (activation_uri, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (activation_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		self->priv->_uri = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->_uri), _tmp1_);
		_g_free0 (activation_uri);
	}
	result = self->priv->_uri;
	return result;
}


static char* desktop_agnostic_vfs_volume_gnome_vfs_real_get_icon (DesktopAgnosticVFSVolume* base) {
	char* result;
	DesktopAgnosticVFSVolumeGnomeVFS* self;
	self = (DesktopAgnosticVFSVolumeGnomeVFS*) base;
	result = g_strdup (gnome_vfs_drive_get_icon (self->priv->drive));
	return result;
}


static void desktop_agnostic_vfs_volume_gnome_vfs_class_init (DesktopAgnosticVFSVolumeGnomeVFSClass * klass) {
	desktop_agnostic_vfs_volume_gnome_vfs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSVolumeGnomeVFSPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_volume_gnome_vfs_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_vfs_volume_gnome_vfs_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_volume_gnome_vfs_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_IMPLEMENTATION, g_param_spec_object ("implementation", "implementation", "implementation", GNOME_VFS_TYPE_DRIVE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_ICON, "icon");
}


static void desktop_agnostic_vfs_volume_gnome_vfs_desktop_agnostic_vfs_volume_interface_init (DesktopAgnosticVFSVolumeIface * iface) {
	desktop_agnostic_vfs_volume_gnome_vfs_desktop_agnostic_vfs_volume_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_mounted = desktop_agnostic_vfs_volume_gnome_vfs_real_is_mounted;
	iface->mount = desktop_agnostic_vfs_volume_gnome_vfs_real_mount;
	iface->mount_finish = desktop_agnostic_vfs_volume_gnome_vfs_real_mount_finish;
	iface->unmount = desktop_agnostic_vfs_volume_gnome_vfs_real_unmount;
	iface->unmount_finish = desktop_agnostic_vfs_volume_gnome_vfs_real_unmount_finish;
	iface->can_eject = desktop_agnostic_vfs_volume_gnome_vfs_real_can_eject;
	iface->eject = desktop_agnostic_vfs_volume_gnome_vfs_real_eject;
	iface->eject_finish = desktop_agnostic_vfs_volume_gnome_vfs_real_eject_finish;
	iface->get_name = desktop_agnostic_vfs_volume_gnome_vfs_real_get_name;
	iface->get_uri = desktop_agnostic_vfs_volume_gnome_vfs_real_get_uri;
	iface->get_icon = desktop_agnostic_vfs_volume_gnome_vfs_real_get_icon;
}


static void desktop_agnostic_vfs_volume_gnome_vfs_instance_init (DesktopAgnosticVFSVolumeGnomeVFS * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_volume_gnome_vfs_finalize (GObject* obj) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS (obj);
	_g_object_unref0 (self->priv->drive);
	_g_object_unref0 (self->priv->_uri);
	_desktop_agnostic_vfs_volume_result_free0 (self->priv->result);
	(self->priv->_mount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_mount_callback_target_destroy_notify (self->priv->_mount_callback_target), NULL);
	self->priv->_mount_callback = NULL;
	self->priv->_mount_callback_target = NULL;
	self->priv->_mount_callback_target_destroy_notify = NULL;
	(self->priv->_unmount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_unmount_callback_target_destroy_notify (self->priv->_unmount_callback_target), NULL);
	self->priv->_unmount_callback = NULL;
	self->priv->_unmount_callback_target = NULL;
	self->priv->_unmount_callback_target_destroy_notify = NULL;
	(self->priv->_eject_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_eject_callback_target_destroy_notify (self->priv->_eject_callback_target), NULL);
	self->priv->_eject_callback = NULL;
	self->priv->_eject_callback_target = NULL;
	self->priv->_eject_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (desktop_agnostic_vfs_volume_gnome_vfs_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_volume_gnome_vfs_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_volume_gnome_vfs_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_volume_gnome_vfs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSVolumeGnomeVFSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_volume_gnome_vfs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSVolumeGnomeVFS), 0, (GInstanceInitFunc) desktop_agnostic_vfs_volume_gnome_vfs_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_volume_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_volume_gnome_vfs_desktop_agnostic_vfs_volume_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_volume_gnome_vfs_type_id;
		desktop_agnostic_vfs_volume_gnome_vfs_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSVolumeGnomeVFS", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_volume_gnome_vfs_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME, &desktop_agnostic_vfs_volume_info);
		g_once_init_leave (&desktop_agnostic_vfs_volume_gnome_vfs_type_id__volatile, desktop_agnostic_vfs_volume_gnome_vfs_type_id);
	}
	return desktop_agnostic_vfs_volume_gnome_vfs_type_id__volatile;
}


static void desktop_agnostic_vfs_volume_gnome_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_NAME:
		g_value_set_string (value, desktop_agnostic_vfs_volume_get_name ((DesktopAgnosticVFSVolume*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_URI:
		g_value_set_object (value, desktop_agnostic_vfs_volume_get_uri ((DesktopAgnosticVFSVolume*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_ICON:
		g_value_take_string (value, desktop_agnostic_vfs_volume_get_icon ((DesktopAgnosticVFSVolume*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_vfs_volume_gnome_vfs_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSVolumeGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_VOLUME_GNOME_VFS_IMPLEMENTATION:
		desktop_agnostic_vfs_volume_gnome_vfs_set_implementation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gnome_vfs_create_volume (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSDrive* drive) {
	DesktopAgnosticVFSVolume* result = NULL;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (drive != NULL, NULL);
	result = DESKTOP_AGNOSTIC_VFS_VOLUME ((_tmp0_ = g_object_new (DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GNOME_VFS, "implementation", drive, NULL), G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_));
	return result;
}


static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gnome_vfs_check_volume (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSDrive* drive) {
	DesktopAgnosticVFSVolume* result = NULL;
	DesktopAgnosticVFSVolume* vol;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (drive != NULL, NULL);
	vol = _g_object_ref0 ((DesktopAgnosticVFSVolume*) g_hash_table_lookup (self->priv->_volumes, drive));
	if (vol == NULL) {
		DesktopAgnosticVFSVolume* _tmp0_;
		vol = (_tmp0_ = desktop_agnostic_vfs_volume_monitor_gnome_vfs_create_volume (self, drive), _g_object_unref0 (vol), _tmp0_);
		g_hash_table_insert (self->priv->_volumes, _g_object_ref0 (drive), _g_object_ref0 (vol));
	}
	result = vol;
	return result;
}


static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_connected (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSVolumeMonitor* vmonitor, GnomeVFSDrive* drive) {
	DesktopAgnosticVFSVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vmonitor != NULL);
	g_return_if_fail (drive != NULL);
	_tmp0_ = desktop_agnostic_vfs_volume_monitor_gnome_vfs_check_volume (self, drive);
	_g_object_unref0 (_tmp0_);
}


static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_disconnected (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSVolumeMonitor* vmonitor, GnomeVFSDrive* drive) {
	DesktopAgnosticVFSVolume* vol;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vmonitor != NULL);
	g_return_if_fail (drive != NULL);
	vol = _g_object_ref0 ((DesktopAgnosticVFSVolume*) g_hash_table_lookup (self->priv->_volumes, drive));
	if (vol != NULL) {
		g_hash_table_remove (self->priv->_volumes, drive);
	}
	_g_object_unref0 (vol);
}


static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_volume (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSVolume* gvol) {
	DesktopAgnosticVFSVolume* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gvol != NULL, NULL);
	result = desktop_agnostic_vfs_volume_monitor_gnome_vfs_check_volume (self, gnome_vfs_volume_get_drive (gvol));
	return result;
}


static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_mounted (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSVolumeMonitor* vmonitor, GnomeVFSVolume* gvol) {
	DesktopAgnosticVFSVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vmonitor != NULL);
	g_return_if_fail (gvol != NULL);
	g_signal_emit_by_name ((DesktopAgnosticVFSVolumeMonitor*) self, "volume-mounted", _tmp0_ = desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_volume (self, gvol));
	_g_object_unref0 (_tmp0_);
}


static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_unmounted (DesktopAgnosticVFSVolumeMonitorGnomeVFS* self, GnomeVFSVolumeMonitor* vmonitor, GnomeVFSVolume* gvol) {
	DesktopAgnosticVFSVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vmonitor != NULL);
	g_return_if_fail (gvol != NULL);
	g_signal_emit_by_name ((DesktopAgnosticVFSVolumeMonitor*) self, "volume-unmounted", _tmp0_ = desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_volume (self, gvol));
	_g_object_unref0 (_tmp0_);
}


DesktopAgnosticVFSVolumeMonitorGnomeVFS* desktop_agnostic_vfs_volume_monitor_gnome_vfs_construct (GType object_type) {
	DesktopAgnosticVFSVolumeMonitorGnomeVFS * self = NULL;
	self = (DesktopAgnosticVFSVolumeMonitorGnomeVFS*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSVolumeMonitorGnomeVFS* desktop_agnostic_vfs_volume_monitor_gnome_vfs_new (void) {
	return desktop_agnostic_vfs_volume_monitor_gnome_vfs_construct (DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GNOME_VFS);
}


static void* desktop_agnostic_vfs_volume_monitor_gnome_vfs_real_get_implementation (DesktopAgnosticVFSVolumeMonitor* base) {
	void* result;
	DesktopAgnosticVFSVolumeMonitorGnomeVFS* self;
	self = (DesktopAgnosticVFSVolumeMonitorGnomeVFS*) base;
	result = (void*) self->priv->monitor;
	return result;
}


static GList* desktop_agnostic_vfs_volume_monitor_gnome_vfs_real_get_volumes (DesktopAgnosticVFSVolumeMonitor* base) {
	GList* result;
	DesktopAgnosticVFSVolumeMonitorGnomeVFS* self;
	self = (DesktopAgnosticVFSVolumeMonitorGnomeVFS*) base;
	result = g_hash_table_get_values (self->priv->_volumes);
	return result;
}


static void _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_connected_gnome_vfs_volume_monitor_drive_connected (GnomeVFSVolumeMonitor* _sender, GnomeVFSDrive* drive, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_connected (self, _sender, drive);
}


static void _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_disconnected_gnome_vfs_volume_monitor_drive_disconnected (GnomeVFSVolumeMonitor* _sender, GnomeVFSDrive* drive, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_disconnected (self, _sender, drive);
}


static void _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_mounted_gnome_vfs_volume_monitor_volume_mounted (GnomeVFSVolumeMonitor* _sender, GnomeVFSVolume* volume, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_mounted (self, _sender, volume);
}


static void _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_unmounted_gnome_vfs_volume_monitor_volume_unmounted (GnomeVFSVolumeMonitor* _sender, GnomeVFSVolume* volume, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_unmounted (self, _sender, volume);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static GObject * desktop_agnostic_vfs_volume_monitor_gnome_vfs_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopAgnosticVFSVolumeMonitorGnomeVFS * self;
	parent_class = G_OBJECT_CLASS (desktop_agnostic_vfs_volume_monitor_gnome_vfs_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS (obj);
	{
		GnomeVFSVolumeMonitor* _tmp0_;
		GHashTable* _tmp1_;
		GList* drives;
		self->priv->monitor = (_tmp0_ = _g_object_ref0 (gnome_vfs_get_volume_monitor ()), _g_object_unref0 (self->priv->monitor), _tmp0_);
		self->priv->_volumes = (_tmp1_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, g_object_unref), _g_hash_table_unref0 (self->priv->_volumes), _tmp1_);
		drives = gnome_vfs_volume_monitor_get_connected_drives (self->priv->monitor);
		{
			GList* drive_collection;
			GList* drive_it;
			drive_collection = drives;
			for (drive_it = drive_collection; drive_it != NULL; drive_it = drive_it->next) {
				GnomeVFSDrive* drive;
				drive = (GnomeVFSDrive*) drive_it->data;
				{
					DesktopAgnosticVFSVolume* vol;
					vol = desktop_agnostic_vfs_volume_monitor_gnome_vfs_create_volume (self, drive);
					g_hash_table_insert (self->priv->_volumes, _g_object_ref0 (drive), _g_object_ref0 (vol));
					_g_object_unref0 (vol);
				}
			}
		}
		g_signal_connect_object (self->priv->monitor, "drive-connected", (GCallback) _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_connected_gnome_vfs_volume_monitor_drive_connected, self, 0);
		g_signal_connect_object (self->priv->monitor, "drive-disconnected", (GCallback) _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_drive_disconnected_gnome_vfs_volume_monitor_drive_disconnected, self, 0);
		g_signal_connect_object (self->priv->monitor, "volume-mounted", (GCallback) _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_mounted_gnome_vfs_volume_monitor_volume_mounted, self, 0);
		g_signal_connect_object (self->priv->monitor, "volume-unmounted", (GCallback) _desktop_agnostic_vfs_volume_monitor_gnome_vfs_on_volume_unmounted_gnome_vfs_volume_monitor_volume_unmounted, self, 0);
		__g_list_free_g_object_unref0 (drives);
	}
	return obj;
}


static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_class_init (DesktopAgnosticVFSVolumeMonitorGnomeVFSClass * klass) {
	desktop_agnostic_vfs_volume_monitor_gnome_vfs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSVolumeMonitorGnomeVFSPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_agnostic_vfs_volume_monitor_gnome_vfs_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_volume_monitor_gnome_vfs_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_IMPLEMENTATION, "implementation");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_VOLUMES, "volumes");
}


static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_desktop_agnostic_vfs_volume_monitor_interface_init (DesktopAgnosticVFSVolumeMonitorIface * iface) {
	desktop_agnostic_vfs_volume_monitor_gnome_vfs_desktop_agnostic_vfs_volume_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_implementation = desktop_agnostic_vfs_volume_monitor_gnome_vfs_real_get_implementation;
	iface->get_volumes = desktop_agnostic_vfs_volume_monitor_gnome_vfs_real_get_volumes;
}


static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_instance_init (DesktopAgnosticVFSVolumeMonitorGnomeVFS * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_finalize (GObject* obj) {
	DesktopAgnosticVFSVolumeMonitorGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS (obj);
	_g_object_unref0 (self->priv->monitor);
	_g_hash_table_unref0 (self->priv->_volumes);
	G_OBJECT_CLASS (desktop_agnostic_vfs_volume_monitor_gnome_vfs_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_volume_monitor_gnome_vfs_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_volume_monitor_gnome_vfs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSVolumeMonitorGnomeVFSClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_volume_monitor_gnome_vfs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSVolumeMonitorGnomeVFS), 0, (GInstanceInitFunc) desktop_agnostic_vfs_volume_monitor_gnome_vfs_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_volume_monitor_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_volume_monitor_gnome_vfs_desktop_agnostic_vfs_volume_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_volume_monitor_gnome_vfs_type_id;
		desktop_agnostic_vfs_volume_monitor_gnome_vfs_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSVolumeMonitorGnomeVFS", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_volume_monitor_gnome_vfs_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, &desktop_agnostic_vfs_volume_monitor_info);
		g_once_init_leave (&desktop_agnostic_vfs_volume_monitor_gnome_vfs_type_id__volatile, desktop_agnostic_vfs_volume_monitor_gnome_vfs_type_id);
	}
	return desktop_agnostic_vfs_volume_monitor_gnome_vfs_type_id__volatile;
}


static void desktop_agnostic_vfs_volume_monitor_gnome_vfs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSVolumeMonitorGnomeVFS * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_IMPLEMENTATION:
		g_value_set_pointer (value, desktop_agnostic_vfs_volume_monitor_get_implementation ((DesktopAgnosticVFSVolumeMonitor*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GNOME_VFS_VOLUMES:
		g_value_set_pointer (value, desktop_agnostic_vfs_volume_monitor_get_volumes ((DesktopAgnosticVFSVolumeMonitor*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




