/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomSerializer {
    protected CleanerProperties props;
    protected boolean escapeXml = true;

    public DomSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public DomSerializer(CleanerProperties props) {
        this(props, true);
    }

    public Document createDOM(TagNode rootNode) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = factory.newDocumentBuilder().newDocument();
        Element rootElement = this.createElement(rootNode, document);
        document.appendChild(rootElement);
        this.setAttributes(rootNode, rootElement);
        this.createSubnodes(document, rootElement, rootNode.getChildren());
        return document;
    }

    private Element createElement(TagNode node, Document document) {
        String name = node.getName();
        boolean nsAware = this.props.isNamespacesAware();
        String prefix = Utils.getXmlNSPrefix(name);
        Map<String, String> nsDeclarations = node.getNamespaceDeclarations();
        String nsURI = null;
        if (prefix != null) {
            if (nsAware) {
                if (nsDeclarations != null) {
                    nsURI = nsDeclarations.get(prefix);
                }
                if (nsURI == null) {
                    nsURI = node.getNamespaceURIOnPath(prefix);
                }
                if (nsURI == null) {
                    nsURI = prefix;
                }
            } else {
                name = Utils.getXmlName(name);
            }
        } else if (nsAware) {
            if (nsDeclarations != null) {
                nsURI = nsDeclarations.get("");
            }
            if (nsURI == null) {
                nsURI = node.getNamespaceURIOnPath(prefix);
            }
        }
        if (nsAware && nsURI != null) {
            return document.createElementNS(nsURI, name);
        }
        return document.createElement(name);
    }

    private void setAttributes(TagNode node, Element element) {
        for (Map.Entry<String, String> entry : node.getAttributes().entrySet()) {
            String attPrefix;
            String attrName = entry.getKey();
            String attrValue = entry.getValue();
            if (this.escapeXml) {
                attrValue = Utils.escapeXml(attrValue, this.props, true);
            }
            if ((attPrefix = Utils.getXmlNSPrefix(attrName)) != null) {
                if (this.props.isNamespacesAware()) {
                    String nsURI = node.getNamespaceURIOnPath(attPrefix);
                    if (nsURI == null) {
                        nsURI = attPrefix;
                    }
                    element.setAttributeNS(nsURI, attrName, attrValue);
                    continue;
                }
                element.setAttribute(Utils.getXmlName(attrName), attrValue);
                continue;
            }
            element.setAttribute(attrName, attrValue);
        }
    }

    private void createSubnodes(Document document, Element element, List tagChildren) {
        if (tagChildren != null) {
            for (Object item : tagChildren) {
                if (item instanceof CommentNode) {
                    CommentNode commentNode = (CommentNode)item;
                    Comment comment = document.createComment(commentNode.getContent().toString());
                    element.appendChild(comment);
                    continue;
                }
                if (item instanceof ContentNode) {
                    boolean specialCase;
                    String nodeName = element.getNodeName();
                    String content = item.toString();
                    boolean bl = specialCase = this.props.isUseCdataForScriptAndStyle() && ("script".equalsIgnoreCase(nodeName) || "style".equalsIgnoreCase(nodeName));
                    if (this.escapeXml && !specialCase) {
                        content = Utils.escapeXml(content, this.props, true);
                    }
                    element.appendChild(specialCase ? document.createCDATASection(content) : document.createTextNode(content));
                    continue;
                }
                if (item instanceof TagNode) {
                    TagNode subTagNode = (TagNode)item;
                    Element subelement = this.createElement(subTagNode, document);
                    this.setAttributes(subTagNode, subelement);
                    this.createSubnodes(document, subelement, subTagNode.getChildren());
                    element.appendChild(subelement);
                    continue;
                }
                if (!(item instanceof List)) continue;
                List sublist = (List)item;
                this.createSubnodes(document, element, sublist);
            }
        }
    }
}

