module.exports = {
  files: ["*.js"],
  extends: ["eslint:recommended", "prettier"],
  parserOptions: {
    ecmaVersion: 2018,
    sourceType: "module",
  },
  rules: {
    "block-scoped-var": "error",
    "callback-return": "error",
    curly: ["error", "multi-line", "consistent"],
    "dot-location": ["error", "property"],
    "dot-notation": "error",
    eqeqeq: ["error", "smart"],
    "id-match": "error",
    "linebreak-style": ["error", "unix"],
    "new-cap": "error",
    "no-console": "error",
    "no-debugger": "error",
    "no-duplicate-imports": "error",
    "no-else-return": "error",
    "no-eq-null": "error",
    "no-eval": "error",
    "no-fallthrough": "error",
    "no-invalid-this": "error",
    "no-new-wrappers": "error",
    "no-path-concat": "error",
    "no-redeclare": "error",
    "no-return-assign": "error",
    "no-sequences": "error",
    "no-shadow": "warn",
    "no-template-curly-in-string": "error",
    "no-trailing-spaces": "error",
    "no-undef-init": "error",
    "no-use-before-define": ["error", "nofunc"],
    "prefer-arrow-callback": "error",
    "prefer-const": "error",
    "prefer-destructuring": ["warn", {VariableDeclarator: {object: true}}],
    radix: "error",
    semi: "off",
    "valid-jsdoc": ["error", {requireReturn: false}],
    "no-useless-escape": "error",
    "no-void": "error",
    "no-var": "error",
  },
}
