# Jasmine Core 3.5 Release Notes

## Summary

This is a maintenance release of Jasmine with a number of new features and fixes

### Highlights

* The output of toHaveBeenCalledWith should now be more readable

This breaks each call out onto its own line, so that it's much easier to
see where each call starts and how they differ. E.g. previously the output
would be:

    Expected spy foo to have been called with [ 'bar', 'baz', 'qux' ] but actual calls were [ [ 42, 'wibble' ], [ 'bar' 'qux' ], [ 'grault '] ]

Now it's:

    Expected spy foo to have been called with:
      [ 'bar', 'baz', 'qux' ]
    but actual calls were:
      [ 42, 'wibble' ],
      [ 'bar' 'qux' ],
      [ 'grault '].

* Add new spy strategies to resolve and reject Promises `resolveTo` and `rejectWith`

* Add the ability to have custom async matchers

### Internal notes

* Stop testing against PhantomJS
  * PhantomJS is at end of life, and the last version of Selenium that supported it was 3.6.0, released almost three years ago. We can't test Jasmine against PhantomJS without pinning key pieces of the project to increasingly outdated versions of key libraries.

* Fail Jasmine's CI build if the promise returned from `jasmineBrowser.runSpecs` is rejected

* A bunch of other rejiggering of the Travis-CI builds to make them easier to work with

* Also released a new browser runner that is being used by Jasmine
  * See [jasmine-browser-runner](https://github.com/jasmine/jasmine-browser)
  * This is a first pass at getting this to work for other projects as well. Please try it out and let us know what isn't working for you.

* add prettier and eslint


## All Changes

* Adds new configuration option to failSpecWithNoExpectations that will report specs without expectations as failures if enabled
  * Merges [#1743](https://github.com/jasmine/jasmine/issues/1743) from @dtychshenko
  * Fixes [#1740](https://github.com/jasmine/jasmine/issues/1740)


* Correctly propagate the `Error` object caught by the global error handler to reporters, etc.
  - Merges [#1738](https://github.com/jasmine/jasmine/issues/1738) from @prantlf
  - Fixes [#1728](https://github.com/jasmine/jasmine/issues/1728)


* Show argument diffs in toHaveBeenCalledWith failure messages
  * Fixes [#1641](https://github.com/jasmine/jasmine/issues/1641)


* Updated arrayContaining to require actual values to be arrays
  * Merges [#1746](https://github.com/jasmine/jasmine/issues/1746) from @divido
  * Fixes [#1745](https://github.com/jasmine/jasmine/issues/1745)


* Add the ability to have custom async matchers
  * Merges [#1732](https://github.com/jasmine/jasmine/issues/1732) from @UziTech


* Allow users to set a default spy strategy
  - Merges [#1716](https://github.com/jasmine/jasmine/issues/1716) from @elliot-nelson


* Accept configurations with `Promise: undefined`.


* PrettyPrinter survives if objects throw in toString
  - Merges [#1718](https://github.com/jasmine/jasmine/issues/1718) from @johnjbarton
  - Fixes [#1726](https://github.com/jasmine/jasmine/issues/1726)


* Add `mapContaining` and `setContaining` asymmetric matchers
  * Merges [#1741](https://github.com/jasmine/jasmine/issues/1741) from @eventlistener


* Use the same spec file pattern for both node and browser


* Gemspec: Drop EOL'd property rubyforge_project
  * Merges [#1736](https://github.com/jasmine/jasmine/issues/1736) from @olleolleolle


* Updated async timeout message to include all of the ways that async code can be run in Jasmine


* Allow users to pass property names to createSpyObj
  - Merges [#1722](https://github.com/jasmine/jasmine/issues/1722) from @elliot-nelson
  - Closes [#1569](https://github.com/jasmine/jasmine/issues/1569)
  - Fixes [#1442](https://github.com/jasmine/jasmine/issues/1442)


* don't attempt to normalize PNGs (gitattributes)
  - Merges [#1721](https://github.com/jasmine/jasmine/issues/1721) from @elliot-nelson


* Add `@since` to most JSDoc comments
  - See [jasmine/jasmine.github.io#117](https://github.com/jasmine/jasmine.github.io/issues/117)


* Make no expectations in HTML Reporter message a console warning
  - Fixes [#1704](https://github.com/jasmine/jasmine/issues/1704)


* Prevent page overflow in HTML reporter under some situations by setting an explicit width
  - Merges [#1713](https://github.com/jasmine/jasmine/issues/1713) from @pixelpax


* Cleanup: minor dead code removal and style fixes
  - Merges [#1708](https://github.com/jasmine/jasmine/issues/1708) from @elliot-nelson


* Pretty Printer can now handle printing an object whose `toString` function has been spied upon
  - Merges [#1712](https://github.com/jasmine/jasmine/issues/1712) from @johnjbarton


* PrettyPrinter handles objects with invalid toString implementations
  - Merges [#1711](https://github.com/jasmine/jasmine/issues/1711) from @elliot-nelson
  - Closes [#1700](https://github.com/jasmine/jasmine/issues/1700)
  - Closes [#1575](https://github.com/jasmine/jasmine/issues/1575)


* Fix toBeCloseTo matcher for Node.js 12 and Chrome 74
  - Merges [#1710](https://github.com/jasmine/jasmine/issues/1710) from @paulvanbrenk
  - Fixes [#1695](https://github.com/jasmine/jasmine/issues/1695)


* spyOnProperty jasmine-style error messages with usage note
  - Merges [#1706](https://github.com/jasmine/jasmine/issues/1706) from @elliot-nelson


* spyOnProperty respects the allowRespy flag
  - Merges [#1705](https://github.com/jasmine/jasmine/issues/1705) from @elliot-nelson


* Introduce matchers#toBeInstanceOf
  - Merges [#1697](https://github.com/jasmine/jasmine/issues/1697) from @elliot-nelson


* Print global errors encountered during CI runs
  - Merges [#1701](https://github.com/jasmine/jasmine/issues/1701) from @elliot-nelson


* Update contributing doc based on some of the newer tooling
  - Fixes [#1702](https://github.com/jasmine/jasmine/issues/1702)


* Extend spyOnAllFunctions to include prototype and parent methods
  - Merges [#1699](https://github.com/jasmine/jasmine/issues/1699) from @elliot-nelson
  - Fixes [#1677](https://github.com/jasmine/jasmine/issues/1677)


* Improve error handling in CI test launcher
  - Merges [#1598](https://github.com/jasmine/jasmine/issues/1598) from @elliot-nelson


* Add new spy strategies to resolve and reject Promises `resolveTo` and `rejectWith`
  - Merges [#1688](https://github.com/jasmine/jasmine/issues/1688) from @enelson
  - See [#1590](https://github.com/jasmine/jasmine/issues/1590)
  - Fixes [#1715](https://github.com/jasmine/jasmine/issues/1715)


* Update deprecation messages to indicate _future_ removal
  - Fixes [#1628](https://github.com/jasmine/jasmine/issues/1628)

* Add toBeRejectedWithError matcher
  - Merges [#1686](https://github.com/jasmine/jasmine/issues/1686) from @megahertz
  - Fixes [#1625](https://github.com/jasmine/jasmine/issues/1625)


* Ignore internal ci.js from npm package
  - See [#1684](https://github.com/jasmine/jasmine/issues/1684)


* Fix failure messages for positive/negative infinity matchers
  - Fixes [#1674](https://github.com/jasmine/jasmine/issues/1674)


* nit: fix typo
  - Merges [#1680](https://github.com/jasmine/jasmine/issues/1680) from @acinader


* added #toBeTrue and #toBeFalse matchers
  - Merges [#1679](https://github.com/jasmine/jasmine/issues/1679) from @FelixRilling


------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
