/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_RegisteredDNSProfileAccess.h"

const string _InstanceID="OpenDRIM:DNS:1.0.1";

int DNS_OpenDRIM_RegisteredDNSProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DNS_OpenDRIM_RegisteredDNSProfile_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DNS_OpenDRIM_RegisteredDNSProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredDNSProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RegisteredDNSProfile instance;
	instance.setInstanceID(_InstanceID);

	if (discriminant == "ei")
		CF_assert(DNS_OpenDRIM_RegisteredDNSProfile_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int DNS_OpenDRIM_RegisteredDNSProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredDNSProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID!=_InstanceID)
	{
		errorMessage = "No Instance";
		return NOT_FOUND;
	}
	
	CF_assert(DNS_OpenDRIM_RegisteredDNSProfile_populate(instance, errorMessage));
	_L_;
	return OK;
}

int DNS_OpenDRIM_RegisteredDNSProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredDNSProfile& newInstance, const OpenDRIM_RegisteredDNSProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_RegisteredDNSProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredDNSProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_RegisteredDNSProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredDNSProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DNS_OpenDRIM_RegisteredDNSProfile_populate(OpenDRIM_RegisteredDNSProfile& instance, string& errorMessage) {
	_E_;
	vector<unsigned short> _AdvertiseTypes;
	//Registred name of profile which is listed in Standard
	instance.setRegisteredName("DNS Client");
	
	//Registred version of Profile	
	instance.setRegisteredVersion("1.0.1");
	
	// Profile Registred organization - 2 (DMTF)
	instance.setRegisteredOrganization(2);
	
	_AdvertiseTypes.push_back(2);
	instance.setAdvertiseTypes(_AdvertiseTypes);
	_L_;
	return OK;
}

