<?php

final class ManiphestTaskClosedStatusDatasource
  extends PhabricatorTypeaheadDatasource {

  const FUNCTION_TOKEN = 'closed()';

  public function getBrowseTitle() {
    return pht('Browse Any Closed Status');
  }

  public function getPlaceholderText() {
    return pht('Type closed()...');
  }

  public function getDatasourceApplicationClass() {
    return 'PhabricatorManiphestApplication';
  }

  public function getDatasourceFunctions() {
    return array(
      'closed' => array(
        'name' => pht('Any Closed Status'),
        'summary' => pht('Find results with any closed status.'),
        'description' => pht(
          'This function includes results which have any closed status.'),
      ),
    );
  }

  public function loadResults() {
    $results = array(
      $this->buildClosedResult(),
    );
    return $this->filterResultsAgainstTokens($results);
  }

  protected function evaluateFunction($function, array $argv_list) {
    $results = array();

    $map = ManiphestTaskStatus::getTaskStatusMap();
    foreach ($argv_list as $argv) {
      foreach ($map as $status => $name) {
        if (!ManiphestTaskStatus::isOpenStatus($status)) {
          $results[] = $status;
        }
      }
    }

    return $results;
  }

  public function renderFunctionTokens($function, array $argv_list) {
    $results = array();

    foreach ($argv_list as $argv) {
      $results[] = PhabricatorTypeaheadTokenView::newFromTypeaheadResult(
        $this->buildClosedResult());
    }

    return $results;
  }

  private function buildClosedResult() {
    $name = pht('Any Closed Status');
    return $this->newFunctionResult()
      ->setName($name.' closed')
      ->setDisplayName($name)
      ->setPHID(self::FUNCTION_TOKEN)
      ->setUnique(true);
  }

}
