/***************************************************************************
 *   Copyright (C) 2008 by Damien Lévin <dml_aon@hotmail.com>      	   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/
 

#ifndef Plasmoid_HEADER
#define Plasmoid_HEADER


#include <KIcon>
#include <KConfigGroup>
#include <KCompletion>

#include <Plasma/PopupApplet>
#include <Plasma/Svg>
#include <plasma/widgets/lineedit.h>
#include <plasma/widgets/iconwidget.h>


#include <QStringList>
#include <QGraphicsWidget>
#include <QGraphicsLinearLayout>
#include <QHash>
#include "ui_searchmoidConfig.h"

#include <plasma/widgets/lineedit.h>




class Searchmoid : public Plasma::PopupApplet
{
    Q_OBJECT
    public:
        Searchmoid(QObject *parent, const QVariantList &args);
        ~Searchmoid();
	QGraphicsWidget *graphicsWidget();


    public slots:
	void launchRequest();
        void configAccepted();
        void createConfigurationInterface(KConfigDialog *parent);
  
    private:
	Ui::searchmoidConfig uiConfig;

	QGraphicsLinearLayout* m_layout;
	Plasma::LineEdit *searchLine;
	Plasma::IconWidget *iconWebsite;

	KConfigGroup configGroup;
        KCompletion *completion;

        QStringList completionHistory;
	QString currentWebSite;
	QHash<QString, QString> mapWebSites;
	QHash<QString, QString> mapWebSitesLogos;
	QWidget *widgetConfig; 
	QGraphicsWidget *widgetMain;

	void updateHistory();
	void initWebSites();
	void initGui();

};



K_EXPORT_PLASMA_APPLET(searchmoid, Searchmoid)
#endif