/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.File;
import org.codehaus.plexus.archiver.tar.TarEntry;
import org.codehaus.plexus.archiver.tar.TarUtils;

public class PosixTarEntry
extends TarEntry {
    protected StringBuffer prefix;
    protected StringBuffer version;

    public PosixTarEntry(String name) {
        super(name);
        this.initPOSIXTar();
    }

    public PosixTarEntry(File file) {
        super(file);
        this.initPOSIXTar();
    }

    public PosixTarEntry(String name, byte linkFlag) {
        super(name, linkFlag);
        this.initPOSIXTar();
    }

    protected void initPOSIXTar() {
        this.magic = new StringBuffer("ustar\u0000");
        this.splitPath();
        this.version = new StringBuffer("00");
    }

    public void writeEntryHeader(byte[] outbuf) {
        int offset = 0;
        offset = TarUtils.getNameBytes(this.name, outbuf, offset, 100);
        offset = TarUtils.getOctalBytes(this.mode, outbuf, offset, 8);
        offset = TarUtils.getOctalBytes(this.userId >= 0 ? this.userId : 0, outbuf, offset, 8);
        offset = TarUtils.getOctalBytes(this.groupId >= 0 ? this.groupId : 0, outbuf, offset, 8);
        offset = TarUtils.getLongOctalBytes(this.size, outbuf, offset, 12);
        int csOffset = offset = TarUtils.getLongOctalBytes(this.modTime, outbuf, offset, 12);
        for (int c = 0; c < 8; ++c) {
            outbuf[offset++] = 32;
        }
        outbuf[offset++] = this.linkFlag;
        offset = TarUtils.getNameBytes(this.linkName, outbuf, offset, 100);
        offset = TarUtils.getNameBytes(this.magic, outbuf, offset, 6);
        offset = TarUtils.getNameBytes(this.version, outbuf, offset, 2);
        offset = TarUtils.getNameBytes(this.userName, outbuf, offset, 32);
        offset = TarUtils.getNameBytes(this.groupName, outbuf, offset, 32);
        offset = TarUtils.getOctalBytes(this.devMajor, outbuf, offset, 8);
        offset = TarUtils.getOctalBytes(this.devMinor, outbuf, offset, 8);
        offset = TarUtils.getNameBytes(this.prefix, outbuf, offset, 155);
        while (offset < outbuf.length) {
            outbuf[offset++] = 0;
        }
        long checkSum = TarUtils.computeCheckSum(outbuf);
        TarUtils.getCheckSumOctalBytes(checkSum, outbuf, csOffset, 8);
    }

    public void parseTarHeader(byte[] header) {
        int offset = 0;
        this.name = TarUtils.parseName(header, offset, 100);
        this.mode = (int)TarUtils.parseOctal(header, offset += 100, 8);
        this.userId = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.groupId = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.size = TarUtils.parseOctal(header, offset += 8, 12);
        this.modTime = TarUtils.parseOctal(header, offset += 12, 12);
        this.checkSum = (int)TarUtils.parseOctal(header, offset += 12, 8);
        offset += 8;
        this.linkFlag = header[offset++];
        this.linkName = TarUtils.parseName(header, offset, 100);
        this.magic = TarUtils.parseName(header, offset += 100, 6);
        this.version = TarUtils.parseName(header, offset += 6, 2);
        this.userName = TarUtils.parseName(header, offset += 2, 32);
        this.groupName = TarUtils.parseName(header, offset += 32, 32);
        this.devMajor = (int)TarUtils.parseOctal(header, offset += 32, 8);
        this.devMinor = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.prefix = TarUtils.parseName(header, offset += 8, 155);
    }

    private void splitPath() {
        if (this.name.length() >= 100) {
            int firstNameIndex = 0;
            int j = 0;
            for (int i = this.name.length() - 1; i >= 0 && j < 100; --i, ++j) {
                if (this.name.charAt(i) != '/') continue;
                firstNameIndex = i;
            }
            if (firstNameIndex > 0) {
                this.prefix = new StringBuffer(this.name.substring(0, firstNameIndex));
                this.name = new StringBuffer(this.name.substring(firstNameIndex + 1));
            } else {
                this.prefix = new StringBuffer("");
            }
        } else {
            this.prefix = new StringBuffer("");
        }
    }
}

