% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available.R
\name{available}
\alias{available}
\title{Discover packages available for installation.}
\usage{
available(pattern = "", include_installed = TRUE)
}
\arguments{
\item{pattern}{character(1) pattern to filter (via
\code{grep(pattern=...)}) available packages; the filter is not case
sensitive.}

\item{include_installed}{logical(1) When \code{TRUE}, include installed
packages in list of available packages; when \code{FALSE}, exclude
installed packages.}
}
\value{
\code{character()} vector of package names available for
installation.
}
\description{
Discover packages available for installation.
}
\examples{
if (interactive()) {
  avail <- BiocManager::available()
  length(avail)

  BiocManager::available("bs.*hsapiens")
}
}
