% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_numeric_linter.R
\name{is_numeric_linter}
\alias{is_numeric_linter}
\title{Redirect \code{is.numeric(x) || is.integer(x)} to just use \code{is.numeric(x)}}
\usage{
is_numeric_linter()
}
\description{
\code{\link[=is.numeric]{is.numeric()}} returns \code{TRUE} when \code{typeof(x)} is \code{double} or \code{integer} --
testing \code{is.numeric(x) || is.integer(x)} is thus redundant.
}
\details{
NB: This linter plays well with \code{\link[=class_equals_linter]{class_equals_linter()}}, which can help
avoid further \code{is.numeric()} equivalents like
\code{any(class(x) == c("numeric", "integer"))}.
}
\examples{
# will produce lints
lint(
  text = "is.numeric(y) || is.integer(y)",
  linters = is_numeric_linter()
)

lint(
  text = 'class(z) \%in\% c("numeric", "integer")',
  linters = is_numeric_linter()
)

# okay
lint(
  text = "is.numeric(y) || is.factor(y)",
  linters = is_numeric_linter()
)

lint(
  text = 'class(z) \%in\% c("numeric", "integer", "factor")',
  linters = is_numeric_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=readability_linters]{readability}
}
