% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{read_settings}
\alias{read_settings}
\title{Read lintr settings}
\usage{
read_settings(filename)
}
\arguments{
\item{filename}{source file to be linted}
}
\description{
Lintr searches for settings for a given source file in the following order:
\enumerate{
\item options defined as \code{linter.setting}.
\item \code{linter_file} in the same directory
\item \code{linter_file} in the project directory
\item \code{linter_file} in the user home directory
\item \code{\link[=default_settings]{default_settings()}}
}
}
\details{
The default linter_file name is \code{.lintr} but it can be changed with option \code{lintr.linter_file}
or the environment variable \code{R_LINTR_LINTER_FILE}
This file is a DCF file, see \code{\link[base:dcf]{base::read.dcf()}} for details.
Experimentally, we also support keeping the config in a plain R file. By default we look for
a file named '.lintr.R' (in the same directories where we search for '.lintr').
We are still deciding the future of config support in lintr, so user feedback is welcome.
The advantage of R is that it maps more closely to how the configs are actually stored,
whereas the DCF approach requires somewhat awkward formatting of parseable R code within
valid DCF key-value pairs. The main disadvantage of the R file is it might be \emph{too} flexible,
with users tempted to write configs with side effects causing hard-to-detect bugs or
like YAML could work, but require new dependencies and are harder to parse
both programmatically and visually.
}
